# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAccessGrantResult',
    'AwaitableGetAccessGrantResult',
    'get_access_grant',
    'get_access_grant_output',
]

@pulumi.output_type
class GetAccessGrantResult:
    def __init__(__self__, access_grant_arn=None, access_grant_id=None, access_grants_location_configuration=None, access_grants_location_id=None, application_arn=None, grant_scope=None, grantee=None, permission=None):
        if access_grant_arn and not isinstance(access_grant_arn, str):
            raise TypeError("Expected argument 'access_grant_arn' to be a str")
        pulumi.set(__self__, "access_grant_arn", access_grant_arn)
        if access_grant_id and not isinstance(access_grant_id, str):
            raise TypeError("Expected argument 'access_grant_id' to be a str")
        pulumi.set(__self__, "access_grant_id", access_grant_id)
        if access_grants_location_configuration and not isinstance(access_grants_location_configuration, dict):
            raise TypeError("Expected argument 'access_grants_location_configuration' to be a dict")
        pulumi.set(__self__, "access_grants_location_configuration", access_grants_location_configuration)
        if access_grants_location_id and not isinstance(access_grants_location_id, str):
            raise TypeError("Expected argument 'access_grants_location_id' to be a str")
        pulumi.set(__self__, "access_grants_location_id", access_grants_location_id)
        if application_arn and not isinstance(application_arn, str):
            raise TypeError("Expected argument 'application_arn' to be a str")
        pulumi.set(__self__, "application_arn", application_arn)
        if grant_scope and not isinstance(grant_scope, str):
            raise TypeError("Expected argument 'grant_scope' to be a str")
        pulumi.set(__self__, "grant_scope", grant_scope)
        if grantee and not isinstance(grantee, dict):
            raise TypeError("Expected argument 'grantee' to be a dict")
        pulumi.set(__self__, "grantee", grantee)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter(name="accessGrantArn")
    def access_grant_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the specified access grant.
        """
        return pulumi.get(self, "access_grant_arn")

    @property
    @pulumi.getter(name="accessGrantId")
    def access_grant_id(self) -> Optional[str]:
        """
        The ID assigned to this access grant.
        """
        return pulumi.get(self, "access_grant_id")

    @property
    @pulumi.getter(name="accessGrantsLocationConfiguration")
    def access_grants_location_configuration(self) -> Optional['outputs.AccessGrantsLocationConfiguration']:
        """
        The configuration options of the grant location, which is the S3 path to the data to which you are granting access.
        """
        return pulumi.get(self, "access_grants_location_configuration")

    @property
    @pulumi.getter(name="accessGrantsLocationId")
    def access_grants_location_id(self) -> Optional[str]:
        """
        The custom S3 location to be accessed by the grantee
        """
        return pulumi.get(self, "access_grants_location_id")

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[str]:
        """
        The ARN of the application grantees will use to access the location
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="grantScope")
    def grant_scope(self) -> Optional[str]:
        """
        The S3 path of the data to which you are granting access. It is a combination of the S3 path of the registered location and the subprefix.
        """
        return pulumi.get(self, "grant_scope")

    @property
    @pulumi.getter
    def grantee(self) -> Optional['outputs.AccessGrantGrantee']:
        """
        The principal who will be granted permission to access S3.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def permission(self) -> Optional['AccessGrantPermission']:
        """
        The level of access to be afforded to the grantee
        """
        return pulumi.get(self, "permission")


class AwaitableGetAccessGrantResult(GetAccessGrantResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessGrantResult(
            access_grant_arn=self.access_grant_arn,
            access_grant_id=self.access_grant_id,
            access_grants_location_configuration=self.access_grants_location_configuration,
            access_grants_location_id=self.access_grants_location_id,
            application_arn=self.application_arn,
            grant_scope=self.grant_scope,
            grantee=self.grantee,
            permission=self.permission)


def get_access_grant(access_grant_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessGrantResult:
    """
    The AWS::S3::AccessGrant resource is an Amazon S3 resource type representing permissions to a specific S3 bucket or prefix hosted in an S3 Access Grants instance.


    :param str access_grant_id: The ID assigned to this access grant.
    """
    __args__ = dict()
    __args__['accessGrantId'] = access_grant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:s3:getAccessGrant', __args__, opts=opts, typ=GetAccessGrantResult).value

    return AwaitableGetAccessGrantResult(
        access_grant_arn=pulumi.get(__ret__, 'access_grant_arn'),
        access_grant_id=pulumi.get(__ret__, 'access_grant_id'),
        access_grants_location_configuration=pulumi.get(__ret__, 'access_grants_location_configuration'),
        access_grants_location_id=pulumi.get(__ret__, 'access_grants_location_id'),
        application_arn=pulumi.get(__ret__, 'application_arn'),
        grant_scope=pulumi.get(__ret__, 'grant_scope'),
        grantee=pulumi.get(__ret__, 'grantee'),
        permission=pulumi.get(__ret__, 'permission'))


@_utilities.lift_output_func(get_access_grant)
def get_access_grant_output(access_grant_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessGrantResult]:
    """
    The AWS::S3::AccessGrant resource is an Amazon S3 resource type representing permissions to a specific S3 bucket or prefix hosted in an S3 Access Grants instance.


    :param str access_grant_id: The ID assigned to this access grant.
    """
    ...
