# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 accelerate_configuration: Optional[pulumi.Input['BucketAccelerateConfigurationArgs']] = None,
                 access_control: Optional[pulumi.Input['BucketAccessControl']] = None,
                 analytics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAnalyticsConfigurationArgs']]]] = None,
                 bucket_encryption: Optional[pulumi.Input['BucketEncryptionArgs']] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 cors_configuration: Optional[pulumi.Input['BucketCorsConfigurationArgs']] = None,
                 intelligent_tiering_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['BucketIntelligentTieringConfigurationArgs']]]] = None,
                 inventory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['BucketInventoryConfigurationArgs']]]] = None,
                 lifecycle_configuration: Optional[pulumi.Input['BucketLifecycleConfigurationArgs']] = None,
                 logging_configuration: Optional[pulumi.Input['BucketLoggingConfigurationArgs']] = None,
                 metrics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['BucketMetricsConfigurationArgs']]]] = None,
                 notification_configuration: Optional[pulumi.Input['BucketNotificationConfigurationArgs']] = None,
                 object_lock_configuration: Optional[pulumi.Input['BucketObjectLockConfigurationArgs']] = None,
                 object_lock_enabled: Optional[pulumi.Input[bool]] = None,
                 ownership_controls: Optional[pulumi.Input['BucketOwnershipControlsArgs']] = None,
                 public_access_block_configuration: Optional[pulumi.Input['BucketPublicAccessBlockConfigurationArgs']] = None,
                 replication_configuration: Optional[pulumi.Input['BucketReplicationConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 versioning_configuration: Optional[pulumi.Input['BucketVersioningConfigurationArgs']] = None,
                 website_configuration: Optional[pulumi.Input['BucketWebsiteConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input['BucketAccelerateConfigurationArgs'] accelerate_configuration: Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input['BucketAccessControl'] access_control: This is a legacy property, and it is not recommended for most use cases. A majority of modern use cases in Amazon S3 no longer require the use of ACLs, and we recommend that you keep ACLs disabled. For more information, see [Controlling object ownership](https://docs.aws.amazon.com//AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
                 A canned access control list (ACL) that grants predefined permissions to the bucket. For more information about canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 User Guide*.
                 S3 buckets are created with ACLs disabled by default. Therefore, unless you explicitly set the [AWS::S3::OwnershipControls](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html) property to enable ACLs, your resource will fail to deploy with any value other than Private. Use cases requiring ACLs are uncommon.
                 The majority of access control configurations can be successfully and more easily achieved with bucket policies. For more information, see [AWS::S3::BucketPolicy](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html). For examples of common policy configurations, including S3 Server Access Logs buckets and more, see [Bucket policy examples](https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['BucketAnalyticsConfigurationArgs']]] analytics_configurations: Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        :param pulumi.Input['BucketEncryptionArgs'] bucket_encryption: Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[str] bucket_name: A name for the bucket. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html). For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules) in the *Amazon S3 User Guide*. 
                 If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
        :param pulumi.Input['BucketCorsConfigurationArgs'] cors_configuration: Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['BucketIntelligentTieringConfigurationArgs']]] intelligent_tiering_configurations: Defines how Amazon S3 handles Intelligent-Tiering storage.
        :param pulumi.Input[Sequence[pulumi.Input['BucketInventoryConfigurationArgs']]] inventory_configurations: Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
        :param pulumi.Input['BucketLifecycleConfigurationArgs'] lifecycle_configuration: Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input['BucketLoggingConfigurationArgs'] logging_configuration: Settings that define where logs are stored.
        :param pulumi.Input[Sequence[pulumi.Input['BucketMetricsConfigurationArgs']]] metrics_configurations: Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html).
        :param pulumi.Input['BucketNotificationConfigurationArgs'] notification_configuration: Configuration that defines how Amazon S3 handles bucket notifications.
        :param pulumi.Input['BucketObjectLockConfigurationArgs'] object_lock_configuration: This operation is not supported by directory buckets.
                 Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). 
                  +  The ``DefaultRetention`` settings require both a mode and a period.
                 +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
                 +  You can enable Object Lock for new or existing buckets. For more information, see [Configuring Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-configure.html).
        :param pulumi.Input[bool] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        :param pulumi.Input['BucketOwnershipControlsArgs'] ownership_controls: Configuration that defines how Amazon S3 handles Object Ownership rules.
        :param pulumi.Input['BucketPublicAccessBlockConfigurationArgs'] public_access_block_configuration: Configuration that defines how Amazon S3 handles public access.
        :param pulumi.Input['BucketReplicationConfigurationArgs'] replication_configuration: Configuration for replicating objects in an S3 bucket. To enable replication, you must also enable versioning by using the ``VersioningConfiguration`` property.
                Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this S3 bucket.
        :param pulumi.Input['BucketVersioningConfigurationArgs'] versioning_configuration: Enables multiple versions of all objects in this bucket. You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
        :param pulumi.Input['BucketWebsiteConfigurationArgs'] website_configuration: Information used to configure the bucket as a static website. For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
        """
        if accelerate_configuration is not None:
            pulumi.set(__self__, "accelerate_configuration", accelerate_configuration)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if analytics_configurations is not None:
            pulumi.set(__self__, "analytics_configurations", analytics_configurations)
        if bucket_encryption is not None:
            pulumi.set(__self__, "bucket_encryption", bucket_encryption)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if cors_configuration is not None:
            pulumi.set(__self__, "cors_configuration", cors_configuration)
        if intelligent_tiering_configurations is not None:
            pulumi.set(__self__, "intelligent_tiering_configurations", intelligent_tiering_configurations)
        if inventory_configurations is not None:
            pulumi.set(__self__, "inventory_configurations", inventory_configurations)
        if lifecycle_configuration is not None:
            pulumi.set(__self__, "lifecycle_configuration", lifecycle_configuration)
        if logging_configuration is not None:
            pulumi.set(__self__, "logging_configuration", logging_configuration)
        if metrics_configurations is not None:
            pulumi.set(__self__, "metrics_configurations", metrics_configurations)
        if notification_configuration is not None:
            pulumi.set(__self__, "notification_configuration", notification_configuration)
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if ownership_controls is not None:
            pulumi.set(__self__, "ownership_controls", ownership_controls)
        if public_access_block_configuration is not None:
            pulumi.set(__self__, "public_access_block_configuration", public_access_block_configuration)
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning_configuration is not None:
            pulumi.set(__self__, "versioning_configuration", versioning_configuration)
        if website_configuration is not None:
            pulumi.set(__self__, "website_configuration", website_configuration)

    @property
    @pulumi.getter(name="accelerateConfiguration")
    def accelerate_configuration(self) -> Optional[pulumi.Input['BucketAccelerateConfigurationArgs']]:
        """
        Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "accelerate_configuration")

    @accelerate_configuration.setter
    def accelerate_configuration(self, value: Optional[pulumi.Input['BucketAccelerateConfigurationArgs']]):
        pulumi.set(self, "accelerate_configuration", value)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['BucketAccessControl']]:
        """
        This is a legacy property, and it is not recommended for most use cases. A majority of modern use cases in Amazon S3 no longer require the use of ACLs, and we recommend that you keep ACLs disabled. For more information, see [Controlling object ownership](https://docs.aws.amazon.com//AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
          A canned access control list (ACL) that grants predefined permissions to the bucket. For more information about canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 User Guide*.
          S3 buckets are created with ACLs disabled by default. Therefore, unless you explicitly set the [AWS::S3::OwnershipControls](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html) property to enable ACLs, your resource will fail to deploy with any value other than Private. Use cases requiring ACLs are uncommon.
          The majority of access control configurations can be successfully and more easily achieved with bucket policies. For more information, see [AWS::S3::BucketPolicy](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html). For examples of common policy configurations, including S3 Server Access Logs buckets and more, see [Bucket policy examples](https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['BucketAccessControl']]):
        pulumi.set(self, "access_control", value)

    @property
    @pulumi.getter(name="analyticsConfigurations")
    def analytics_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketAnalyticsConfigurationArgs']]]]:
        """
        Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        """
        return pulumi.get(self, "analytics_configurations")

    @analytics_configurations.setter
    def analytics_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAnalyticsConfigurationArgs']]]]):
        pulumi.set(self, "analytics_configurations", value)

    @property
    @pulumi.getter(name="bucketEncryption")
    def bucket_encryption(self) -> Optional[pulumi.Input['BucketEncryptionArgs']]:
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "bucket_encryption")

    @bucket_encryption.setter
    def bucket_encryption(self, value: Optional[pulumi.Input['BucketEncryptionArgs']]):
        pulumi.set(self, "bucket_encryption", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the bucket. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html). For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules) in the *Amazon S3 User Guide*. 
          If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> Optional[pulumi.Input['BucketCorsConfigurationArgs']]:
        """
        Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "cors_configuration")

    @cors_configuration.setter
    def cors_configuration(self, value: Optional[pulumi.Input['BucketCorsConfigurationArgs']]):
        pulumi.set(self, "cors_configuration", value)

    @property
    @pulumi.getter(name="intelligentTieringConfigurations")
    def intelligent_tiering_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketIntelligentTieringConfigurationArgs']]]]:
        """
        Defines how Amazon S3 handles Intelligent-Tiering storage.
        """
        return pulumi.get(self, "intelligent_tiering_configurations")

    @intelligent_tiering_configurations.setter
    def intelligent_tiering_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketIntelligentTieringConfigurationArgs']]]]):
        pulumi.set(self, "intelligent_tiering_configurations", value)

    @property
    @pulumi.getter(name="inventoryConfigurations")
    def inventory_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketInventoryConfigurationArgs']]]]:
        """
        Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
        """
        return pulumi.get(self, "inventory_configurations")

    @inventory_configurations.setter
    def inventory_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketInventoryConfigurationArgs']]]]):
        pulumi.set(self, "inventory_configurations", value)

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> Optional[pulumi.Input['BucketLifecycleConfigurationArgs']]:
        """
        Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "lifecycle_configuration")

    @lifecycle_configuration.setter
    def lifecycle_configuration(self, value: Optional[pulumi.Input['BucketLifecycleConfigurationArgs']]):
        pulumi.set(self, "lifecycle_configuration", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional[pulumi.Input['BucketLoggingConfigurationArgs']]:
        """
        Settings that define where logs are stored.
        """
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: Optional[pulumi.Input['BucketLoggingConfigurationArgs']]):
        pulumi.set(self, "logging_configuration", value)

    @property
    @pulumi.getter(name="metricsConfigurations")
    def metrics_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketMetricsConfigurationArgs']]]]:
        """
        Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html).
        """
        return pulumi.get(self, "metrics_configurations")

    @metrics_configurations.setter
    def metrics_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketMetricsConfigurationArgs']]]]):
        pulumi.set(self, "metrics_configurations", value)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional[pulumi.Input['BucketNotificationConfigurationArgs']]:
        """
        Configuration that defines how Amazon S3 handles bucket notifications.
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: Optional[pulumi.Input['BucketNotificationConfigurationArgs']]):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> Optional[pulumi.Input['BucketObjectLockConfigurationArgs']]:
        """
        This operation is not supported by directory buckets.
          Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). 
           +  The ``DefaultRetention`` settings require both a mode and a period.
          +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
          +  You can enable Object Lock for new or existing buckets. For more information, see [Configuring Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-configure.html).
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['BucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        """
        return pulumi.get(self, "object_lock_enabled")

    @object_lock_enabled.setter
    def object_lock_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "object_lock_enabled", value)

    @property
    @pulumi.getter(name="ownershipControls")
    def ownership_controls(self) -> Optional[pulumi.Input['BucketOwnershipControlsArgs']]:
        """
        Configuration that defines how Amazon S3 handles Object Ownership rules.
        """
        return pulumi.get(self, "ownership_controls")

    @ownership_controls.setter
    def ownership_controls(self, value: Optional[pulumi.Input['BucketOwnershipControlsArgs']]):
        pulumi.set(self, "ownership_controls", value)

    @property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> Optional[pulumi.Input['BucketPublicAccessBlockConfigurationArgs']]:
        """
        Configuration that defines how Amazon S3 handles public access.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @public_access_block_configuration.setter
    def public_access_block_configuration(self, value: Optional[pulumi.Input['BucketPublicAccessBlockConfigurationArgs']]):
        pulumi.set(self, "public_access_block_configuration", value)

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional[pulumi.Input['BucketReplicationConfigurationArgs']]:
        """
        Configuration for replicating objects in an S3 bucket. To enable replication, you must also enable versioning by using the ``VersioningConfiguration`` property.
         Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['BucketReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this S3 bucket.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versioningConfiguration")
    def versioning_configuration(self) -> Optional[pulumi.Input['BucketVersioningConfigurationArgs']]:
        """
        Enables multiple versions of all objects in this bucket. You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
        """
        return pulumi.get(self, "versioning_configuration")

    @versioning_configuration.setter
    def versioning_configuration(self, value: Optional[pulumi.Input['BucketVersioningConfigurationArgs']]):
        pulumi.set(self, "versioning_configuration", value)

    @property
    @pulumi.getter(name="websiteConfiguration")
    def website_configuration(self) -> Optional[pulumi.Input['BucketWebsiteConfigurationArgs']]:
        """
        Information used to configure the bucket as a static website. For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
        """
        return pulumi.get(self, "website_configuration")

    @website_configuration.setter
    def website_configuration(self, value: Optional[pulumi.Input['BucketWebsiteConfigurationArgs']]):
        pulumi.set(self, "website_configuration", value)


class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerate_configuration: Optional[pulumi.Input[pulumi.InputType['BucketAccelerateConfigurationArgs']]] = None,
                 access_control: Optional[pulumi.Input['BucketAccessControl']] = None,
                 analytics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAnalyticsConfigurationArgs']]]]] = None,
                 bucket_encryption: Optional[pulumi.Input[pulumi.InputType['BucketEncryptionArgs']]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 cors_configuration: Optional[pulumi.Input[pulumi.InputType['BucketCorsConfigurationArgs']]] = None,
                 intelligent_tiering_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketIntelligentTieringConfigurationArgs']]]]] = None,
                 inventory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketInventoryConfigurationArgs']]]]] = None,
                 lifecycle_configuration: Optional[pulumi.Input[pulumi.InputType['BucketLifecycleConfigurationArgs']]] = None,
                 logging_configuration: Optional[pulumi.Input[pulumi.InputType['BucketLoggingConfigurationArgs']]] = None,
                 metrics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketMetricsConfigurationArgs']]]]] = None,
                 notification_configuration: Optional[pulumi.Input[pulumi.InputType['BucketNotificationConfigurationArgs']]] = None,
                 object_lock_configuration: Optional[pulumi.Input[pulumi.InputType['BucketObjectLockConfigurationArgs']]] = None,
                 object_lock_enabled: Optional[pulumi.Input[bool]] = None,
                 ownership_controls: Optional[pulumi.Input[pulumi.InputType['BucketOwnershipControlsArgs']]] = None,
                 public_access_block_configuration: Optional[pulumi.Input[pulumi.InputType['BucketPublicAccessBlockConfigurationArgs']]] = None,
                 replication_configuration: Optional[pulumi.Input[pulumi.InputType['BucketReplicationConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 versioning_configuration: Optional[pulumi.Input[pulumi.InputType['BucketVersioningConfigurationArgs']]] = None,
                 website_configuration: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteConfigurationArgs']]] = None,
                 __props__=None):
        """
        The ``AWS::S3::Bucket`` resource creates an Amazon S3 bucket in the same AWS Region where you create the AWS CloudFormation stack.
         To control how AWS CloudFormation handles the bucket when the stack is deleted, you can set a deletion policy for your bucket. You can choose to *retain* the bucket or to *delete* the bucket. For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).
          You can only delete empty buckets. Deletion fails for buckets that have contents.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        s3_bucket = aws_native.s3.Bucket("s3Bucket")
        recording_configuration = aws_native.ivs.RecordingConfiguration("recordingConfiguration",
            name="MyRecordingConfiguration",
            destination_configuration=aws_native.ivs.RecordingConfigurationDestinationConfigurationArgs(
                s3=aws_native.ivs.RecordingConfigurationS3DestinationConfigurationArgs(
                    bucket_name=s3_bucket.id,
                ),
            ),
            thumbnail_configuration=aws_native.ivs.RecordingConfigurationThumbnailConfigurationArgs(
                recording_mode=aws_native.ivs.RecordingConfigurationThumbnailConfigurationRecordingMode.INTERVAL,
                target_interval_seconds=60,
                storage=[
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.SEQUENTIAL,
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.LATEST,
                ],
                resolution=aws_native.ivs.RecordingConfigurationThumbnailConfigurationResolution.HD,
            ),
            rendition_configuration=aws_native.ivs.RecordingConfigurationRenditionConfigurationArgs(
                rendition_selection=aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionSelection.CUSTOM,
                renditions=[
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.HD,
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.SD,
                ],
            ),
            opts=pulumi.ResourceOptions(depends_on=[s3_bucket]))
        channel = aws_native.ivs.Channel("channel",
            name="MyRecordedChannel",
            recording_configuration_arn=recording_configuration.id,
            opts=pulumi.ResourceOptions(depends_on=[recording_configuration]))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        s3_bucket = aws_native.s3.Bucket("s3Bucket")
        recording_configuration = aws_native.ivs.RecordingConfiguration("recordingConfiguration",
            name="MyRecordingConfiguration",
            destination_configuration=aws_native.ivs.RecordingConfigurationDestinationConfigurationArgs(
                s3=aws_native.ivs.RecordingConfigurationS3DestinationConfigurationArgs(
                    bucket_name=s3_bucket.id,
                ),
            ),
            thumbnail_configuration=aws_native.ivs.RecordingConfigurationThumbnailConfigurationArgs(
                recording_mode=aws_native.ivs.RecordingConfigurationThumbnailConfigurationRecordingMode.INTERVAL,
                target_interval_seconds=60,
                resolution=aws_native.ivs.RecordingConfigurationThumbnailConfigurationResolution.HD,
                storage=[
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.SEQUENTIAL,
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.LATEST,
                ],
            ),
            rendition_configuration=aws_native.ivs.RecordingConfigurationRenditionConfigurationArgs(
                rendition_selection=aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionSelection.CUSTOM,
                renditions=[
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.HD,
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.SD,
                ],
            ),
            opts=pulumi.ResourceOptions(depends_on=[s3_bucket]))
        channel = aws_native.ivs.Channel("channel",
            name="MyRecordedChannel",
            recording_configuration_arn=recording_configuration.id,
            opts=pulumi.ResourceOptions(depends_on=[recording_configuration]))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        latest_ami_id = config.get("latestAmiId")
        if latest_ami_id is None:
            latest_ami_id = ""
        latest_ami_id_value = "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2" if latest_ami_id == "" else aws_native.get_ssm_parameter_string(name=latest_ami_id).value
        git_hub_owner = config.require("gitHubOwner")
        git_hub_repo = config.require("gitHubRepo")
        git_hub_branch = config.require("gitHubBranch")
        ssm_assoc_logs = aws_native.s3.Bucket("ssmAssocLogs")
        ssm_instance_role = aws_native.iam.Role("ssmInstanceRole",
            policies=[
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": ["s3:GetObject"],
                            "resource": [
                                "arn:aws:s3:::aws-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::aws-windows-downloads-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-packages-${AWS::Region}/*",
                                "arn:aws:s3:::${AWS::Region}-birdwatcher-prod/*",
                                "arn:aws:s3:::patch-baseline-snapshot-${AWS::Region}/*",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="ssm-custom-s3-policy",
                ),
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": [
                                "s3:GetObject",
                                "s3:PutObject",
                                "s3:PutObjectAcl",
                                "s3:ListBucket",
                            ],
                            "resource": [
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}/*",
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="s3-instance-bucket-policy",
                ),
            ],
            path="/",
            managed_policy_arns=["arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_profile = aws_native.iam.InstanceProfile("ssmInstanceProfile", roles=["SSMInstanceRole"])
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="LatestAmiId",
            instance_type="t3.small",
            iam_instance_profile="SSMInstanceProfile")
        ansible_association = aws_native.ssm.Association("ansibleAssociation",
            name="AWS-ApplyAnsiblePlaybooks",
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="InstanceIds",
                values=["EC2Instance"],
            )],
            output_location=aws_native.ssm.AssociationInstanceAssociationOutputLocationArgs(
                s3_location=aws_native.ssm.AssociationS3OutputLocationArgs(
                    output_s3_bucket_name="SSMAssocLogs",
                    output_s3_key_prefix="logs/",
                ),
            ),
            parameters={
                "sourceType": ["GitHub"],
                "sourceInfo": [\"\"\"{"owner":"${GitHubOwner}",
        "repository":"${GitHubRepo}",
        "path":"",
        "getOptions":"branch:${GitHubBranch}"}
        \"\"\"],
                "installDependencies": ["True"],
                "playbookFile": ["playbook.yml"],
                "extraVariables": ["SSM=True"],
                "check": ["False"],
                "verbose": ["-v"],
            })
        pulumi.export("webServerPublic", "EC2Instance.PublicDnsName")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        latest_ami_id = config.get("latestAmiId")
        if latest_ami_id is None:
            latest_ami_id = ""
        latest_ami_id_value = "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2" if latest_ami_id == "" else aws_native.get_ssm_parameter_string(name=latest_ami_id).value
        ssm_assoc_logs = aws_native.s3.Bucket("ssmAssocLogs")
        ssm_instance_role = aws_native.iam.Role("ssmInstanceRole",
            policies=[
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": ["s3:GetObject"],
                            "resource": [
                                "arn:aws:s3:::aws-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::aws-windows-downloads-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-packages-${AWS::Region}/*",
                                "arn:aws:s3:::${AWS::Region}-birdwatcher-prod/*",
                                "arn:aws:s3:::patch-baseline-snapshot-${AWS::Region}/*",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="ssm-custom-s3-policy",
                ),
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": [
                                "s3:GetObject",
                                "s3:PutObject",
                                "s3:PutObjectAcl",
                                "s3:ListBucket",
                            ],
                            "resource": [
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}/*",
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="s3-instance-bucket-policy",
                ),
            ],
            path="/",
            managed_policy_arns=[
                "arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore",
                "arn:${AWS::Partition}:iam::aws:policy/CloudWatchAgentServerPolicy",
            ],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_profile = aws_native.iam.InstanceProfile("ssmInstanceProfile", roles=["SSMInstanceRole"])
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="LatestAmiId",
            instance_type="t3.medium",
            iam_instance_profile="SSMInstanceProfile",
            tags=[aws_native.TagArgs(
                key="nginx",
                value="yes",
            )])
        nginx_association = aws_native.ssm.Association("nginxAssociation",
            name="AWS-RunShellScript",
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="tag:nginx",
                values=["yes"],
            )],
            output_location=aws_native.ssm.AssociationInstanceAssociationOutputLocationArgs(
                s3_location=aws_native.ssm.AssociationS3OutputLocationArgs(
                    output_s3_bucket_name="SSMAssocLogs",
                    output_s3_key_prefix="logs/",
                ),
            ),
            parameters={
                "commands": [\"\"\"sudo amazon-linux-extras install nginx1 -y
        sudo service nginx start
        \"\"\"],
            },
            opts=pulumi.ResourceOptions(depends_on=[ec2_instance]))
        pulumi.export("webServerPublic", "EC2Instance.PublicDnsName")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        latest_ami_id = config.get("latestAmiId")
        if latest_ami_id is None:
            latest_ami_id = ""
        latest_ami_id_value = "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2" if latest_ami_id == "" else aws_native.get_ssm_parameter_string(name=latest_ami_id).value
        ssm_assoc_logs = aws_native.s3.Bucket("ssmAssocLogs")
        nginx_install_automation = aws_native.ssm.Document("nginxInstallAutomation",
            document_type=aws_native.ssm.DocumentType.AUTOMATION,
            content={
                "schemaVersion": "0.3",
                "description": "Updates AMI with Linux distribution packages and installs Nginx software",
                "assumeRole": "{{AutomationAssumeRole}}",
                "parameters": {
                    "instanceId": {
                        "description": "ID of the Instance.",
                        "type": "String",
                    },
                    "automationAssumeRole": {
                        "default": "",
                        "description": "(Optional) The ARN of the role that allows Automation to perform the actions on your behalf.",
                        "type": "String",
                    },
                },
                "mainSteps": [
                    {
                        "name": "updateOSSoftware",
                        "action": "aws:runCommand",
                        "maxAttempts": 3,
                        "timeoutSeconds": 3600,
                        "inputs": {
                            "documentName": "AWS-RunShellScript",
                            "instanceIds": ["{{InstanceId}}"],
                            "cloudWatchOutputConfig": {
                                "cloudWatchOutputEnabled": "true",
                            },
                            "parameters": {
                                "commands": [\"\"\"#!/bin/bash
        sudo yum update -y
        needs-restarting -r
        if [ $? -eq 1 ]
        then
                exit 194
        else
                exit 0
        fi
        \"\"\"],
                            },
                        },
                    },
                    {
                        "name": "InstallNginx",
                        "action": "aws:runCommand",
                        "inputs": {
                            "documentName": "AWS-RunShellScript",
                            "instanceIds": ["{{InstanceId}}"],
                            "cloudWatchOutputConfig": {
                                "cloudWatchOutputEnabled": "true",
                            },
                            "parameters": {
                                "commands": [\"\"\"sudo amazon-linux-extras install nginx1 -y
        sudo service nginx start
        \"\"\"],
                            },
                        },
                    },
                    {
                        "name": "TestInstall",
                        "action": "aws:runCommand",
                        "maxAttempts": 3,
                        "timeoutSeconds": 3600,
                        "onFailure": "Abort",
                        "inputs": {
                            "documentName": "AWS-RunShellScript",
                            "instanceIds": ["{{InstanceId}}"],
                            "parameters": {
                                "commands": ["curl localhost\\n"],
                            },
                        },
                    },
                ],
            })
        ssm_execution_role = aws_native.iam.Role("ssmExecutionRole",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "action": [
                            "ssm:StartAssociationsOnce",
                            "ssm:CreateAssociation",
                            "ssm:CreateAssociationBatch",
                            "ssm:UpdateAssociation",
                        ],
                        "resource": "*",
                        "effect": "Allow",
                    }],
                },
                policy_name="ssm-association",
            )],
            path="/",
            managed_policy_arns=["arn:${AWS::Partition}:iam::aws:policy/service-role/AmazonSSMAutomationRole"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_role = aws_native.iam.Role("ssmInstanceRole",
            policies=[
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": ["s3:GetObject"],
                            "resource": [
                                "arn:aws:s3:::aws-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::aws-windows-downloads-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-packages-${AWS::Region}/*",
                                "arn:aws:s3:::${AWS::Region}-birdwatcher-prod/*",
                                "arn:aws:s3:::patch-baseline-snapshot-${AWS::Region}/*",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="ssm-custom-s3-policy",
                ),
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": [
                                "s3:GetObject",
                                "s3:PutObject",
                                "s3:PutObjectAcl",
                                "s3:ListBucket",
                            ],
                            "resource": [
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}/*",
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="s3-instance-bucket-policy",
                ),
            ],
            path="/",
            managed_policy_arns=[
                "arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore",
                "arn:${AWS::Partition}:iam::aws:policy/CloudWatchAgentServerPolicy",
            ],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_profile = aws_native.iam.InstanceProfile("ssmInstanceProfile", roles=["SSMInstanceRole"])
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="LatestAmiId",
            instance_type="t3.medium",
            iam_instance_profile="SSMInstanceProfile",
            tags=[aws_native.TagArgs(
                key="nginx",
                value="true",
            )])
        nginx_association = aws_native.ssm.Association("nginxAssociation",
            name="nginxInstallAutomation",
            output_location=aws_native.ssm.AssociationInstanceAssociationOutputLocationArgs(
                s3_location=aws_native.ssm.AssociationS3OutputLocationArgs(
                    output_s3_bucket_name="SSMAssocLogs",
                    output_s3_key_prefix="logs/",
                ),
            ),
            automation_target_parameter_name="InstanceId",
            parameters={
                "automationAssumeRole": ["SSMExecutionRole.Arn"],
            },
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="tag:nginx",
                values=["true"],
            )],
            opts=pulumi.ResourceOptions(depends_on=[ec2_instance]))
        pulumi.export("webServerPublic", "EC2Instance.PublicDnsName")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BucketAccelerateConfigurationArgs']] accelerate_configuration: Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input['BucketAccessControl'] access_control: This is a legacy property, and it is not recommended for most use cases. A majority of modern use cases in Amazon S3 no longer require the use of ACLs, and we recommend that you keep ACLs disabled. For more information, see [Controlling object ownership](https://docs.aws.amazon.com//AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
                 A canned access control list (ACL) that grants predefined permissions to the bucket. For more information about canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 User Guide*.
                 S3 buckets are created with ACLs disabled by default. Therefore, unless you explicitly set the [AWS::S3::OwnershipControls](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html) property to enable ACLs, your resource will fail to deploy with any value other than Private. Use cases requiring ACLs are uncommon.
                 The majority of access control configurations can be successfully and more easily achieved with bucket policies. For more information, see [AWS::S3::BucketPolicy](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html). For examples of common policy configurations, including S3 Server Access Logs buckets and more, see [Bucket policy examples](https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAnalyticsConfigurationArgs']]]] analytics_configurations: Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        :param pulumi.Input[pulumi.InputType['BucketEncryptionArgs']] bucket_encryption: Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[str] bucket_name: A name for the bucket. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html). For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules) in the *Amazon S3 User Guide*. 
                 If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
        :param pulumi.Input[pulumi.InputType['BucketCorsConfigurationArgs']] cors_configuration: Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketIntelligentTieringConfigurationArgs']]]] intelligent_tiering_configurations: Defines how Amazon S3 handles Intelligent-Tiering storage.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketInventoryConfigurationArgs']]]] inventory_configurations: Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
        :param pulumi.Input[pulumi.InputType['BucketLifecycleConfigurationArgs']] lifecycle_configuration: Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
        :param pulumi.Input[pulumi.InputType['BucketLoggingConfigurationArgs']] logging_configuration: Settings that define where logs are stored.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketMetricsConfigurationArgs']]]] metrics_configurations: Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html).
        :param pulumi.Input[pulumi.InputType['BucketNotificationConfigurationArgs']] notification_configuration: Configuration that defines how Amazon S3 handles bucket notifications.
        :param pulumi.Input[pulumi.InputType['BucketObjectLockConfigurationArgs']] object_lock_configuration: This operation is not supported by directory buckets.
                 Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). 
                  +  The ``DefaultRetention`` settings require both a mode and a period.
                 +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
                 +  You can enable Object Lock for new or existing buckets. For more information, see [Configuring Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-configure.html).
        :param pulumi.Input[bool] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        :param pulumi.Input[pulumi.InputType['BucketOwnershipControlsArgs']] ownership_controls: Configuration that defines how Amazon S3 handles Object Ownership rules.
        :param pulumi.Input[pulumi.InputType['BucketPublicAccessBlockConfigurationArgs']] public_access_block_configuration: Configuration that defines how Amazon S3 handles public access.
        :param pulumi.Input[pulumi.InputType['BucketReplicationConfigurationArgs']] replication_configuration: Configuration for replicating objects in an S3 bucket. To enable replication, you must also enable versioning by using the ``VersioningConfiguration`` property.
                Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An arbitrary set of tags (key-value pairs) for this S3 bucket.
        :param pulumi.Input[pulumi.InputType['BucketVersioningConfigurationArgs']] versioning_configuration: Enables multiple versions of all objects in this bucket. You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
        :param pulumi.Input[pulumi.InputType['BucketWebsiteConfigurationArgs']] website_configuration: Information used to configure the bucket as a static website. For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::S3::Bucket`` resource creates an Amazon S3 bucket in the same AWS Region where you create the AWS CloudFormation stack.
         To control how AWS CloudFormation handles the bucket when the stack is deleted, you can set a deletion policy for your bucket. You can choose to *retain* the bucket or to *delete* the bucket. For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).
          You can only delete empty buckets. Deletion fails for buckets that have contents.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        s3_bucket = aws_native.s3.Bucket("s3Bucket")
        recording_configuration = aws_native.ivs.RecordingConfiguration("recordingConfiguration",
            name="MyRecordingConfiguration",
            destination_configuration=aws_native.ivs.RecordingConfigurationDestinationConfigurationArgs(
                s3=aws_native.ivs.RecordingConfigurationS3DestinationConfigurationArgs(
                    bucket_name=s3_bucket.id,
                ),
            ),
            thumbnail_configuration=aws_native.ivs.RecordingConfigurationThumbnailConfigurationArgs(
                recording_mode=aws_native.ivs.RecordingConfigurationThumbnailConfigurationRecordingMode.INTERVAL,
                target_interval_seconds=60,
                storage=[
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.SEQUENTIAL,
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.LATEST,
                ],
                resolution=aws_native.ivs.RecordingConfigurationThumbnailConfigurationResolution.HD,
            ),
            rendition_configuration=aws_native.ivs.RecordingConfigurationRenditionConfigurationArgs(
                rendition_selection=aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionSelection.CUSTOM,
                renditions=[
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.HD,
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.SD,
                ],
            ),
            opts=pulumi.ResourceOptions(depends_on=[s3_bucket]))
        channel = aws_native.ivs.Channel("channel",
            name="MyRecordedChannel",
            recording_configuration_arn=recording_configuration.id,
            opts=pulumi.ResourceOptions(depends_on=[recording_configuration]))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        s3_bucket = aws_native.s3.Bucket("s3Bucket")
        recording_configuration = aws_native.ivs.RecordingConfiguration("recordingConfiguration",
            name="MyRecordingConfiguration",
            destination_configuration=aws_native.ivs.RecordingConfigurationDestinationConfigurationArgs(
                s3=aws_native.ivs.RecordingConfigurationS3DestinationConfigurationArgs(
                    bucket_name=s3_bucket.id,
                ),
            ),
            thumbnail_configuration=aws_native.ivs.RecordingConfigurationThumbnailConfigurationArgs(
                recording_mode=aws_native.ivs.RecordingConfigurationThumbnailConfigurationRecordingMode.INTERVAL,
                target_interval_seconds=60,
                resolution=aws_native.ivs.RecordingConfigurationThumbnailConfigurationResolution.HD,
                storage=[
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.SEQUENTIAL,
                    aws_native.ivs.RecordingConfigurationThumbnailConfigurationStorageItem.LATEST,
                ],
            ),
            rendition_configuration=aws_native.ivs.RecordingConfigurationRenditionConfigurationArgs(
                rendition_selection=aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionSelection.CUSTOM,
                renditions=[
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.HD,
                    aws_native.ivs.RecordingConfigurationRenditionConfigurationRenditionsItem.SD,
                ],
            ),
            opts=pulumi.ResourceOptions(depends_on=[s3_bucket]))
        channel = aws_native.ivs.Channel("channel",
            name="MyRecordedChannel",
            recording_configuration_arn=recording_configuration.id,
            opts=pulumi.ResourceOptions(depends_on=[recording_configuration]))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        latest_ami_id = config.get("latestAmiId")
        if latest_ami_id is None:
            latest_ami_id = ""
        latest_ami_id_value = "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2" if latest_ami_id == "" else aws_native.get_ssm_parameter_string(name=latest_ami_id).value
        git_hub_owner = config.require("gitHubOwner")
        git_hub_repo = config.require("gitHubRepo")
        git_hub_branch = config.require("gitHubBranch")
        ssm_assoc_logs = aws_native.s3.Bucket("ssmAssocLogs")
        ssm_instance_role = aws_native.iam.Role("ssmInstanceRole",
            policies=[
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": ["s3:GetObject"],
                            "resource": [
                                "arn:aws:s3:::aws-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::aws-windows-downloads-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-packages-${AWS::Region}/*",
                                "arn:aws:s3:::${AWS::Region}-birdwatcher-prod/*",
                                "arn:aws:s3:::patch-baseline-snapshot-${AWS::Region}/*",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="ssm-custom-s3-policy",
                ),
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": [
                                "s3:GetObject",
                                "s3:PutObject",
                                "s3:PutObjectAcl",
                                "s3:ListBucket",
                            ],
                            "resource": [
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}/*",
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="s3-instance-bucket-policy",
                ),
            ],
            path="/",
            managed_policy_arns=["arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_profile = aws_native.iam.InstanceProfile("ssmInstanceProfile", roles=["SSMInstanceRole"])
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="LatestAmiId",
            instance_type="t3.small",
            iam_instance_profile="SSMInstanceProfile")
        ansible_association = aws_native.ssm.Association("ansibleAssociation",
            name="AWS-ApplyAnsiblePlaybooks",
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="InstanceIds",
                values=["EC2Instance"],
            )],
            output_location=aws_native.ssm.AssociationInstanceAssociationOutputLocationArgs(
                s3_location=aws_native.ssm.AssociationS3OutputLocationArgs(
                    output_s3_bucket_name="SSMAssocLogs",
                    output_s3_key_prefix="logs/",
                ),
            ),
            parameters={
                "sourceType": ["GitHub"],
                "sourceInfo": [\"\"\"{"owner":"${GitHubOwner}",
        "repository":"${GitHubRepo}",
        "path":"",
        "getOptions":"branch:${GitHubBranch}"}
        \"\"\"],
                "installDependencies": ["True"],
                "playbookFile": ["playbook.yml"],
                "extraVariables": ["SSM=True"],
                "check": ["False"],
                "verbose": ["-v"],
            })
        pulumi.export("webServerPublic", "EC2Instance.PublicDnsName")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        latest_ami_id = config.get("latestAmiId")
        if latest_ami_id is None:
            latest_ami_id = ""
        latest_ami_id_value = "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2" if latest_ami_id == "" else aws_native.get_ssm_parameter_string(name=latest_ami_id).value
        ssm_assoc_logs = aws_native.s3.Bucket("ssmAssocLogs")
        ssm_instance_role = aws_native.iam.Role("ssmInstanceRole",
            policies=[
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": ["s3:GetObject"],
                            "resource": [
                                "arn:aws:s3:::aws-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::aws-windows-downloads-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-packages-${AWS::Region}/*",
                                "arn:aws:s3:::${AWS::Region}-birdwatcher-prod/*",
                                "arn:aws:s3:::patch-baseline-snapshot-${AWS::Region}/*",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="ssm-custom-s3-policy",
                ),
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": [
                                "s3:GetObject",
                                "s3:PutObject",
                                "s3:PutObjectAcl",
                                "s3:ListBucket",
                            ],
                            "resource": [
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}/*",
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="s3-instance-bucket-policy",
                ),
            ],
            path="/",
            managed_policy_arns=[
                "arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore",
                "arn:${AWS::Partition}:iam::aws:policy/CloudWatchAgentServerPolicy",
            ],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_profile = aws_native.iam.InstanceProfile("ssmInstanceProfile", roles=["SSMInstanceRole"])
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="LatestAmiId",
            instance_type="t3.medium",
            iam_instance_profile="SSMInstanceProfile",
            tags=[aws_native.TagArgs(
                key="nginx",
                value="yes",
            )])
        nginx_association = aws_native.ssm.Association("nginxAssociation",
            name="AWS-RunShellScript",
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="tag:nginx",
                values=["yes"],
            )],
            output_location=aws_native.ssm.AssociationInstanceAssociationOutputLocationArgs(
                s3_location=aws_native.ssm.AssociationS3OutputLocationArgs(
                    output_s3_bucket_name="SSMAssocLogs",
                    output_s3_key_prefix="logs/",
                ),
            ),
            parameters={
                "commands": [\"\"\"sudo amazon-linux-extras install nginx1 -y
        sudo service nginx start
        \"\"\"],
            },
            opts=pulumi.ResourceOptions(depends_on=[ec2_instance]))
        pulumi.export("webServerPublic", "EC2Instance.PublicDnsName")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        latest_ami_id = config.get("latestAmiId")
        if latest_ami_id is None:
            latest_ami_id = ""
        latest_ami_id_value = "/aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2" if latest_ami_id == "" else aws_native.get_ssm_parameter_string(name=latest_ami_id).value
        ssm_assoc_logs = aws_native.s3.Bucket("ssmAssocLogs")
        nginx_install_automation = aws_native.ssm.Document("nginxInstallAutomation",
            document_type=aws_native.ssm.DocumentType.AUTOMATION,
            content={
                "schemaVersion": "0.3",
                "description": "Updates AMI with Linux distribution packages and installs Nginx software",
                "assumeRole": "{{AutomationAssumeRole}}",
                "parameters": {
                    "instanceId": {
                        "description": "ID of the Instance.",
                        "type": "String",
                    },
                    "automationAssumeRole": {
                        "default": "",
                        "description": "(Optional) The ARN of the role that allows Automation to perform the actions on your behalf.",
                        "type": "String",
                    },
                },
                "mainSteps": [
                    {
                        "name": "updateOSSoftware",
                        "action": "aws:runCommand",
                        "maxAttempts": 3,
                        "timeoutSeconds": 3600,
                        "inputs": {
                            "documentName": "AWS-RunShellScript",
                            "instanceIds": ["{{InstanceId}}"],
                            "cloudWatchOutputConfig": {
                                "cloudWatchOutputEnabled": "true",
                            },
                            "parameters": {
                                "commands": [\"\"\"#!/bin/bash
        sudo yum update -y
        needs-restarting -r
        if [ $? -eq 1 ]
        then
                exit 194
        else
                exit 0
        fi
        \"\"\"],
                            },
                        },
                    },
                    {
                        "name": "InstallNginx",
                        "action": "aws:runCommand",
                        "inputs": {
                            "documentName": "AWS-RunShellScript",
                            "instanceIds": ["{{InstanceId}}"],
                            "cloudWatchOutputConfig": {
                                "cloudWatchOutputEnabled": "true",
                            },
                            "parameters": {
                                "commands": [\"\"\"sudo amazon-linux-extras install nginx1 -y
        sudo service nginx start
        \"\"\"],
                            },
                        },
                    },
                    {
                        "name": "TestInstall",
                        "action": "aws:runCommand",
                        "maxAttempts": 3,
                        "timeoutSeconds": 3600,
                        "onFailure": "Abort",
                        "inputs": {
                            "documentName": "AWS-RunShellScript",
                            "instanceIds": ["{{InstanceId}}"],
                            "parameters": {
                                "commands": ["curl localhost\\n"],
                            },
                        },
                    },
                ],
            })
        ssm_execution_role = aws_native.iam.Role("ssmExecutionRole",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "action": [
                            "ssm:StartAssociationsOnce",
                            "ssm:CreateAssociation",
                            "ssm:CreateAssociationBatch",
                            "ssm:UpdateAssociation",
                        ],
                        "resource": "*",
                        "effect": "Allow",
                    }],
                },
                policy_name="ssm-association",
            )],
            path="/",
            managed_policy_arns=["arn:${AWS::Partition}:iam::aws:policy/service-role/AmazonSSMAutomationRole"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_role = aws_native.iam.Role("ssmInstanceRole",
            policies=[
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": ["s3:GetObject"],
                            "resource": [
                                "arn:aws:s3:::aws-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::aws-windows-downloads-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-${AWS::Region}/*",
                                "arn:aws:s3:::amazon-ssm-packages-${AWS::Region}/*",
                                "arn:aws:s3:::${AWS::Region}-birdwatcher-prod/*",
                                "arn:aws:s3:::patch-baseline-snapshot-${AWS::Region}/*",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="ssm-custom-s3-policy",
                ),
                aws_native.iam.RolePolicyArgs(
                    policy_document={
                        "version": "2012-10-17",
                        "statement": [{
                            "action": [
                                "s3:GetObject",
                                "s3:PutObject",
                                "s3:PutObjectAcl",
                                "s3:ListBucket",
                            ],
                            "resource": [
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}/*",
                                "arn:${AWS::Partition}:s3:::${SSMAssocLogs}",
                            ],
                            "effect": "Allow",
                        }],
                    },
                    policy_name="s3-instance-bucket-policy",
                ),
            ],
            path="/",
            managed_policy_arns=[
                "arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore",
                "arn:${AWS::Partition}:iam::aws:policy/CloudWatchAgentServerPolicy",
            ],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "ec2.amazonaws.com",
                            "ssm.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            })
        ssm_instance_profile = aws_native.iam.InstanceProfile("ssmInstanceProfile", roles=["SSMInstanceRole"])
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="LatestAmiId",
            instance_type="t3.medium",
            iam_instance_profile="SSMInstanceProfile",
            tags=[aws_native.TagArgs(
                key="nginx",
                value="true",
            )])
        nginx_association = aws_native.ssm.Association("nginxAssociation",
            name="nginxInstallAutomation",
            output_location=aws_native.ssm.AssociationInstanceAssociationOutputLocationArgs(
                s3_location=aws_native.ssm.AssociationS3OutputLocationArgs(
                    output_s3_bucket_name="SSMAssocLogs",
                    output_s3_key_prefix="logs/",
                ),
            ),
            automation_target_parameter_name="InstanceId",
            parameters={
                "automationAssumeRole": ["SSMExecutionRole.Arn"],
            },
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="tag:nginx",
                values=["true"],
            )],
            opts=pulumi.ResourceOptions(depends_on=[ec2_instance]))
        pulumi.export("webServerPublic", "EC2Instance.PublicDnsName")

        ```

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerate_configuration: Optional[pulumi.Input[pulumi.InputType['BucketAccelerateConfigurationArgs']]] = None,
                 access_control: Optional[pulumi.Input['BucketAccessControl']] = None,
                 analytics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAnalyticsConfigurationArgs']]]]] = None,
                 bucket_encryption: Optional[pulumi.Input[pulumi.InputType['BucketEncryptionArgs']]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 cors_configuration: Optional[pulumi.Input[pulumi.InputType['BucketCorsConfigurationArgs']]] = None,
                 intelligent_tiering_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketIntelligentTieringConfigurationArgs']]]]] = None,
                 inventory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketInventoryConfigurationArgs']]]]] = None,
                 lifecycle_configuration: Optional[pulumi.Input[pulumi.InputType['BucketLifecycleConfigurationArgs']]] = None,
                 logging_configuration: Optional[pulumi.Input[pulumi.InputType['BucketLoggingConfigurationArgs']]] = None,
                 metrics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketMetricsConfigurationArgs']]]]] = None,
                 notification_configuration: Optional[pulumi.Input[pulumi.InputType['BucketNotificationConfigurationArgs']]] = None,
                 object_lock_configuration: Optional[pulumi.Input[pulumi.InputType['BucketObjectLockConfigurationArgs']]] = None,
                 object_lock_enabled: Optional[pulumi.Input[bool]] = None,
                 ownership_controls: Optional[pulumi.Input[pulumi.InputType['BucketOwnershipControlsArgs']]] = None,
                 public_access_block_configuration: Optional[pulumi.Input[pulumi.InputType['BucketPublicAccessBlockConfigurationArgs']]] = None,
                 replication_configuration: Optional[pulumi.Input[pulumi.InputType['BucketReplicationConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 versioning_configuration: Optional[pulumi.Input[pulumi.InputType['BucketVersioningConfigurationArgs']]] = None,
                 website_configuration: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["accelerate_configuration"] = accelerate_configuration
            __props__.__dict__["access_control"] = access_control
            __props__.__dict__["analytics_configurations"] = analytics_configurations
            __props__.__dict__["bucket_encryption"] = bucket_encryption
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["cors_configuration"] = cors_configuration
            __props__.__dict__["intelligent_tiering_configurations"] = intelligent_tiering_configurations
            __props__.__dict__["inventory_configurations"] = inventory_configurations
            __props__.__dict__["lifecycle_configuration"] = lifecycle_configuration
            __props__.__dict__["logging_configuration"] = logging_configuration
            __props__.__dict__["metrics_configurations"] = metrics_configurations
            __props__.__dict__["notification_configuration"] = notification_configuration
            __props__.__dict__["object_lock_configuration"] = object_lock_configuration
            __props__.__dict__["object_lock_enabled"] = object_lock_enabled
            __props__.__dict__["ownership_controls"] = ownership_controls
            __props__.__dict__["public_access_block_configuration"] = public_access_block_configuration
            __props__.__dict__["replication_configuration"] = replication_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versioning_configuration"] = versioning_configuration
            __props__.__dict__["website_configuration"] = website_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["dual_stack_domain_name"] = None
            __props__.__dict__["regional_domain_name"] = None
            __props__.__dict__["website_url"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["bucketName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Bucket, __self__).__init__(
            'aws-native:s3:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BucketArgs.__new__(BucketArgs)

        __props__.__dict__["accelerate_configuration"] = None
        __props__.__dict__["access_control"] = None
        __props__.__dict__["analytics_configurations"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["bucket_encryption"] = None
        __props__.__dict__["bucket_name"] = None
        __props__.__dict__["cors_configuration"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["dual_stack_domain_name"] = None
        __props__.__dict__["intelligent_tiering_configurations"] = None
        __props__.__dict__["inventory_configurations"] = None
        __props__.__dict__["lifecycle_configuration"] = None
        __props__.__dict__["logging_configuration"] = None
        __props__.__dict__["metrics_configurations"] = None
        __props__.__dict__["notification_configuration"] = None
        __props__.__dict__["object_lock_configuration"] = None
        __props__.__dict__["object_lock_enabled"] = None
        __props__.__dict__["ownership_controls"] = None
        __props__.__dict__["public_access_block_configuration"] = None
        __props__.__dict__["regional_domain_name"] = None
        __props__.__dict__["replication_configuration"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["versioning_configuration"] = None
        __props__.__dict__["website_configuration"] = None
        __props__.__dict__["website_url"] = None
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accelerateConfiguration")
    def accelerate_configuration(self) -> pulumi.Output[Optional['outputs.BucketAccelerateConfiguration']]:
        """
        Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "accelerate_configuration")

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> pulumi.Output[Optional['BucketAccessControl']]:
        """
        This is a legacy property, and it is not recommended for most use cases. A majority of modern use cases in Amazon S3 no longer require the use of ACLs, and we recommend that you keep ACLs disabled. For more information, see [Controlling object ownership](https://docs.aws.amazon.com//AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
          A canned access control list (ACL) that grants predefined permissions to the bucket. For more information about canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 User Guide*.
          S3 buckets are created with ACLs disabled by default. Therefore, unless you explicitly set the [AWS::S3::OwnershipControls](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html) property to enable ACLs, your resource will fail to deploy with any value other than Private. Use cases requiring ACLs are uncommon.
          The majority of access control configurations can be successfully and more easily achieved with bucket policies. For more information, see [AWS::S3::BucketPolicy](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html). For examples of common policy configurations, including S3 Server Access Logs buckets and more, see [Bucket policy examples](https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="analyticsConfigurations")
    def analytics_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.BucketAnalyticsConfiguration']]]:
        """
        Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        """
        return pulumi.get(self, "analytics_configurations")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bucketEncryption")
    def bucket_encryption(self) -> pulumi.Output[Optional['outputs.BucketEncryption']]:
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "bucket_encryption")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[Optional[str]]:
        """
        A name for the bucket. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html). For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules) in the *Amazon S3 User Guide*. 
          If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> pulumi.Output[Optional['outputs.BucketCorsConfiguration']]:
        """
        Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "cors_configuration")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="dualStackDomainName")
    def dual_stack_domain_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "dual_stack_domain_name")

    @property
    @pulumi.getter(name="intelligentTieringConfigurations")
    def intelligent_tiering_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.BucketIntelligentTieringConfiguration']]]:
        """
        Defines how Amazon S3 handles Intelligent-Tiering storage.
        """
        return pulumi.get(self, "intelligent_tiering_configurations")

    @property
    @pulumi.getter(name="inventoryConfigurations")
    def inventory_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.BucketInventoryConfiguration']]]:
        """
        Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
        """
        return pulumi.get(self, "inventory_configurations")

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> pulumi.Output[Optional['outputs.BucketLifecycleConfiguration']]:
        """
        Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "lifecycle_configuration")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> pulumi.Output[Optional['outputs.BucketLoggingConfiguration']]:
        """
        Settings that define where logs are stored.
        """
        return pulumi.get(self, "logging_configuration")

    @property
    @pulumi.getter(name="metricsConfigurations")
    def metrics_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.BucketMetricsConfiguration']]]:
        """
        Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html).
        """
        return pulumi.get(self, "metrics_configurations")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output[Optional['outputs.BucketNotificationConfiguration']]:
        """
        Configuration that defines how Amazon S3 handles bucket notifications.
        """
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> pulumi.Output[Optional['outputs.BucketObjectLockConfiguration']]:
        """
        This operation is not supported by directory buckets.
          Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). 
           +  The ``DefaultRetention`` settings require both a mode and a period.
          +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
          +  You can enable Object Lock for new or existing buckets. For more information, see [Configuring Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-configure.html).
        """
        return pulumi.get(self, "object_lock_configuration")

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        """
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter(name="ownershipControls")
    def ownership_controls(self) -> pulumi.Output[Optional['outputs.BucketOwnershipControls']]:
        """
        Configuration that defines how Amazon S3 handles Object Ownership rules.
        """
        return pulumi.get(self, "ownership_controls")

    @property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> pulumi.Output[Optional['outputs.BucketPublicAccessBlockConfiguration']]:
        """
        Configuration that defines how Amazon S3 handles public access.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @property
    @pulumi.getter(name="regionalDomainName")
    def regional_domain_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "regional_domain_name")

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> pulumi.Output[Optional['outputs.BucketReplicationConfiguration']]:
        """
        Configuration for replicating objects in an S3 bucket. To enable replication, you must also enable versioning by using the ``VersioningConfiguration`` property.
         Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
        """
        return pulumi.get(self, "replication_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this S3 bucket.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versioningConfiguration")
    def versioning_configuration(self) -> pulumi.Output[Optional['outputs.BucketVersioningConfiguration']]:
        """
        Enables multiple versions of all objects in this bucket. You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
        """
        return pulumi.get(self, "versioning_configuration")

    @property
    @pulumi.getter(name="websiteConfiguration")
    def website_configuration(self) -> pulumi.Output[Optional['outputs.BucketWebsiteConfiguration']]:
        """
        Information used to configure the bucket as a static website. For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
        """
        return pulumi.get(self, "website_configuration")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "website_url")

