# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['AccessGrantsInstanceArgs', 'AccessGrantsInstance']

@pulumi.input_type
class AccessGrantsInstanceArgs:
    def __init__(__self__, *,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a AccessGrantsInstance resource.
        :param pulumi.Input[str] identity_center_arn: The Amazon Resource Name (ARN) of the specified AWS Identity Center.
        """
        if identity_center_arn is not None:
            pulumi.set(__self__, "identity_center_arn", identity_center_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="identityCenterArn")
    def identity_center_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the specified AWS Identity Center.
        """
        return pulumi.get(self, "identity_center_arn")

    @identity_center_arn.setter
    def identity_center_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_center_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


class AccessGrantsInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]]] = None,
                 __props__=None):
        """
        The AWS::S3::AccessGrantsInstance resource is an Amazon S3 resource type that hosts Access Grants and their associated locations

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identity_center_arn: The Amazon Resource Name (ARN) of the specified AWS Identity Center.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccessGrantsInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::S3::AccessGrantsInstance resource is an Amazon S3 resource type that hosts Access Grants and their associated locations

        :param str resource_name: The name of the resource.
        :param AccessGrantsInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessGrantsInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessGrantsInstanceArgs.__new__(AccessGrantsInstanceArgs)

            __props__.__dict__["identity_center_arn"] = identity_center_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["access_grants_instance_arn"] = None
            __props__.__dict__["access_grants_instance_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccessGrantsInstance, __self__).__init__(
            'aws-native:s3:AccessGrantsInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccessGrantsInstance':
        """
        Get an existing AccessGrantsInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccessGrantsInstanceArgs.__new__(AccessGrantsInstanceArgs)

        __props__.__dict__["access_grants_instance_arn"] = None
        __props__.__dict__["access_grants_instance_id"] = None
        __props__.__dict__["identity_center_arn"] = None
        __props__.__dict__["tags"] = None
        return AccessGrantsInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessGrantsInstanceArn")
    def access_grants_instance_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the specified Access Grants instance.
        """
        return pulumi.get(self, "access_grants_instance_arn")

    @property
    @pulumi.getter(name="accessGrantsInstanceId")
    def access_grants_instance_id(self) -> pulumi.Output[str]:
        """
        A unique identifier for the specified access grants instance.
        """
        return pulumi.get(self, "access_grants_instance_id")

    @property
    @pulumi.getter(name="identityCenterArn")
    def identity_center_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the specified AWS Identity Center.
        """
        return pulumi.get(self, "identity_center_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        return pulumi.get(self, "tags")

