# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    def __init__(__self__, cluster_arn=None, cluster_endpoints=None, status=None):
        if cluster_arn and not isinstance(cluster_arn, str):
            raise TypeError("Expected argument 'cluster_arn' to be a str")
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        if cluster_endpoints and not isinstance(cluster_endpoints, list):
            raise TypeError("Expected argument 'cluster_endpoints' to be a list")
        pulumi.set(__self__, "cluster_endpoints", cluster_endpoints)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @property
    @pulumi.getter(name="clusterEndpoints")
    def cluster_endpoints(self) -> Optional[Sequence['outputs.ClusterEndpoint']]:
        """
        Endpoints for the cluster.
        """
        return pulumi.get(self, "cluster_endpoints")

    @property
    @pulumi.getter
    def status(self) -> Optional['ClusterStatus']:
        """
        Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
        """
        return pulumi.get(self, "status")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            cluster_arn=self.cluster_arn,
            cluster_endpoints=self.cluster_endpoints,
            status=self.status)


def get_cluster(cluster_arn: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    AWS Route53 Recovery Control Cluster resource schema


    :param str cluster_arn: The Amazon Resource Name (ARN) of the cluster.
    """
    __args__ = dict()
    __args__['clusterArn'] = cluster_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53recoverycontrol:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        cluster_arn=pulumi.get(__ret__, 'cluster_arn'),
        cluster_endpoints=pulumi.get(__ret__, 'cluster_endpoints'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_cluster)
def get_cluster_output(cluster_arn: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterResult]:
    """
    AWS Route53 Recovery Control Cluster resource schema


    :param str cluster_arn: The Amazon Resource Name (ARN) of the cluster.
    """
    ...
