# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ProfileResourceAssociationArgs', 'ProfileResourceAssociation']

@pulumi.input_type
class ProfileResourceAssociationArgs:
    def __init__(__self__, *,
                 profile_id: pulumi.Input[str],
                 resource_arn: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 resource_properties: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProfileResourceAssociation resource.
        :param pulumi.Input[str] profile_id: The ID of the  profile that you associated the resource to that is specified by ResourceArn.
        :param pulumi.Input[str] resource_arn: The arn of the resource that you associated to the  Profile.
        :param pulumi.Input[str] name: The name of an association between the  Profile and resource.
        :param pulumi.Input[str] resource_properties: A JSON-formatted string with key-value pairs specifying the properties of the associated resource.
        """
        pulumi.set(__self__, "profile_id", profile_id)
        pulumi.set(__self__, "resource_arn", resource_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_properties is not None:
            pulumi.set(__self__, "resource_properties", resource_properties)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[str]:
        """
        The ID of the  profile that you associated the resource to that is specified by ResourceArn.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[str]:
        """
        The arn of the resource that you associated to the  Profile.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an association between the  Profile and resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON-formatted string with key-value pairs specifying the properties of the associated resource.
        """
        return pulumi.get(self, "resource_properties")

    @resource_properties.setter
    def resource_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_properties", value)


class ProfileResourceAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 resource_properties: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Route53Profiles::ProfileResourceAssociation

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of an association between the  Profile and resource.
        :param pulumi.Input[str] profile_id: The ID of the  profile that you associated the resource to that is specified by ResourceArn.
        :param pulumi.Input[str] resource_arn: The arn of the resource that you associated to the  Profile.
        :param pulumi.Input[str] resource_properties: A JSON-formatted string with key-value pairs specifying the properties of the associated resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileResourceAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Route53Profiles::ProfileResourceAssociation

        :param str resource_name: The name of the resource.
        :param ProfileResourceAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileResourceAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 resource_properties: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileResourceAssociationArgs.__new__(ProfileResourceAssociationArgs)

            __props__.__dict__["name"] = name
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
            __props__.__dict__["resource_properties"] = resource_properties
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["resource_type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name", "profileId", "resourceArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ProfileResourceAssociation, __self__).__init__(
            'aws-native:route53profiles:ProfileResourceAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProfileResourceAssociation':
        """
        Get an existing ProfileResourceAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProfileResourceAssociationArgs.__new__(ProfileResourceAssociationArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["profile_id"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["resource_properties"] = None
        __props__.__dict__["resource_type"] = None
        return ProfileResourceAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        Primary Identifier for  Profile Resource Association
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of an association between the  Profile and resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[str]:
        """
        The ID of the  profile that you associated the resource to that is specified by ResourceArn.
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[str]:
        """
        The arn of the resource that you associated to the  Profile.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON-formatted string with key-value pairs specifying the properties of the associated resource.
        """
        return pulumi.get(self, "resource_properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        The type of the resource associated to the  Profile.
        """
        return pulumi.get(self, "resource_type")

