# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CidrCollectionLocation',
    'HealthCheckAlarmIdentifier',
    'HealthCheckConfigProperties',
    'HealthCheckTag',
    'HostedZoneConfig',
    'HostedZoneQueryLoggingConfig',
    'HostedZoneTag',
    'HostedZoneVpc',
]

@pulumi.output_type
class CidrCollectionLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrList":
            suggest = "cidr_list"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CidrCollectionLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CidrCollectionLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CidrCollectionLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_list: Sequence[str],
                 location_name: str):
        """
        :param Sequence[str] cidr_list: A list of CIDR blocks.
        :param str location_name: The name of the location that is associated with the CIDR collection.
        """
        pulumi.set(__self__, "cidr_list", cidr_list)
        pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> Sequence[str]:
        """
        A list of CIDR blocks.
        """
        return pulumi.get(self, "cidr_list")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> str:
        """
        The name of the location that is associated with the CIDR collection.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class HealthCheckAlarmIdentifier(dict):
    """
    A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
    """
    def __init__(__self__, *,
                 name: str,
                 region: str):
        """
        A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
        :param str name: The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
        :param str region: For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class HealthCheckConfigProperties(dict):
    """
    A complex type that contains information about the health check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmIdentifier":
            suggest = "alarm_identifier"
        elif key == "childHealthChecks":
            suggest = "child_health_checks"
        elif key == "enableSni":
            suggest = "enable_sni"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "fullyQualifiedDomainName":
            suggest = "fully_qualified_domain_name"
        elif key == "healthThreshold":
            suggest = "health_threshold"
        elif key == "insufficientDataHealthStatus":
            suggest = "insufficient_data_health_status"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "measureLatency":
            suggest = "measure_latency"
        elif key == "requestInterval":
            suggest = "request_interval"
        elif key == "resourcePath":
            suggest = "resource_path"
        elif key == "routingControlArn":
            suggest = "routing_control_arn"
        elif key == "searchString":
            suggest = "search_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthCheckConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthCheckConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthCheckConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'HealthCheckConfigPropertiesType',
                 alarm_identifier: Optional['outputs.HealthCheckAlarmIdentifier'] = None,
                 child_health_checks: Optional[Sequence[str]] = None,
                 enable_sni: Optional[bool] = None,
                 failure_threshold: Optional[int] = None,
                 fully_qualified_domain_name: Optional[str] = None,
                 health_threshold: Optional[int] = None,
                 insufficient_data_health_status: Optional['HealthCheckConfigPropertiesInsufficientDataHealthStatus'] = None,
                 inverted: Optional[bool] = None,
                 ip_address: Optional[str] = None,
                 measure_latency: Optional[bool] = None,
                 port: Optional[int] = None,
                 regions: Optional[Sequence[str]] = None,
                 request_interval: Optional[int] = None,
                 resource_path: Optional[str] = None,
                 routing_control_arn: Optional[str] = None,
                 search_string: Optional[str] = None):
        """
        A complex type that contains information about the health check.
        """
        pulumi.set(__self__, "type", type)
        if alarm_identifier is not None:
            pulumi.set(__self__, "alarm_identifier", alarm_identifier)
        if child_health_checks is not None:
            pulumi.set(__self__, "child_health_checks", child_health_checks)
        if enable_sni is not None:
            pulumi.set(__self__, "enable_sni", enable_sni)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if fully_qualified_domain_name is not None:
            pulumi.set(__self__, "fully_qualified_domain_name", fully_qualified_domain_name)
        if health_threshold is not None:
            pulumi.set(__self__, "health_threshold", health_threshold)
        if insufficient_data_health_status is not None:
            pulumi.set(__self__, "insufficient_data_health_status", insufficient_data_health_status)
        if inverted is not None:
            pulumi.set(__self__, "inverted", inverted)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if measure_latency is not None:
            pulumi.set(__self__, "measure_latency", measure_latency)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if request_interval is not None:
            pulumi.set(__self__, "request_interval", request_interval)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if routing_control_arn is not None:
            pulumi.set(__self__, "routing_control_arn", routing_control_arn)
        if search_string is not None:
            pulumi.set(__self__, "search_string", search_string)

    @property
    @pulumi.getter
    def type(self) -> 'HealthCheckConfigPropertiesType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="alarmIdentifier")
    def alarm_identifier(self) -> Optional['outputs.HealthCheckAlarmIdentifier']:
        return pulumi.get(self, "alarm_identifier")

    @property
    @pulumi.getter(name="childHealthChecks")
    def child_health_checks(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "child_health_checks")

    @property
    @pulumi.getter(name="enableSni")
    def enable_sni(self) -> Optional[bool]:
        return pulumi.get(self, "enable_sni")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> Optional[str]:
        return pulumi.get(self, "fully_qualified_domain_name")

    @property
    @pulumi.getter(name="healthThreshold")
    def health_threshold(self) -> Optional[int]:
        return pulumi.get(self, "health_threshold")

    @property
    @pulumi.getter(name="insufficientDataHealthStatus")
    def insufficient_data_health_status(self) -> Optional['HealthCheckConfigPropertiesInsufficientDataHealthStatus']:
        return pulumi.get(self, "insufficient_data_health_status")

    @property
    @pulumi.getter
    def inverted(self) -> Optional[bool]:
        return pulumi.get(self, "inverted")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="measureLatency")
    def measure_latency(self) -> Optional[bool]:
        return pulumi.get(self, "measure_latency")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requestInterval")
    def request_interval(self) -> Optional[int]:
        return pulumi.get(self, "request_interval")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[str]:
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter(name="routingControlArn")
    def routing_control_arn(self) -> Optional[str]:
        return pulumi.get(self, "routing_control_arn")

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[str]:
        return pulumi.get(self, "search_string")


@pulumi.output_type
class HealthCheckTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag.
        :param str value: The value for the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HostedZoneConfig(dict):
    """
    A complex type that contains an optional comment about your hosted zone. If you don't want to specify a comment, omit both the ``HostedZoneConfig`` and ``Comment`` elements.
    """
    def __init__(__self__, *,
                 comment: Optional[str] = None):
        """
        A complex type that contains an optional comment about your hosted zone. If you don't want to specify a comment, omit both the ``HostedZoneConfig`` and ``Comment`` elements.
        :param str comment: Any comments that you want to include about the hosted zone.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Any comments that you want to include about the hosted zone.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class HostedZoneQueryLoggingConfig(dict):
    """
    A complex type that contains information about a configuration for DNS query logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsLogGroupArn":
            suggest = "cloud_watch_logs_log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostedZoneQueryLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostedZoneQueryLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostedZoneQueryLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_log_group_arn: str):
        """
        A complex type that contains information about a configuration for DNS query logging.
        :param str cloud_watch_logs_log_group_arn: The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
        """
        pulumi.set(__self__, "cloud_watch_logs_log_group_arn", cloud_watch_logs_log_group_arn)

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroupArn")
    def cloud_watch_logs_log_group_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
        """
        return pulumi.get(self, "cloud_watch_logs_log_group_arn")


@pulumi.output_type
class HostedZoneTag(dict):
    """
    A complex type that contains information about a tag that you want to add or edit for the specified health check or hosted zone.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A complex type that contains information about a tag that you want to add or edit for the specified health check or hosted zone.
        :param str key: The value of ``Key`` depends on the operation that you want to perform:
                 +   *Add a tag to a health check or hosted zone*: ``Key`` is the name that you want to give the new tag.
                 +   *Edit a tag*: ``Key`` is the name of the tag that you want to change the ``Value`` for.
                 +   *Delete a key*: ``Key`` is the name of the tag you want to remove.
                 +   *Give a name to a health check*: Edit the default ``Name`` tag. In the Amazon Route 53 console, the list of your health checks includes a *Name* column that lets you see the name that you've given to each health check.
        :param str value: The value of ``Value`` depends on the operation that you want to perform:
                 +   *Add a tag to a health check or hosted zone*: ``Value`` is the value that you want to give the new tag.
                 +   *Edit a tag*: ``Value`` is the new value that you want to assign the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The value of ``Key`` depends on the operation that you want to perform:
          +   *Add a tag to a health check or hosted zone*: ``Key`` is the name that you want to give the new tag.
          +   *Edit a tag*: ``Key`` is the name of the tag that you want to change the ``Value`` for.
          +   *Delete a key*: ``Key`` is the name of the tag you want to remove.
          +   *Give a name to a health check*: Edit the default ``Name`` tag. In the Amazon Route 53 console, the list of your health checks includes a *Name* column that lets you see the name that you've given to each health check.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of ``Value`` depends on the operation that you want to perform:
          +   *Add a tag to a health check or hosted zone*: ``Value`` is the value that you want to give the new tag.
          +   *Edit a tag*: ``Value`` is the new value that you want to assign the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HostedZoneVpc(dict):
    """
    *Private hosted zones only:* A complex type that contains information about an Amazon VPC. Route 53 Resolver uses the records in the private hosted zone to route traffic in that VPC. 
      For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpcRegion":
            suggest = "vpc_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostedZoneVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostedZoneVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostedZoneVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str,
                 vpc_region: str):
        """
        *Private hosted zones only:* A complex type that contains information about an Amazon VPC. Route 53 Resolver uses the records in the private hosted zone to route traffic in that VPC. 
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        :param str vpc_id: *Private hosted zones only:* The ID of an Amazon VPC.
                 For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        :param str vpc_region: *Private hosted zones only:* The region that an Amazon VPC was created in.
                 For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_region", vpc_region)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        *Private hosted zones only:* The ID of an Amazon VPC.
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> str:
        """
        *Private hosted zones only:* The region that an Amazon VPC was created in.
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        return pulumi.get(self, "vpc_region")


