# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHostedZoneResult',
    'AwaitableGetHostedZoneResult',
    'get_hosted_zone',
    'get_hosted_zone_output',
]

@pulumi.output_type
class GetHostedZoneResult:
    def __init__(__self__, hosted_zone_config=None, hosted_zone_tags=None, id=None, name_servers=None, query_logging_config=None, vpcs=None):
        if hosted_zone_config and not isinstance(hosted_zone_config, dict):
            raise TypeError("Expected argument 'hosted_zone_config' to be a dict")
        pulumi.set(__self__, "hosted_zone_config", hosted_zone_config)
        if hosted_zone_tags and not isinstance(hosted_zone_tags, list):
            raise TypeError("Expected argument 'hosted_zone_tags' to be a list")
        pulumi.set(__self__, "hosted_zone_tags", hosted_zone_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_servers and not isinstance(name_servers, list):
            raise TypeError("Expected argument 'name_servers' to be a list")
        pulumi.set(__self__, "name_servers", name_servers)
        if query_logging_config and not isinstance(query_logging_config, dict):
            raise TypeError("Expected argument 'query_logging_config' to be a dict")
        pulumi.set(__self__, "query_logging_config", query_logging_config)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @property
    @pulumi.getter(name="hostedZoneConfig")
    def hosted_zone_config(self) -> Optional['outputs.HostedZoneConfig']:
        """
        A complex type that contains an optional comment.
         If you don't want to specify a comment, omit the ``HostedZoneConfig`` and ``Comment`` elements.
        """
        return pulumi.get(self, "hosted_zone_config")

    @property
    @pulumi.getter(name="hostedZoneTags")
    def hosted_zone_tags(self) -> Optional[Sequence['outputs.HostedZoneTag']]:
        """
        Adds, edits, or deletes tags for a health check or a hosted zone.
         For information about using tags for cost allocation, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *User Guide*.
        """
        return pulumi.get(self, "hosted_zone_tags")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter(name="queryLoggingConfig")
    def query_logging_config(self) -> Optional['outputs.HostedZoneQueryLoggingConfig']:
        """
        Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
         DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
          +  Route 53 edge location that responded to the DNS query
          +  Domain or subdomain that was requested
          +  DNS record type, such as A or AAAA
          +  DNS response code, such as ``NoError`` or ``ServFail`` 
          
          + Log Group and Resource Policy Before you create a query logging configuration, perform the following operations. If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically. Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following: You must create the log group in the us-east-1 region. You must use the same to create the log group and the hosted zone that you want to configure query logging for. When you create log groups for query logging, we recommend that you use a consistent prefix, for example: /aws/route53/hosted zone name In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging. Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of Resource, specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with *, for example: arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/* To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values: For aws:SourceArn, supply the hosted zone ARN used in creating the query logging configuration. For example, aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID. For aws:SourceAccount, supply the account ID for the account that creates the query logging configuration. For example, aws:SourceAccount:111111111111. For more information, see The confused deputy problem in the IAM User Guide. You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the SDKs, or the . + Log Streams and Edge Locations When Route 53 finishes creating the configuration for DNS query logging, it does the following: Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location. Begins to send query logs to the applicable log stream. The name of each log stream is in the following format: hosted zone ID/edge location code The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the Route 53 Product Details page. + Queries That Are Logged Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see Routing Internet Traffic to Your Website or Web Application in the Amazon Route 53 Developer Guide. + Log File Format For a list of the values in each query log and the format of each value, see Logging DNS Queries in the Amazon Route 53 Developer Guide. + Pricing For information about charges for query logs, see Amazon CloudWatch Pricing. + How to Stop Logging If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see DeleteQueryLoggingConfig.
        """
        return pulumi.get(self, "query_logging_config")

    @property
    @pulumi.getter
    def vpcs(self) -> Optional[Sequence['outputs.HostedZoneVpc']]:
        """
        *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone.
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        return pulumi.get(self, "vpcs")


class AwaitableGetHostedZoneResult(GetHostedZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostedZoneResult(
            hosted_zone_config=self.hosted_zone_config,
            hosted_zone_tags=self.hosted_zone_tags,
            id=self.id,
            name_servers=self.name_servers,
            query_logging_config=self.query_logging_config,
            vpcs=self.vpcs)


def get_hosted_zone(id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostedZoneResult:
    """
    Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
      You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.
      For more information about charges for hosted zones, see [Amazon Route 53 Pricing](https://docs.aws.amazon.com/route53/pricing/).
     Note the following:
      +  You can't create a hosted zone for a top-level domain (TLD) such as .com.
      +  If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see [Migrating DNS Service for an Existing Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html) in the *Amazon Route 53 Developer Guide*.

     When you submit a ``CreateHostedZone`` request, the initial status of the hosted zone is ``PENDING``. For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to ``INSYNC``.
     The ``CreateHostedZone`` request requires the caller to have an ``ec2:DescribeVpcs`` permission.
      When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is created. A partition is a group of AWS-Regions. Each AWS-account is scoped to one partition.
     The following are the supported partitions:
      +   ``aws`` - AWS-Regions
      +   ``aws-cn`` - China Regions
      +   ``aws-us-gov`` - govcloud-us-region

     For more information, see [Access Management](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53:getHostedZone', __args__, opts=opts, typ=GetHostedZoneResult).value

    return AwaitableGetHostedZoneResult(
        hosted_zone_config=pulumi.get(__ret__, 'hosted_zone_config'),
        hosted_zone_tags=pulumi.get(__ret__, 'hosted_zone_tags'),
        id=pulumi.get(__ret__, 'id'),
        name_servers=pulumi.get(__ret__, 'name_servers'),
        query_logging_config=pulumi.get(__ret__, 'query_logging_config'),
        vpcs=pulumi.get(__ret__, 'vpcs'))


@_utilities.lift_output_func(get_hosted_zone)
def get_hosted_zone_output(id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostedZoneResult]:
    """
    Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
      You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.
      For more information about charges for hosted zones, see [Amazon Route 53 Pricing](https://docs.aws.amazon.com/route53/pricing/).
     Note the following:
      +  You can't create a hosted zone for a top-level domain (TLD) such as .com.
      +  If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see [Migrating DNS Service for an Existing Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html) in the *Amazon Route 53 Developer Guide*.

     When you submit a ``CreateHostedZone`` request, the initial status of the hosted zone is ``PENDING``. For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to ``INSYNC``.
     The ``CreateHostedZone`` request requires the caller to have an ``ec2:DescribeVpcs`` permission.
      When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is created. A partition is a group of AWS-Regions. Each AWS-account is scoped to one partition.
     The following are the supported partitions:
      +   ``aws`` - AWS-Regions
      +   ``aws-cn`` - China Regions
      +   ``aws-us-gov`` - govcloud-us-region

     For more information, see [Access Management](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
    """
    ...
