# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetOptionGroupResult',
    'AwaitableGetOptionGroupResult',
    'get_option_group',
    'get_option_group_output',
]

@pulumi.output_type
class GetOptionGroupResult:
    def __init__(__self__, option_configurations=None, tags=None):
        if option_configurations and not isinstance(option_configurations, list):
            raise TypeError("Expected argument 'option_configurations' to be a list")
        pulumi.set(__self__, "option_configurations", option_configurations)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="optionConfigurations")
    def option_configurations(self) -> Optional[Sequence['outputs.OptionGroupOptionConfiguration']]:
        """
        Indicates what options are available in the option group.
        """
        return pulumi.get(self, "option_configurations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetOptionGroupResult(GetOptionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOptionGroupResult(
            option_configurations=self.option_configurations,
            tags=self.tags)


def get_option_group(option_group_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOptionGroupResult:
    """
    The AWS::RDS::OptionGroup resource creates an option group, to enable and configure features that are specific to a particular DB engine.


    :param str option_group_name: Specifies the name of the option group.
    """
    __args__ = dict()
    __args__['optionGroupName'] = option_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getOptionGroup', __args__, opts=opts, typ=GetOptionGroupResult).value

    return AwaitableGetOptionGroupResult(
        option_configurations=pulumi.get(__ret__, 'option_configurations'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_option_group)
def get_option_group_output(option_group_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOptionGroupResult]:
    """
    The AWS::RDS::OptionGroup resource creates an option group, to enable and configure features that are specific to a particular DB engine.


    :param str option_group_name: Specifies the name of the option group.
    """
    ...
