# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDbParameterGroupResult',
    'AwaitableGetDbParameterGroupResult',
    'get_db_parameter_group',
    'get_db_parameter_group_output',
]

@pulumi.output_type
class GetDbParameterGroupResult:
    def __init__(__self__, parameters=None, tags=None):
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        An array of parameter names and values for the parameter update. At least one parameter name and value must be supplied. Subsequent arguments are optional.
         RDS for Db2 requires you to bring your own Db2 license. You must enter your IBM customer ID (``rds.ibm_customer_id``) and site number (``rds.ibm_site_id``) before starting a Db2 instance.
         For more information about DB parameters and DB parameter groups for Amazon RDS DB engines, see [Working with DB Parameter Groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
         For more information about DB cluster and DB instance parameters and parameter groups for Amazon Aurora DB engines, see [Working with DB Parameter Groups and DB Cluster Parameter Groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
           AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBParameterGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An optional array of key-value pairs to apply to this DB parameter group.
           Currently, this is the only property that supports drift detection.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDbParameterGroupResult(GetDbParameterGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbParameterGroupResult(
            parameters=self.parameters,
            tags=self.tags)


def get_db_parameter_group(db_parameter_group_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbParameterGroupResult:
    """
    The ``AWS::RDS::DBParameterGroup`` resource creates a custom parameter group for an RDS database family.
     This type can be declared in a template and referenced in the ``DBParameterGroupName`` property of an ``AWS::RDS::DBInstance`` resource.
     For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
     For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
      Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.


    :param str db_parameter_group_name: The name of the DB parameter group.
            Constraints:
             +  Must be 1 to 255 letters, numbers, or hyphens.
             +  First character must be a letter
             +  Can't end with a hyphen or contain two consecutive hyphens
             
            If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['dbParameterGroupName'] = db_parameter_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbParameterGroup', __args__, opts=opts, typ=GetDbParameterGroupResult).value

    return AwaitableGetDbParameterGroupResult(
        parameters=pulumi.get(__ret__, 'parameters'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_db_parameter_group)
def get_db_parameter_group_output(db_parameter_group_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbParameterGroupResult]:
    """
    The ``AWS::RDS::DBParameterGroup`` resource creates a custom parameter group for an RDS database family.
     This type can be declared in a template and referenced in the ``DBParameterGroupName`` property of an ``AWS::RDS::DBInstance`` resource.
     For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
     For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
      Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.


    :param str db_parameter_group_name: The name of the DB parameter group.
            Constraints:
             +  Must be 1 to 255 letters, numbers, or hyphens.
             +  First character must be a letter
             +  Can't end with a hyphen or contain two consecutive hyphens
             
            If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
             This value is stored as a lowercase string.
    """
    ...
