# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDataSetResult',
    'AwaitableGetDataSetResult',
    'get_data_set',
    'get_data_set_output',
]

@pulumi.output_type
class GetDataSetResult:
    def __init__(__self__, arn=None, column_groups=None, column_level_permission_rules=None, consumed_spice_capacity_in_bytes=None, created_time=None, data_set_refresh_properties=None, data_set_usage_configuration=None, dataset_parameters=None, import_mode=None, last_updated_time=None, logical_table_map=None, name=None, output_columns=None, permissions=None, physical_table_map=None, row_level_permission_data_set=None, row_level_permission_tag_configuration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if column_groups and not isinstance(column_groups, list):
            raise TypeError("Expected argument 'column_groups' to be a list")
        pulumi.set(__self__, "column_groups", column_groups)
        if column_level_permission_rules and not isinstance(column_level_permission_rules, list):
            raise TypeError("Expected argument 'column_level_permission_rules' to be a list")
        pulumi.set(__self__, "column_level_permission_rules", column_level_permission_rules)
        if consumed_spice_capacity_in_bytes and not isinstance(consumed_spice_capacity_in_bytes, float):
            raise TypeError("Expected argument 'consumed_spice_capacity_in_bytes' to be a float")
        pulumi.set(__self__, "consumed_spice_capacity_in_bytes", consumed_spice_capacity_in_bytes)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if data_set_refresh_properties and not isinstance(data_set_refresh_properties, dict):
            raise TypeError("Expected argument 'data_set_refresh_properties' to be a dict")
        pulumi.set(__self__, "data_set_refresh_properties", data_set_refresh_properties)
        if data_set_usage_configuration and not isinstance(data_set_usage_configuration, dict):
            raise TypeError("Expected argument 'data_set_usage_configuration' to be a dict")
        pulumi.set(__self__, "data_set_usage_configuration", data_set_usage_configuration)
        if dataset_parameters and not isinstance(dataset_parameters, list):
            raise TypeError("Expected argument 'dataset_parameters' to be a list")
        pulumi.set(__self__, "dataset_parameters", dataset_parameters)
        if import_mode and not isinstance(import_mode, str):
            raise TypeError("Expected argument 'import_mode' to be a str")
        pulumi.set(__self__, "import_mode", import_mode)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if logical_table_map and not isinstance(logical_table_map, dict):
            raise TypeError("Expected argument 'logical_table_map' to be a dict")
        pulumi.set(__self__, "logical_table_map", logical_table_map)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_columns and not isinstance(output_columns, list):
            raise TypeError("Expected argument 'output_columns' to be a list")
        pulumi.set(__self__, "output_columns", output_columns)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if physical_table_map and not isinstance(physical_table_map, dict):
            raise TypeError("Expected argument 'physical_table_map' to be a dict")
        pulumi.set(__self__, "physical_table_map", physical_table_map)
        if row_level_permission_data_set and not isinstance(row_level_permission_data_set, dict):
            raise TypeError("Expected argument 'row_level_permission_data_set' to be a dict")
        pulumi.set(__self__, "row_level_permission_data_set", row_level_permission_data_set)
        if row_level_permission_tag_configuration and not isinstance(row_level_permission_tag_configuration, dict):
            raise TypeError("Expected argument 'row_level_permission_tag_configuration' to be a dict")
        pulumi.set(__self__, "row_level_permission_tag_configuration", row_level_permission_tag_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="columnGroups")
    def column_groups(self) -> Optional[Sequence['outputs.DataSetColumnGroup']]:
        """
        <p>Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        """
        return pulumi.get(self, "column_groups")

    @property
    @pulumi.getter(name="columnLevelPermissionRules")
    def column_level_permission_rules(self) -> Optional[Sequence['outputs.DataSetColumnLevelPermissionRule']]:
        return pulumi.get(self, "column_level_permission_rules")

    @property
    @pulumi.getter(name="consumedSpiceCapacityInBytes")
    def consumed_spice_capacity_in_bytes(self) -> Optional[float]:
        """
        <p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't
                    imported into SPICE.</p>
        """
        return pulumi.get(self, "consumed_spice_capacity_in_bytes")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        <p>The time that this dataset was created.</p>
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="dataSetRefreshProperties")
    def data_set_refresh_properties(self) -> Optional['outputs.DataSetRefreshProperties']:
        return pulumi.get(self, "data_set_refresh_properties")

    @property
    @pulumi.getter(name="dataSetUsageConfiguration")
    def data_set_usage_configuration(self) -> Optional['outputs.DataSetUsageConfiguration']:
        return pulumi.get(self, "data_set_usage_configuration")

    @property
    @pulumi.getter(name="datasetParameters")
    def dataset_parameters(self) -> Optional[Sequence['outputs.DataSetDatasetParameter']]:
        """
        <p>The parameters declared in the dataset.</p>
        """
        return pulumi.get(self, "dataset_parameters")

    @property
    @pulumi.getter(name="importMode")
    def import_mode(self) -> Optional['DataSetImportMode']:
        return pulumi.get(self, "import_mode")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        <p>The last time that this dataset was updated.</p>
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="logicalTableMap")
    def logical_table_map(self) -> Optional[Mapping[str, 'outputs.DataSetLogicalTable']]:
        return pulumi.get(self, "logical_table_map")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The display name for the dataset.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputColumns")
    def output_columns(self) -> Optional[Sequence['outputs.DataSetOutputColumn']]:
        """
        <p>The list of columns after all transforms. These columns are available in templates,
                    analyses, and dashboards.</p>
        """
        return pulumi.get(self, "output_columns")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence['outputs.DataSetResourcePermission']]:
        """
        <p>A list of resource permissions on the dataset.</p>
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="physicalTableMap")
    def physical_table_map(self) -> Optional[Mapping[str, 'outputs.DataSetPhysicalTable']]:
        return pulumi.get(self, "physical_table_map")

    @property
    @pulumi.getter(name="rowLevelPermissionDataSet")
    def row_level_permission_data_set(self) -> Optional['outputs.DataSetRowLevelPermissionDataSet']:
        return pulumi.get(self, "row_level_permission_data_set")

    @property
    @pulumi.getter(name="rowLevelPermissionTagConfiguration")
    def row_level_permission_tag_configuration(self) -> Optional['outputs.DataSetRowLevelPermissionTagConfiguration']:
        return pulumi.get(self, "row_level_permission_tag_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        """
        return pulumi.get(self, "tags")


class AwaitableGetDataSetResult(GetDataSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSetResult(
            arn=self.arn,
            column_groups=self.column_groups,
            column_level_permission_rules=self.column_level_permission_rules,
            consumed_spice_capacity_in_bytes=self.consumed_spice_capacity_in_bytes,
            created_time=self.created_time,
            data_set_refresh_properties=self.data_set_refresh_properties,
            data_set_usage_configuration=self.data_set_usage_configuration,
            dataset_parameters=self.dataset_parameters,
            import_mode=self.import_mode,
            last_updated_time=self.last_updated_time,
            logical_table_map=self.logical_table_map,
            name=self.name,
            output_columns=self.output_columns,
            permissions=self.permissions,
            physical_table_map=self.physical_table_map,
            row_level_permission_data_set=self.row_level_permission_data_set,
            row_level_permission_tag_configuration=self.row_level_permission_tag_configuration,
            tags=self.tags)


def get_data_set(aws_account_id: Optional[str] = None,
                 data_set_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSetResult:
    """
    Definition of the AWS::QuickSight::DataSet Resource Type.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['dataSetId'] = data_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:quicksight:getDataSet', __args__, opts=opts, typ=GetDataSetResult).value

    return AwaitableGetDataSetResult(
        arn=pulumi.get(__ret__, 'arn'),
        column_groups=pulumi.get(__ret__, 'column_groups'),
        column_level_permission_rules=pulumi.get(__ret__, 'column_level_permission_rules'),
        consumed_spice_capacity_in_bytes=pulumi.get(__ret__, 'consumed_spice_capacity_in_bytes'),
        created_time=pulumi.get(__ret__, 'created_time'),
        data_set_refresh_properties=pulumi.get(__ret__, 'data_set_refresh_properties'),
        data_set_usage_configuration=pulumi.get(__ret__, 'data_set_usage_configuration'),
        dataset_parameters=pulumi.get(__ret__, 'dataset_parameters'),
        import_mode=pulumi.get(__ret__, 'import_mode'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        logical_table_map=pulumi.get(__ret__, 'logical_table_map'),
        name=pulumi.get(__ret__, 'name'),
        output_columns=pulumi.get(__ret__, 'output_columns'),
        permissions=pulumi.get(__ret__, 'permissions'),
        physical_table_map=pulumi.get(__ret__, 'physical_table_map'),
        row_level_permission_data_set=pulumi.get(__ret__, 'row_level_permission_data_set'),
        row_level_permission_tag_configuration=pulumi.get(__ret__, 'row_level_permission_tag_configuration'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_data_set)
def get_data_set_output(aws_account_id: Optional[pulumi.Input[str]] = None,
                        data_set_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataSetResult]:
    """
    Definition of the AWS::QuickSight::DataSet Resource Type.
    """
    ...
