# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetPipelineResult',
    'AwaitableGetPipelineResult',
    'get_pipeline',
    'get_pipeline_output',
]

@pulumi.output_type
class GetPipelineResult:
    def __init__(__self__, buffer_options=None, encryption_at_rest_options=None, ingest_endpoint_urls=None, log_publishing_options=None, max_units=None, min_units=None, pipeline_arn=None, pipeline_configuration_body=None, tags=None, vpc_endpoints=None):
        if buffer_options and not isinstance(buffer_options, dict):
            raise TypeError("Expected argument 'buffer_options' to be a dict")
        pulumi.set(__self__, "buffer_options", buffer_options)
        if encryption_at_rest_options and not isinstance(encryption_at_rest_options, dict):
            raise TypeError("Expected argument 'encryption_at_rest_options' to be a dict")
        pulumi.set(__self__, "encryption_at_rest_options", encryption_at_rest_options)
        if ingest_endpoint_urls and not isinstance(ingest_endpoint_urls, list):
            raise TypeError("Expected argument 'ingest_endpoint_urls' to be a list")
        pulumi.set(__self__, "ingest_endpoint_urls", ingest_endpoint_urls)
        if log_publishing_options and not isinstance(log_publishing_options, dict):
            raise TypeError("Expected argument 'log_publishing_options' to be a dict")
        pulumi.set(__self__, "log_publishing_options", log_publishing_options)
        if max_units and not isinstance(max_units, int):
            raise TypeError("Expected argument 'max_units' to be a int")
        pulumi.set(__self__, "max_units", max_units)
        if min_units and not isinstance(min_units, int):
            raise TypeError("Expected argument 'min_units' to be a int")
        pulumi.set(__self__, "min_units", min_units)
        if pipeline_arn and not isinstance(pipeline_arn, str):
            raise TypeError("Expected argument 'pipeline_arn' to be a str")
        pulumi.set(__self__, "pipeline_arn", pipeline_arn)
        if pipeline_configuration_body and not isinstance(pipeline_configuration_body, str):
            raise TypeError("Expected argument 'pipeline_configuration_body' to be a str")
        pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpc_endpoints and not isinstance(vpc_endpoints, list):
            raise TypeError("Expected argument 'vpc_endpoints' to be a list")
        pulumi.set(__self__, "vpc_endpoints", vpc_endpoints)

    @property
    @pulumi.getter(name="bufferOptions")
    def buffer_options(self) -> Optional['outputs.PipelineBufferOptions']:
        return pulumi.get(self, "buffer_options")

    @property
    @pulumi.getter(name="encryptionAtRestOptions")
    def encryption_at_rest_options(self) -> Optional['outputs.PipelineEncryptionAtRestOptions']:
        return pulumi.get(self, "encryption_at_rest_options")

    @property
    @pulumi.getter(name="ingestEndpointUrls")
    def ingest_endpoint_urls(self) -> Optional[Sequence[str]]:
        """
        A list of endpoints that can be used for ingesting data into a pipeline
        """
        return pulumi.get(self, "ingest_endpoint_urls")

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> Optional['outputs.PipelineLogPublishingOptions']:
        return pulumi.get(self, "log_publishing_options")

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> Optional[int]:
        """
        The maximum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        """
        return pulumi.get(self, "max_units")

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> Optional[int]:
        """
        The minimum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        """
        return pulumi.get(self, "min_units")

    @property
    @pulumi.getter(name="pipelineArn")
    def pipeline_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the pipeline.
        """
        return pulumi.get(self, "pipeline_arn")

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> Optional[str]:
        """
        The Data Prepper pipeline configuration.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> Optional[Sequence['outputs.PipelineVpcEndpoint']]:
        """
        The VPC interface endpoints that have access to the pipeline.
        """
        return pulumi.get(self, "vpc_endpoints")


class AwaitableGetPipelineResult(GetPipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineResult(
            buffer_options=self.buffer_options,
            encryption_at_rest_options=self.encryption_at_rest_options,
            ingest_endpoint_urls=self.ingest_endpoint_urls,
            log_publishing_options=self.log_publishing_options,
            max_units=self.max_units,
            min_units=self.min_units,
            pipeline_arn=self.pipeline_arn,
            pipeline_configuration_body=self.pipeline_configuration_body,
            tags=self.tags,
            vpc_endpoints=self.vpc_endpoints)


def get_pipeline(pipeline_arn: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineResult:
    """
    An OpenSearch Ingestion Service Data Prepper pipeline running Data Prepper.


    :param str pipeline_arn: The Amazon Resource Name (ARN) of the pipeline.
    """
    __args__ = dict()
    __args__['pipelineArn'] = pipeline_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:osis:getPipeline', __args__, opts=opts, typ=GetPipelineResult).value

    return AwaitableGetPipelineResult(
        buffer_options=pulumi.get(__ret__, 'buffer_options'),
        encryption_at_rest_options=pulumi.get(__ret__, 'encryption_at_rest_options'),
        ingest_endpoint_urls=pulumi.get(__ret__, 'ingest_endpoint_urls'),
        log_publishing_options=pulumi.get(__ret__, 'log_publishing_options'),
        max_units=pulumi.get(__ret__, 'max_units'),
        min_units=pulumi.get(__ret__, 'min_units'),
        pipeline_arn=pulumi.get(__ret__, 'pipeline_arn'),
        pipeline_configuration_body=pulumi.get(__ret__, 'pipeline_configuration_body'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_endpoints=pulumi.get(__ret__, 'vpc_endpoints'))


@_utilities.lift_output_func(get_pipeline)
def get_pipeline_output(pipeline_arn: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPipelineResult]:
    """
    An OpenSearch Ingestion Service Data Prepper pipeline running Data Prepper.


    :param str pipeline_arn: The Amazon Resource Name (ARN) of the pipeline.
    """
    ...
