# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityConfigResult',
    'AwaitableGetSecurityConfigResult',
    'get_security_config',
    'get_security_config_output',
]

@pulumi.output_type
class GetSecurityConfigResult:
    def __init__(__self__, description=None, id=None, saml_options=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if saml_options and not isinstance(saml_options, dict):
            raise TypeError("Expected argument 'saml_options' to be a dict")
        pulumi.set(__self__, "saml_options", saml_options)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Security config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the security config
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="samlOptions")
    def saml_options(self) -> Optional['outputs.SecurityConfigSamlConfigOptions']:
        return pulumi.get(self, "saml_options")


class AwaitableGetSecurityConfigResult(GetSecurityConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityConfigResult(
            description=self.description,
            id=self.id,
            saml_options=self.saml_options)


def get_security_config(id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityConfigResult:
    """
    Amazon OpenSearchServerless security config resource


    :param str id: The identifier of the security config
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getSecurityConfig', __args__, opts=opts, typ=GetSecurityConfigResult).value

    return AwaitableGetSecurityConfigResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        saml_options=pulumi.get(__ret__, 'saml_options'))


@_utilities.lift_output_func(get_security_config)
def get_security_config_output(id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityConfigResult]:
    """
    Amazon OpenSearchServerless security config resource


    :param str id: The identifier of the security config
    """
    ...
