# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetStreamingImageResult',
    'AwaitableGetStreamingImageResult',
    'get_streaming_image',
    'get_streaming_image_output',
]

@pulumi.output_type
class GetStreamingImageResult:
    def __init__(__self__, description=None, encryption_configuration=None, eula_ids=None, name=None, owner=None, platform=None, streaming_image_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if encryption_configuration and not isinstance(encryption_configuration, dict):
            raise TypeError("Expected argument 'encryption_configuration' to be a dict")
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if eula_ids and not isinstance(eula_ids, list):
            raise TypeError("Expected argument 'eula_ids' to be a list")
        pulumi.set(__self__, "eula_ids", eula_ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if streaming_image_id and not isinstance(streaming_image_id, str):
            raise TypeError("Expected argument 'streaming_image_id' to be a str")
        pulumi.set(__self__, "streaming_image_id", streaming_image_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        <p>A human-readable description of the streaming image.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.StreamingImageEncryptionConfiguration']:
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="eulaIds")
    def eula_ids(self) -> Optional[Sequence[str]]:
        """
        <p>The list of EULAs that must be accepted before a Streaming Session can be started using this streaming image.</p>
        """
        return pulumi.get(self, "eula_ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>A friendly name for a streaming image resource.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        <p>The owner of the streaming image, either the studioId that contains the streaming image, or 'amazon' for images that are provided by Amazon Nimble Studio.</p>
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def platform(self) -> Optional[str]:
        """
        <p>The platform of the streaming image, either WINDOWS or LINUX.</p>
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="streamingImageId")
    def streaming_image_id(self) -> Optional[str]:
        return pulumi.get(self, "streaming_image_id")


class AwaitableGetStreamingImageResult(GetStreamingImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamingImageResult(
            description=self.description,
            encryption_configuration=self.encryption_configuration,
            eula_ids=self.eula_ids,
            name=self.name,
            owner=self.owner,
            platform=self.platform,
            streaming_image_id=self.streaming_image_id)


def get_streaming_image(streaming_image_id: Optional[str] = None,
                        studio_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamingImageResult:
    """
    Represents a streaming session machine image that can be used to launch a streaming session


    :param str studio_id: <p>The studioId. </p>
    """
    __args__ = dict()
    __args__['streamingImageId'] = streaming_image_id
    __args__['studioId'] = studio_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:nimblestudio:getStreamingImage', __args__, opts=opts, typ=GetStreamingImageResult).value

    return AwaitableGetStreamingImageResult(
        description=pulumi.get(__ret__, 'description'),
        encryption_configuration=pulumi.get(__ret__, 'encryption_configuration'),
        eula_ids=pulumi.get(__ret__, 'eula_ids'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        platform=pulumi.get(__ret__, 'platform'),
        streaming_image_id=pulumi.get(__ret__, 'streaming_image_id'))


@_utilities.lift_output_func(get_streaming_image)
def get_streaming_image_output(streaming_image_id: Optional[pulumi.Input[str]] = None,
                               studio_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamingImageResult]:
    """
    Represents a streaming session machine image that can be used to launch a streaming session


    :param str studio_id: <p>The studioId. </p>
    """
    ...
