# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetLaunchProfileResult',
    'AwaitableGetLaunchProfileResult',
    'get_launch_profile',
    'get_launch_profile_output',
]

@pulumi.output_type
class GetLaunchProfileResult:
    def __init__(__self__, description=None, launch_profile_id=None, launch_profile_protocol_versions=None, name=None, stream_configuration=None, studio_component_ids=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if launch_profile_id and not isinstance(launch_profile_id, str):
            raise TypeError("Expected argument 'launch_profile_id' to be a str")
        pulumi.set(__self__, "launch_profile_id", launch_profile_id)
        if launch_profile_protocol_versions and not isinstance(launch_profile_protocol_versions, list):
            raise TypeError("Expected argument 'launch_profile_protocol_versions' to be a list")
        pulumi.set(__self__, "launch_profile_protocol_versions", launch_profile_protocol_versions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if stream_configuration and not isinstance(stream_configuration, dict):
            raise TypeError("Expected argument 'stream_configuration' to be a dict")
        pulumi.set(__self__, "stream_configuration", stream_configuration)
        if studio_component_ids and not isinstance(studio_component_ids, list):
            raise TypeError("Expected argument 'studio_component_ids' to be a list")
        pulumi.set(__self__, "studio_component_ids", studio_component_ids)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        <p>The description.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="launchProfileId")
    def launch_profile_id(self) -> Optional[str]:
        return pulumi.get(self, "launch_profile_id")

    @property
    @pulumi.getter(name="launchProfileProtocolVersions")
    def launch_profile_protocol_versions(self) -> Optional[Sequence[str]]:
        """
        <p>The version number of the protocol that is used by the launch profile. The only valid
                    version is "2021-03-31".</p>
        """
        return pulumi.get(self, "launch_profile_protocol_versions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name for the launch profile.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="streamConfiguration")
    def stream_configuration(self) -> Optional['outputs.LaunchProfileStreamConfiguration']:
        return pulumi.get(self, "stream_configuration")

    @property
    @pulumi.getter(name="studioComponentIds")
    def studio_component_ids(self) -> Optional[Sequence[str]]:
        """
        <p>Unique identifiers for a collection of studio components that can be used with this
                    launch profile.</p>
        """
        return pulumi.get(self, "studio_component_ids")


class AwaitableGetLaunchProfileResult(GetLaunchProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLaunchProfileResult(
            description=self.description,
            launch_profile_id=self.launch_profile_id,
            launch_profile_protocol_versions=self.launch_profile_protocol_versions,
            name=self.name,
            stream_configuration=self.stream_configuration,
            studio_component_ids=self.studio_component_ids)


def get_launch_profile(launch_profile_id: Optional[str] = None,
                       studio_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLaunchProfileResult:
    """
    Represents a launch profile which delegates access to a collection of studio components to studio users


    :param str studio_id: <p>The studio ID. </p>
    """
    __args__ = dict()
    __args__['launchProfileId'] = launch_profile_id
    __args__['studioId'] = studio_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:nimblestudio:getLaunchProfile', __args__, opts=opts, typ=GetLaunchProfileResult).value

    return AwaitableGetLaunchProfileResult(
        description=pulumi.get(__ret__, 'description'),
        launch_profile_id=pulumi.get(__ret__, 'launch_profile_id'),
        launch_profile_protocol_versions=pulumi.get(__ret__, 'launch_profile_protocol_versions'),
        name=pulumi.get(__ret__, 'name'),
        stream_configuration=pulumi.get(__ret__, 'stream_configuration'),
        studio_component_ids=pulumi.get(__ret__, 'studio_component_ids'))


@_utilities.lift_output_func(get_launch_profile)
def get_launch_profile_output(launch_profile_id: Optional[pulumi.Input[str]] = None,
                              studio_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLaunchProfileResult]:
    """
    Represents a launch profile which delegates access to a collection of studio components to studio users


    :param str studio_id: <p>The studio ID. </p>
    """
    ...
