# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['GraphArgs', 'Graph']

@pulumi.input_type
class GraphArgs:
    def __init__(__self__, *,
                 provisioned_memory: pulumi.Input[int],
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 graph_name: Optional[pulumi.Input[str]] = None,
                 public_connectivity: Optional[pulumi.Input[bool]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vector_search_configuration: Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Graph resource.
        :param pulumi.Input[int] provisioned_memory: Memory for the Graph.
        :param pulumi.Input[bool] deletion_protection: Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
               
               _Default_: If not specified, the default value is true.
        :param pulumi.Input[str] graph_name: Contains a user-supplied name for the Graph. 
               
               If you don't specify a name, we generate a unique Graph Name using a combination of Stack Name and a UUID comprising of 4 characters.
               
               _Important_: If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[bool] public_connectivity: Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.
               
               When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.
               
               When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
               
               _Default_: If not specified, the default value is false.
        :param pulumi.Input[int] replica_count: Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.
               
               Replica Count should always be less than or equal to 2.
               
               _Default_: If not specified, the default value is 1.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags associated with this graph.
        :param pulumi.Input['GraphVectorSearchConfigurationArgs'] vector_search_configuration: Vector Search Configuration
        """
        pulumi.set(__self__, "provisioned_memory", provisioned_memory)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if graph_name is not None:
            pulumi.set(__self__, "graph_name", graph_name)
        if public_connectivity is not None:
            pulumi.set(__self__, "public_connectivity", public_connectivity)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vector_search_configuration is not None:
            pulumi.set(__self__, "vector_search_configuration", vector_search_configuration)

    @property
    @pulumi.getter(name="provisionedMemory")
    def provisioned_memory(self) -> pulumi.Input[int]:
        """
        Memory for the Graph.
        """
        return pulumi.get(self, "provisioned_memory")

    @provisioned_memory.setter
    def provisioned_memory(self, value: pulumi.Input[int]):
        pulumi.set(self, "provisioned_memory", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.

        _Default_: If not specified, the default value is true.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="graphName")
    def graph_name(self) -> Optional[pulumi.Input[str]]:
        """
        Contains a user-supplied name for the Graph. 

        If you don't specify a name, we generate a unique Graph Name using a combination of Stack Name and a UUID comprising of 4 characters.

        _Important_: If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "graph_name")

    @graph_name.setter
    def graph_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graph_name", value)

    @property
    @pulumi.getter(name="publicConnectivity")
    def public_connectivity(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.

        When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.

        When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.

        _Default_: If not specified, the default value is false.
        """
        return pulumi.get(self, "public_connectivity")

    @public_connectivity.setter
    def public_connectivity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_connectivity", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.

        Replica Count should always be less than or equal to 2.

        _Default_: If not specified, the default value is 1.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags associated with this graph.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vectorSearchConfiguration")
    def vector_search_configuration(self) -> Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']]:
        """
        Vector Search Configuration
        """
        return pulumi.get(self, "vector_search_configuration")

    @vector_search_configuration.setter
    def vector_search_configuration(self, value: Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']]):
        pulumi.set(self, "vector_search_configuration", value)


class Graph(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 graph_name: Optional[pulumi.Input[str]] = None,
                 provisioned_memory: Optional[pulumi.Input[int]] = None,
                 public_connectivity: Optional[pulumi.Input[bool]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 vector_search_configuration: Optional[pulumi.Input[pulumi.InputType['GraphVectorSearchConfigurationArgs']]] = None,
                 __props__=None):
        """
        The AWS::NeptuneGraph::Graph resource creates an Amazon NeptuneGraph Graph.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] deletion_protection: Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
               
               _Default_: If not specified, the default value is true.
        :param pulumi.Input[str] graph_name: Contains a user-supplied name for the Graph. 
               
               If you don't specify a name, we generate a unique Graph Name using a combination of Stack Name and a UUID comprising of 4 characters.
               
               _Important_: If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[int] provisioned_memory: Memory for the Graph.
        :param pulumi.Input[bool] public_connectivity: Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.
               
               When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.
               
               When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
               
               _Default_: If not specified, the default value is false.
        :param pulumi.Input[int] replica_count: Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.
               
               Replica Count should always be less than or equal to 2.
               
               _Default_: If not specified, the default value is 1.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: The tags associated with this graph.
        :param pulumi.Input[pulumi.InputType['GraphVectorSearchConfigurationArgs']] vector_search_configuration: Vector Search Configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GraphArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::NeptuneGraph::Graph resource creates an Amazon NeptuneGraph Graph.

        :param str resource_name: The name of the resource.
        :param GraphArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GraphArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 graph_name: Optional[pulumi.Input[str]] = None,
                 provisioned_memory: Optional[pulumi.Input[int]] = None,
                 public_connectivity: Optional[pulumi.Input[bool]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 vector_search_configuration: Optional[pulumi.Input[pulumi.InputType['GraphVectorSearchConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GraphArgs.__new__(GraphArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["graph_name"] = graph_name
            if provisioned_memory is None and not opts.urn:
                raise TypeError("Missing required property 'provisioned_memory'")
            __props__.__dict__["provisioned_memory"] = provisioned_memory
            __props__.__dict__["public_connectivity"] = public_connectivity
            __props__.__dict__["replica_count"] = replica_count
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vector_search_configuration"] = vector_search_configuration
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["graph_arn"] = None
            __props__.__dict__["graph_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["graphName", "replicaCount", "vectorSearchConfiguration"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Graph, __self__).__init__(
            'aws-native:neptunegraph:Graph',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Graph':
        """
        Get an existing Graph resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GraphArgs.__new__(GraphArgs)

        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["graph_arn"] = None
        __props__.__dict__["graph_id"] = None
        __props__.__dict__["graph_name"] = None
        __props__.__dict__["provisioned_memory"] = None
        __props__.__dict__["public_connectivity"] = None
        __props__.__dict__["replica_count"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vector_search_configuration"] = None
        return Graph(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.

        _Default_: If not specified, the default value is true.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The connection endpoint for the graph. For example: `g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com`
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="graphArn")
    def graph_arn(self) -> pulumi.Output[str]:
        """
        Graph resource ARN
        """
        return pulumi.get(self, "graph_arn")

    @property
    @pulumi.getter(name="graphId")
    def graph_id(self) -> pulumi.Output[str]:
        """
        The auto-generated id assigned by the service.
        """
        return pulumi.get(self, "graph_id")

    @property
    @pulumi.getter(name="graphName")
    def graph_name(self) -> pulumi.Output[Optional[str]]:
        """
        Contains a user-supplied name for the Graph. 

        If you don't specify a name, we generate a unique Graph Name using a combination of Stack Name and a UUID comprising of 4 characters.

        _Important_: If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "graph_name")

    @property
    @pulumi.getter(name="provisionedMemory")
    def provisioned_memory(self) -> pulumi.Output[int]:
        """
        Memory for the Graph.
        """
        return pulumi.get(self, "provisioned_memory")

    @property
    @pulumi.getter(name="publicConnectivity")
    def public_connectivity(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.

        When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.

        When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.

        _Default_: If not specified, the default value is false.
        """
        return pulumi.get(self, "public_connectivity")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.

        Replica Count should always be less than or equal to 2.

        _Default_: If not specified, the default value is 1.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags associated with this graph.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vectorSearchConfiguration")
    def vector_search_configuration(self) -> pulumi.Output[Optional['outputs.GraphVectorSearchConfiguration']]:
        """
        Vector Search Configuration
        """
        return pulumi.get(self, "vector_search_configuration")

