# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterBrokerLogs',
    'ClusterBrokerNodeGroupInfo',
    'ClusterClientAuthentication',
    'ClusterCloudWatchLogs',
    'ClusterConfigurationInfo',
    'ClusterConnectivityInfo',
    'ClusterEbsStorageInfo',
    'ClusterEncryptionAtRest',
    'ClusterEncryptionInTransit',
    'ClusterEncryptionInfo',
    'ClusterFirehose',
    'ClusterIam',
    'ClusterJmxExporter',
    'ClusterLoggingInfo',
    'ClusterNodeExporter',
    'ClusterOpenMonitoring',
    'ClusterPrometheus',
    'ClusterProvisionedThroughput',
    'ClusterPublicAccess',
    'ClusterS3',
    'ClusterSasl',
    'ClusterScram',
    'ClusterStorageInfo',
    'ClusterTls',
    'ClusterUnauthenticated',
    'ClusterVpcConnectivity',
    'ClusterVpcConnectivityClientAuthentication',
    'ClusterVpcConnectivityIam',
    'ClusterVpcConnectivitySasl',
    'ClusterVpcConnectivityScram',
    'ClusterVpcConnectivityTls',
    'ConfigurationLatestRevision',
    'ReplicatorAmazonMskCluster',
    'ReplicatorConsumerGroupReplication',
    'ReplicatorKafkaCluster',
    'ReplicatorKafkaClusterClientVpcConfig',
    'ReplicatorReplicationInfo',
    'ReplicatorReplicationStartingPosition',
    'ReplicatorTopicReplication',
    'ServerlessClusterClientAuthentication',
    'ServerlessClusterIam',
    'ServerlessClusterSasl',
    'ServerlessClusterVpcConfig',
]

@pulumi.output_type
class ClusterBrokerLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogs":
            suggest = "cloud_watch_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs: Optional['outputs.ClusterCloudWatchLogs'] = None,
                 firehose: Optional['outputs.ClusterFirehose'] = None,
                 s3: Optional['outputs.ClusterS3'] = None):
        if cloud_watch_logs is not None:
            pulumi.set(__self__, "cloud_watch_logs", cloud_watch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudWatchLogs")
    def cloud_watch_logs(self) -> Optional['outputs.ClusterCloudWatchLogs']:
        return pulumi.get(self, "cloud_watch_logs")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.ClusterFirehose']:
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.ClusterS3']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class ClusterBrokerNodeGroupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientSubnets":
            suggest = "client_subnets"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "brokerAzDistribution":
            suggest = "broker_az_distribution"
        elif key == "connectivityInfo":
            suggest = "connectivity_info"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "storageInfo":
            suggest = "storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_subnets: Sequence[str],
                 instance_type: str,
                 broker_az_distribution: Optional[str] = None,
                 connectivity_info: Optional['outputs.ClusterConnectivityInfo'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 storage_info: Optional['outputs.ClusterStorageInfo'] = None):
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "instance_type", instance_type)
        if broker_az_distribution is not None:
            pulumi.set(__self__, "broker_az_distribution", broker_az_distribution)
        if connectivity_info is not None:
            pulumi.set(__self__, "connectivity_info", connectivity_info)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if storage_info is not None:
            pulumi.set(__self__, "storage_info", storage_info)

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> Sequence[str]:
        return pulumi.get(self, "client_subnets")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="brokerAzDistribution")
    def broker_az_distribution(self) -> Optional[str]:
        return pulumi.get(self, "broker_az_distribution")

    @property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> Optional['outputs.ClusterConnectivityInfo']:
        return pulumi.get(self, "connectivity_info")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="storageInfo")
    def storage_info(self) -> Optional['outputs.ClusterStorageInfo']:
        return pulumi.get(self, "storage_info")


@pulumi.output_type
class ClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterSasl'] = None,
                 tls: Optional['outputs.ClusterTls'] = None,
                 unauthenticated: Optional['outputs.ClusterUnauthenticated'] = None):
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if unauthenticated is not None:
            pulumi.set(__self__, "unauthenticated", unauthenticated)

    @property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterSasl']:
        return pulumi.get(self, "sasl")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ClusterTls']:
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def unauthenticated(self) -> Optional['outputs.ClusterUnauthenticated']:
        return pulumi.get(self, "unauthenticated")


@pulumi.output_type
class ClusterCloudWatchLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroup":
            suggest = "log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudWatchLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudWatchLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudWatchLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 log_group: Optional[str] = None):
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[str]:
        return pulumi.get(self, "log_group")


@pulumi.output_type
class ClusterConfigurationInfo(dict):
    def __init__(__self__, *,
                 arn: str,
                 revision: int):
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def revision(self) -> int:
        return pulumi.get(self, "revision")


@pulumi.output_type
class ClusterConnectivityInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicAccess":
            suggest = "public_access"
        elif key == "vpcConnectivity":
            suggest = "vpc_connectivity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConnectivityInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConnectivityInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConnectivityInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_access: Optional['outputs.ClusterPublicAccess'] = None,
                 vpc_connectivity: Optional['outputs.ClusterVpcConnectivity'] = None):
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if vpc_connectivity is not None:
            pulumi.set(__self__, "vpc_connectivity", vpc_connectivity)

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional['outputs.ClusterPublicAccess']:
        return pulumi.get(self, "public_access")

    @property
    @pulumi.getter(name="vpcConnectivity")
    def vpc_connectivity(self) -> Optional['outputs.ClusterVpcConnectivity']:
        return pulumi.get(self, "vpc_connectivity")


@pulumi.output_type
class ClusterEbsStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedThroughput":
            suggest = "provisioned_throughput"
        elif key == "volumeSize":
            suggest = "volume_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEbsStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEbsStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEbsStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_throughput: Optional['outputs.ClusterProvisionedThroughput'] = None,
                 volume_size: Optional[int] = None):
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional['outputs.ClusterProvisionedThroughput']:
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")


@pulumi.output_type
class ClusterEncryptionAtRest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeKmsKeyId":
            suggest = "data_volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionAtRest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionAtRest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionAtRest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_kms_key_id: str):
        pulumi.set(__self__, "data_volume_kms_key_id", data_volume_kms_key_id)

    @property
    @pulumi.getter(name="dataVolumeKmsKeyId")
    def data_volume_kms_key_id(self) -> str:
        return pulumi.get(self, "data_volume_kms_key_id")


@pulumi.output_type
class ClusterEncryptionInTransit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientBroker":
            suggest = "client_broker"
        elif key == "inCluster":
            suggest = "in_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInTransit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInTransit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInTransit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_broker: Optional['ClusterEncryptionInTransitClientBroker'] = None,
                 in_cluster: Optional[bool] = None):
        if client_broker is not None:
            pulumi.set(__self__, "client_broker", client_broker)
        if in_cluster is not None:
            pulumi.set(__self__, "in_cluster", in_cluster)

    @property
    @pulumi.getter(name="clientBroker")
    def client_broker(self) -> Optional['ClusterEncryptionInTransitClientBroker']:
        return pulumi.get(self, "client_broker")

    @property
    @pulumi.getter(name="inCluster")
    def in_cluster(self) -> Optional[bool]:
        return pulumi.get(self, "in_cluster")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAtRest":
            suggest = "encryption_at_rest"
        elif key == "encryptionInTransit":
            suggest = "encryption_in_transit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_at_rest: Optional['outputs.ClusterEncryptionAtRest'] = None,
                 encryption_in_transit: Optional['outputs.ClusterEncryptionInTransit'] = None):
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional['outputs.ClusterEncryptionAtRest']:
        return pulumi.get(self, "encryption_at_rest")

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional['outputs.ClusterEncryptionInTransit']:
        return pulumi.get(self, "encryption_in_transit")


@pulumi.output_type
class ClusterFirehose(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStream":
            suggest = "delivery_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 delivery_stream: Optional[str] = None):
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[str]:
        return pulumi.get(self, "delivery_stream")


@pulumi.output_type
class ClusterIam(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterJmxExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterJmxExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterJmxExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterJmxExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: bool):
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> bool:
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ClusterLoggingInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brokerLogs":
            suggest = "broker_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker_logs: 'outputs.ClusterBrokerLogs'):
        pulumi.set(__self__, "broker_logs", broker_logs)

    @property
    @pulumi.getter(name="brokerLogs")
    def broker_logs(self) -> 'outputs.ClusterBrokerLogs':
        return pulumi.get(self, "broker_logs")


@pulumi.output_type
class ClusterNodeExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: bool):
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> bool:
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ClusterOpenMonitoring(dict):
    def __init__(__self__, *,
                 prometheus: 'outputs.ClusterPrometheus'):
        pulumi.set(__self__, "prometheus", prometheus)

    @property
    @pulumi.getter
    def prometheus(self) -> 'outputs.ClusterPrometheus':
        return pulumi.get(self, "prometheus")


@pulumi.output_type
class ClusterPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jmxExporter":
            suggest = "jmx_exporter"
        elif key == "nodeExporter":
            suggest = "node_exporter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jmx_exporter: Optional['outputs.ClusterJmxExporter'] = None,
                 node_exporter: Optional['outputs.ClusterNodeExporter'] = None):
        if jmx_exporter is not None:
            pulumi.set(__self__, "jmx_exporter", jmx_exporter)
        if node_exporter is not None:
            pulumi.set(__self__, "node_exporter", node_exporter)

    @property
    @pulumi.getter(name="jmxExporter")
    def jmx_exporter(self) -> Optional['outputs.ClusterJmxExporter']:
        return pulumi.get(self, "jmx_exporter")

    @property
    @pulumi.getter(name="nodeExporter")
    def node_exporter(self) -> Optional['outputs.ClusterNodeExporter']:
        return pulumi.get(self, "node_exporter")


@pulumi.output_type
class ClusterProvisionedThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeThroughput":
            suggest = "volume_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterProvisionedThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterProvisionedThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterProvisionedThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 volume_throughput: Optional[int] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if volume_throughput is not None:
            pulumi.set(__self__, "volume_throughput", volume_throughput)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="volumeThroughput")
    def volume_throughput(self) -> Optional[int]:
        return pulumi.get(self, "volume_throughput")


@pulumi.output_type
class ClusterPublicAccess(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterS3(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 bucket: Optional[str] = None,
                 prefix: Optional[str] = None):
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ClusterSasl(dict):
    def __init__(__self__, *,
                 iam: Optional['outputs.ClusterIam'] = None,
                 scram: Optional['outputs.ClusterScram'] = None):
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional['outputs.ClusterIam']:
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def scram(self) -> Optional['outputs.ClusterScram']:
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterScram(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsStorageInfo":
            suggest = "ebs_storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_storage_info: Optional['outputs.ClusterEbsStorageInfo'] = None):
        if ebs_storage_info is not None:
            pulumi.set(__self__, "ebs_storage_info", ebs_storage_info)

    @property
    @pulumi.getter(name="ebsStorageInfo")
    def ebs_storage_info(self) -> Optional['outputs.ClusterEbsStorageInfo']:
        return pulumi.get(self, "ebs_storage_info")


@pulumi.output_type
class ClusterTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityArnList":
            suggest = "certificate_authority_arn_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_arn_list: Optional[Sequence[str]] = None,
                 enabled: Optional[bool] = None):
        if certificate_authority_arn_list is not None:
            pulumi.set(__self__, "certificate_authority_arn_list", certificate_authority_arn_list)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="certificateAuthorityArnList")
    def certificate_authority_arn_list(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "certificate_authority_arn_list")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterUnauthenticated(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterVpcConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuthentication":
            suggest = "client_authentication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVpcConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVpcConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVpcConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_authentication: Optional['outputs.ClusterVpcConnectivityClientAuthentication'] = None):
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)

    @property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional['outputs.ClusterVpcConnectivityClientAuthentication']:
        return pulumi.get(self, "client_authentication")


@pulumi.output_type
class ClusterVpcConnectivityClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterVpcConnectivitySasl'] = None,
                 tls: Optional['outputs.ClusterVpcConnectivityTls'] = None):
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterVpcConnectivitySasl']:
        return pulumi.get(self, "sasl")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ClusterVpcConnectivityTls']:
        return pulumi.get(self, "tls")


@pulumi.output_type
class ClusterVpcConnectivityIam(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterVpcConnectivitySasl(dict):
    def __init__(__self__, *,
                 iam: Optional['outputs.ClusterVpcConnectivityIam'] = None,
                 scram: Optional['outputs.ClusterVpcConnectivityScram'] = None):
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional['outputs.ClusterVpcConnectivityIam']:
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def scram(self) -> Optional['outputs.ClusterVpcConnectivityScram']:
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterVpcConnectivityScram(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterVpcConnectivityTls(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConfigurationLatestRevision(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationLatestRevision. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationLatestRevision.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationLatestRevision.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: Optional[str] = None,
                 description: Optional[str] = None,
                 revision: Optional[int] = None):
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def revision(self) -> Optional[int]:
        return pulumi.get(self, "revision")


@pulumi.output_type
class ReplicatorAmazonMskCluster(dict):
    """
    Details of an Amazon MSK cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mskClusterArn":
            suggest = "msk_cluster_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorAmazonMskCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorAmazonMskCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorAmazonMskCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 msk_cluster_arn: str):
        """
        Details of an Amazon MSK cluster.
        :param str msk_cluster_arn: The ARN of an Amazon MSK cluster.
        """
        pulumi.set(__self__, "msk_cluster_arn", msk_cluster_arn)

    @property
    @pulumi.getter(name="mskClusterArn")
    def msk_cluster_arn(self) -> str:
        """
        The ARN of an Amazon MSK cluster.
        """
        return pulumi.get(self, "msk_cluster_arn")


@pulumi.output_type
class ReplicatorConsumerGroupReplication(dict):
    """
    Configuration relating to consumer group replication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupsToReplicate":
            suggest = "consumer_groups_to_replicate"
        elif key == "consumerGroupsToExclude":
            suggest = "consumer_groups_to_exclude"
        elif key == "detectAndCopyNewConsumerGroups":
            suggest = "detect_and_copy_new_consumer_groups"
        elif key == "synchroniseConsumerGroupOffsets":
            suggest = "synchronise_consumer_group_offsets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorConsumerGroupReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorConsumerGroupReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorConsumerGroupReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_groups_to_replicate: Sequence[str],
                 consumer_groups_to_exclude: Optional[Sequence[str]] = None,
                 detect_and_copy_new_consumer_groups: Optional[bool] = None,
                 synchronise_consumer_group_offsets: Optional[bool] = None):
        """
        Configuration relating to consumer group replication.
        :param Sequence[str] consumer_groups_to_replicate: List of regular expression patterns indicating the consumer groups to copy.
        :param Sequence[str] consumer_groups_to_exclude: List of regular expression patterns indicating the consumer groups that should not be replicated.
        :param bool detect_and_copy_new_consumer_groups: Whether to periodically check for new consumer groups.
        :param bool synchronise_consumer_group_offsets: Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        pulumi.set(__self__, "consumer_groups_to_replicate", consumer_groups_to_replicate)
        if consumer_groups_to_exclude is not None:
            pulumi.set(__self__, "consumer_groups_to_exclude", consumer_groups_to_exclude)
        if detect_and_copy_new_consumer_groups is not None:
            pulumi.set(__self__, "detect_and_copy_new_consumer_groups", detect_and_copy_new_consumer_groups)
        if synchronise_consumer_group_offsets is not None:
            pulumi.set(__self__, "synchronise_consumer_group_offsets", synchronise_consumer_group_offsets)

    @property
    @pulumi.getter(name="consumerGroupsToReplicate")
    def consumer_groups_to_replicate(self) -> Sequence[str]:
        """
        List of regular expression patterns indicating the consumer groups to copy.
        """
        return pulumi.get(self, "consumer_groups_to_replicate")

    @property
    @pulumi.getter(name="consumerGroupsToExclude")
    def consumer_groups_to_exclude(self) -> Optional[Sequence[str]]:
        """
        List of regular expression patterns indicating the consumer groups that should not be replicated.
        """
        return pulumi.get(self, "consumer_groups_to_exclude")

    @property
    @pulumi.getter(name="detectAndCopyNewConsumerGroups")
    def detect_and_copy_new_consumer_groups(self) -> Optional[bool]:
        """
        Whether to periodically check for new consumer groups.
        """
        return pulumi.get(self, "detect_and_copy_new_consumer_groups")

    @property
    @pulumi.getter(name="synchroniseConsumerGroupOffsets")
    def synchronise_consumer_group_offsets(self) -> Optional[bool]:
        """
        Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        return pulumi.get(self, "synchronise_consumer_group_offsets")


@pulumi.output_type
class ReplicatorKafkaCluster(dict):
    """
    Details of a Kafka cluster for replication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amazonMskCluster":
            suggest = "amazon_msk_cluster"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amazon_msk_cluster: 'outputs.ReplicatorAmazonMskCluster',
                 vpc_config: 'outputs.ReplicatorKafkaClusterClientVpcConfig'):
        """
        Details of a Kafka cluster for replication.
        :param 'ReplicatorAmazonMskCluster' amazon_msk_cluster: Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        :param 'ReplicatorKafkaClusterClientVpcConfig' vpc_config: Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        pulumi.set(__self__, "amazon_msk_cluster", amazon_msk_cluster)
        pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="amazonMskCluster")
    def amazon_msk_cluster(self) -> 'outputs.ReplicatorAmazonMskCluster':
        """
        Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        """
        return pulumi.get(self, "amazon_msk_cluster")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> 'outputs.ReplicatorKafkaClusterClientVpcConfig':
        """
        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ReplicatorKafkaClusterClientVpcConfig(dict):
    """
    Details of an Amazon VPC which has network connectivity to the Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaClusterClientVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaClusterClientVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaClusterClientVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[str],
                 security_group_ids: Optional[Sequence[str]] = None):
        """
        Details of an Amazon VPC which has network connectivity to the Kafka cluster.
        :param Sequence[str] subnet_ids: The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        :param Sequence[str] security_group_ids: The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class ReplicatorReplicationInfo(dict):
    """
    Specifies configuration for replication between a source and target Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupReplication":
            suggest = "consumer_group_replication"
        elif key == "sourceKafkaClusterArn":
            suggest = "source_kafka_cluster_arn"
        elif key == "targetCompressionType":
            suggest = "target_compression_type"
        elif key == "targetKafkaClusterArn":
            suggest = "target_kafka_cluster_arn"
        elif key == "topicReplication":
            suggest = "topic_replication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorReplicationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorReplicationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorReplicationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_replication: 'outputs.ReplicatorConsumerGroupReplication',
                 source_kafka_cluster_arn: str,
                 target_compression_type: 'ReplicatorReplicationInfoTargetCompressionType',
                 target_kafka_cluster_arn: str,
                 topic_replication: 'outputs.ReplicatorTopicReplication'):
        """
        Specifies configuration for replication between a source and target Kafka cluster.
        :param 'ReplicatorConsumerGroupReplication' consumer_group_replication: Configuration relating to consumer group replication.
        :param str source_kafka_cluster_arn: Amazon Resource Name of the source Kafka cluster.
        :param 'ReplicatorReplicationInfoTargetCompressionType' target_compression_type: The type of compression to use writing records to target Kafka cluster.
        :param str target_kafka_cluster_arn: Amazon Resource Name of the target Kafka cluster.
        :param 'ReplicatorTopicReplication' topic_replication: Configuration relating to topic replication.
        """
        pulumi.set(__self__, "consumer_group_replication", consumer_group_replication)
        pulumi.set(__self__, "source_kafka_cluster_arn", source_kafka_cluster_arn)
        pulumi.set(__self__, "target_compression_type", target_compression_type)
        pulumi.set(__self__, "target_kafka_cluster_arn", target_kafka_cluster_arn)
        pulumi.set(__self__, "topic_replication", topic_replication)

    @property
    @pulumi.getter(name="consumerGroupReplication")
    def consumer_group_replication(self) -> 'outputs.ReplicatorConsumerGroupReplication':
        """
        Configuration relating to consumer group replication.
        """
        return pulumi.get(self, "consumer_group_replication")

    @property
    @pulumi.getter(name="sourceKafkaClusterArn")
    def source_kafka_cluster_arn(self) -> str:
        """
        Amazon Resource Name of the source Kafka cluster.
        """
        return pulumi.get(self, "source_kafka_cluster_arn")

    @property
    @pulumi.getter(name="targetCompressionType")
    def target_compression_type(self) -> 'ReplicatorReplicationInfoTargetCompressionType':
        """
        The type of compression to use writing records to target Kafka cluster.
        """
        return pulumi.get(self, "target_compression_type")

    @property
    @pulumi.getter(name="targetKafkaClusterArn")
    def target_kafka_cluster_arn(self) -> str:
        """
        Amazon Resource Name of the target Kafka cluster.
        """
        return pulumi.get(self, "target_kafka_cluster_arn")

    @property
    @pulumi.getter(name="topicReplication")
    def topic_replication(self) -> 'outputs.ReplicatorTopicReplication':
        """
        Configuration relating to topic replication.
        """
        return pulumi.get(self, "topic_replication")


@pulumi.output_type
class ReplicatorReplicationStartingPosition(dict):
    """
    Configuration for specifying the position in the topics to start replicating from.
    """
    def __init__(__self__, *,
                 type: Optional['ReplicatorReplicationStartingPositionType'] = None):
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional['ReplicatorReplicationStartingPositionType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicatorTopicReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicsToReplicate":
            suggest = "topics_to_replicate"
        elif key == "copyAccessControlListsForTopics":
            suggest = "copy_access_control_lists_for_topics"
        elif key == "copyTopicConfigurations":
            suggest = "copy_topic_configurations"
        elif key == "detectAndCopyNewTopics":
            suggest = "detect_and_copy_new_topics"
        elif key == "startingPosition":
            suggest = "starting_position"
        elif key == "topicsToExclude":
            suggest = "topics_to_exclude"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorTopicReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorTopicReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorTopicReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topics_to_replicate: Sequence[str],
                 copy_access_control_lists_for_topics: Optional[bool] = None,
                 copy_topic_configurations: Optional[bool] = None,
                 detect_and_copy_new_topics: Optional[bool] = None,
                 starting_position: Optional['outputs.ReplicatorReplicationStartingPosition'] = None,
                 topics_to_exclude: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] topics_to_replicate: List of regular expression patterns indicating the topics to copy.
        :param bool copy_access_control_lists_for_topics: Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        :param bool copy_topic_configurations: Whether to periodically configure remote topics to match their corresponding upstream topics.
        :param bool detect_and_copy_new_topics: Whether to periodically check for new topics and partitions.
        :param 'ReplicatorReplicationStartingPosition' starting_position: Configuration for specifying the position in the topics to start replicating from.
        :param Sequence[str] topics_to_exclude: List of regular expression patterns indicating the topics that should not be replicated.
        """
        pulumi.set(__self__, "topics_to_replicate", topics_to_replicate)
        if copy_access_control_lists_for_topics is not None:
            pulumi.set(__self__, "copy_access_control_lists_for_topics", copy_access_control_lists_for_topics)
        if copy_topic_configurations is not None:
            pulumi.set(__self__, "copy_topic_configurations", copy_topic_configurations)
        if detect_and_copy_new_topics is not None:
            pulumi.set(__self__, "detect_and_copy_new_topics", detect_and_copy_new_topics)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if topics_to_exclude is not None:
            pulumi.set(__self__, "topics_to_exclude", topics_to_exclude)

    @property
    @pulumi.getter(name="topicsToReplicate")
    def topics_to_replicate(self) -> Sequence[str]:
        """
        List of regular expression patterns indicating the topics to copy.
        """
        return pulumi.get(self, "topics_to_replicate")

    @property
    @pulumi.getter(name="copyAccessControlListsForTopics")
    def copy_access_control_lists_for_topics(self) -> Optional[bool]:
        """
        Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_access_control_lists_for_topics")

    @property
    @pulumi.getter(name="copyTopicConfigurations")
    def copy_topic_configurations(self) -> Optional[bool]:
        """
        Whether to periodically configure remote topics to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_topic_configurations")

    @property
    @pulumi.getter(name="detectAndCopyNewTopics")
    def detect_and_copy_new_topics(self) -> Optional[bool]:
        """
        Whether to periodically check for new topics and partitions.
        """
        return pulumi.get(self, "detect_and_copy_new_topics")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional['outputs.ReplicatorReplicationStartingPosition']:
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="topicsToExclude")
    def topics_to_exclude(self) -> Optional[Sequence[str]]:
        """
        List of regular expression patterns indicating the topics that should not be replicated.
        """
        return pulumi.get(self, "topics_to_exclude")


@pulumi.output_type
class ServerlessClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: 'outputs.ServerlessClusterSasl'):
        pulumi.set(__self__, "sasl", sasl)

    @property
    @pulumi.getter
    def sasl(self) -> 'outputs.ServerlessClusterSasl':
        return pulumi.get(self, "sasl")


@pulumi.output_type
class ServerlessClusterIam(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServerlessClusterSasl(dict):
    def __init__(__self__, *,
                 iam: 'outputs.ServerlessClusterIam'):
        pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.ServerlessClusterIam':
        return pulumi.get(self, "iam")


@pulumi.output_type
class ServerlessClusterVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[str],
                 security_groups: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "security_groups")


