# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetClusterPolicyResult',
    'AwaitableGetClusterPolicyResult',
    'get_cluster_policy',
    'get_cluster_policy_output',
]

@pulumi.output_type
class GetClusterPolicyResult:
    def __init__(__self__, current_version=None, policy=None):
        if current_version and not isinstance(current_version, str):
            raise TypeError("Expected argument 'current_version' to be a str")
        pulumi.set(__self__, "current_version", current_version)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[str]:
        """
        The current version of the policy attached to the specified cluster
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        A policy document containing permissions to add to the specified cluster.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MSK::ClusterPolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")


class AwaitableGetClusterPolicyResult(GetClusterPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterPolicyResult(
            current_version=self.current_version,
            policy=self.policy)


def get_cluster_policy(cluster_arn: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterPolicyResult:
    """
    Resource Type definition for AWS::MSK::ClusterPolicy


    :param str cluster_arn: The arn of the cluster for the resource policy.
    """
    __args__ = dict()
    __args__['clusterArn'] = cluster_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:msk:getClusterPolicy', __args__, opts=opts, typ=GetClusterPolicyResult).value

    return AwaitableGetClusterPolicyResult(
        current_version=pulumi.get(__ret__, 'current_version'),
        policy=pulumi.get(__ret__, 'policy'))


@_utilities.lift_output_func(get_cluster_policy)
def get_cluster_policy_output(cluster_arn: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterPolicyResult]:
    """
    Resource Type definition for AWS::MSK::ClusterPolicy


    :param str cluster_arn: The arn of the cluster for the resource policy.
    """
    ...
