# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['SourceLocationArgs', 'SourceLocation']

@pulumi.input_type
class SourceLocationArgs:
    def __init__(__self__, *,
                 http_configuration: pulumi.Input['SourceLocationHttpConfigurationArgs'],
                 access_configuration: Optional[pulumi.Input['SourceLocationAccessConfigurationArgs']] = None,
                 default_segment_delivery_configuration: Optional[pulumi.Input['SourceLocationDefaultSegmentDeliveryConfigurationArgs']] = None,
                 segment_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['SourceLocationSegmentDeliveryConfigurationArgs']]]] = None,
                 source_location_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a SourceLocation resource.
        :param pulumi.Input[Sequence[pulumi.Input['SourceLocationSegmentDeliveryConfigurationArgs']]] segment_delivery_configurations: <p>A list of the segment delivery configurations associated with this resource.</p>
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to assign to the source location.
        """
        pulumi.set(__self__, "http_configuration", http_configuration)
        if access_configuration is not None:
            pulumi.set(__self__, "access_configuration", access_configuration)
        if default_segment_delivery_configuration is not None:
            pulumi.set(__self__, "default_segment_delivery_configuration", default_segment_delivery_configuration)
        if segment_delivery_configurations is not None:
            pulumi.set(__self__, "segment_delivery_configurations", segment_delivery_configurations)
        if source_location_name is not None:
            pulumi.set(__self__, "source_location_name", source_location_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="httpConfiguration")
    def http_configuration(self) -> pulumi.Input['SourceLocationHttpConfigurationArgs']:
        return pulumi.get(self, "http_configuration")

    @http_configuration.setter
    def http_configuration(self, value: pulumi.Input['SourceLocationHttpConfigurationArgs']):
        pulumi.set(self, "http_configuration", value)

    @property
    @pulumi.getter(name="accessConfiguration")
    def access_configuration(self) -> Optional[pulumi.Input['SourceLocationAccessConfigurationArgs']]:
        return pulumi.get(self, "access_configuration")

    @access_configuration.setter
    def access_configuration(self, value: Optional[pulumi.Input['SourceLocationAccessConfigurationArgs']]):
        pulumi.set(self, "access_configuration", value)

    @property
    @pulumi.getter(name="defaultSegmentDeliveryConfiguration")
    def default_segment_delivery_configuration(self) -> Optional[pulumi.Input['SourceLocationDefaultSegmentDeliveryConfigurationArgs']]:
        return pulumi.get(self, "default_segment_delivery_configuration")

    @default_segment_delivery_configuration.setter
    def default_segment_delivery_configuration(self, value: Optional[pulumi.Input['SourceLocationDefaultSegmentDeliveryConfigurationArgs']]):
        pulumi.set(self, "default_segment_delivery_configuration", value)

    @property
    @pulumi.getter(name="segmentDeliveryConfigurations")
    def segment_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceLocationSegmentDeliveryConfigurationArgs']]]]:
        """
        <p>A list of the segment delivery configurations associated with this resource.</p>
        """
        return pulumi.get(self, "segment_delivery_configurations")

    @segment_delivery_configurations.setter
    def segment_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceLocationSegmentDeliveryConfigurationArgs']]]]):
        pulumi.set(self, "segment_delivery_configurations", value)

    @property
    @pulumi.getter(name="sourceLocationName")
    def source_location_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_location_name")

    @source_location_name.setter
    def source_location_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_location_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to assign to the source location.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class SourceLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_configuration: Optional[pulumi.Input[pulumi.InputType['SourceLocationAccessConfigurationArgs']]] = None,
                 default_segment_delivery_configuration: Optional[pulumi.Input[pulumi.InputType['SourceLocationDefaultSegmentDeliveryConfigurationArgs']]] = None,
                 http_configuration: Optional[pulumi.Input[pulumi.InputType['SourceLocationHttpConfigurationArgs']]] = None,
                 segment_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceLocationSegmentDeliveryConfigurationArgs']]]]] = None,
                 source_location_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::MediaTailor::SourceLocation Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceLocationSegmentDeliveryConfigurationArgs']]]] segment_delivery_configurations: <p>A list of the segment delivery configurations associated with this resource.</p>
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: The tags to assign to the source location.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::MediaTailor::SourceLocation Resource Type

        :param str resource_name: The name of the resource.
        :param SourceLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_configuration: Optional[pulumi.Input[pulumi.InputType['SourceLocationAccessConfigurationArgs']]] = None,
                 default_segment_delivery_configuration: Optional[pulumi.Input[pulumi.InputType['SourceLocationDefaultSegmentDeliveryConfigurationArgs']]] = None,
                 http_configuration: Optional[pulumi.Input[pulumi.InputType['SourceLocationHttpConfigurationArgs']]] = None,
                 segment_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceLocationSegmentDeliveryConfigurationArgs']]]]] = None,
                 source_location_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceLocationArgs.__new__(SourceLocationArgs)

            __props__.__dict__["access_configuration"] = access_configuration
            __props__.__dict__["default_segment_delivery_configuration"] = default_segment_delivery_configuration
            if http_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'http_configuration'")
            __props__.__dict__["http_configuration"] = http_configuration
            __props__.__dict__["segment_delivery_configurations"] = segment_delivery_configurations
            __props__.__dict__["source_location_name"] = source_location_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["sourceLocationName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SourceLocation, __self__).__init__(
            'aws-native:mediatailor:SourceLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SourceLocation':
        """
        Get an existing SourceLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SourceLocationArgs.__new__(SourceLocationArgs)

        __props__.__dict__["access_configuration"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["default_segment_delivery_configuration"] = None
        __props__.__dict__["http_configuration"] = None
        __props__.__dict__["segment_delivery_configurations"] = None
        __props__.__dict__["source_location_name"] = None
        __props__.__dict__["tags"] = None
        return SourceLocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessConfiguration")
    def access_configuration(self) -> pulumi.Output[Optional['outputs.SourceLocationAccessConfiguration']]:
        return pulumi.get(self, "access_configuration")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        <p>The ARN of the source location.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultSegmentDeliveryConfiguration")
    def default_segment_delivery_configuration(self) -> pulumi.Output[Optional['outputs.SourceLocationDefaultSegmentDeliveryConfiguration']]:
        return pulumi.get(self, "default_segment_delivery_configuration")

    @property
    @pulumi.getter(name="httpConfiguration")
    def http_configuration(self) -> pulumi.Output['outputs.SourceLocationHttpConfiguration']:
        return pulumi.get(self, "http_configuration")

    @property
    @pulumi.getter(name="segmentDeliveryConfigurations")
    def segment_delivery_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.SourceLocationSegmentDeliveryConfiguration']]]:
        """
        <p>A list of the segment delivery configurations associated with this resource.</p>
        """
        return pulumi.get(self, "segment_delivery_configurations")

    @property
    @pulumi.getter(name="sourceLocationName")
    def source_location_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "source_location_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to assign to the source location.
        """
        return pulumi.get(self, "tags")

