# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ChannelIngestEndpoint',
    'OriginEndpointEncryption',
    'OriginEndpointEncryptionContractConfiguration',
    'OriginEndpointEncryptionMethod',
    'OriginEndpointFilterConfiguration',
    'OriginEndpointHlsManifestConfiguration',
    'OriginEndpointLowLatencyHlsManifestConfiguration',
    'OriginEndpointScte',
    'OriginEndpointScteHls',
    'OriginEndpointSegment',
    'OriginEndpointSpekeKeyProvider',
]

@pulumi.output_type
class ChannelIngestEndpoint(dict):
    """
    <p>The ingest domain URL where the source stream should be sent.</p>
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 url: Optional[str] = None):
        """
        <p>The ingest domain URL where the source stream should be sent.</p>
        :param str id: <p>The system-generated unique identifier for the IngestEndpoint.</p>
        :param str url: <p>The ingest domain URL where the source stream should be sent.</p>
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        <p>The system-generated unique identifier for the IngestEndpoint.</p>
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        <p>The ingest domain URL where the source stream should be sent.</p>
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OriginEndpointEncryption(dict):
    """
    <p>The parameters for encrypting content.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionMethod":
            suggest = "encryption_method"
        elif key == "spekeKeyProvider":
            suggest = "speke_key_provider"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "keyRotationIntervalSeconds":
            suggest = "key_rotation_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_method: 'outputs.OriginEndpointEncryptionMethod',
                 speke_key_provider: 'outputs.OriginEndpointSpekeKeyProvider',
                 constant_initialization_vector: Optional[str] = None,
                 key_rotation_interval_seconds: Optional[int] = None):
        """
        <p>The parameters for encrypting content.</p>
        :param str constant_initialization_vector: <p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).</p>
        :param int key_rotation_interval_seconds: <p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.</p>
                        <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
                        </p>
        """
        pulumi.set(__self__, "encryption_method", encryption_method)
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> 'outputs.OriginEndpointEncryptionMethod':
        return pulumi.get(self, "encryption_method")

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.OriginEndpointSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        <p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).</p>
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[int]:
        """
        <p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.</p>
                 <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
                 </p>
        """
        return pulumi.get(self, "key_rotation_interval_seconds")


@pulumi.output_type
class OriginEndpointEncryptionContractConfiguration(dict):
    """
    <p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "presetSpeke20Audio":
            suggest = "preset_speke20_audio"
        elif key == "presetSpeke20Video":
            suggest = "preset_speke20_video"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointEncryptionContractConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointEncryptionContractConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointEncryptionContractConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preset_speke20_audio: 'OriginEndpointPresetSpeke20Audio',
                 preset_speke20_video: 'OriginEndpointPresetSpeke20Video'):
        """
        <p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>
        """
        pulumi.set(__self__, "preset_speke20_audio", preset_speke20_audio)
        pulumi.set(__self__, "preset_speke20_video", preset_speke20_video)

    @property
    @pulumi.getter(name="presetSpeke20Audio")
    def preset_speke20_audio(self) -> 'OriginEndpointPresetSpeke20Audio':
        return pulumi.get(self, "preset_speke20_audio")

    @property
    @pulumi.getter(name="presetSpeke20Video")
    def preset_speke20_video(self) -> 'OriginEndpointPresetSpeke20Video':
        return pulumi.get(self, "preset_speke20_video")


@pulumi.output_type
class OriginEndpointEncryptionMethod(dict):
    """
    <p>The encryption type.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmafEncryptionMethod":
            suggest = "cmaf_encryption_method"
        elif key == "tsEncryptionMethod":
            suggest = "ts_encryption_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointEncryptionMethod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointEncryptionMethod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointEncryptionMethod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cmaf_encryption_method: Optional['OriginEndpointCmafEncryptionMethod'] = None,
                 ts_encryption_method: Optional['OriginEndpointTsEncryptionMethod'] = None):
        """
        <p>The encryption type.</p>
        """
        if cmaf_encryption_method is not None:
            pulumi.set(__self__, "cmaf_encryption_method", cmaf_encryption_method)
        if ts_encryption_method is not None:
            pulumi.set(__self__, "ts_encryption_method", ts_encryption_method)

    @property
    @pulumi.getter(name="cmafEncryptionMethod")
    def cmaf_encryption_method(self) -> Optional['OriginEndpointCmafEncryptionMethod']:
        return pulumi.get(self, "cmaf_encryption_method")

    @property
    @pulumi.getter(name="tsEncryptionMethod")
    def ts_encryption_method(self) -> Optional['OriginEndpointTsEncryptionMethod']:
        return pulumi.get(self, "ts_encryption_method")


@pulumi.output_type
class OriginEndpointFilterConfiguration(dict):
    """
    <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest. </p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestFilter":
            suggest = "manifest_filter"
        elif key == "timeDelaySeconds":
            suggest = "time_delay_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: Optional[str] = None,
                 manifest_filter: Optional[str] = None,
                 start: Optional[str] = None,
                 time_delay_seconds: Optional[int] = None):
        """
        <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest. </p>
        :param str end: <p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.</p>
        :param str manifest_filter: <p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.</p>
        :param str start: <p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.</p>
        :param int time_delay_seconds: <p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.</p>
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if manifest_filter is not None:
            pulumi.set(__self__, "manifest_filter", manifest_filter)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if time_delay_seconds is not None:
            pulumi.set(__self__, "time_delay_seconds", time_delay_seconds)

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        <p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="manifestFilter")
    def manifest_filter(self) -> Optional[str]:
        """
        <p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "manifest_filter")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        <p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="timeDelaySeconds")
    def time_delay_seconds(self) -> Optional[int]:
        """
        <p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "time_delay_seconds")


@pulumi.output_type
class OriginEndpointHlsManifestConfiguration(dict):
    """
    <p>Retrieve the HTTP live streaming (HLS) manifest configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "childManifestName":
            suggest = "child_manifest_name"
        elif key == "filterConfiguration":
            suggest = "filter_configuration"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"
        elif key == "scteHls":
            suggest = "scte_hls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointHlsManifestConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointHlsManifestConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointHlsManifestConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: str,
                 child_manifest_name: Optional[str] = None,
                 filter_configuration: Optional['outputs.OriginEndpointFilterConfiguration'] = None,
                 manifest_window_seconds: Optional[int] = None,
                 program_date_time_interval_seconds: Optional[int] = None,
                 scte_hls: Optional['outputs.OriginEndpointScteHls'] = None,
                 url: Optional[str] = None):
        """
        <p>Retrieve the HTTP live streaming (HLS) manifest configuration.</p>
        :param str manifest_name: <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param str child_manifest_name: <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param int manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param int program_date_time_interval_seconds: <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                        EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                        The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                        ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                        <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        :param str url: <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if child_manifest_name is not None:
            pulumi.set(__self__, "child_manifest_name", child_manifest_name)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if scte_hls is not None:
            pulumi.set(__self__, "scte_hls", scte_hls)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> str:
        """
        <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="childManifestName")
    def child_manifest_name(self) -> Optional[str]:
        """
        <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "child_manifest_name")

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.OriginEndpointFilterConfiguration']:
        return pulumi.get(self, "filter_configuration")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[int]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[int]:
        """
        <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                 EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                 The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                 ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                 <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter(name="scteHls")
    def scte_hls(self) -> Optional['outputs.OriginEndpointScteHls']:
        return pulumi.get(self, "scte_hls")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OriginEndpointLowLatencyHlsManifestConfiguration(dict):
    """
    <p>Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "childManifestName":
            suggest = "child_manifest_name"
        elif key == "filterConfiguration":
            suggest = "filter_configuration"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"
        elif key == "scteHls":
            suggest = "scte_hls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointLowLatencyHlsManifestConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointLowLatencyHlsManifestConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointLowLatencyHlsManifestConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: str,
                 child_manifest_name: Optional[str] = None,
                 filter_configuration: Optional['outputs.OriginEndpointFilterConfiguration'] = None,
                 manifest_window_seconds: Optional[int] = None,
                 program_date_time_interval_seconds: Optional[int] = None,
                 scte_hls: Optional['outputs.OriginEndpointScteHls'] = None,
                 url: Optional[str] = None):
        """
        <p>Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.</p>
        :param str manifest_name: <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param str child_manifest_name: <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param int manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param int program_date_time_interval_seconds: <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                        EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                        The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                        ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                        <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        :param str url: <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if child_manifest_name is not None:
            pulumi.set(__self__, "child_manifest_name", child_manifest_name)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if scte_hls is not None:
            pulumi.set(__self__, "scte_hls", scte_hls)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> str:
        """
        <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="childManifestName")
    def child_manifest_name(self) -> Optional[str]:
        """
        <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "child_manifest_name")

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.OriginEndpointFilterConfiguration']:
        return pulumi.get(self, "filter_configuration")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[int]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[int]:
        """
        <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                 EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                 The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                 ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                 <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter(name="scteHls")
    def scte_hls(self) -> Optional['outputs.OriginEndpointScteHls']:
        return pulumi.get(self, "scte_hls")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OriginEndpointScte(dict):
    """
    <p>The SCTE configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scteFilter":
            suggest = "scte_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointScte. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointScte.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointScte.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scte_filter: Optional[Sequence['OriginEndpointScteFilter']] = None):
        """
        <p>The SCTE configuration.</p>
        :param Sequence['OriginEndpointScteFilter'] scte_filter: <p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>
        """
        if scte_filter is not None:
            pulumi.set(__self__, "scte_filter", scte_filter)

    @property
    @pulumi.getter(name="scteFilter")
    def scte_filter(self) -> Optional[Sequence['OriginEndpointScteFilter']]:
        """
        <p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>
        """
        return pulumi.get(self, "scte_filter")


@pulumi.output_type
class OriginEndpointScteHls(dict):
    """
    <p>The SCTE configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkerHls":
            suggest = "ad_marker_hls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointScteHls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointScteHls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointScteHls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_marker_hls: Optional['OriginEndpointAdMarkerHls'] = None):
        """
        <p>The SCTE configuration.</p>
        """
        if ad_marker_hls is not None:
            pulumi.set(__self__, "ad_marker_hls", ad_marker_hls)

    @property
    @pulumi.getter(name="adMarkerHls")
    def ad_marker_hls(self) -> Optional['OriginEndpointAdMarkerHls']:
        return pulumi.get(self, "ad_marker_hls")


@pulumi.output_type
class OriginEndpointSegment(dict):
    """
    <p>The segment configuration, including the segment name, duration, and other configuration values.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeIframeOnlyStreams":
            suggest = "include_iframe_only_streams"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "segmentName":
            suggest = "segment_name"
        elif key == "tsIncludeDvbSubtitles":
            suggest = "ts_include_dvb_subtitles"
        elif key == "tsUseAudioRenditionGroup":
            suggest = "ts_use_audio_rendition_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointSegment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointSegment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointSegment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption: Optional['outputs.OriginEndpointEncryption'] = None,
                 include_iframe_only_streams: Optional[bool] = None,
                 scte: Optional['outputs.OriginEndpointScte'] = None,
                 segment_duration_seconds: Optional[int] = None,
                 segment_name: Optional[str] = None,
                 ts_include_dvb_subtitles: Optional[bool] = None,
                 ts_use_audio_rendition_group: Optional[bool] = None):
        """
        <p>The segment configuration, including the segment name, duration, and other configuration values.</p>
        :param bool include_iframe_only_streams: <p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>
        :param int segment_duration_seconds: <p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>
        :param str segment_name: <p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.</p>
        :param bool ts_include_dvb_subtitles: <p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>
        :param bool ts_use_audio_rendition_group: <p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_iframe_only_streams is not None:
            pulumi.set(__self__, "include_iframe_only_streams", include_iframe_only_streams)
        if scte is not None:
            pulumi.set(__self__, "scte", scte)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if ts_include_dvb_subtitles is not None:
            pulumi.set(__self__, "ts_include_dvb_subtitles", ts_include_dvb_subtitles)
        if ts_use_audio_rendition_group is not None:
            pulumi.set(__self__, "ts_use_audio_rendition_group", ts_use_audio_rendition_group)

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.OriginEndpointEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="includeIframeOnlyStreams")
    def include_iframe_only_streams(self) -> Optional[bool]:
        """
        <p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>
        """
        return pulumi.get(self, "include_iframe_only_streams")

    @property
    @pulumi.getter
    def scte(self) -> Optional['outputs.OriginEndpointScte']:
        return pulumi.get(self, "scte")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        """
        <p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>
        """
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[str]:
        """
        <p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.</p>
        """
        return pulumi.get(self, "segment_name")

    @property
    @pulumi.getter(name="tsIncludeDvbSubtitles")
    def ts_include_dvb_subtitles(self) -> Optional[bool]:
        """
        <p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>
        """
        return pulumi.get(self, "ts_include_dvb_subtitles")

    @property
    @pulumi.getter(name="tsUseAudioRenditionGroup")
    def ts_use_audio_rendition_group(self) -> Optional[bool]:
        """
        <p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>
        """
        return pulumi.get(self, "ts_use_audio_rendition_group")


@pulumi.output_type
class OriginEndpointSpekeKeyProvider(dict):
    """
    <p>The parameters for the SPEKE key provider.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drmSystems":
            suggest = "drm_systems"
        elif key == "encryptionContractConfiguration":
            suggest = "encryption_contract_configuration"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointSpekeKeyProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointSpekeKeyProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointSpekeKeyProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drm_systems: Sequence['OriginEndpointDrmSystem'],
                 encryption_contract_configuration: 'outputs.OriginEndpointEncryptionContractConfiguration',
                 resource_id: str,
                 role_arn: str,
                 url: str):
        """
        <p>The parameters for the SPEKE key provider.</p>
        :param Sequence['OriginEndpointDrmSystem'] drm_systems: <p>The DRM solution provider you're using to protect your content during distribution.</p>
        :param str resource_id: <p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p>
                        <p>The following example shows a resource ID: <code>MovieNight20171126093045</code>
                        </p>
        :param str role_arn: <p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p>
                        <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
                        </p>
        :param str url: <p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p>
                        <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code>
                        </p>
        """
        pulumi.set(__self__, "drm_systems", drm_systems)
        pulumi.set(__self__, "encryption_contract_configuration", encryption_contract_configuration)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="drmSystems")
    def drm_systems(self) -> Sequence['OriginEndpointDrmSystem']:
        """
        <p>The DRM solution provider you're using to protect your content during distribution.</p>
        """
        return pulumi.get(self, "drm_systems")

    @property
    @pulumi.getter(name="encryptionContractConfiguration")
    def encryption_contract_configuration(self) -> 'outputs.OriginEndpointEncryptionContractConfiguration':
        return pulumi.get(self, "encryption_contract_configuration")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        <p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p>
                 <p>The following example shows a resource ID: <code>MovieNight20171126093045</code>
                 </p>
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        <p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p>
                 <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
                 </p>
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        <p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p>
                 <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code>
                 </p>
        """
        return pulumi.get(self, "url")


