# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'OriginEndpointEncryptionContractConfigurationArgs',
    'OriginEndpointEncryptionMethodArgs',
    'OriginEndpointEncryptionArgs',
    'OriginEndpointFilterConfigurationArgs',
    'OriginEndpointHlsManifestConfigurationArgs',
    'OriginEndpointLowLatencyHlsManifestConfigurationArgs',
    'OriginEndpointScteHlsArgs',
    'OriginEndpointScteArgs',
    'OriginEndpointSegmentArgs',
    'OriginEndpointSpekeKeyProviderArgs',
]

@pulumi.input_type
class OriginEndpointEncryptionContractConfigurationArgs:
    def __init__(__self__, *,
                 preset_speke20_audio: pulumi.Input['OriginEndpointPresetSpeke20Audio'],
                 preset_speke20_video: pulumi.Input['OriginEndpointPresetSpeke20Video']):
        """
        <p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>
        """
        pulumi.set(__self__, "preset_speke20_audio", preset_speke20_audio)
        pulumi.set(__self__, "preset_speke20_video", preset_speke20_video)

    @property
    @pulumi.getter(name="presetSpeke20Audio")
    def preset_speke20_audio(self) -> pulumi.Input['OriginEndpointPresetSpeke20Audio']:
        return pulumi.get(self, "preset_speke20_audio")

    @preset_speke20_audio.setter
    def preset_speke20_audio(self, value: pulumi.Input['OriginEndpointPresetSpeke20Audio']):
        pulumi.set(self, "preset_speke20_audio", value)

    @property
    @pulumi.getter(name="presetSpeke20Video")
    def preset_speke20_video(self) -> pulumi.Input['OriginEndpointPresetSpeke20Video']:
        return pulumi.get(self, "preset_speke20_video")

    @preset_speke20_video.setter
    def preset_speke20_video(self, value: pulumi.Input['OriginEndpointPresetSpeke20Video']):
        pulumi.set(self, "preset_speke20_video", value)


@pulumi.input_type
class OriginEndpointEncryptionMethodArgs:
    def __init__(__self__, *,
                 cmaf_encryption_method: Optional[pulumi.Input['OriginEndpointCmafEncryptionMethod']] = None,
                 ts_encryption_method: Optional[pulumi.Input['OriginEndpointTsEncryptionMethod']] = None):
        """
        <p>The encryption type.</p>
        """
        if cmaf_encryption_method is not None:
            pulumi.set(__self__, "cmaf_encryption_method", cmaf_encryption_method)
        if ts_encryption_method is not None:
            pulumi.set(__self__, "ts_encryption_method", ts_encryption_method)

    @property
    @pulumi.getter(name="cmafEncryptionMethod")
    def cmaf_encryption_method(self) -> Optional[pulumi.Input['OriginEndpointCmafEncryptionMethod']]:
        return pulumi.get(self, "cmaf_encryption_method")

    @cmaf_encryption_method.setter
    def cmaf_encryption_method(self, value: Optional[pulumi.Input['OriginEndpointCmafEncryptionMethod']]):
        pulumi.set(self, "cmaf_encryption_method", value)

    @property
    @pulumi.getter(name="tsEncryptionMethod")
    def ts_encryption_method(self) -> Optional[pulumi.Input['OriginEndpointTsEncryptionMethod']]:
        return pulumi.get(self, "ts_encryption_method")

    @ts_encryption_method.setter
    def ts_encryption_method(self, value: Optional[pulumi.Input['OriginEndpointTsEncryptionMethod']]):
        pulumi.set(self, "ts_encryption_method", value)


@pulumi.input_type
class OriginEndpointEncryptionArgs:
    def __init__(__self__, *,
                 encryption_method: pulumi.Input['OriginEndpointEncryptionMethodArgs'],
                 speke_key_provider: pulumi.Input['OriginEndpointSpekeKeyProviderArgs'],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 key_rotation_interval_seconds: Optional[pulumi.Input[int]] = None):
        """
        <p>The parameters for encrypting content.</p>
        :param pulumi.Input[str] constant_initialization_vector: <p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).</p>
        :param pulumi.Input[int] key_rotation_interval_seconds: <p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.</p>
                        <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
                        </p>
        """
        pulumi.set(__self__, "encryption_method", encryption_method)
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> pulumi.Input['OriginEndpointEncryptionMethodArgs']:
        return pulumi.get(self, "encryption_method")

    @encryption_method.setter
    def encryption_method(self, value: pulumi.Input['OriginEndpointEncryptionMethodArgs']):
        pulumi.set(self, "encryption_method", value)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['OriginEndpointSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['OriginEndpointSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        <p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).</p>
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.</p>
                 <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
                 </p>
        """
        return pulumi.get(self, "key_rotation_interval_seconds")

    @key_rotation_interval_seconds.setter
    def key_rotation_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_rotation_interval_seconds", value)


@pulumi.input_type
class OriginEndpointFilterConfigurationArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 manifest_filter: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None,
                 time_delay_seconds: Optional[pulumi.Input[int]] = None):
        """
        <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest. </p>
        :param pulumi.Input[str] end: <p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.</p>
        :param pulumi.Input[str] manifest_filter: <p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.</p>
        :param pulumi.Input[str] start: <p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.</p>
        :param pulumi.Input[int] time_delay_seconds: <p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.</p>
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if manifest_filter is not None:
            pulumi.set(__self__, "manifest_filter", manifest_filter)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if time_delay_seconds is not None:
            pulumi.set(__self__, "time_delay_seconds", time_delay_seconds)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        <p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="manifestFilter")
    def manifest_filter(self) -> Optional[pulumi.Input[str]]:
        """
        <p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "manifest_filter")

    @manifest_filter.setter
    def manifest_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_filter", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        <p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="timeDelaySeconds")
    def time_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "time_delay_seconds")

    @time_delay_seconds.setter
    def time_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_delay_seconds", value)


@pulumi.input_type
class OriginEndpointHlsManifestConfigurationArgs:
    def __init__(__self__, *,
                 manifest_name: pulumi.Input[str],
                 child_manifest_name: Optional[pulumi.Input[str]] = None,
                 filter_configuration: Optional[pulumi.Input['OriginEndpointFilterConfigurationArgs']] = None,
                 manifest_window_seconds: Optional[pulumi.Input[int]] = None,
                 program_date_time_interval_seconds: Optional[pulumi.Input[int]] = None,
                 scte_hls: Optional[pulumi.Input['OriginEndpointScteHlsArgs']] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        <p>Retrieve the HTTP live streaming (HLS) manifest configuration.</p>
        :param pulumi.Input[str] manifest_name: <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param pulumi.Input[str] child_manifest_name: <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param pulumi.Input[int] manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param pulumi.Input[int] program_date_time_interval_seconds: <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                        EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                        The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                        ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                        <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        :param pulumi.Input[str] url: <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if child_manifest_name is not None:
            pulumi.set(__self__, "child_manifest_name", child_manifest_name)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if scte_hls is not None:
            pulumi.set(__self__, "scte_hls", scte_hls)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> pulumi.Input[str]:
        """
        <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="childManifestName")
    def child_manifest_name(self) -> Optional[pulumi.Input[str]]:
        """
        <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "child_manifest_name")

    @child_manifest_name.setter
    def child_manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "child_manifest_name", value)

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional[pulumi.Input['OriginEndpointFilterConfigurationArgs']]:
        return pulumi.get(self, "filter_configuration")

    @filter_configuration.setter
    def filter_configuration(self, value: Optional[pulumi.Input['OriginEndpointFilterConfigurationArgs']]):
        pulumi.set(self, "filter_configuration", value)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @manifest_window_seconds.setter
    def manifest_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manifest_window_seconds", value)

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                 EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                 The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                 ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                 <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @program_date_time_interval_seconds.setter
    def program_date_time_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "program_date_time_interval_seconds", value)

    @property
    @pulumi.getter(name="scteHls")
    def scte_hls(self) -> Optional[pulumi.Input['OriginEndpointScteHlsArgs']]:
        return pulumi.get(self, "scte_hls")

    @scte_hls.setter
    def scte_hls(self, value: Optional[pulumi.Input['OriginEndpointScteHlsArgs']]):
        pulumi.set(self, "scte_hls", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class OriginEndpointLowLatencyHlsManifestConfigurationArgs:
    def __init__(__self__, *,
                 manifest_name: pulumi.Input[str],
                 child_manifest_name: Optional[pulumi.Input[str]] = None,
                 filter_configuration: Optional[pulumi.Input['OriginEndpointFilterConfigurationArgs']] = None,
                 manifest_window_seconds: Optional[pulumi.Input[int]] = None,
                 program_date_time_interval_seconds: Optional[pulumi.Input[int]] = None,
                 scte_hls: Optional[pulumi.Input['OriginEndpointScteHlsArgs']] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        <p>Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.</p>
        :param pulumi.Input[str] manifest_name: <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param pulumi.Input[str] child_manifest_name: <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param pulumi.Input[int] manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param pulumi.Input[int] program_date_time_interval_seconds: <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                        EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                        The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                        ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                        <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        :param pulumi.Input[str] url: <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if child_manifest_name is not None:
            pulumi.set(__self__, "child_manifest_name", child_manifest_name)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if scte_hls is not None:
            pulumi.set(__self__, "scte_hls", scte_hls)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> pulumi.Input[str]:
        """
        <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="childManifestName")
    def child_manifest_name(self) -> Optional[pulumi.Input[str]]:
        """
        <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "child_manifest_name")

    @child_manifest_name.setter
    def child_manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "child_manifest_name", value)

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional[pulumi.Input['OriginEndpointFilterConfigurationArgs']]:
        return pulumi.get(self, "filter_configuration")

    @filter_configuration.setter
    def filter_configuration(self, value: Optional[pulumi.Input['OriginEndpointFilterConfigurationArgs']]):
        pulumi.set(self, "filter_configuration", value)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @manifest_window_seconds.setter
    def manifest_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manifest_window_seconds", value)

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, 
                 EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. 
                 The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. 
                 ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
                 <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @program_date_time_interval_seconds.setter
    def program_date_time_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "program_date_time_interval_seconds", value)

    @property
    @pulumi.getter(name="scteHls")
    def scte_hls(self) -> Optional[pulumi.Input['OriginEndpointScteHlsArgs']]:
        return pulumi.get(self, "scte_hls")

    @scte_hls.setter
    def scte_hls(self, value: Optional[pulumi.Input['OriginEndpointScteHlsArgs']]):
        pulumi.set(self, "scte_hls", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class OriginEndpointScteHlsArgs:
    def __init__(__self__, *,
                 ad_marker_hls: Optional[pulumi.Input['OriginEndpointAdMarkerHls']] = None):
        """
        <p>The SCTE configuration.</p>
        """
        if ad_marker_hls is not None:
            pulumi.set(__self__, "ad_marker_hls", ad_marker_hls)

    @property
    @pulumi.getter(name="adMarkerHls")
    def ad_marker_hls(self) -> Optional[pulumi.Input['OriginEndpointAdMarkerHls']]:
        return pulumi.get(self, "ad_marker_hls")

    @ad_marker_hls.setter
    def ad_marker_hls(self, value: Optional[pulumi.Input['OriginEndpointAdMarkerHls']]):
        pulumi.set(self, "ad_marker_hls", value)


@pulumi.input_type
class OriginEndpointScteArgs:
    def __init__(__self__, *,
                 scte_filter: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointScteFilter']]]] = None):
        """
        <p>The SCTE configuration.</p>
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointScteFilter']]] scte_filter: <p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>
        """
        if scte_filter is not None:
            pulumi.set(__self__, "scte_filter", scte_filter)

    @property
    @pulumi.getter(name="scteFilter")
    def scte_filter(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointScteFilter']]]]:
        """
        <p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>
        """
        return pulumi.get(self, "scte_filter")

    @scte_filter.setter
    def scte_filter(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointScteFilter']]]]):
        pulumi.set(self, "scte_filter", value)


@pulumi.input_type
class OriginEndpointSegmentArgs:
    def __init__(__self__, *,
                 encryption: Optional[pulumi.Input['OriginEndpointEncryptionArgs']] = None,
                 include_iframe_only_streams: Optional[pulumi.Input[bool]] = None,
                 scte: Optional[pulumi.Input['OriginEndpointScteArgs']] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 segment_name: Optional[pulumi.Input[str]] = None,
                 ts_include_dvb_subtitles: Optional[pulumi.Input[bool]] = None,
                 ts_use_audio_rendition_group: Optional[pulumi.Input[bool]] = None):
        """
        <p>The segment configuration, including the segment name, duration, and other configuration values.</p>
        :param pulumi.Input[bool] include_iframe_only_streams: <p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>
        :param pulumi.Input[int] segment_duration_seconds: <p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>
        :param pulumi.Input[str] segment_name: <p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.</p>
        :param pulumi.Input[bool] ts_include_dvb_subtitles: <p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>
        :param pulumi.Input[bool] ts_use_audio_rendition_group: <p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_iframe_only_streams is not None:
            pulumi.set(__self__, "include_iframe_only_streams", include_iframe_only_streams)
        if scte is not None:
            pulumi.set(__self__, "scte", scte)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if ts_include_dvb_subtitles is not None:
            pulumi.set(__self__, "ts_include_dvb_subtitles", ts_include_dvb_subtitles)
        if ts_use_audio_rendition_group is not None:
            pulumi.set(__self__, "ts_use_audio_rendition_group", ts_use_audio_rendition_group)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['OriginEndpointEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['OriginEndpointEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="includeIframeOnlyStreams")
    def include_iframe_only_streams(self) -> Optional[pulumi.Input[bool]]:
        """
        <p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>
        """
        return pulumi.get(self, "include_iframe_only_streams")

    @include_iframe_only_streams.setter
    def include_iframe_only_streams(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_iframe_only_streams", value)

    @property
    @pulumi.getter
    def scte(self) -> Optional[pulumi.Input['OriginEndpointScteArgs']]:
        return pulumi.get(self, "scte")

    @scte.setter
    def scte(self, value: Optional[pulumi.Input['OriginEndpointScteArgs']]):
        pulumi.set(self, "scte", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        <p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>
        """
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        <p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.</p>
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter(name="tsIncludeDvbSubtitles")
    def ts_include_dvb_subtitles(self) -> Optional[pulumi.Input[bool]]:
        """
        <p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>
        """
        return pulumi.get(self, "ts_include_dvb_subtitles")

    @ts_include_dvb_subtitles.setter
    def ts_include_dvb_subtitles(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ts_include_dvb_subtitles", value)

    @property
    @pulumi.getter(name="tsUseAudioRenditionGroup")
    def ts_use_audio_rendition_group(self) -> Optional[pulumi.Input[bool]]:
        """
        <p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>
        """
        return pulumi.get(self, "ts_use_audio_rendition_group")

    @ts_use_audio_rendition_group.setter
    def ts_use_audio_rendition_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ts_use_audio_rendition_group", value)


@pulumi.input_type
class OriginEndpointSpekeKeyProviderArgs:
    def __init__(__self__, *,
                 drm_systems: pulumi.Input[Sequence[pulumi.Input['OriginEndpointDrmSystem']]],
                 encryption_contract_configuration: pulumi.Input['OriginEndpointEncryptionContractConfigurationArgs'],
                 resource_id: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        <p>The parameters for the SPEKE key provider.</p>
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointDrmSystem']]] drm_systems: <p>The DRM solution provider you're using to protect your content during distribution.</p>
        :param pulumi.Input[str] resource_id: <p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p>
                        <p>The following example shows a resource ID: <code>MovieNight20171126093045</code>
                        </p>
        :param pulumi.Input[str] role_arn: <p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p>
                        <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
                        </p>
        :param pulumi.Input[str] url: <p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p>
                        <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code>
                        </p>
        """
        pulumi.set(__self__, "drm_systems", drm_systems)
        pulumi.set(__self__, "encryption_contract_configuration", encryption_contract_configuration)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="drmSystems")
    def drm_systems(self) -> pulumi.Input[Sequence[pulumi.Input['OriginEndpointDrmSystem']]]:
        """
        <p>The DRM solution provider you're using to protect your content during distribution.</p>
        """
        return pulumi.get(self, "drm_systems")

    @drm_systems.setter
    def drm_systems(self, value: pulumi.Input[Sequence[pulumi.Input['OriginEndpointDrmSystem']]]):
        pulumi.set(self, "drm_systems", value)

    @property
    @pulumi.getter(name="encryptionContractConfiguration")
    def encryption_contract_configuration(self) -> pulumi.Input['OriginEndpointEncryptionContractConfigurationArgs']:
        return pulumi.get(self, "encryption_contract_configuration")

    @encryption_contract_configuration.setter
    def encryption_contract_configuration(self, value: pulumi.Input['OriginEndpointEncryptionContractConfigurationArgs']):
        pulumi.set(self, "encryption_contract_configuration", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        <p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p>
                 <p>The following example shows a resource ID: <code>MovieNight20171126093045</code>
                 </p>
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        <p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p>
                 <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
                 </p>
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        <p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p>
                 <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code>
                 </p>
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


