# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ChannelArgs', 'Channel']

@pulumi.input_type
class ChannelArgs:
    def __init__(__self__, *,
                 aws_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 egress_access_logs: Optional[pulumi.Input['ChannelLogConfigurationArgs']] = None,
                 hls_ingest: Optional[pulumi.Input['ChannelHlsIngestArgs']] = None,
                 ingress_access_logs: Optional[pulumi.Input['ChannelLogConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a Channel resource.
        :param pulumi.Input[str] aws_id: The ID of the Channel.
        :param pulumi.Input[str] description: A short text description of the Channel.
        :param pulumi.Input['ChannelLogConfigurationArgs'] egress_access_logs: The configuration parameters for egress access logging.
        :param pulumi.Input['ChannelHlsIngestArgs'] hls_ingest: An HTTP Live Streaming (HLS) ingest resource configuration.
        :param pulumi.Input['ChannelLogConfigurationArgs'] ingress_access_logs: The configuration parameters for egress access logging.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: A collection of tags associated with a resource
        """
        pulumi.set(__self__, "aws_id", aws_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_access_logs is not None:
            pulumi.set(__self__, "egress_access_logs", egress_access_logs)
        if hls_ingest is not None:
            pulumi.set(__self__, "hls_ingest", hls_ingest)
        if ingress_access_logs is not None:
            pulumi.set(__self__, "ingress_access_logs", ingress_access_logs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Input[str]:
        """
        The ID of the Channel.
        """
        return pulumi.get(self, "aws_id")

    @aws_id.setter
    def aws_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A short text description of the Channel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressAccessLogs")
    def egress_access_logs(self) -> Optional[pulumi.Input['ChannelLogConfigurationArgs']]:
        """
        The configuration parameters for egress access logging.
        """
        return pulumi.get(self, "egress_access_logs")

    @egress_access_logs.setter
    def egress_access_logs(self, value: Optional[pulumi.Input['ChannelLogConfigurationArgs']]):
        pulumi.set(self, "egress_access_logs", value)

    @property
    @pulumi.getter(name="hlsIngest")
    def hls_ingest(self) -> Optional[pulumi.Input['ChannelHlsIngestArgs']]:
        """
        An HTTP Live Streaming (HLS) ingest resource configuration.
        """
        return pulumi.get(self, "hls_ingest")

    @hls_ingest.setter
    def hls_ingest(self, value: Optional[pulumi.Input['ChannelHlsIngestArgs']]):
        pulumi.set(self, "hls_ingest", value)

    @property
    @pulumi.getter(name="ingressAccessLogs")
    def ingress_access_logs(self) -> Optional[pulumi.Input['ChannelLogConfigurationArgs']]:
        """
        The configuration parameters for egress access logging.
        """
        return pulumi.get(self, "ingress_access_logs")

    @ingress_access_logs.setter
    def ingress_access_logs(self, value: Optional[pulumi.Input['ChannelLogConfigurationArgs']]):
        pulumi.set(self, "ingress_access_logs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        A collection of tags associated with a resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Channel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_access_logs: Optional[pulumi.Input[pulumi.InputType['ChannelLogConfigurationArgs']]] = None,
                 hls_ingest: Optional[pulumi.Input[pulumi.InputType['ChannelHlsIngestArgs']]] = None,
                 ingress_access_logs: Optional[pulumi.Input[pulumi.InputType['ChannelLogConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaPackage::Channel

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_id: The ID of the Channel.
        :param pulumi.Input[str] description: A short text description of the Channel.
        :param pulumi.Input[pulumi.InputType['ChannelLogConfigurationArgs']] egress_access_logs: The configuration parameters for egress access logging.
        :param pulumi.Input[pulumi.InputType['ChannelHlsIngestArgs']] hls_ingest: An HTTP Live Streaming (HLS) ingest resource configuration.
        :param pulumi.Input[pulumi.InputType['ChannelLogConfigurationArgs']] ingress_access_logs: The configuration parameters for egress access logging.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]] tags: A collection of tags associated with a resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaPackage::Channel

        :param str resource_name: The name of the resource.
        :param ChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_access_logs: Optional[pulumi.Input[pulumi.InputType['ChannelLogConfigurationArgs']]] = None,
                 hls_ingest: Optional[pulumi.Input[pulumi.InputType['ChannelHlsIngestArgs']]] = None,
                 ingress_access_logs: Optional[pulumi.Input[pulumi.InputType['ChannelLogConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelArgs.__new__(ChannelArgs)

            if aws_id is None and not opts.urn:
                raise TypeError("Missing required property 'aws_id'")
            __props__.__dict__["aws_id"] = aws_id
            __props__.__dict__["description"] = description
            __props__.__dict__["egress_access_logs"] = egress_access_logs
            __props__.__dict__["hls_ingest"] = hls_ingest
            __props__.__dict__["ingress_access_logs"] = ingress_access_logs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Channel, __self__).__init__(
            'aws-native:mediapackage:Channel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Channel':
        """
        Get an existing Channel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChannelArgs.__new__(ChannelArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["egress_access_logs"] = None
        __props__.__dict__["hls_ingest"] = None
        __props__.__dict__["ingress_access_logs"] = None
        __props__.__dict__["tags"] = None
        return Channel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) assigned to the Channel.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        The ID of the Channel.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A short text description of the Channel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressAccessLogs")
    def egress_access_logs(self) -> pulumi.Output[Optional['outputs.ChannelLogConfiguration']]:
        """
        The configuration parameters for egress access logging.
        """
        return pulumi.get(self, "egress_access_logs")

    @property
    @pulumi.getter(name="hlsIngest")
    def hls_ingest(self) -> pulumi.Output[Optional['outputs.ChannelHlsIngest']]:
        """
        An HTTP Live Streaming (HLS) ingest resource configuration.
        """
        return pulumi.get(self, "hls_ingest")

    @property
    @pulumi.getter(name="ingressAccessLogs")
    def ingress_access_logs(self) -> pulumi.Output[Optional['outputs.ChannelLogConfiguration']]:
        """
        The configuration parameters for egress access logging.
        """
        return pulumi.get(self, "ingress_access_logs")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        A collection of tags associated with a resource
        """
        return pulumi.get(self, "tags")

