# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BridgeEgressGatewayBridge',
    'BridgeFailoverConfig',
    'BridgeFlowSource',
    'BridgeIngressGatewayBridge',
    'BridgeNetworkOutput',
    'BridgeNetworkSource',
    'BridgeOutput',
    'BridgeOutputResourceBridgeNetworkOutput',
    'BridgeSource',
    'BridgeSourceBridgeFlowSource',
    'BridgeSourceBridgeNetworkSource',
    'BridgeSourcePriority',
    'BridgeSourceVpcInterfaceAttachment',
    'BridgeVpcInterfaceAttachment',
    'FlowEncryption',
    'FlowEntitlementEncryption',
    'FlowFailoverConfig',
    'FlowFailoverConfigSourcePriorityProperties',
    'FlowGatewayBridgeSource',
    'FlowOutputEncryption',
    'FlowOutputVpcInterfaceAttachment',
    'FlowSource',
    'FlowSourceEncryption',
    'FlowSourceGatewayBridgeSource',
    'FlowSourceVpcInterfaceAttachment',
    'FlowVpcInterfaceAttachment',
    'GatewayNetwork',
]

@pulumi.output_type
class BridgeEgressGatewayBridge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBitrate":
            suggest = "max_bitrate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeEgressGatewayBridge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeEgressGatewayBridge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeEgressGatewayBridge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_bitrate: int):
        """
        :param int max_bitrate: The maximum expected bitrate of the egress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> int:
        """
        The maximum expected bitrate of the egress bridge.
        """
        return pulumi.get(self, "max_bitrate")


@pulumi.output_type
class BridgeFailoverConfig(dict):
    """
    The settings for source failover.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverMode":
            suggest = "failover_mode"
        elif key == "sourcePriority":
            suggest = "source_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeFailoverConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeFailoverConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeFailoverConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_mode: 'BridgeFailoverModeEnum',
                 source_priority: Optional['outputs.BridgeSourcePriority'] = None,
                 state: Optional['BridgeFailoverConfigStateEnum'] = None):
        """
        The settings for source failover.
        :param 'BridgeFailoverModeEnum' failover_mode: The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        :param 'BridgeSourcePriority' source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        pulumi.set(__self__, "failover_mode", failover_mode)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> 'BridgeFailoverModeEnum':
        """
        The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional['outputs.BridgeSourcePriority']:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @property
    @pulumi.getter
    def state(self) -> Optional['BridgeFailoverConfigStateEnum']:
        return pulumi.get(self, "state")


@pulumi.output_type
class BridgeFlowSource(dict):
    """
    The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowArn":
            suggest = "flow_arn"
        elif key == "flowVpcInterfaceAttachment":
            suggest = "flow_vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeFlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeFlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeFlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_arn: str,
                 name: str,
                 flow_vpc_interface_attachment: Optional['outputs.BridgeVpcInterfaceAttachment'] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param str flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param str name: The name of the flow source.
        :param 'BridgeVpcInterfaceAttachment' flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        pulumi.set(__self__, "name", name)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> str:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the flow source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional['outputs.BridgeVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")


@pulumi.output_type
class BridgeIngressGatewayBridge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "maxOutputs":
            suggest = "max_outputs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeIngressGatewayBridge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeIngressGatewayBridge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeIngressGatewayBridge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_bitrate: int,
                 max_outputs: int):
        """
        :param int max_bitrate: The maximum expected bitrate of the ingress bridge.
        :param int max_outputs: The maximum number of outputs on the ingress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)
        pulumi.set(__self__, "max_outputs", max_outputs)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> int:
        """
        The maximum expected bitrate of the ingress bridge.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter(name="maxOutputs")
    def max_outputs(self) -> int:
        """
        The maximum number of outputs on the ingress bridge.
        """
        return pulumi.get(self, "max_outputs")


@pulumi.output_type
class BridgeNetworkOutput(dict):
    """
    The output of the bridge. A network output is delivered to your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeNetworkOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeNetworkOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeNetworkOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: str,
                 name: str,
                 network_name: str,
                 port: int,
                 protocol: 'BridgeProtocolEnum',
                 ttl: int):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param str ip_address: The network output IP Address.
        :param str name: The network output name.
        :param str network_name: The network output's gateway network name.
        :param int port: The network output port.
        :param 'BridgeProtocolEnum' protocol: The network output protocol.
        :param int ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The network output name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> str:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeProtocolEnum':
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BridgeNetworkSource(dict):
    """
    The source of the bridge. A network source originates at your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multicastIp":
            suggest = "multicast_ip"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeNetworkSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeNetworkSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeNetworkSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multicast_ip: str,
                 name: str,
                 network_name: str,
                 port: int,
                 protocol: 'BridgeProtocolEnum'):
        """
        The source of the bridge. A network source originates at your premises.
        :param str multicast_ip: The network source multicast IP.
        :param str name: The name of the network source.
        :param str network_name: The network source's gateway network name.
        :param int port: The network source port.
        :param 'BridgeProtocolEnum' protocol: The network source protocol.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> str:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the network source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> str:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeProtocolEnum':
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class BridgeOutput(dict):
    """
    The output of the bridge.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkOutput":
            suggest = "network_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_output: Optional['outputs.BridgeNetworkOutput'] = None):
        """
        The output of the bridge.
        """
        if network_output is not None:
            pulumi.set(__self__, "network_output", network_output)

    @property
    @pulumi.getter(name="networkOutput")
    def network_output(self) -> Optional['outputs.BridgeNetworkOutput']:
        return pulumi.get(self, "network_output")


@pulumi.output_type
class BridgeOutputResourceBridgeNetworkOutput(dict):
    """
    The output of the bridge. A network output is delivered to your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeOutputResourceBridgeNetworkOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeOutputResourceBridgeNetworkOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeOutputResourceBridgeNetworkOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: str,
                 network_name: str,
                 port: int,
                 protocol: 'BridgeOutputResourceBridgeNetworkOutputProtocol',
                 ttl: int):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param str ip_address: The network output IP Address.
        :param str network_name: The network output's gateway network name.
        :param int port: The network output port.
        :param 'BridgeOutputResourceBridgeNetworkOutputProtocol' protocol: The network output protocol.
        :param int ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> str:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeOutputResourceBridgeNetworkOutputProtocol':
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BridgeSource(dict):
    """
    The bridge's source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowSource":
            suggest = "flow_source"
        elif key == "networkSource":
            suggest = "network_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_source: Optional['outputs.BridgeFlowSource'] = None,
                 network_source: Optional['outputs.BridgeNetworkSource'] = None):
        """
        The bridge's source.
        """
        if flow_source is not None:
            pulumi.set(__self__, "flow_source", flow_source)
        if network_source is not None:
            pulumi.set(__self__, "network_source", network_source)

    @property
    @pulumi.getter(name="flowSource")
    def flow_source(self) -> Optional['outputs.BridgeFlowSource']:
        return pulumi.get(self, "flow_source")

    @property
    @pulumi.getter(name="networkSource")
    def network_source(self) -> Optional['outputs.BridgeNetworkSource']:
        return pulumi.get(self, "network_source")


@pulumi.output_type
class BridgeSourceBridgeFlowSource(dict):
    """
    The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowArn":
            suggest = "flow_arn"
        elif key == "flowVpcInterfaceAttachment":
            suggest = "flow_vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceBridgeFlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceBridgeFlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceBridgeFlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_arn: str,
                 flow_vpc_interface_attachment: Optional['outputs.BridgeSourceVpcInterfaceAttachment'] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param str flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param 'BridgeSourceVpcInterfaceAttachment' flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> str:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional['outputs.BridgeSourceVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")


@pulumi.output_type
class BridgeSourceBridgeNetworkSource(dict):
    """
    The source of the bridge. A network source originates at your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multicastIp":
            suggest = "multicast_ip"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceBridgeNetworkSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceBridgeNetworkSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceBridgeNetworkSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multicast_ip: str,
                 network_name: str,
                 port: int,
                 protocol: 'BridgeSourceProtocolEnum'):
        """
        The source of the bridge. A network source originates at your premises.
        :param str multicast_ip: The network source multicast IP.
        :param str network_name: The network source's gateway network name.
        :param int port: The network source port.
        :param 'BridgeSourceProtocolEnum' protocol: The network source protocol.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> str:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> str:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeSourceProtocolEnum':
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class BridgeSourcePriority(dict):
    """
    The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarySource":
            suggest = "primary_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourcePriority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourcePriority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourcePriority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_source: Optional[str] = None):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param str primary_source: The name of the source you choose as the primary source for this flow.
        """
        if primary_source is not None:
            pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> Optional[str]:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")


@pulumi.output_type
class BridgeSourceVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class BridgeVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 algorithm: Optional['FlowEncryptionAlgorithm'] = None,
                 constant_initialization_vector: Optional[str] = None,
                 device_id: Optional[str] = None,
                 key_type: Optional['FlowEncryptionKeyType'] = None,
                 region: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 secret_arn: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Information about the encryption of the flow.
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param 'FlowEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowEntitlementEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEntitlementEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEntitlementEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEntitlementEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: 'FlowEntitlementEncryptionAlgorithm',
                 role_arn: str,
                 constant_initialization_vector: Optional[str] = None,
                 device_id: Optional[str] = None,
                 key_type: Optional['FlowEntitlementEncryptionKeyType'] = None,
                 region: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 secret_arn: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Information about the encryption of the flow.
        :param 'FlowEntitlementEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowEntitlementEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> 'FlowEntitlementEncryptionAlgorithm':
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowEntitlementEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowFailoverConfig(dict):
    """
    The settings for source failover
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverMode":
            suggest = "failover_mode"
        elif key == "recoveryWindow":
            suggest = "recovery_window"
        elif key == "sourcePriority":
            suggest = "source_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFailoverConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFailoverConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFailoverConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_mode: Optional['FlowFailoverConfigFailoverMode'] = None,
                 recovery_window: Optional[int] = None,
                 source_priority: Optional['outputs.FlowFailoverConfigSourcePriorityProperties'] = None,
                 state: Optional['FlowFailoverConfigState'] = None):
        """
        The settings for source failover
        :param 'FlowFailoverConfigFailoverMode' failover_mode: The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        :param int recovery_window: Search window time to look for dash-7 packets
        :param 'FlowFailoverConfigSourcePriorityProperties' source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        if failover_mode is not None:
            pulumi.set(__self__, "failover_mode", failover_mode)
        if recovery_window is not None:
            pulumi.set(__self__, "recovery_window", recovery_window)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> Optional['FlowFailoverConfigFailoverMode']:
        """
        The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @property
    @pulumi.getter(name="recoveryWindow")
    def recovery_window(self) -> Optional[int]:
        """
        Search window time to look for dash-7 packets
        """
        return pulumi.get(self, "recovery_window")

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional['outputs.FlowFailoverConfigSourcePriorityProperties']:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @property
    @pulumi.getter
    def state(self) -> Optional['FlowFailoverConfigState']:
        return pulumi.get(self, "state")


@pulumi.output_type
class FlowFailoverConfigSourcePriorityProperties(dict):
    """
    The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarySource":
            suggest = "primary_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFailoverConfigSourcePriorityProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFailoverConfigSourcePriorityProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFailoverConfigSourcePriorityProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_source: str):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param str primary_source: The name of the source you choose as the primary source for this flow.
        """
        pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> str:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")


@pulumi.output_type
class FlowGatewayBridgeSource(dict):
    """
    The source configuration for cloud flows receiving a stream from a bridge.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bridgeArn":
            suggest = "bridge_arn"
        elif key == "vpcInterfaceAttachment":
            suggest = "vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowGatewayBridgeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowGatewayBridgeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowGatewayBridgeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bridge_arn: str,
                 vpc_interface_attachment: Optional['outputs.FlowVpcInterfaceAttachment'] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param str bridge_arn: The ARN of the bridge feeding this flow.
        :param 'FlowVpcInterfaceAttachment' vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> str:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional['outputs.FlowVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")


@pulumi.output_type
class FlowOutputEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 secret_arn: str,
                 algorithm: Optional['FlowOutputEncryptionAlgorithm'] = None,
                 key_type: Optional['FlowOutputEncryptionKeyType'] = None):
        """
        Information about the encryption of the flow.
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param 'FlowOutputEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param 'FlowOutputEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> str:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowOutputEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowOutputEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")


@pulumi.output_type
class FlowOutputVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[str] = None):
        """
        The settings for attaching a VPC interface to an output.
        :param str vpc_interface_name: The name of the VPC interface to use for this output.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC interface to use for this output.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowSource(dict):
    """
    The settings for the source of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entitlementArn":
            suggest = "entitlement_arn"
        elif key == "gatewayBridgeSource":
            suggest = "gateway_bridge_source"
        elif key == "ingestIp":
            suggest = "ingest_ip"
        elif key == "ingestPort":
            suggest = "ingest_port"
        elif key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "maxLatency":
            suggest = "max_latency"
        elif key == "minLatency":
            suggest = "min_latency"
        elif key == "senderControlPort":
            suggest = "sender_control_port"
        elif key == "senderIpAddress":
            suggest = "sender_ip_address"
        elif key == "sourceArn":
            suggest = "source_arn"
        elif key == "sourceIngestPort":
            suggest = "source_ingest_port"
        elif key == "sourceListenerAddress":
            suggest = "source_listener_address"
        elif key == "sourceListenerPort":
            suggest = "source_listener_port"
        elif key == "streamId":
            suggest = "stream_id"
        elif key == "vpcInterfaceName":
            suggest = "vpc_interface_name"
        elif key == "whitelistCidr":
            suggest = "whitelist_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decryption: Optional['outputs.FlowEncryption'] = None,
                 description: Optional[str] = None,
                 entitlement_arn: Optional[str] = None,
                 gateway_bridge_source: Optional['outputs.FlowGatewayBridgeSource'] = None,
                 ingest_ip: Optional[str] = None,
                 ingest_port: Optional[int] = None,
                 max_bitrate: Optional[int] = None,
                 max_latency: Optional[int] = None,
                 min_latency: Optional[int] = None,
                 name: Optional[str] = None,
                 protocol: Optional['FlowSourceProtocol'] = None,
                 sender_control_port: Optional[int] = None,
                 sender_ip_address: Optional[str] = None,
                 source_arn: Optional[str] = None,
                 source_ingest_port: Optional[str] = None,
                 source_listener_address: Optional[str] = None,
                 source_listener_port: Optional[int] = None,
                 stream_id: Optional[str] = None,
                 vpc_interface_name: Optional[str] = None,
                 whitelist_cidr: Optional[str] = None):
        """
        The settings for the source of the flow.
        :param 'FlowEncryption' decryption: The type of decryption that is used on the content ingested from this source.
        :param str description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param str entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param 'FlowGatewayBridgeSource' gateway_bridge_source: The source configuration for cloud flows receiving a stream from a bridge.
        :param str ingest_ip: The IP address that the flow will be listening on for incoming content.
        :param int ingest_port: The port that the flow will be listening on for incoming content.
        :param int max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param int max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param int min_latency: The minimum latency in milliseconds.
        :param str name: The name of the source.
        :param 'FlowSourceProtocol' protocol: The protocol that is used by the source.
        :param int sender_control_port: The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        :param str sender_ip_address: The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        :param str source_arn: The ARN of the source.
        :param str source_ingest_port: The port that the flow will be listening on for incoming content.(ReadOnly)
        :param str source_listener_address: Source IP or domain name for SRT-caller protocol.
        :param int source_listener_port: Source port for SRT-caller protocol.
        :param str stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param str vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param str whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if gateway_bridge_source is not None:
            pulumi.set(__self__, "gateway_bridge_source", gateway_bridge_source)
        if ingest_ip is not None:
            pulumi.set(__self__, "ingest_ip", ingest_ip)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if min_latency is not None:
            pulumi.set(__self__, "min_latency", min_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sender_control_port is not None:
            pulumi.set(__self__, "sender_control_port", sender_control_port)
        if sender_ip_address is not None:
            pulumi.set(__self__, "sender_ip_address", sender_ip_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if source_ingest_port is not None:
            pulumi.set(__self__, "source_ingest_port", source_ingest_port)
        if source_listener_address is not None:
            pulumi.set(__self__, "source_listener_address", source_listener_address)
        if source_listener_port is not None:
            pulumi.set(__self__, "source_listener_port", source_listener_port)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def decryption(self) -> Optional['outputs.FlowEncryption']:
        """
        The type of decryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[str]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @property
    @pulumi.getter(name="gatewayBridgeSource")
    def gateway_bridge_source(self) -> Optional['outputs.FlowGatewayBridgeSource']:
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        return pulumi.get(self, "gateway_bridge_source")

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> Optional[str]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[int]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[int]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[int]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> Optional[int]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['FlowSourceProtocol']:
        """
        The protocol that is used by the source.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="senderControlPort")
    def sender_control_port(self) -> Optional[int]:
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_control_port")

    @property
    @pulumi.getter(name="senderIpAddress")
    def sender_ip_address(self) -> Optional[str]:
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_ip_address")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[str]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceIngestPort")
    def source_ingest_port(self) -> Optional[str]:
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        return pulumi.get(self, "source_ingest_port")

    @property
    @pulumi.getter(name="sourceListenerAddress")
    def source_listener_address(self) -> Optional[str]:
        """
        Source IP or domain name for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_address")

    @property
    @pulumi.getter(name="sourceListenerPort")
    def source_listener_port(self) -> Optional[int]:
        """
        Source port for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_port")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[str]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[str]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")


@pulumi.output_type
class FlowSourceEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 algorithm: Optional['FlowSourceEncryptionAlgorithm'] = None,
                 constant_initialization_vector: Optional[str] = None,
                 device_id: Optional[str] = None,
                 key_type: Optional['FlowSourceEncryptionKeyType'] = None,
                 region: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 secret_arn: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Information about the encryption of the flow.
        :param str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param 'FlowSourceEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowSourceEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowSourceEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowSourceEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowSourceGatewayBridgeSource(dict):
    """
    The source configuration for cloud flows receiving a stream from a bridge.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bridgeArn":
            suggest = "bridge_arn"
        elif key == "vpcInterfaceAttachment":
            suggest = "vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceGatewayBridgeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceGatewayBridgeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceGatewayBridgeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bridge_arn: str,
                 vpc_interface_attachment: Optional['outputs.FlowSourceVpcInterfaceAttachment'] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param str bridge_arn: The ARN of the bridge feeding this flow.
        :param 'FlowSourceVpcInterfaceAttachment' vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> str:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional['outputs.FlowSourceVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")


@pulumi.output_type
class FlowSourceVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class GatewayNetwork(dict):
    """
    The network settings for a gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: str,
                 name: str):
        """
        The network settings for a gateway.
        :param str cidr_block: A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        :param str name: The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        return pulumi.get(self, "name")


