# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetGatewayResult',
    'AwaitableGetGatewayResult',
    'get_gateway',
    'get_gateway_output',
]

@pulumi.output_type
class GetGatewayResult:
    def __init__(__self__, gateway_arn=None, gateway_state=None):
        if gateway_arn and not isinstance(gateway_arn, str):
            raise TypeError("Expected argument 'gateway_arn' to be a str")
        pulumi.set(__self__, "gateway_arn", gateway_arn)
        if gateway_state and not isinstance(gateway_state, str):
            raise TypeError("Expected argument 'gateway_state' to be a str")
        pulumi.set(__self__, "gateway_state", gateway_state)

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @property
    @pulumi.getter(name="gatewayState")
    def gateway_state(self) -> Optional['GatewayState']:
        """
        The current status of the gateway.
        """
        return pulumi.get(self, "gateway_state")


class AwaitableGetGatewayResult(GetGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayResult(
            gateway_arn=self.gateway_arn,
            gateway_state=self.gateway_state)


def get_gateway(gateway_arn: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayResult:
    """
    Resource schema for AWS::MediaConnect::Gateway


    :param str gateway_arn: The Amazon Resource Name (ARN) of the gateway.
    """
    __args__ = dict()
    __args__['gatewayArn'] = gateway_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:mediaconnect:getGateway', __args__, opts=opts, typ=GetGatewayResult).value

    return AwaitableGetGatewayResult(
        gateway_arn=pulumi.get(__ret__, 'gateway_arn'),
        gateway_state=pulumi.get(__ret__, 'gateway_state'))


@_utilities.lift_output_func(get_gateway)
def get_gateway_output(gateway_arn: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayResult]:
    """
    Resource schema for AWS::MediaConnect::Gateway


    :param str gateway_arn: The Amazon Resource Name (ARN) of the gateway.
    """
    ...
