# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'BridgeEgressGatewayBridgeArgs',
    'BridgeFailoverConfigArgs',
    'BridgeFlowSourceArgs',
    'BridgeIngressGatewayBridgeArgs',
    'BridgeNetworkOutputArgs',
    'BridgeNetworkSourceArgs',
    'BridgeOutputResourceBridgeNetworkOutputArgs',
    'BridgeOutputArgs',
    'BridgeSourceBridgeFlowSourceArgs',
    'BridgeSourceBridgeNetworkSourceArgs',
    'BridgeSourcePriorityArgs',
    'BridgeSourceVpcInterfaceAttachmentArgs',
    'BridgeSourceArgs',
    'BridgeVpcInterfaceAttachmentArgs',
    'FlowEncryptionArgs',
    'FlowEntitlementEncryptionArgs',
    'FlowFailoverConfigSourcePriorityPropertiesArgs',
    'FlowFailoverConfigArgs',
    'FlowGatewayBridgeSourceArgs',
    'FlowOutputEncryptionArgs',
    'FlowOutputVpcInterfaceAttachmentArgs',
    'FlowSourceEncryptionArgs',
    'FlowSourceGatewayBridgeSourceArgs',
    'FlowSourceVpcInterfaceAttachmentArgs',
    'FlowSourceArgs',
    'FlowVpcInterfaceAttachmentArgs',
    'GatewayNetworkArgs',
]

@pulumi.input_type
class BridgeEgressGatewayBridgeArgs:
    def __init__(__self__, *,
                 max_bitrate: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_bitrate: The maximum expected bitrate of the egress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> pulumi.Input[int]:
        """
        The maximum expected bitrate of the egress bridge.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_bitrate", value)


@pulumi.input_type
class BridgeFailoverConfigArgs:
    def __init__(__self__, *,
                 failover_mode: pulumi.Input['BridgeFailoverModeEnum'],
                 source_priority: Optional[pulumi.Input['BridgeSourcePriorityArgs']] = None,
                 state: Optional[pulumi.Input['BridgeFailoverConfigStateEnum']] = None):
        """
        The settings for source failover.
        :param pulumi.Input['BridgeFailoverModeEnum'] failover_mode: The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        :param pulumi.Input['BridgeSourcePriorityArgs'] source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        pulumi.set(__self__, "failover_mode", failover_mode)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> pulumi.Input['BridgeFailoverModeEnum']:
        """
        The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @failover_mode.setter
    def failover_mode(self, value: pulumi.Input['BridgeFailoverModeEnum']):
        pulumi.set(self, "failover_mode", value)

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional[pulumi.Input['BridgeSourcePriorityArgs']]:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @source_priority.setter
    def source_priority(self, value: Optional[pulumi.Input['BridgeSourcePriorityArgs']]):
        pulumi.set(self, "source_priority", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['BridgeFailoverConfigStateEnum']]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['BridgeFailoverConfigStateEnum']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class BridgeFlowSourceArgs:
    def __init__(__self__, *,
                 flow_arn: pulumi.Input[str],
                 name: pulumi.Input[str],
                 flow_vpc_interface_attachment: Optional[pulumi.Input['BridgeVpcInterfaceAttachmentArgs']] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param pulumi.Input[str] flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param pulumi.Input[str] name: The name of the flow source.
        :param pulumi.Input['BridgeVpcInterfaceAttachmentArgs'] flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        pulumi.set(__self__, "name", name)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the flow source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional[pulumi.Input['BridgeVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")

    @flow_vpc_interface_attachment.setter
    def flow_vpc_interface_attachment(self, value: Optional[pulumi.Input['BridgeVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "flow_vpc_interface_attachment", value)


@pulumi.input_type
class BridgeIngressGatewayBridgeArgs:
    def __init__(__self__, *,
                 max_bitrate: pulumi.Input[int],
                 max_outputs: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_bitrate: The maximum expected bitrate of the ingress bridge.
        :param pulumi.Input[int] max_outputs: The maximum number of outputs on the ingress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)
        pulumi.set(__self__, "max_outputs", max_outputs)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> pulumi.Input[int]:
        """
        The maximum expected bitrate of the ingress bridge.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter(name="maxOutputs")
    def max_outputs(self) -> pulumi.Input[int]:
        """
        The maximum number of outputs on the ingress bridge.
        """
        return pulumi.get(self, "max_outputs")

    @max_outputs.setter
    def max_outputs(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_outputs", value)


@pulumi.input_type
class BridgeNetworkOutputArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeProtocolEnum'],
                 ttl: pulumi.Input[int]):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param pulumi.Input[str] ip_address: The network output IP Address.
        :param pulumi.Input[str] name: The network output name.
        :param pulumi.Input[str] network_name: The network output's gateway network name.
        :param pulumi.Input[int] port: The network output port.
        :param pulumi.Input['BridgeProtocolEnum'] protocol: The network output protocol.
        :param pulumi.Input[int] ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The network output name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeProtocolEnum']:
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeProtocolEnum']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[int]:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class BridgeNetworkSourceArgs:
    def __init__(__self__, *,
                 multicast_ip: pulumi.Input[str],
                 name: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeProtocolEnum']):
        """
        The source of the bridge. A network source originates at your premises.
        :param pulumi.Input[str] multicast_ip: The network source multicast IP.
        :param pulumi.Input[str] name: The name of the network source.
        :param pulumi.Input[str] network_name: The network source's gateway network name.
        :param pulumi.Input[int] port: The network source port.
        :param pulumi.Input['BridgeProtocolEnum'] protocol: The network source protocol.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> pulumi.Input[str]:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @multicast_ip.setter
    def multicast_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "multicast_ip", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the network source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeProtocolEnum']:
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeProtocolEnum']):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class BridgeOutputResourceBridgeNetworkOutputArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol'],
                 ttl: pulumi.Input[int]):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param pulumi.Input[str] ip_address: The network output IP Address.
        :param pulumi.Input[str] network_name: The network output's gateway network name.
        :param pulumi.Input[int] port: The network output port.
        :param pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol'] protocol: The network output protocol.
        :param pulumi.Input[int] ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol']:
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[int]:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class BridgeOutputArgs:
    def __init__(__self__, *,
                 network_output: Optional[pulumi.Input['BridgeNetworkOutputArgs']] = None):
        """
        The output of the bridge.
        """
        if network_output is not None:
            pulumi.set(__self__, "network_output", network_output)

    @property
    @pulumi.getter(name="networkOutput")
    def network_output(self) -> Optional[pulumi.Input['BridgeNetworkOutputArgs']]:
        return pulumi.get(self, "network_output")

    @network_output.setter
    def network_output(self, value: Optional[pulumi.Input['BridgeNetworkOutputArgs']]):
        pulumi.set(self, "network_output", value)


@pulumi.input_type
class BridgeSourceBridgeFlowSourceArgs:
    def __init__(__self__, *,
                 flow_arn: pulumi.Input[str],
                 flow_vpc_interface_attachment: Optional[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs']] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param pulumi.Input[str] flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs'] flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")

    @flow_vpc_interface_attachment.setter
    def flow_vpc_interface_attachment(self, value: Optional[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "flow_vpc_interface_attachment", value)


@pulumi.input_type
class BridgeSourceBridgeNetworkSourceArgs:
    def __init__(__self__, *,
                 multicast_ip: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeSourceProtocolEnum']):
        """
        The source of the bridge. A network source originates at your premises.
        :param pulumi.Input[str] multicast_ip: The network source multicast IP.
        :param pulumi.Input[str] network_name: The network source's gateway network name.
        :param pulumi.Input[int] port: The network source port.
        :param pulumi.Input['BridgeSourceProtocolEnum'] protocol: The network source protocol.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> pulumi.Input[str]:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @multicast_ip.setter
    def multicast_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "multicast_ip", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeSourceProtocolEnum']:
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeSourceProtocolEnum']):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class BridgeSourcePriorityArgs:
    def __init__(__self__, *,
                 primary_source: Optional[pulumi.Input[str]] = None):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param pulumi.Input[str] primary_source: The name of the source you choose as the primary source for this flow.
        """
        if primary_source is not None:
            pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")

    @primary_source.setter
    def primary_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_source", value)


@pulumi.input_type
class BridgeSourceVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


@pulumi.input_type
class BridgeSourceArgs:
    def __init__(__self__, *,
                 flow_source: Optional[pulumi.Input['BridgeFlowSourceArgs']] = None,
                 network_source: Optional[pulumi.Input['BridgeNetworkSourceArgs']] = None):
        """
        The bridge's source.
        """
        if flow_source is not None:
            pulumi.set(__self__, "flow_source", flow_source)
        if network_source is not None:
            pulumi.set(__self__, "network_source", network_source)

    @property
    @pulumi.getter(name="flowSource")
    def flow_source(self) -> Optional[pulumi.Input['BridgeFlowSourceArgs']]:
        return pulumi.get(self, "flow_source")

    @flow_source.setter
    def flow_source(self, value: Optional[pulumi.Input['BridgeFlowSourceArgs']]):
        pulumi.set(self, "flow_source", value)

    @property
    @pulumi.getter(name="networkSource")
    def network_source(self) -> Optional[pulumi.Input['BridgeNetworkSourceArgs']]:
        return pulumi.get(self, "network_source")

    @network_source.setter
    def network_source(self, value: Optional[pulumi.Input['BridgeNetworkSourceArgs']]):
        pulumi.set(self, "network_source", value)


@pulumi.input_type
class BridgeVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


@pulumi.input_type
class FlowEncryptionArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 algorithm: Optional[pulumi.Input['FlowEncryptionAlgorithm']] = None,
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input['FlowEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['FlowEncryptionAlgorithm']]:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['FlowEncryptionAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FlowEntitlementEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['FlowEntitlementEncryptionAlgorithm'],
                 role_arn: pulumi.Input[str],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input['FlowEntitlementEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowEntitlementEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['FlowEntitlementEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['FlowEntitlementEncryptionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FlowFailoverConfigSourcePriorityPropertiesArgs:
    def __init__(__self__, *,
                 primary_source: pulumi.Input[str]):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param pulumi.Input[str] primary_source: The name of the source you choose as the primary source for this flow.
        """
        pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> pulumi.Input[str]:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")

    @primary_source.setter
    def primary_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_source", value)


@pulumi.input_type
class FlowFailoverConfigArgs:
    def __init__(__self__, *,
                 failover_mode: Optional[pulumi.Input['FlowFailoverConfigFailoverMode']] = None,
                 recovery_window: Optional[pulumi.Input[int]] = None,
                 source_priority: Optional[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs']] = None,
                 state: Optional[pulumi.Input['FlowFailoverConfigState']] = None):
        """
        The settings for source failover
        :param pulumi.Input['FlowFailoverConfigFailoverMode'] failover_mode: The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        :param pulumi.Input[int] recovery_window: Search window time to look for dash-7 packets
        :param pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs'] source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        if failover_mode is not None:
            pulumi.set(__self__, "failover_mode", failover_mode)
        if recovery_window is not None:
            pulumi.set(__self__, "recovery_window", recovery_window)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> Optional[pulumi.Input['FlowFailoverConfigFailoverMode']]:
        """
        The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @failover_mode.setter
    def failover_mode(self, value: Optional[pulumi.Input['FlowFailoverConfigFailoverMode']]):
        pulumi.set(self, "failover_mode", value)

    @property
    @pulumi.getter(name="recoveryWindow")
    def recovery_window(self) -> Optional[pulumi.Input[int]]:
        """
        Search window time to look for dash-7 packets
        """
        return pulumi.get(self, "recovery_window")

    @recovery_window.setter
    def recovery_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_window", value)

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs']]:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @source_priority.setter
    def source_priority(self, value: Optional[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs']]):
        pulumi.set(self, "source_priority", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['FlowFailoverConfigState']]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['FlowFailoverConfigState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class FlowGatewayBridgeSourceArgs:
    def __init__(__self__, *,
                 bridge_arn: pulumi.Input[str],
                 vpc_interface_attachment: Optional[pulumi.Input['FlowVpcInterfaceAttachmentArgs']] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[str] bridge_arn: The ARN of the bridge feeding this flow.
        :param pulumi.Input['FlowVpcInterfaceAttachmentArgs'] vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @bridge_arn.setter
    def bridge_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bridge_arn", value)

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional[pulumi.Input['FlowVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")

    @vpc_interface_attachment.setter
    def vpc_interface_attachment(self, value: Optional[pulumi.Input['FlowVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "vpc_interface_attachment", value)


@pulumi.input_type
class FlowOutputEncryptionArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 secret_arn: pulumi.Input[str],
                 algorithm: Optional[pulumi.Input['FlowOutputEncryptionAlgorithm']] = None,
                 key_type: Optional[pulumi.Input['FlowOutputEncryptionKeyType']] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input['FlowOutputEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input['FlowOutputEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Input[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['FlowOutputEncryptionAlgorithm']]:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['FlowOutputEncryptionAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowOutputEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowOutputEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)


@pulumi.input_type
class FlowOutputVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an output.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this output.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this output.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


@pulumi.input_type
class FlowSourceEncryptionArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 algorithm: Optional[pulumi.Input['FlowSourceEncryptionAlgorithm']] = None,
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowSourceEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input['FlowSourceEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowSourceEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['FlowSourceEncryptionAlgorithm']]:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['FlowSourceEncryptionAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowSourceEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowSourceEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FlowSourceGatewayBridgeSourceArgs:
    def __init__(__self__, *,
                 bridge_arn: pulumi.Input[str],
                 vpc_interface_attachment: Optional[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs']] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[str] bridge_arn: The ARN of the bridge feeding this flow.
        :param pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs'] vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @bridge_arn.setter
    def bridge_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bridge_arn", value)

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")

    @vpc_interface_attachment.setter
    def vpc_interface_attachment(self, value: Optional[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "vpc_interface_attachment", value)


@pulumi.input_type
class FlowSourceVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


@pulumi.input_type
class FlowSourceArgs:
    def __init__(__self__, *,
                 decryption: Optional[pulumi.Input['FlowEncryptionArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entitlement_arn: Optional[pulumi.Input[str]] = None,
                 gateway_bridge_source: Optional[pulumi.Input['FlowGatewayBridgeSourceArgs']] = None,
                 ingest_ip: Optional[pulumi.Input[str]] = None,
                 ingest_port: Optional[pulumi.Input[int]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 max_latency: Optional[pulumi.Input[int]] = None,
                 min_latency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['FlowSourceProtocol']] = None,
                 sender_control_port: Optional[pulumi.Input[int]] = None,
                 sender_ip_address: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 source_ingest_port: Optional[pulumi.Input[str]] = None,
                 source_listener_address: Optional[pulumi.Input[str]] = None,
                 source_listener_port: Optional[pulumi.Input[int]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None,
                 whitelist_cidr: Optional[pulumi.Input[str]] = None):
        """
        The settings for the source of the flow.
        :param pulumi.Input['FlowEncryptionArgs'] decryption: The type of decryption that is used on the content ingested from this source.
        :param pulumi.Input[str] description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param pulumi.Input[str] entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param pulumi.Input['FlowGatewayBridgeSourceArgs'] gateway_bridge_source: The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[str] ingest_ip: The IP address that the flow will be listening on for incoming content.
        :param pulumi.Input[int] ingest_port: The port that the flow will be listening on for incoming content.
        :param pulumi.Input[int] max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param pulumi.Input[int] max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param pulumi.Input[int] min_latency: The minimum latency in milliseconds.
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input['FlowSourceProtocol'] protocol: The protocol that is used by the source.
        :param pulumi.Input[int] sender_control_port: The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] sender_ip_address: The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] source_arn: The ARN of the source.
        :param pulumi.Input[str] source_ingest_port: The port that the flow will be listening on for incoming content.(ReadOnly)
        :param pulumi.Input[str] source_listener_address: Source IP or domain name for SRT-caller protocol.
        :param pulumi.Input[int] source_listener_port: Source port for SRT-caller protocol.
        :param pulumi.Input[str] stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param pulumi.Input[str] whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if gateway_bridge_source is not None:
            pulumi.set(__self__, "gateway_bridge_source", gateway_bridge_source)
        if ingest_ip is not None:
            pulumi.set(__self__, "ingest_ip", ingest_ip)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if min_latency is not None:
            pulumi.set(__self__, "min_latency", min_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sender_control_port is not None:
            pulumi.set(__self__, "sender_control_port", sender_control_port)
        if sender_ip_address is not None:
            pulumi.set(__self__, "sender_ip_address", sender_ip_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if source_ingest_port is not None:
            pulumi.set(__self__, "source_ingest_port", source_ingest_port)
        if source_listener_address is not None:
            pulumi.set(__self__, "source_listener_address", source_listener_address)
        if source_listener_port is not None:
            pulumi.set(__self__, "source_listener_port", source_listener_port)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def decryption(self) -> Optional[pulumi.Input['FlowEncryptionArgs']]:
        """
        The type of decryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @decryption.setter
    def decryption(self, value: Optional[pulumi.Input['FlowEncryptionArgs']]):
        pulumi.set(self, "decryption", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @entitlement_arn.setter
    def entitlement_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entitlement_arn", value)

    @property
    @pulumi.getter(name="gatewayBridgeSource")
    def gateway_bridge_source(self) -> Optional[pulumi.Input['FlowGatewayBridgeSourceArgs']]:
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        return pulumi.get(self, "gateway_bridge_source")

    @gateway_bridge_source.setter
    def gateway_bridge_source(self, value: Optional[pulumi.Input['FlowGatewayBridgeSourceArgs']]):
        pulumi.set(self, "gateway_bridge_source", value)

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @ingest_ip.setter
    def ingest_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_ip", value)

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @ingest_port.setter
    def ingest_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingest_port", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @max_latency.setter
    def max_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_latency", value)

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @min_latency.setter
    def min_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_latency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['FlowSourceProtocol']]:
        """
        The protocol that is used by the source.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['FlowSourceProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="senderControlPort")
    def sender_control_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_control_port")

    @sender_control_port.setter
    def sender_control_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sender_control_port", value)

    @property
    @pulumi.getter(name="senderIpAddress")
    def sender_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_ip_address")

    @sender_ip_address.setter
    def sender_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_ip_address", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="sourceIngestPort")
    def source_ingest_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        return pulumi.get(self, "source_ingest_port")

    @source_ingest_port.setter
    def source_ingest_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ingest_port", value)

    @property
    @pulumi.getter(name="sourceListenerAddress")
    def source_listener_address(self) -> Optional[pulumi.Input[str]]:
        """
        Source IP or domain name for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_address")

    @source_listener_address.setter
    def source_listener_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_listener_address", value)

    @property
    @pulumi.getter(name="sourceListenerPort")
    def source_listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        Source port for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_port")

    @source_listener_port.setter
    def source_listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_listener_port", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")

    @whitelist_cidr.setter
    def whitelist_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_cidr", value)


@pulumi.input_type
class FlowVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


@pulumi.input_type
class GatewayNetworkArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        The network settings for a gateway.
        :param pulumi.Input[str] cidr_block: A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        :param pulumi.Input[str] name: The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[str]:
        """
        A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


