# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetSubscriptionFilterResult',
    'AwaitableGetSubscriptionFilterResult',
    'get_subscription_filter',
    'get_subscription_filter_output',
]

@pulumi.output_type
class GetSubscriptionFilterResult:
    def __init__(__self__, destination_arn=None, distribution=None, filter_pattern=None, role_arn=None):
        if destination_arn and not isinstance(destination_arn, str):
            raise TypeError("Expected argument 'destination_arn' to be a str")
        pulumi.set(__self__, "destination_arn", destination_arn)
        if distribution and not isinstance(distribution, str):
            raise TypeError("Expected argument 'distribution' to be a str")
        pulumi.set(__self__, "distribution", distribution)
        if filter_pattern and not isinstance(filter_pattern, str):
            raise TypeError("Expected argument 'filter_pattern' to be a str")
        pulumi.set(__self__, "filter_pattern", filter_pattern)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the destination.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter
    def distribution(self) -> Optional['SubscriptionFilterDistribution']:
        """
        The method used to distribute log data to the destination, which can be either random or grouped by log stream.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="filterPattern")
    def filter_pattern(self) -> Optional[str]:
        """
        The filtering expressions that restrict what gets delivered to the destination AWS resource. For more information about the filter pattern syntax, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        """
        return pulumi.get(self, "filter_pattern")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of an IAM role that grants CWL permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
        """
        return pulumi.get(self, "role_arn")


class AwaitableGetSubscriptionFilterResult(GetSubscriptionFilterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionFilterResult(
            destination_arn=self.destination_arn,
            distribution=self.distribution,
            filter_pattern=self.filter_pattern,
            role_arn=self.role_arn)


def get_subscription_filter(filter_name: Optional[str] = None,
                            log_group_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionFilterResult:
    """
    The ``AWS::Logs::SubscriptionFilter`` resource specifies a subscription filter and associates it with the specified log group. Subscription filters allow you to subscribe to a real-time stream of log events and have them delivered to a specific destination. Currently, the supported destinations are:
      +  An Amazon Kinesis data stream belonging to the same account as the subscription filter, for same-account delivery.
      +  A logical destination that belongs to a different account, for cross-account delivery.
      +  An Amazon Kinesis Firehose delivery stream that belongs to the same account as the subscription filter, for same-account delivery.
      +  An LAMlong function that belongs to the same account as the subscription filter, for same-account delivery.

     There can be as many as two subscription filters associated with a log group.


    :param str filter_name: The name of the subscription filter.
    :param str log_group_name: The log group to associate with the subscription filter. All log events that are uploaded to this log group are filtered and delivered to the specified AWS resource if the filter pattern matches the log events.
    """
    __args__ = dict()
    __args__['filterName'] = filter_name
    __args__['logGroupName'] = log_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:logs:getSubscriptionFilter', __args__, opts=opts, typ=GetSubscriptionFilterResult).value

    return AwaitableGetSubscriptionFilterResult(
        destination_arn=pulumi.get(__ret__, 'destination_arn'),
        distribution=pulumi.get(__ret__, 'distribution'),
        filter_pattern=pulumi.get(__ret__, 'filter_pattern'),
        role_arn=pulumi.get(__ret__, 'role_arn'))


@_utilities.lift_output_func(get_subscription_filter)
def get_subscription_filter_output(filter_name: Optional[pulumi.Input[str]] = None,
                                   log_group_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionFilterResult]:
    """
    The ``AWS::Logs::SubscriptionFilter`` resource specifies a subscription filter and associates it with the specified log group. Subscription filters allow you to subscribe to a real-time stream of log events and have them delivered to a specific destination. Currently, the supported destinations are:
      +  An Amazon Kinesis data stream belonging to the same account as the subscription filter, for same-account delivery.
      +  A logical destination that belongs to a different account, for cross-account delivery.
      +  An Amazon Kinesis Firehose delivery stream that belongs to the same account as the subscription filter, for same-account delivery.
      +  An LAMlong function that belongs to the same account as the subscription filter, for same-account delivery.

     There can be as many as two subscription filters associated with a log group.


    :param str filter_name: The name of the subscription filter.
    :param str log_group_name: The log group to associate with the subscription filter. All log events that are uploaded to this log group are filtered and delivered to the specified AWS resource if the filter pattern matches the log events.
    """
    ...
