# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAlarmResult',
    'AwaitableGetAlarmResult',
    'get_alarm',
    'get_alarm_output',
]

@pulumi.output_type
class GetAlarmResult:
    def __init__(__self__, alarm_arn=None, comparison_operator=None, contact_protocols=None, datapoints_to_alarm=None, evaluation_periods=None, notification_enabled=None, notification_triggers=None, state=None, threshold=None, treat_missing_data=None):
        if alarm_arn and not isinstance(alarm_arn, str):
            raise TypeError("Expected argument 'alarm_arn' to be a str")
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        if comparison_operator and not isinstance(comparison_operator, str):
            raise TypeError("Expected argument 'comparison_operator' to be a str")
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        if contact_protocols and not isinstance(contact_protocols, list):
            raise TypeError("Expected argument 'contact_protocols' to be a list")
        pulumi.set(__self__, "contact_protocols", contact_protocols)
        if datapoints_to_alarm and not isinstance(datapoints_to_alarm, int):
            raise TypeError("Expected argument 'datapoints_to_alarm' to be a int")
        pulumi.set(__self__, "datapoints_to_alarm", datapoints_to_alarm)
        if evaluation_periods and not isinstance(evaluation_periods, int):
            raise TypeError("Expected argument 'evaluation_periods' to be a int")
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if notification_enabled and not isinstance(notification_enabled, bool):
            raise TypeError("Expected argument 'notification_enabled' to be a bool")
        pulumi.set(__self__, "notification_enabled", notification_enabled)
        if notification_triggers and not isinstance(notification_triggers, list):
            raise TypeError("Expected argument 'notification_triggers' to be a list")
        pulumi.set(__self__, "notification_triggers", notification_triggers)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if threshold and not isinstance(threshold, float):
            raise TypeError("Expected argument 'threshold' to be a float")
        pulumi.set(__self__, "threshold", threshold)
        if treat_missing_data and not isinstance(treat_missing_data, str):
            raise TypeError("Expected argument 'treat_missing_data' to be a str")
        pulumi.set(__self__, "treat_missing_data", treat_missing_data)

    @property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> Optional[str]:
        return pulumi.get(self, "alarm_arn")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[str]:
        """
        The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="contactProtocols")
    def contact_protocols(self) -> Optional[Sequence[str]]:
        """
        The contact protocols to use for the alarm, such as Email, SMS (text messaging), or both.
        """
        return pulumi.get(self, "contact_protocols")

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> Optional[int]:
        """
        The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (datapointsToAlarm) is the M.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods) is the N.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="notificationEnabled")
    def notification_enabled(self) -> Optional[bool]:
        """
        Indicates whether the alarm is enabled. Notifications are enabled by default if you don't specify this parameter.
        """
        return pulumi.get(self, "notification_enabled")

    @property
    @pulumi.getter(name="notificationTriggers")
    def notification_triggers(self) -> Optional[Sequence[str]]:
        """
        The alarm states that trigger a notification.
        """
        return pulumi.get(self, "notification_triggers")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the alarm.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The value against which the specified statistic is compared.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> Optional[str]:
        """
        Sets how this alarm will handle missing data points.
        """
        return pulumi.get(self, "treat_missing_data")


class AwaitableGetAlarmResult(GetAlarmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmResult(
            alarm_arn=self.alarm_arn,
            comparison_operator=self.comparison_operator,
            contact_protocols=self.contact_protocols,
            datapoints_to_alarm=self.datapoints_to_alarm,
            evaluation_periods=self.evaluation_periods,
            notification_enabled=self.notification_enabled,
            notification_triggers=self.notification_triggers,
            state=self.state,
            threshold=self.threshold,
            treat_missing_data=self.treat_missing_data)


def get_alarm(alarm_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmResult:
    """
    Resource Type definition for AWS::Lightsail::Alarm


    :param str alarm_name: The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
    """
    __args__ = dict()
    __args__['alarmName'] = alarm_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lightsail:getAlarm', __args__, opts=opts, typ=GetAlarmResult).value

    return AwaitableGetAlarmResult(
        alarm_arn=pulumi.get(__ret__, 'alarm_arn'),
        comparison_operator=pulumi.get(__ret__, 'comparison_operator'),
        contact_protocols=pulumi.get(__ret__, 'contact_protocols'),
        datapoints_to_alarm=pulumi.get(__ret__, 'datapoints_to_alarm'),
        evaluation_periods=pulumi.get(__ret__, 'evaluation_periods'),
        notification_enabled=pulumi.get(__ret__, 'notification_enabled'),
        notification_triggers=pulumi.get(__ret__, 'notification_triggers'),
        state=pulumi.get(__ret__, 'state'),
        threshold=pulumi.get(__ret__, 'threshold'),
        treat_missing_data=pulumi.get(__ret__, 'treat_missing_data'))


@_utilities.lift_output_func(get_alarm)
def get_alarm_output(alarm_name: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlarmResult]:
    """
    Resource Type definition for AWS::Lightsail::Alarm


    :param str alarm_name: The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
    """
    ...
