# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'BucketAccessRulesArgs',
    'ContainerEnvironmentVariableArgs',
    'ContainerHealthCheckConfigArgs',
    'ContainerPortInfoArgs',
    'ContainerPrivateRegistryAccessEcrImagePullerRolePropertiesArgs',
    'ContainerPrivateRegistryAccessArgs',
    'ContainerPublicDomainNameArgs',
    'ContainerPublicEndpointArgs',
    'ContainerServiceDeploymentArgs',
    'ContainerArgs',
    'DatabaseRelationalDatabaseParameterArgs',
    'DiskAddOnArgs',
    'DiskAutoSnapshotAddOnArgs',
    'DiskLocationArgs',
    'InstanceAddOnArgs',
    'InstanceAutoSnapshotAddOnArgs',
    'InstanceDiskArgs',
    'InstanceHardwareArgs',
    'InstanceLocationArgs',
    'InstanceMonthlyTransferArgs',
    'InstanceNetworkingArgs',
    'InstancePortArgs',
    'InstanceStateArgs',
]

@pulumi.input_type
class BucketAccessRulesArgs:
    def __init__(__self__, *,
                 allow_public_overrides: Optional[pulumi.Input[bool]] = None,
                 get_object: Optional[pulumi.Input[str]] = None):
        """
        An object that sets the public accessibility of objects in the specified bucket.
        :param pulumi.Input[bool] allow_public_overrides: A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the getObject option that is currently specified.
        :param pulumi.Input[str] get_object: Specifies the anonymous access to all objects in a bucket.
        """
        if allow_public_overrides is not None:
            pulumi.set(__self__, "allow_public_overrides", allow_public_overrides)
        if get_object is not None:
            pulumi.set(__self__, "get_object", get_object)

    @property
    @pulumi.getter(name="allowPublicOverrides")
    def allow_public_overrides(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the getObject option that is currently specified.
        """
        return pulumi.get(self, "allow_public_overrides")

    @allow_public_overrides.setter
    def allow_public_overrides(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_public_overrides", value)

    @property
    @pulumi.getter(name="getObject")
    def get_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the anonymous access to all objects in a bucket.
        """
        return pulumi.get(self, "get_object")

    @get_object.setter
    def get_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "get_object", value)


@pulumi.input_type
class ContainerEnvironmentVariableArgs:
    def __init__(__self__, *,
                 value: Optional[pulumi.Input[str]] = None,
                 variable: Optional[pulumi.Input[str]] = None):
        if value is not None:
            pulumi.set(__self__, "value", value)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def variable(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "variable")

    @variable.setter
    def variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "variable", value)


@pulumi.input_type
class ContainerHealthCheckConfigArgs:
    def __init__(__self__, *,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 interval_seconds: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 success_codes: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        Describes the health check configuration of an Amazon Lightsail container service.
        :param pulumi.Input[int] healthy_threshold: The number of consecutive health checks successes required before moving the container to the Healthy state. The default value is 2.
        :param pulumi.Input[int] interval_seconds: The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is 5.
        :param pulumi.Input[str] path: The path on the container on which to perform the health check. The default value is /.
        :param pulumi.Input[str] success_codes: The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. You can specify multiple values (for example, 200,202) or a range of values (for example, 200-299).
        :param pulumi.Input[int] timeout_seconds: The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is 2.
        :param pulumi.Input[int] unhealthy_threshold: The number of consecutive health check failures required before moving the container to the Unhealthy state. The default value is 2.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_codes is not None:
            pulumi.set(__self__, "success_codes", success_codes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive health checks successes required before moving the container to the Healthy state. The default value is 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is 5.
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_seconds", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path on the container on which to perform the health check. The default value is /.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="successCodes")
    def success_codes(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. You can specify multiple values (for example, 200,202) or a range of values (for example, 200-299).
        """
        return pulumi.get(self, "success_codes")

    @success_codes.setter
    def success_codes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "success_codes", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is 2.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive health check failures required before moving the container to the Unhealthy state. The default value is 2.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class ContainerPortInfoArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ContainerPrivateRegistryAccessEcrImagePullerRolePropertiesArgs:
    def __init__(__self__, *,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 principal_arn: Optional[pulumi.Input[str]] = None):
        """
        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
        :param pulumi.Input[bool] is_active: A Boolean value that indicates whether to activate the role.
        :param pulumi.Input[str] principal_arn: The Amazon Resource Name (ARN) of the role, if it is activated.
        """
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean value that indicates whether to activate the role.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the role, if it is activated.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_arn", value)


@pulumi.input_type
class ContainerPrivateRegistryAccessArgs:
    def __init__(__self__, *,
                 ecr_image_puller_role: Optional[pulumi.Input['ContainerPrivateRegistryAccessEcrImagePullerRolePropertiesArgs']] = None):
        """
        An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
        :param pulumi.Input['ContainerPrivateRegistryAccessEcrImagePullerRolePropertiesArgs'] ecr_image_puller_role: An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
        """
        if ecr_image_puller_role is not None:
            pulumi.set(__self__, "ecr_image_puller_role", ecr_image_puller_role)

    @property
    @pulumi.getter(name="ecrImagePullerRole")
    def ecr_image_puller_role(self) -> Optional[pulumi.Input['ContainerPrivateRegistryAccessEcrImagePullerRolePropertiesArgs']]:
        """
        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
        """
        return pulumi.get(self, "ecr_image_puller_role")

    @ecr_image_puller_role.setter
    def ecr_image_puller_role(self, value: Optional[pulumi.Input['ContainerPrivateRegistryAccessEcrImagePullerRolePropertiesArgs']]):
        pulumi.set(self, "ecr_image_puller_role", value)


@pulumi.input_type
class ContainerPublicDomainNameArgs:
    def __init__(__self__, *,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The public domain name to use with the container service, such as example.com and www.example.com.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_names: An object that describes the configuration for the containers of the deployment.
        """
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An object that describes the configuration for the containers of the deployment.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_names", value)


@pulumi.input_type
class ContainerPublicEndpointArgs:
    def __init__(__self__, *,
                 container_name: Optional[pulumi.Input[str]] = None,
                 container_port: Optional[pulumi.Input[int]] = None,
                 health_check_config: Optional[pulumi.Input['ContainerHealthCheckConfigArgs']] = None):
        """
        Describes the settings of a public endpoint for an Amazon Lightsail container service.
        :param pulumi.Input[str] container_name: The name of the container for the endpoint.
        :param pulumi.Input[int] container_port: The port of the container to which traffic is forwarded to.
        :param pulumi.Input['ContainerHealthCheckConfigArgs'] health_check_config: An object that describes the health check configuration of the container.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container for the endpoint.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of the container to which traffic is forwarded to.
        """
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ContainerHealthCheckConfigArgs']]:
        """
        An object that describes the health check configuration of the container.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ContainerHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)


@pulumi.input_type
class ContainerServiceDeploymentArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]] = None,
                 public_endpoint: Optional[pulumi.Input['ContainerPublicEndpointArgs']] = None):
        """
        Describes a container deployment configuration of an Amazon Lightsail container service.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]] containers: An object that describes the configuration for the containers of the deployment.
        :param pulumi.Input['ContainerPublicEndpointArgs'] public_endpoint: An object that describes the endpoint of the deployment.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]:
        """
        An object that describes the configuration for the containers of the deployment.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input['ContainerPublicEndpointArgs']]:
        """
        An object that describes the endpoint of the deployment.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input['ContainerPublicEndpointArgs']]):
        pulumi.set(self, "public_endpoint", value)


@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerEnvironmentVariableArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortInfoArgs']]]] = None):
        """
        Describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: The launch command for the container.
        :param pulumi.Input[str] container_name: The name of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerEnvironmentVariableArgs']]] environment: The environment variables of the container.
        :param pulumi.Input[str] image: The name of the image used for the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerPortInfoArgs']]] ports: The open firewall ports of the container.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The launch command for the container.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerEnvironmentVariableArgs']]]]:
        """
        The environment variables of the container.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image used for the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortInfoArgs']]]]:
        """
        The open firewall ports of the container.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortInfoArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class DatabaseRelationalDatabaseParameterArgs:
    def __init__(__self__, *,
                 allowed_values: Optional[pulumi.Input[str]] = None,
                 apply_method: Optional[pulumi.Input[str]] = None,
                 apply_type: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_modifiable: Optional[pulumi.Input[bool]] = None,
                 parameter_name: Optional[pulumi.Input[str]] = None,
                 parameter_value: Optional[pulumi.Input[str]] = None):
        """
        Describes the parameters of the database.
        :param pulumi.Input[str] allowed_values: Specifies the valid range of values for the parameter.
        :param pulumi.Input[str] apply_method: Indicates when parameter updates are applied. Can be immediate or pending-reboot.
        :param pulumi.Input[str] apply_type: Specifies the engine-specific parameter type.
        :param pulumi.Input[str] data_type: Specifies the valid data type for the parameter.
        :param pulumi.Input[str] description: Provides a description of the parameter.
        :param pulumi.Input[bool] is_modifiable: A Boolean value indicating whether the parameter can be modified.
        :param pulumi.Input[str] parameter_name: Specifies the name of the parameter.
        :param pulumi.Input[str] parameter_value: Specifies the value of the parameter.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)
        if apply_type is not None:
            pulumi.set(__self__, "apply_type", apply_type)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_modifiable is not None:
            pulumi.set(__self__, "is_modifiable", is_modifiable)
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the valid range of values for the parameter.
        """
        return pulumi.get(self, "allowed_values")

    @allowed_values.setter
    def allowed_values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_values", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates when parameter updates are applied. Can be immediate or pending-reboot.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apply_method", value)

    @property
    @pulumi.getter(name="applyType")
    def apply_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the engine-specific parameter type.
        """
        return pulumi.get(self, "apply_type")

    @apply_type.setter
    def apply_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apply_type", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the valid data type for the parameter.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Provides a description of the parameter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isModifiable")
    def is_modifiable(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean value indicating whether the parameter can be modified.
        """
        return pulumi.get(self, "is_modifiable")

    @is_modifiable.setter
    def is_modifiable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_modifiable", value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the value of the parameter.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_value", value)


@pulumi.input_type
class DiskAddOnArgs:
    def __init__(__self__, *,
                 add_on_type: pulumi.Input[str],
                 auto_snapshot_add_on_request: Optional[pulumi.Input['DiskAutoSnapshotAddOnArgs']] = None,
                 status: Optional[pulumi.Input['DiskAddOnStatus']] = None):
        """
        A addon associate with a resource.
        :param pulumi.Input[str] add_on_type: The add-on type
        :param pulumi.Input['DiskAddOnStatus'] status: Status of the Addon
        """
        pulumi.set(__self__, "add_on_type", add_on_type)
        if auto_snapshot_add_on_request is not None:
            pulumi.set(__self__, "auto_snapshot_add_on_request", auto_snapshot_add_on_request)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="addOnType")
    def add_on_type(self) -> pulumi.Input[str]:
        """
        The add-on type
        """
        return pulumi.get(self, "add_on_type")

    @add_on_type.setter
    def add_on_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "add_on_type", value)

    @property
    @pulumi.getter(name="autoSnapshotAddOnRequest")
    def auto_snapshot_add_on_request(self) -> Optional[pulumi.Input['DiskAutoSnapshotAddOnArgs']]:
        return pulumi.get(self, "auto_snapshot_add_on_request")

    @auto_snapshot_add_on_request.setter
    def auto_snapshot_add_on_request(self, value: Optional[pulumi.Input['DiskAutoSnapshotAddOnArgs']]):
        pulumi.set(self, "auto_snapshot_add_on_request", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['DiskAddOnStatus']]:
        """
        Status of the Addon
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['DiskAddOnStatus']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class DiskAutoSnapshotAddOnArgs:
    def __init__(__self__, *,
                 snapshot_time_of_day: Optional[pulumi.Input[str]] = None):
        """
        An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
        :param pulumi.Input[str] snapshot_time_of_day: The daily time when an automatic snapshot will be created.
        """
        if snapshot_time_of_day is not None:
            pulumi.set(__self__, "snapshot_time_of_day", snapshot_time_of_day)

    @property
    @pulumi.getter(name="snapshotTimeOfDay")
    def snapshot_time_of_day(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "snapshot_time_of_day")

    @snapshot_time_of_day.setter
    def snapshot_time_of_day(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_time_of_day", value)


@pulumi.input_type
class DiskLocationArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 region_name: Optional[pulumi.Input[str]] = None):
        """
        Location of a resource.
        :param pulumi.Input[str] availability_zone: The Availability Zone in which to create your disk. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        :param pulumi.Input[str] region_name: The Region Name in which to create your disk.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone in which to create your disk. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Region Name in which to create your disk.
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_name", value)


@pulumi.input_type
class InstanceAddOnArgs:
    def __init__(__self__, *,
                 add_on_type: pulumi.Input[str],
                 auto_snapshot_add_on_request: Optional[pulumi.Input['InstanceAutoSnapshotAddOnArgs']] = None,
                 status: Optional[pulumi.Input['InstanceAddOnStatus']] = None):
        """
        A addon associate with a resource.
        :param pulumi.Input[str] add_on_type: The add-on type
        :param pulumi.Input['InstanceAddOnStatus'] status: Status of the Addon
        """
        pulumi.set(__self__, "add_on_type", add_on_type)
        if auto_snapshot_add_on_request is not None:
            pulumi.set(__self__, "auto_snapshot_add_on_request", auto_snapshot_add_on_request)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="addOnType")
    def add_on_type(self) -> pulumi.Input[str]:
        """
        The add-on type
        """
        return pulumi.get(self, "add_on_type")

    @add_on_type.setter
    def add_on_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "add_on_type", value)

    @property
    @pulumi.getter(name="autoSnapshotAddOnRequest")
    def auto_snapshot_add_on_request(self) -> Optional[pulumi.Input['InstanceAutoSnapshotAddOnArgs']]:
        return pulumi.get(self, "auto_snapshot_add_on_request")

    @auto_snapshot_add_on_request.setter
    def auto_snapshot_add_on_request(self, value: Optional[pulumi.Input['InstanceAutoSnapshotAddOnArgs']]):
        pulumi.set(self, "auto_snapshot_add_on_request", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['InstanceAddOnStatus']]:
        """
        Status of the Addon
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['InstanceAddOnStatus']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class InstanceAutoSnapshotAddOnArgs:
    def __init__(__self__, *,
                 snapshot_time_of_day: Optional[pulumi.Input[str]] = None):
        """
        An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
        :param pulumi.Input[str] snapshot_time_of_day: The daily time when an automatic snapshot will be created.
        """
        if snapshot_time_of_day is not None:
            pulumi.set(__self__, "snapshot_time_of_day", snapshot_time_of_day)

    @property
    @pulumi.getter(name="snapshotTimeOfDay")
    def snapshot_time_of_day(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "snapshot_time_of_day")

    @snapshot_time_of_day.setter
    def snapshot_time_of_day(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_time_of_day", value)


@pulumi.input_type
class InstanceDiskArgs:
    def __init__(__self__, *,
                 disk_name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 attached_to: Optional[pulumi.Input[str]] = None,
                 attachment_state: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 is_system_disk: Optional[pulumi.Input[bool]] = None,
                 size_in_gb: Optional[pulumi.Input[str]] = None):
        """
        Disk associated with the Instance.
        :param pulumi.Input[str] disk_name: The names to use for your new Lightsail disk.
        :param pulumi.Input[str] path: Path of the disk attached to the instance.
        :param pulumi.Input[str] attached_to: Instance attached to the disk.
        :param pulumi.Input[str] attachment_state: Attachment state of the disk.
        :param pulumi.Input[int] iops: IOPS of disk.
        :param pulumi.Input[bool] is_system_disk: Is the Attached disk is the system disk of the Instance.
        :param pulumi.Input[str] size_in_gb: Size of the disk attached to the Instance.
        """
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "path", path)
        if attached_to is not None:
            pulumi.set(__self__, "attached_to", attached_to)
        if attachment_state is not None:
            pulumi.set(__self__, "attachment_state", attachment_state)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if is_system_disk is not None:
            pulumi.set(__self__, "is_system_disk", is_system_disk)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> pulumi.Input[str]:
        """
        The names to use for your new Lightsail disk.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path of the disk attached to the instance.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="attachedTo")
    def attached_to(self) -> Optional[pulumi.Input[str]]:
        """
        Instance attached to the disk.
        """
        return pulumi.get(self, "attached_to")

    @attached_to.setter
    def attached_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attached_to", value)

    @property
    @pulumi.getter(name="attachmentState")
    def attachment_state(self) -> Optional[pulumi.Input[str]]:
        """
        Attachment state of the disk.
        """
        return pulumi.get(self, "attachment_state")

    @attachment_state.setter
    def attachment_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_state", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        IOPS of disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="isSystemDisk")
    def is_system_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the Attached disk is the system disk of the Instance.
        """
        return pulumi.get(self, "is_system_disk")

    @is_system_disk.setter
    def is_system_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_system_disk", value)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the disk attached to the Instance.
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class InstanceHardwareArgs:
    def __init__(__self__, *,
                 cpu_count: Optional[pulumi.Input[int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]] = None,
                 ram_size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Hardware of the Instance.
        :param pulumi.Input[int] cpu_count: CPU count of the Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]] disks: Disks attached to the Instance.
        :param pulumi.Input[int] ram_size_in_gb: RAM Size of the Instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if ram_size_in_gb is not None:
            pulumi.set(__self__, "ram_size_in_gb", ram_size_in_gb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        CPU count of the Instance.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_count", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]]:
        """
        Disks attached to the Instance.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="ramSizeInGb")
    def ram_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        RAM Size of the Instance.
        """
        return pulumi.get(self, "ram_size_in_gb")

    @ram_size_in_gb.setter
    def ram_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ram_size_in_gb", value)


@pulumi.input_type
class InstanceLocationArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 region_name: Optional[pulumi.Input[str]] = None):
        """
        Location of a resource.
        :param pulumi.Input[str] availability_zone: The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        :param pulumi.Input[str] region_name: The Region Name in which to create your instance.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Region Name in which to create your instance.
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_name", value)


@pulumi.input_type
class InstanceMonthlyTransferArgs:
    def __init__(__self__, *,
                 gb_per_month_allocated: Optional[pulumi.Input[str]] = None):
        """
        Monthly Transfer of the Instance.
        :param pulumi.Input[str] gb_per_month_allocated: GbPerMonthAllocated of the Instance.
        """
        if gb_per_month_allocated is not None:
            pulumi.set(__self__, "gb_per_month_allocated", gb_per_month_allocated)

    @property
    @pulumi.getter(name="gbPerMonthAllocated")
    def gb_per_month_allocated(self) -> Optional[pulumi.Input[str]]:
        """
        GbPerMonthAllocated of the Instance.
        """
        return pulumi.get(self, "gb_per_month_allocated")

    @gb_per_month_allocated.setter
    def gb_per_month_allocated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gb_per_month_allocated", value)


@pulumi.input_type
class InstanceNetworkingArgs:
    def __init__(__self__, *,
                 ports: pulumi.Input[Sequence[pulumi.Input['InstancePortArgs']]],
                 monthly_transfer: Optional[pulumi.Input['InstanceMonthlyTransferArgs']] = None):
        """
        Networking of the Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePortArgs']]] ports: Ports to the Instance.
        """
        pulumi.set(__self__, "ports", ports)
        if monthly_transfer is not None:
            pulumi.set(__self__, "monthly_transfer", monthly_transfer)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['InstancePortArgs']]]:
        """
        Ports to the Instance.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['InstancePortArgs']]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="monthlyTransfer")
    def monthly_transfer(self) -> Optional[pulumi.Input['InstanceMonthlyTransferArgs']]:
        return pulumi.get(self, "monthly_transfer")

    @monthly_transfer.setter
    def monthly_transfer(self, value: Optional[pulumi.Input['InstanceMonthlyTransferArgs']]):
        pulumi.set(self, "monthly_transfer", value)


@pulumi.input_type
class InstancePortArgs:
    def __init__(__self__, *,
                 access_direction: Optional[pulumi.Input[str]] = None,
                 access_from: Optional[pulumi.Input[str]] = None,
                 access_type: Optional[pulumi.Input[str]] = None,
                 cidr_list_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 from_port: Optional[pulumi.Input[int]] = None,
                 ipv6_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 to_port: Optional[pulumi.Input[int]] = None):
        """
        Port of the Instance.
        :param pulumi.Input[str] access_direction: Access Direction for Protocol of the Instance(inbound/outbound).
        :param pulumi.Input[str] access_from: Access From Protocol of the Instance.
        :param pulumi.Input[str] access_type: Access Type Protocol of the Instance.
        :param pulumi.Input[str] common_name: CommonName for Protocol of the Instance.
        :param pulumi.Input[int] from_port: From Port of the Instance.
        :param pulumi.Input[str] protocol: Port Protocol of the Instance.
        :param pulumi.Input[int] to_port: To Port of the Instance.
        """
        if access_direction is not None:
            pulumi.set(__self__, "access_direction", access_direction)
        if access_from is not None:
            pulumi.set(__self__, "access_from", access_from)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if cidr_list_aliases is not None:
            pulumi.set(__self__, "cidr_list_aliases", cidr_list_aliases)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="accessDirection")
    def access_direction(self) -> Optional[pulumi.Input[str]]:
        """
        Access Direction for Protocol of the Instance(inbound/outbound).
        """
        return pulumi.get(self, "access_direction")

    @access_direction.setter
    def access_direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_direction", value)

    @property
    @pulumi.getter(name="accessFrom")
    def access_from(self) -> Optional[pulumi.Input[str]]:
        """
        Access From Protocol of the Instance.
        """
        return pulumi.get(self, "access_from")

    @access_from.setter
    def access_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_from", value)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[str]]:
        """
        Access Type Protocol of the Instance.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter(name="cidrListAliases")
    def cidr_list_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "cidr_list_aliases")

    @cidr_list_aliases.setter
    def cidr_list_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidr_list_aliases", value)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidrs", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        CommonName for Protocol of the Instance.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[pulumi.Input[int]]:
        """
        From Port of the Instance.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "ipv6_cidrs")

    @ipv6_cidrs.setter
    def ipv6_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_cidrs", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Port Protocol of the Instance.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[pulumi.Input[int]]:
        """
        To Port of the Instance.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "to_port", value)


@pulumi.input_type
class InstanceStateArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Current State of the Instance.
        :param pulumi.Input[int] code: Status code of the Instance.
        :param pulumi.Input[str] name: Status code of the Instance.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        Status code of the Instance.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Status code of the Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


