# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasProvisionedConcurrencyConfiguration',
    'AliasRoutingConfiguration',
    'AliasVersionWeight',
    'CodeSigningConfigAllowedPublishers',
    'CodeSigningConfigCodeSigningPolicies',
    'EventInvokeConfigDestinationConfig',
    'EventInvokeConfigOnFailure',
    'EventInvokeConfigOnSuccess',
    'EventSourceMappingAmazonManagedKafkaEventSourceConfig',
    'EventSourceMappingDestinationConfig',
    'EventSourceMappingDocumentDbEventSourceConfig',
    'EventSourceMappingEndpoints',
    'EventSourceMappingFilter',
    'EventSourceMappingFilterCriteria',
    'EventSourceMappingOnFailure',
    'EventSourceMappingScalingConfig',
    'EventSourceMappingSelfManagedEventSource',
    'EventSourceMappingSelfManagedKafkaEventSourceConfig',
    'EventSourceMappingSourceAccessConfiguration',
    'FunctionCode',
    'FunctionDeadLetterConfig',
    'FunctionEnvironment',
    'FunctionEphemeralStorage',
    'FunctionFileSystemConfig',
    'FunctionImageConfig',
    'FunctionLoggingConfig',
    'FunctionRuntimeManagementConfig',
    'FunctionSnapStart',
    'FunctionSnapStartResponse',
    'FunctionTracingConfig',
    'FunctionVpcConfig',
    'LayerVersionContent',
    'UrlCors',
    'VersionProvisionedConcurrencyConfiguration',
    'VersionRuntimePolicy',
]

@pulumi.output_type
class AliasProvisionedConcurrencyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedConcurrentExecutions":
            suggest = "provisioned_concurrent_executions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasProvisionedConcurrencyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasProvisionedConcurrencyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasProvisionedConcurrencyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_concurrent_executions: int):
        pulumi.set(__self__, "provisioned_concurrent_executions", provisioned_concurrent_executions)

    @property
    @pulumi.getter(name="provisionedConcurrentExecutions")
    def provisioned_concurrent_executions(self) -> int:
        return pulumi.get(self, "provisioned_concurrent_executions")


@pulumi.output_type
class AliasRoutingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalVersionWeights":
            suggest = "additional_version_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_version_weights: Sequence['outputs.AliasVersionWeight']):
        pulumi.set(__self__, "additional_version_weights", additional_version_weights)

    @property
    @pulumi.getter(name="additionalVersionWeights")
    def additional_version_weights(self) -> Sequence['outputs.AliasVersionWeight']:
        return pulumi.get(self, "additional_version_weights")


@pulumi.output_type
class AliasVersionWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionVersion":
            suggest = "function_version"
        elif key == "functionWeight":
            suggest = "function_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasVersionWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasVersionWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasVersionWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_version: str,
                 function_weight: float):
        pulumi.set(__self__, "function_version", function_version)
        pulumi.set(__self__, "function_weight", function_weight)

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> str:
        return pulumi.get(self, "function_version")

    @property
    @pulumi.getter(name="functionWeight")
    def function_weight(self) -> float:
        return pulumi.get(self, "function_weight")


@pulumi.output_type
class CodeSigningConfigAllowedPublishers(dict):
    """
    When the CodeSigningConfig is later on attached to a function, the function code will be expected to be signed by profiles from this list
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingProfileVersionArns":
            suggest = "signing_profile_version_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeSigningConfigAllowedPublishers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeSigningConfigAllowedPublishers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeSigningConfigAllowedPublishers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_profile_version_arns: Sequence[str]):
        """
        When the CodeSigningConfig is later on attached to a function, the function code will be expected to be signed by profiles from this list
        :param Sequence[str] signing_profile_version_arns: List of Signing profile version Arns
        """
        pulumi.set(__self__, "signing_profile_version_arns", signing_profile_version_arns)

    @property
    @pulumi.getter(name="signingProfileVersionArns")
    def signing_profile_version_arns(self) -> Sequence[str]:
        """
        List of Signing profile version Arns
        """
        return pulumi.get(self, "signing_profile_version_arns")


@pulumi.output_type
class CodeSigningConfigCodeSigningPolicies(dict):
    """
    Policies to control how to act if a signature is invalid
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "untrustedArtifactOnDeployment":
            suggest = "untrusted_artifact_on_deployment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeSigningConfigCodeSigningPolicies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeSigningConfigCodeSigningPolicies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeSigningConfigCodeSigningPolicies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 untrusted_artifact_on_deployment: 'CodeSigningConfigCodeSigningPoliciesUntrustedArtifactOnDeployment'):
        """
        Policies to control how to act if a signature is invalid
        :param 'CodeSigningConfigCodeSigningPoliciesUntrustedArtifactOnDeployment' untrusted_artifact_on_deployment: Indicates how Lambda operations involve updating the code artifact will operate. Default to Warn if not provided
        """
        pulumi.set(__self__, "untrusted_artifact_on_deployment", untrusted_artifact_on_deployment)

    @property
    @pulumi.getter(name="untrustedArtifactOnDeployment")
    def untrusted_artifact_on_deployment(self) -> 'CodeSigningConfigCodeSigningPoliciesUntrustedArtifactOnDeployment':
        """
        Indicates how Lambda operations involve updating the code artifact will operate. Default to Warn if not provided
        """
        return pulumi.get(self, "untrusted_artifact_on_deployment")


@pulumi.output_type
class EventInvokeConfigDestinationConfig(dict):
    """
    A destination for events after they have been sent to a function for processing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"
        elif key == "onSuccess":
            suggest = "on_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventInvokeConfigDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventInvokeConfigDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventInvokeConfigDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.EventInvokeConfigOnFailure'] = None,
                 on_success: Optional['outputs.EventInvokeConfigOnSuccess'] = None):
        """
        A destination for events after they have been sent to a function for processing.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.EventInvokeConfigOnFailure']:
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional['outputs.EventInvokeConfigOnSuccess']:
        return pulumi.get(self, "on_success")


@pulumi.output_type
class EventInvokeConfigOnFailure(dict):
    """
    The destination configuration for failed invocations.
    """
    def __init__(__self__, *,
                 destination: str):
        """
        The destination configuration for failed invocations.
        :param str destination: The Amazon Resource Name (ARN) of the destination resource.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The Amazon Resource Name (ARN) of the destination resource.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class EventInvokeConfigOnSuccess(dict):
    """
    The destination configuration for successful invocations.
    """
    def __init__(__self__, *,
                 destination: str):
        """
        The destination configuration for successful invocations.
        :param str destination: The Amazon Resource Name (ARN) of the destination resource.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The Amazon Resource Name (ARN) of the destination resource.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class EventSourceMappingAmazonManagedKafkaEventSourceConfig(dict):
    """
    Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupId":
            suggest = "consumer_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingAmazonManagedKafkaEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingAmazonManagedKafkaEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingAmazonManagedKafkaEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_id: Optional[str] = None):
        """
        Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
        :param str consumer_group_id: The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. For more information, see [Customizable consumer group ID](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id).
        """
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[str]:
        """
        The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. For more information, see [Customizable consumer group ID](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id).
        """
        return pulumi.get(self, "consumer_group_id")


@pulumi.output_type
class EventSourceMappingDestinationConfig(dict):
    """
    A configuration object that specifies the destination of an event after Lambda processes it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.EventSourceMappingOnFailure'] = None):
        """
        A configuration object that specifies the destination of an event after Lambda processes it.
        :param 'EventSourceMappingOnFailure' on_failure: The destination configuration for failed invocations.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.EventSourceMappingOnFailure']:
        """
        The destination configuration for failed invocations.
        """
        return pulumi.get(self, "on_failure")


@pulumi.output_type
class EventSourceMappingDocumentDbEventSourceConfig(dict):
    """
    Specific configuration settings for a DocumentDB event source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionName":
            suggest = "collection_name"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fullDocument":
            suggest = "full_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDocumentDbEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDocumentDbEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDocumentDbEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_name: Optional[str] = None,
                 database_name: Optional[str] = None,
                 full_document: Optional['EventSourceMappingDocumentDbEventSourceConfigFullDocument'] = None):
        """
        Specific configuration settings for a DocumentDB event source.
        :param str collection_name: The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
        :param str database_name: The name of the database to consume within the DocumentDB cluster.
        :param 'EventSourceMappingDocumentDbEventSourceConfigFullDocument' full_document: Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes.
        """
        if collection_name is not None:
            pulumi.set(__self__, "collection_name", collection_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if full_document is not None:
            pulumi.set(__self__, "full_document", full_document)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Optional[str]:
        """
        The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The name of the database to consume within the DocumentDB cluster.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fullDocument")
    def full_document(self) -> Optional['EventSourceMappingDocumentDbEventSourceConfigFullDocument']:
        """
        Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes.
        """
        return pulumi.get(self, "full_document")


@pulumi.output_type
class EventSourceMappingEndpoints(dict):
    """
    The list of bootstrap servers for your Kafka brokers in the following format: ``"KafkaBootstrapServers": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kafkaBootstrapServers":
            suggest = "kafka_bootstrap_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingEndpoints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingEndpoints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingEndpoints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kafka_bootstrap_servers: Optional[Sequence[str]] = None):
        """
        The list of bootstrap servers for your Kafka brokers in the following format: ``"KafkaBootstrapServers": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]``.
        :param Sequence[str] kafka_bootstrap_servers: The list of bootstrap servers for your Kafka brokers in the following format: ``"KafkaBootstrapServers": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]``.
        """
        if kafka_bootstrap_servers is not None:
            pulumi.set(__self__, "kafka_bootstrap_servers", kafka_bootstrap_servers)

    @property
    @pulumi.getter(name="kafkaBootstrapServers")
    def kafka_bootstrap_servers(self) -> Optional[Sequence[str]]:
        """
        The list of bootstrap servers for your Kafka brokers in the following format: ``"KafkaBootstrapServers": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]``.
        """
        return pulumi.get(self, "kafka_bootstrap_servers")


@pulumi.output_type
class EventSourceMappingFilter(dict):
    """
    A structure within a ``FilterCriteria`` object that defines an event filtering pattern.
    """
    def __init__(__self__, *,
                 pattern: Optional[str] = None):
        """
        A structure within a ``FilterCriteria`` object that defines an event filtering pattern.
        :param str pattern: A filter pattern. For more information on the syntax of a filter pattern, see [Filter rule syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
        """
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        A filter pattern. For more information on the syntax of a filter pattern, see [Filter rule syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class EventSourceMappingFilterCriteria(dict):
    """
    An object that contains the filters for an event source.
    """
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.EventSourceMappingFilter']] = None):
        """
        An object that contains the filters for an event source.
        :param Sequence['EventSourceMappingFilter'] filters: A list of filters.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.EventSourceMappingFilter']]:
        """
        A list of filters.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class EventSourceMappingOnFailure(dict):
    """
    A destination for events that failed processing.
    """
    def __init__(__self__, *,
                 destination: Optional[str] = None):
        """
        A destination for events that failed processing.
        :param str destination: The Amazon Resource Name (ARN) of the destination resource.
                To retain records of [asynchronous invocations](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations), you can configure an Amazon SNS topic, Amazon SQS queue, Lambda function, or Amazon EventBridge event bus as the destination.
                To retain records of failed invocations from [Kinesis and DynamoDB event sources](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#event-source-mapping-destinations), you can configure an Amazon SNS topic or Amazon SQS queue as the destination.
                To retain records of failed invocations from [self-managed Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-smaa-onfailure-destination) or [Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-onfailure-destination), you can configure an Amazon SNS topic, Amazon SQS queue, or Amazon S3 bucket as the destination.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the destination resource.
         To retain records of [asynchronous invocations](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations), you can configure an Amazon SNS topic, Amazon SQS queue, Lambda function, or Amazon EventBridge event bus as the destination.
         To retain records of failed invocations from [Kinesis and DynamoDB event sources](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#event-source-mapping-destinations), you can configure an Amazon SNS topic or Amazon SQS queue as the destination.
         To retain records of failed invocations from [self-managed Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-smaa-onfailure-destination) or [Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-onfailure-destination), you can configure an Amazon SNS topic, Amazon SQS queue, or Amazon S3 bucket as the destination.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class EventSourceMappingScalingConfig(dict):
    """
    (Amazon SQS only) The scaling configuration for the event source. To remove the configuration, pass an empty value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumConcurrency":
            suggest = "maximum_concurrency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_concurrency: Optional[int] = None):
        """
        (Amazon SQS only) The scaling configuration for the event source. To remove the configuration, pass an empty value.
        :param int maximum_concurrency: Limits the number of concurrent instances that the SQS event source can invoke.
        """
        if maximum_concurrency is not None:
            pulumi.set(__self__, "maximum_concurrency", maximum_concurrency)

    @property
    @pulumi.getter(name="maximumConcurrency")
    def maximum_concurrency(self) -> Optional[int]:
        """
        Limits the number of concurrent instances that the SQS event source can invoke.
        """
        return pulumi.get(self, "maximum_concurrency")


@pulumi.output_type
class EventSourceMappingSelfManagedEventSource(dict):
    """
    The self-managed Apache Kafka cluster for your event source.
    """
    def __init__(__self__, *,
                 endpoints: Optional['outputs.EventSourceMappingEndpoints'] = None):
        """
        The self-managed Apache Kafka cluster for your event source.
        :param 'EventSourceMappingEndpoints' endpoints: The list of bootstrap servers for your Kafka brokers in the following format: ``"KafkaBootstrapServers": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]``.
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional['outputs.EventSourceMappingEndpoints']:
        """
        The list of bootstrap servers for your Kafka brokers in the following format: ``"KafkaBootstrapServers": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]``.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class EventSourceMappingSelfManagedKafkaEventSourceConfig(dict):
    """
    Specific configuration settings for a self-managed Apache Kafka event source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupId":
            suggest = "consumer_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingSelfManagedKafkaEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingSelfManagedKafkaEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingSelfManagedKafkaEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_id: Optional[str] = None):
        """
        Specific configuration settings for a self-managed Apache Kafka event source.
        :param str consumer_group_id: The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. For more information, see [Customizable consumer group ID](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id).
        """
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[str]:
        """
        The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value. For more information, see [Customizable consumer group ID](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id).
        """
        return pulumi.get(self, "consumer_group_id")


@pulumi.output_type
class EventSourceMappingSourceAccessConfiguration(dict):
    """
    An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
    """
    def __init__(__self__, *,
                 type: Optional['EventSourceMappingSourceAccessConfigurationType'] = None,
                 uri: Optional[str] = None):
        """
        An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
        :param 'EventSourceMappingSourceAccessConfigurationType' type: The type of authentication protocol, VPC components, or virtual host for your event source. For example: ``"Type":"SASL_SCRAM_512_AUTH"``.
                 +   ``BASIC_AUTH`` – (Amazon MQ) The ASMlong secret that stores your broker credentials.
                 +   ``BASIC_AUTH`` – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.
                 +   ``VPC_SUBNET`` – (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.
                 +   ``VPC_SECURITY_GROUP`` – (Self-managed Apache Kafka) The VPC security group used to manage access to your self-managed Apache Kafka brokers.
                 +   ``SASL_SCRAM_256_AUTH`` – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
                 +   ``SASL_SCRAM_512_AUTH`` – (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
                 +   ``VIRTUAL_HOST`` –- (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.
                 +   ``CLIENT_CERTIFICATE_TLS_AUTH`` – (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
                 +   ``SERVER_ROOT_CA_CERTIFICATE`` – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
        :param str uri: The value for your chosen configuration in ``Type``. For example: ``"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"``.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> Optional['EventSourceMappingSourceAccessConfigurationType']:
        """
        The type of authentication protocol, VPC components, or virtual host for your event source. For example: ``"Type":"SASL_SCRAM_512_AUTH"``.
          +   ``BASIC_AUTH`` – (Amazon MQ) The ASMlong secret that stores your broker credentials.
          +   ``BASIC_AUTH`` – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.
          +   ``VPC_SUBNET`` – (Self-managed Apache Kafka) The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.
          +   ``VPC_SECURITY_GROUP`` – (Self-managed Apache Kafka) The VPC security group used to manage access to your self-managed Apache Kafka brokers.
          +   ``SASL_SCRAM_256_AUTH`` – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.
          +   ``SASL_SCRAM_512_AUTH`` – (Amazon MSK, Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.
          +   ``VIRTUAL_HOST`` –- (RabbitMQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source. This property cannot be specified in an UpdateEventSourceMapping API call.
          +   ``CLIENT_CERTIFICATE_TLS_AUTH`` – (Amazon MSK, self-managed Apache Kafka) The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
          +   ``SERVER_ROOT_CA_CERTIFICATE`` – (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your Apache Kafka brokers.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The value for your chosen configuration in ``Type``. For example: ``"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"``.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class FunctionCode(dict):
    """
    The [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) for a Lambda function. To deploy a function defined as a container image, you specify the location of a container image in the Amazon ECR registry. For a .zip file deployment package, you can specify the location of an object in Amazon S3. For Node.js and Python functions, you can specify the function code inline in the template.
     Changes to a deployment package in Amazon S3 or a container image in ECR are not detected automatically during stack updates. To update the function code, change the object key or version in the template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3Key":
            suggest = "s3_key"
        elif key == "s3ObjectVersion":
            suggest = "s3_object_version"
        elif key == "zipFile":
            suggest = "zip_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionCode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionCode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionCode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: Optional[str] = None,
                 s3_bucket: Optional[str] = None,
                 s3_key: Optional[str] = None,
                 s3_object_version: Optional[str] = None,
                 zip_file: Optional[str] = None):
        """
        The [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) for a Lambda function. To deploy a function defined as a container image, you specify the location of a container image in the Amazon ECR registry. For a .zip file deployment package, you can specify the location of an object in Amazon S3. For Node.js and Python functions, you can specify the function code inline in the template.
         Changes to a deployment package in Amazon S3 or a container image in ECR are not detected automatically during stack updates. To update the function code, change the object key or version in the template.
        :param str image_uri: URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
        :param str s3_bucket: An Amazon S3 bucket in the same AWS-Region as your function. The bucket can be in a different AWS-account.
        :param str s3_key: The Amazon S3 key of the deployment package.
        :param str s3_object_version: For versioned objects, the version of the deployment package object to use.
        :param str zip_file: (Node.js and Python) The source code of your Lambda function. If you include your function source inline with this parameter, CFN places it in a file named ``index`` and zips it to create a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html). This zip file cannot exceed 4MB. For the ``Handler`` property, the first part of the handler identifier must be ``index``. For example, ``index.handler``.
                 For JSON, you must escape quotes and special characters such as newline (``\\n``) with a backslash.
                If you specify a function that interacts with an AWS CloudFormation custom resource, you don't have to write your own functions to send responses to the custom resource that invoked the function. AWS CloudFormation provides a response module ([cfn-response](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-lambda-function-code-cfnresponsemodule.html)) that simplifies sending responses. See [Using Lambda with CloudFormation](https://docs.aws.amazon.com/lambda/latest/dg/services-cloudformation.html) for details.
        """
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[str]:
        """
        URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[str]:
        """
        An Amazon S3 bucket in the same AWS-Region as your function. The bucket can be in a different AWS-account.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[str]:
        """
        The Amazon S3 key of the deployment package.
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[str]:
        """
        For versioned objects, the version of the deployment package object to use.
        """
        return pulumi.get(self, "s3_object_version")

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[str]:
        """
        (Node.js and Python) The source code of your Lambda function. If you include your function source inline with this parameter, CFN places it in a file named ``index`` and zips it to create a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html). This zip file cannot exceed 4MB. For the ``Handler`` property, the first part of the handler identifier must be ``index``. For example, ``index.handler``.
          For JSON, you must escape quotes and special characters such as newline (``\\n``) with a backslash.
         If you specify a function that interacts with an AWS CloudFormation custom resource, you don't have to write your own functions to send responses to the custom resource that invoked the function. AWS CloudFormation provides a response module ([cfn-response](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-lambda-function-code-cfnresponsemodule.html)) that simplifies sending responses. See [Using Lambda with CloudFormation](https://docs.aws.amazon.com/lambda/latest/dg/services-cloudformation.html) for details.
        """
        return pulumi.get(self, "zip_file")


@pulumi.output_type
class FunctionDeadLetterConfig(dict):
    """
    The [dead-letter queue](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq) for failed asynchronous invocations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetArn":
            suggest = "target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionDeadLetterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionDeadLetterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionDeadLetterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_arn: Optional[str] = None):
        """
        The [dead-letter queue](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq) for failed asynchronous invocations.
        :param str target_arn: The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
        """
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
        """
        return pulumi.get(self, "target_arn")


@pulumi.output_type
class FunctionEnvironment(dict):
    """
    A function's environment variable settings. You can use environment variables to adjust your function's behavior without updating code. An environment variable is a pair of strings that are stored in a function's version-specific configuration.
    """
    def __init__(__self__, *,
                 variables: Optional[Mapping[str, str]] = None):
        """
        A function's environment variable settings. You can use environment variables to adjust your function's behavior without updating code. An environment variable is a pair of strings that are stored in a function's version-specific configuration.
        :param Mapping[str, str] variables: Environment variable key-value pairs. For more information, see [Using Lambda environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html).
        """
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variable key-value pairs. For more information, see [Using Lambda environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html).
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class FunctionEphemeralStorage(dict):
    """
    The size of the function's ``/tmp`` directory in MB. The default value is 512, but it can be any whole number between 512 and 10,240 MB.
    """
    def __init__(__self__, *,
                 size: int):
        """
        The size of the function's ``/tmp`` directory in MB. The default value is 512, but it can be any whole number between 512 and 10,240 MB.
        :param int size: The size of the function's ``/tmp`` directory.
        """
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the function's ``/tmp`` directory.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class FunctionFileSystemConfig(dict):
    """
    Details about the connection between a Lambda function and an [Amazon EFS file system](https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localMountPath":
            suggest = "local_mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 local_mount_path: str):
        """
        Details about the connection between a Lambda function and an [Amazon EFS file system](https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
        :param str arn: The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
        :param str local_mount_path: The path where the function can access the file system, starting with ``/mnt/``.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "local_mount_path", local_mount_path)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> str:
        """
        The path where the function can access the file system, starting with ``/mnt/``.
        """
        return pulumi.get(self, "local_mount_path")


@pulumi.output_type
class FunctionImageConfig(dict):
    """
    Configuration values that override the container image Dockerfile settings. For more information, see [Container image settings](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPoint":
            suggest = "entry_point"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[str]] = None,
                 entry_point: Optional[Sequence[str]] = None,
                 working_directory: Optional[str] = None):
        """
        Configuration values that override the container image Dockerfile settings. For more information, see [Container image settings](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
        :param Sequence[str] command: Specifies parameters that you want to pass in with ENTRYPOINT. You can specify a maximum of 1,500 parameters in the list.
        :param Sequence[str] entry_point: Specifies the entry point to their application, which is typically the location of the runtime executable. You can specify a maximum of 1,500 string entries in the list.
        :param str working_directory: Specifies the working directory. The length of the directory string cannot exceed 1,000 characters.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        Specifies parameters that you want to pass in with ENTRYPOINT. You can specify a maximum of 1,500 parameters in the list.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[Sequence[str]]:
        """
        Specifies the entry point to their application, which is typically the location of the runtime executable. You can specify a maximum of 1,500 string entries in the list.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[str]:
        """
        Specifies the working directory. The length of the directory string cannot exceed 1,000 characters.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class FunctionLoggingConfig(dict):
    """
    The function's Amazon CloudWatch Logs configuration settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationLogLevel":
            suggest = "application_log_level"
        elif key == "logFormat":
            suggest = "log_format"
        elif key == "logGroup":
            suggest = "log_group"
        elif key == "systemLogLevel":
            suggest = "system_log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_log_level: Optional['FunctionLoggingConfigApplicationLogLevel'] = None,
                 log_format: Optional['FunctionLoggingConfigLogFormat'] = None,
                 log_group: Optional[str] = None,
                 system_log_level: Optional['FunctionLoggingConfigSystemLogLevel'] = None):
        """
        The function's Amazon CloudWatch Logs configuration settings.
        :param 'FunctionLoggingConfigApplicationLogLevel' application_log_level: Set this property to filter the application logs for your function that Lambda sends to CloudWatch. Lambda only sends application logs at the selected level of detail and lower, where ``TRACE`` is the highest level and ``FATAL`` is the lowest.
        :param 'FunctionLoggingConfigLogFormat' log_format: The format in which Lambda sends your function's application and system logs to CloudWatch. Select between plain text and structured JSON.
        :param str log_group: The name of the Amazon CloudWatch log group the function sends logs to. By default, Lambda functions send logs to a default log group named ``/aws/lambda/<function name>``. To use a different log group, enter an existing log group or enter a new log group name.
        :param 'FunctionLoggingConfigSystemLogLevel' system_log_level: Set this property to filter the system logs for your function that Lambda sends to CloudWatch. Lambda only sends system logs at the selected level of detail and lower, where ``DEBUG`` is the highest level and ``WARN`` is the lowest.
        """
        if application_log_level is not None:
            pulumi.set(__self__, "application_log_level", application_log_level)
        if log_format is not None:
            pulumi.set(__self__, "log_format", log_format)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if system_log_level is not None:
            pulumi.set(__self__, "system_log_level", system_log_level)

    @property
    @pulumi.getter(name="applicationLogLevel")
    def application_log_level(self) -> Optional['FunctionLoggingConfigApplicationLogLevel']:
        """
        Set this property to filter the application logs for your function that Lambda sends to CloudWatch. Lambda only sends application logs at the selected level of detail and lower, where ``TRACE`` is the highest level and ``FATAL`` is the lowest.
        """
        return pulumi.get(self, "application_log_level")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> Optional['FunctionLoggingConfigLogFormat']:
        """
        The format in which Lambda sends your function's application and system logs to CloudWatch. Select between plain text and structured JSON.
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[str]:
        """
        The name of the Amazon CloudWatch log group the function sends logs to. By default, Lambda functions send logs to a default log group named ``/aws/lambda/<function name>``. To use a different log group, enter an existing log group or enter a new log group name.
        """
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter(name="systemLogLevel")
    def system_log_level(self) -> Optional['FunctionLoggingConfigSystemLogLevel']:
        """
        Set this property to filter the system logs for your function that Lambda sends to CloudWatch. Lambda only sends system logs at the selected level of detail and lower, where ``DEBUG`` is the highest level and ``WARN`` is the lowest.
        """
        return pulumi.get(self, "system_log_level")


@pulumi.output_type
class FunctionRuntimeManagementConfig(dict):
    """
    Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateRuntimeOn":
            suggest = "update_runtime_on"
        elif key == "runtimeVersionArn":
            suggest = "runtime_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionRuntimeManagementConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionRuntimeManagementConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionRuntimeManagementConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_runtime_on: 'FunctionRuntimeManagementConfigUpdateRuntimeOn',
                 runtime_version_arn: Optional[str] = None):
        """
        Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
        :param 'FunctionRuntimeManagementConfigUpdateRuntimeOn' update_runtime_on: Specify the runtime update mode.
                 +   *Auto (default)* - Automatically update to the most recent and secure runtime version using a [Two-phase runtime version rollout](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase). This is the best choice for most customers to ensure they always benefit from runtime updates.
                 +   *FunctionUpdate* - LAM updates the runtime of you function to the most recent and secure runtime version when you update your function. This approach synchronizes runtime updates with function deployments, giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime update incompatibilities early. When using this setting, you need to regularly update your functions to keep their runtime up-to-date.
                 +   *Manual* - You specify a runtime version in your function configuration. The function will use this runtime version indefinitely. In the rare case where a new runtime version is incompatible with an existing function, this allows you to roll back your function to an earlier runtime version. For more information, see [Roll back a runtime version](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback).
                 
                 *Valid Values*: ``Auto`` | ``FunctionUpdate`` | ``Manual``
        :param str runtime_version_arn: The ARN of the runtime version you want the function to use.
                 This is only required if you're using the *Manual* runtime update mode.
        """
        pulumi.set(__self__, "update_runtime_on", update_runtime_on)
        if runtime_version_arn is not None:
            pulumi.set(__self__, "runtime_version_arn", runtime_version_arn)

    @property
    @pulumi.getter(name="updateRuntimeOn")
    def update_runtime_on(self) -> 'FunctionRuntimeManagementConfigUpdateRuntimeOn':
        """
        Specify the runtime update mode.
          +   *Auto (default)* - Automatically update to the most recent and secure runtime version using a [Two-phase runtime version rollout](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase). This is the best choice for most customers to ensure they always benefit from runtime updates.
          +   *FunctionUpdate* - LAM updates the runtime of you function to the most recent and secure runtime version when you update your function. This approach synchronizes runtime updates with function deployments, giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime update incompatibilities early. When using this setting, you need to regularly update your functions to keep their runtime up-to-date.
          +   *Manual* - You specify a runtime version in your function configuration. The function will use this runtime version indefinitely. In the rare case where a new runtime version is incompatible with an existing function, this allows you to roll back your function to an earlier runtime version. For more information, see [Roll back a runtime version](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback).
          
          *Valid Values*: ``Auto`` | ``FunctionUpdate`` | ``Manual``
        """
        return pulumi.get(self, "update_runtime_on")

    @property
    @pulumi.getter(name="runtimeVersionArn")
    def runtime_version_arn(self) -> Optional[str]:
        """
        The ARN of the runtime version you want the function to use.
          This is only required if you're using the *Manual* runtime update mode.
        """
        return pulumi.get(self, "runtime_version_arn")


@pulumi.output_type
class FunctionSnapStart(dict):
    """
    The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyOn":
            suggest = "apply_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSnapStart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSnapStart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSnapStart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_on: 'FunctionSnapStartApplyOn'):
        """
        The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
        :param 'FunctionSnapStartApplyOn' apply_on: Set ``ApplyOn`` to ``PublishedVersions`` to create a snapshot of the initialized execution environment when you publish a function version.
        """
        pulumi.set(__self__, "apply_on", apply_on)

    @property
    @pulumi.getter(name="applyOn")
    def apply_on(self) -> 'FunctionSnapStartApplyOn':
        """
        Set ``ApplyOn`` to ``PublishedVersions`` to create a snapshot of the initialized execution environment when you publish a function version.
        """
        return pulumi.get(self, "apply_on")


@pulumi.output_type
class FunctionSnapStartResponse(dict):
    """
    The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyOn":
            suggest = "apply_on"
        elif key == "optimizationStatus":
            suggest = "optimization_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSnapStartResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSnapStartResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSnapStartResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_on: Optional['FunctionSnapStartResponseApplyOn'] = None,
                 optimization_status: Optional['FunctionSnapStartResponseOptimizationStatus'] = None):
        """
        The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
        :param 'FunctionSnapStartResponseApplyOn' apply_on: When set to ``PublishedVersions``, Lambda creates a snapshot of the execution environment when you publish a function version.
        :param 'FunctionSnapStartResponseOptimizationStatus' optimization_status: When you provide a [qualified Amazon Resource Name (ARN)](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using), this response element indicates whether SnapStart is activated for the specified function version.
        """
        if apply_on is not None:
            pulumi.set(__self__, "apply_on", apply_on)
        if optimization_status is not None:
            pulumi.set(__self__, "optimization_status", optimization_status)

    @property
    @pulumi.getter(name="applyOn")
    def apply_on(self) -> Optional['FunctionSnapStartResponseApplyOn']:
        """
        When set to ``PublishedVersions``, Lambda creates a snapshot of the execution environment when you publish a function version.
        """
        return pulumi.get(self, "apply_on")

    @property
    @pulumi.getter(name="optimizationStatus")
    def optimization_status(self) -> Optional['FunctionSnapStartResponseOptimizationStatus']:
        """
        When you provide a [qualified Amazon Resource Name (ARN)](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using), this response element indicates whether SnapStart is activated for the specified function version.
        """
        return pulumi.get(self, "optimization_status")


@pulumi.output_type
class FunctionTracingConfig(dict):
    """
    The function's [](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html) tracing configuration. To sample and record incoming requests, set ``Mode`` to ``Active``.
    """
    def __init__(__self__, *,
                 mode: Optional['FunctionTracingConfigMode'] = None):
        """
        The function's [](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html) tracing configuration. To sample and record incoming requests, set ``Mode`` to ``Active``.
        :param 'FunctionTracingConfigMode' mode: The tracing mode.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional['FunctionTracingConfigMode']:
        """
        The tracing mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class FunctionVpcConfig(dict):
    """
    The VPC security groups and subnets that are attached to a Lambda function. When you connect a function to a VPC, Lambda creates an elastic network interface for each combination of security group and subnet in the function's VPC configuration. The function can only access resources and the internet through that VPC. For more information, see [VPC Settings](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
      When you delete a function, CFN monitors the state of its network interfaces and waits for Lambda to delete them before proceeding. If the VPC is defined in the same stack, the network interfaces need to be deleted by Lambda before CFN can delete the VPC's resources.
     To monitor network interfaces, CFN needs the ``ec2:DescribeNetworkInterfaces`` permission. It obtains this from the user or role that modifies the stack. If you don't provide this permission, CFN does not wait for network interfaces to be deleted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv6AllowedForDualStack":
            suggest = "ipv6_allowed_for_dual_stack"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv6_allowed_for_dual_stack: Optional[bool] = None,
                 security_group_ids: Optional[Sequence[str]] = None,
                 subnet_ids: Optional[Sequence[str]] = None):
        """
        The VPC security groups and subnets that are attached to a Lambda function. When you connect a function to a VPC, Lambda creates an elastic network interface for each combination of security group and subnet in the function's VPC configuration. The function can only access resources and the internet through that VPC. For more information, see [VPC Settings](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
          When you delete a function, CFN monitors the state of its network interfaces and waits for Lambda to delete them before proceeding. If the VPC is defined in the same stack, the network interfaces need to be deleted by Lambda before CFN can delete the VPC's resources.
         To monitor network interfaces, CFN needs the ``ec2:DescribeNetworkInterfaces`` permission. It obtains this from the user or role that modifies the stack. If you don't provide this permission, CFN does not wait for network interfaces to be deleted.
        :param bool ipv6_allowed_for_dual_stack: Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
        :param Sequence[str] security_group_ids: A list of VPC security group IDs.
        :param Sequence[str] subnet_ids: A list of VPC subnet IDs.
        """
        if ipv6_allowed_for_dual_stack is not None:
            pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> Optional[bool]:
        """
        Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
        """
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        A list of VPC security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        A list of VPC subnet IDs.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class LayerVersionContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3Key":
            suggest = "s3_key"
        elif key == "s3ObjectVersion":
            suggest = "s3_object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LayerVersionContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LayerVersionContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LayerVersionContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: str,
                 s3_key: str,
                 s3_object_version: Optional[str] = None):
        """
        :param str s3_bucket: The Amazon S3 bucket of the layer archive.
        :param str s3_key: The Amazon S3 key of the layer archive.
        :param str s3_object_version: For versioned objects, the version of the layer archive object to use.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        The Amazon S3 bucket of the layer archive.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> str:
        """
        The Amazon S3 key of the layer archive.
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[str]:
        """
        For versioned objects, the version of the layer archive object to use.
        """
        return pulumi.get(self, "s3_object_version")


@pulumi.output_type
class UrlCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence['UrlAllowMethodsItem']] = None,
                 allow_origins: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[int] = None):
        """
        :param bool allow_credentials: Specifies whether credentials are included in the CORS request.
        :param Sequence[str] allow_headers: Represents a collection of allowed headers.
        :param Sequence['UrlAllowMethodsItem'] allow_methods: Represents a collection of allowed HTTP methods.
        :param Sequence[str] allow_origins: Represents a collection of allowed origins.
        :param Sequence[str] expose_headers: Represents a collection of exposed headers.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Specifies whether credentials are included in the CORS request.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        Represents a collection of allowed headers.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence['UrlAllowMethodsItem']]:
        """
        Represents a collection of allowed HTTP methods.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[str]]:
        """
        Represents a collection of allowed origins.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Represents a collection of exposed headers.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[int]:
        return pulumi.get(self, "max_age")


@pulumi.output_type
class VersionProvisionedConcurrencyConfiguration(dict):
    """
    A provisioned concurrency configuration for a function's version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedConcurrentExecutions":
            suggest = "provisioned_concurrent_executions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VersionProvisionedConcurrencyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VersionProvisionedConcurrencyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VersionProvisionedConcurrencyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_concurrent_executions: int):
        """
        A provisioned concurrency configuration for a function's version.
        :param int provisioned_concurrent_executions: The amount of provisioned concurrency to allocate for the version.
        """
        pulumi.set(__self__, "provisioned_concurrent_executions", provisioned_concurrent_executions)

    @property
    @pulumi.getter(name="provisionedConcurrentExecutions")
    def provisioned_concurrent_executions(self) -> int:
        """
        The amount of provisioned concurrency to allocate for the version.
        """
        return pulumi.get(self, "provisioned_concurrent_executions")


@pulumi.output_type
class VersionRuntimePolicy(dict):
    """
    Runtime Management Config of a function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateRuntimeOn":
            suggest = "update_runtime_on"
        elif key == "runtimeVersionArn":
            suggest = "runtime_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VersionRuntimePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VersionRuntimePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VersionRuntimePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_runtime_on: str,
                 runtime_version_arn: Optional[str] = None):
        """
        Runtime Management Config of a function.
        :param str update_runtime_on: The runtime update mode.
        :param str runtime_version_arn: The ARN of the runtime the function is configured to use. If the runtime update mode is manual, the ARN is returned, otherwise null is returned.
        """
        pulumi.set(__self__, "update_runtime_on", update_runtime_on)
        if runtime_version_arn is not None:
            pulumi.set(__self__, "runtime_version_arn", runtime_version_arn)

    @property
    @pulumi.getter(name="updateRuntimeOn")
    def update_runtime_on(self) -> str:
        """
        The runtime update mode.
        """
        return pulumi.get(self, "update_runtime_on")

    @property
    @pulumi.getter(name="runtimeVersionArn")
    def runtime_version_arn(self) -> Optional[str]:
        """
        The ARN of the runtime the function is configured to use. If the runtime update mode is manual, the ARN is returned, otherwise null is returned.
        """
        return pulumi.get(self, "runtime_version_arn")


