# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EventSourceMappingArgs', 'EventSourceMapping']

@pulumi.input_type
class EventSourceMappingArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[str],
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[bool]] = None,
                 destination_config: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']] = None,
                 document_db_event_source_config: Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 filter_criteria: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None,
                 parallelization_factor: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_config: Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']] = None,
                 self_managed_event_source: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]] = None,
                 starting_position: Optional[pulumi.Input[str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[float]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a EventSourceMapping resource.
        :param pulumi.Input[str] function_name: The name or ARN of the Lambda function.
                 **Name formats**
                +   *Function name* – ``MyFunction``.
                 +   *Function ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction``.
                 +   *Version or Alias ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD``.
                 +   *Partial ARN* – ``123456789012:function:MyFunction``.
                 
                The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
        :param pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs'] amazon_managed_kafka_event_source_config: Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
        :param pulumi.Input[int] batch_size: The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
                 +   *Amazon Kinesis* – Default 100. Max 10,000.
                 +   *Amazon DynamoDB Streams* – Default 100. Max 10,000.
                 +   *Amazon Simple Queue Service* – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
                 +   *Amazon Managed Streaming for Apache Kafka* – Default 100. Max 10,000.
                 +   *Self-managed Apache Kafka* – Default 100. Max 10,000.
                 +   *Amazon MQ (ActiveMQ and RabbitMQ)* – Default 100. Max 10,000.
                 +   *DocumentDB* – Default 100. Max 10,000.
        :param pulumi.Input[bool] bisect_batch_on_function_error: (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
        :param pulumi.Input['EventSourceMappingDestinationConfigArgs'] destination_config: (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
        :param pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs'] document_db_event_source_config: Specific configuration settings for a DocumentDB event source.
        :param pulumi.Input[bool] enabled: When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
                Default: True
        :param pulumi.Input[str] event_source_arn: The Amazon Resource Name (ARN) of the event source.
                 +   *Amazon Kinesis* – The ARN of the data stream or a stream consumer.
                 +   *Amazon DynamoDB Streams* – The ARN of the stream.
                 +   *Amazon Simple Queue Service* – The ARN of the queue.
                 +   *Amazon Managed Streaming for Apache Kafka* – The ARN of the cluster or the ARN of the VPC connection (for [cross-account event source mappings](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc)).
                 +   *Amazon MQ* – The ARN of the broker.
                 +   *Amazon DocumentDB* – The ARN of the DocumentDB change stream.
        :param pulumi.Input['EventSourceMappingFilterCriteriaArgs'] filter_criteria: An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]] function_response_types: (Streams and SQS) A list of current response type enums applied to the event source mapping.
                Valid Values: ``ReportBatchItemFailures``
        :param pulumi.Input[int] maximum_batching_window_in_seconds: The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
                *Default (, , event sources)*: 0
                *Default (, Kafka, , event sources)*: 500 ms
                *Related setting:* For SQS event sources, when you set ``BatchSize`` to a value greater than 10, you must set ``MaximumBatchingWindowInSeconds`` to at least 1.
        :param pulumi.Input[int] maximum_record_age_in_seconds: (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
                 The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
        :param pulumi.Input[int] maximum_retry_attempts: (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
        :param pulumi.Input[int] parallelization_factor: (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default value is 1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queues: (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
        :param pulumi.Input['EventSourceMappingScalingConfigArgs'] scaling_config: (Amazon SQS only) The scaling configuration for the event source. For more information, see [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        :param pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs'] self_managed_event_source: The self-managed Apache Kafka cluster for your event source.
        :param pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs'] self_managed_kafka_event_source_config: Specific configuration settings for a self-managed Apache Kafka event source.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]] source_access_configurations: An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
        :param pulumi.Input[str] starting_position: The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB.
                 +  *LATEST* - Read only new records.
                 +  *TRIM_HORIZON* - Process all available records.
                 +  *AT_TIMESTAMP* - Specify a time from which to start reading records.
        :param pulumi.Input[float] starting_position_timestamp: With ``StartingPosition`` set to ``AT_TIMESTAMP``, the time from which to start reading, in Unix time seconds. ``StartingPositionTimestamp`` cannot be in the future.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The name of the Kafka topic.
        :param pulumi.Input[int] tumbling_window_in_seconds: (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
        """
        pulumi.set(__self__, "function_name", function_name)
        if amazon_managed_kafka_event_source_config is not None:
            pulumi.set(__self__, "amazon_managed_kafka_event_source_config", amazon_managed_kafka_event_source_config)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if bisect_batch_on_function_error is not None:
            pulumi.set(__self__, "bisect_batch_on_function_error", bisect_batch_on_function_error)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if document_db_event_source_config is not None:
            pulumi.set(__self__, "document_db_event_source_config", document_db_event_source_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_source_arn is not None:
            pulumi.set(__self__, "event_source_arn", event_source_arn)
        if filter_criteria is not None:
            pulumi.set(__self__, "filter_criteria", filter_criteria)
        if function_response_types is not None:
            pulumi.set(__self__, "function_response_types", function_response_types)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if self_managed_event_source is not None:
            pulumi.set(__self__, "self_managed_event_source", self_managed_event_source)
        if self_managed_kafka_event_source_config is not None:
            pulumi.set(__self__, "self_managed_kafka_event_source_config", self_managed_kafka_event_source_config)
        if source_access_configurations is not None:
            pulumi.set(__self__, "source_access_configurations", source_access_configurations)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if starting_position_timestamp is not None:
            pulumi.set(__self__, "starting_position_timestamp", starting_position_timestamp)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if tumbling_window_in_seconds is not None:
            pulumi.set(__self__, "tumbling_window_in_seconds", tumbling_window_in_seconds)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The name or ARN of the Lambda function.
          **Name formats**
         +   *Function name* – ``MyFunction``.
          +   *Function ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction``.
          +   *Version or Alias ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD``.
          +   *Partial ARN* – ``123456789012:function:MyFunction``.
          
         The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="amazonManagedKafkaEventSourceConfig")
    def amazon_managed_kafka_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]:
        """
        Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
        """
        return pulumi.get(self, "amazon_managed_kafka_event_source_config")

    @amazon_managed_kafka_event_source_config.setter
    def amazon_managed_kafka_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]):
        pulumi.set(self, "amazon_managed_kafka_event_source_config", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
          +   *Amazon Kinesis* – Default 100. Max 10,000.
          +   *Amazon DynamoDB Streams* – Default 100. Max 10,000.
          +   *Amazon Simple Queue Service* – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
          +   *Amazon Managed Streaming for Apache Kafka* – Default 100. Max 10,000.
          +   *Self-managed Apache Kafka* – Default 100. Max 10,000.
          +   *Amazon MQ (ActiveMQ and RabbitMQ)* – Default 100. Max 10,000.
          +   *DocumentDB* – Default 100. Max 10,000.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> Optional[pulumi.Input[bool]]:
        """
        (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @bisect_batch_on_function_error.setter
    def bisect_batch_on_function_error(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bisect_batch_on_function_error", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]:
        """
        (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="documentDbEventSourceConfig")
    def document_db_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']]:
        """
        Specific configuration settings for a DocumentDB event source.
        """
        return pulumi.get(self, "document_db_event_source_config")

    @document_db_event_source_config.setter
    def document_db_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']]):
        pulumi.set(self, "document_db_event_source_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         Default: True
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the event source.
          +   *Amazon Kinesis* – The ARN of the data stream or a stream consumer.
          +   *Amazon DynamoDB Streams* – The ARN of the stream.
          +   *Amazon Simple Queue Service* – The ARN of the queue.
          +   *Amazon Managed Streaming for Apache Kafka* – The ARN of the cluster or the ARN of the VPC connection (for [cross-account event source mappings](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc)).
          +   *Amazon MQ* – The ARN of the broker.
          +   *Amazon DocumentDB* – The ARN of the DocumentDB change stream.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]:
        """
        An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
        """
        return pulumi.get(self, "filter_criteria")

    @filter_criteria.setter
    def filter_criteria(self, value: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]):
        pulumi.set(self, "filter_criteria", value)

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]]:
        """
        (Streams and SQS) A list of current response type enums applied to the event source mapping.
         Valid Values: ``ReportBatchItemFailures``
        """
        return pulumi.get(self, "function_response_types")

    @function_response_types.setter
    def function_response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]]):
        pulumi.set(self, "function_response_types", value)

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         *Default (, , event sources)*: 0
         *Default (, Kafka, , event sources)*: 500 ms
         *Related setting:* For SQS event sources, when you set ``BatchSize`` to a value greater than 10, you must set ``MaximumBatchingWindowInSeconds`` to at least 1.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @maximum_batching_window_in_seconds.setter
    def maximum_batching_window_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_batching_window_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
          The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @maximum_record_age_in_seconds.setter
    def maximum_record_age_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_record_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_retry_attempts", value)

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[pulumi.Input[int]]:
        """
        (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default value is 1.
        """
        return pulumi.get(self, "parallelization_factor")

    @parallelization_factor.setter
    def parallelization_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelization_factor", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "queues", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']]:
        """
        (Amazon SQS only) The scaling configuration for the event source. For more information, see [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]:
        """
        The self-managed Apache Kafka cluster for your event source.
        """
        return pulumi.get(self, "self_managed_event_source")

    @self_managed_event_source.setter
    def self_managed_event_source(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]):
        pulumi.set(self, "self_managed_event_source", value)

    @property
    @pulumi.getter(name="selfManagedKafkaEventSourceConfig")
    def self_managed_kafka_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]:
        """
        Specific configuration settings for a self-managed Apache Kafka event source.
        """
        return pulumi.get(self, "self_managed_kafka_event_source_config")

    @self_managed_kafka_event_source_config.setter
    def self_managed_kafka_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]):
        pulumi.set(self, "self_managed_kafka_event_source_config", value)

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]:
        """
        An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
        """
        return pulumi.get(self, "source_access_configurations")

    @source_access_configurations.setter
    def source_access_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]):
        pulumi.set(self, "source_access_configurations", value)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[pulumi.Input[str]]:
        """
        The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB.
          +  *LATEST* - Read only new records.
          +  *TRIM_HORIZON* - Process all available records.
          +  *AT_TIMESTAMP* - Specify a time from which to start reading records.
        """
        return pulumi.get(self, "starting_position")

    @starting_position.setter
    def starting_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "starting_position", value)

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> Optional[pulumi.Input[float]]:
        """
        With ``StartingPosition`` set to ``AT_TIMESTAMP``, the time from which to start reading, in Unix time seconds. ``StartingPositionTimestamp`` cannot be in the future.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @starting_position_timestamp.setter
    def starting_position_timestamp(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "starting_position_timestamp", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The name of the Kafka topic.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

    @tumbling_window_in_seconds.setter
    def tumbling_window_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tumbling_window_in_seconds", value)


class EventSourceMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[bool]] = None,
                 destination_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingDestinationConfigArgs']]] = None,
                 document_db_event_source_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingDocumentDbEventSourceConfigArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 filter_criteria: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingFilterCriteriaArgs']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None,
                 parallelization_factor: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingScalingConfigArgs']]] = None,
                 self_managed_event_source: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedEventSourceArgs']]] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventSourceMappingSourceAccessConfigurationArgs']]]]] = None,
                 starting_position: Optional[pulumi.Input[str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[float]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        The ``AWS::Lambda::EventSourceMapping`` resource creates a mapping between an event source and an LAMlong function. LAM reads items from the event source and triggers the function.
         For details about each event source type, see the following topics. In particular, each of the topics describes the required and optional parameters for the specific event source.
          +  [Configuring a Dynamo DB stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
          +  [Configuring a Kinesis stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
          +  [Configuring an SQS queue as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
          +  [Configuring an MQ broker as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
          +  [Configuring MSK as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
          +  [Configuring Self-Managed Apache Kafka as an event source](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
          +  [Configuring Amazon DocumentDB as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']] amazon_managed_kafka_event_source_config: Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
        :param pulumi.Input[int] batch_size: The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
                 +   *Amazon Kinesis* – Default 100. Max 10,000.
                 +   *Amazon DynamoDB Streams* – Default 100. Max 10,000.
                 +   *Amazon Simple Queue Service* – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
                 +   *Amazon Managed Streaming for Apache Kafka* – Default 100. Max 10,000.
                 +   *Self-managed Apache Kafka* – Default 100. Max 10,000.
                 +   *Amazon MQ (ActiveMQ and RabbitMQ)* – Default 100. Max 10,000.
                 +   *DocumentDB* – Default 100. Max 10,000.
        :param pulumi.Input[bool] bisect_batch_on_function_error: (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingDestinationConfigArgs']] destination_config: (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingDocumentDbEventSourceConfigArgs']] document_db_event_source_config: Specific configuration settings for a DocumentDB event source.
        :param pulumi.Input[bool] enabled: When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
                Default: True
        :param pulumi.Input[str] event_source_arn: The Amazon Resource Name (ARN) of the event source.
                 +   *Amazon Kinesis* – The ARN of the data stream or a stream consumer.
                 +   *Amazon DynamoDB Streams* – The ARN of the stream.
                 +   *Amazon Simple Queue Service* – The ARN of the queue.
                 +   *Amazon Managed Streaming for Apache Kafka* – The ARN of the cluster or the ARN of the VPC connection (for [cross-account event source mappings](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc)).
                 +   *Amazon MQ* – The ARN of the broker.
                 +   *Amazon DocumentDB* – The ARN of the DocumentDB change stream.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingFilterCriteriaArgs']] filter_criteria: An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
        :param pulumi.Input[str] function_name: The name or ARN of the Lambda function.
                 **Name formats**
                +   *Function name* – ``MyFunction``.
                 +   *Function ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction``.
                 +   *Version or Alias ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD``.
                 +   *Partial ARN* – ``123456789012:function:MyFunction``.
                 
                The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]] function_response_types: (Streams and SQS) A list of current response type enums applied to the event source mapping.
                Valid Values: ``ReportBatchItemFailures``
        :param pulumi.Input[int] maximum_batching_window_in_seconds: The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
                *Default (, , event sources)*: 0
                *Default (, Kafka, , event sources)*: 500 ms
                *Related setting:* For SQS event sources, when you set ``BatchSize`` to a value greater than 10, you must set ``MaximumBatchingWindowInSeconds`` to at least 1.
        :param pulumi.Input[int] maximum_record_age_in_seconds: (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
                 The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
        :param pulumi.Input[int] maximum_retry_attempts: (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
        :param pulumi.Input[int] parallelization_factor: (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default value is 1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queues: (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingScalingConfigArgs']] scaling_config: (Amazon SQS only) The scaling configuration for the event source. For more information, see [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        :param pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedEventSourceArgs']] self_managed_event_source: The self-managed Apache Kafka cluster for your event source.
        :param pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']] self_managed_kafka_event_source_config: Specific configuration settings for a self-managed Apache Kafka event source.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventSourceMappingSourceAccessConfigurationArgs']]]] source_access_configurations: An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
        :param pulumi.Input[str] starting_position: The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB.
                 +  *LATEST* - Read only new records.
                 +  *TRIM_HORIZON* - Process all available records.
                 +  *AT_TIMESTAMP* - Specify a time from which to start reading records.
        :param pulumi.Input[float] starting_position_timestamp: With ``StartingPosition`` set to ``AT_TIMESTAMP``, the time from which to start reading, in Unix time seconds. ``StartingPositionTimestamp`` cannot be in the future.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The name of the Kafka topic.
        :param pulumi.Input[int] tumbling_window_in_seconds: (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventSourceMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::Lambda::EventSourceMapping`` resource creates a mapping between an event source and an LAMlong function. LAM reads items from the event source and triggers the function.
         For details about each event source type, see the following topics. In particular, each of the topics describes the required and optional parameters for the specific event source.
          +  [Configuring a Dynamo DB stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
          +  [Configuring a Kinesis stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
          +  [Configuring an SQS queue as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
          +  [Configuring an MQ broker as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
          +  [Configuring MSK as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
          +  [Configuring Self-Managed Apache Kafka as an event source](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
          +  [Configuring Amazon DocumentDB as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html)

        :param str resource_name: The name of the resource.
        :param EventSourceMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventSourceMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[bool]] = None,
                 destination_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingDestinationConfigArgs']]] = None,
                 document_db_event_source_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingDocumentDbEventSourceConfigArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 filter_criteria: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingFilterCriteriaArgs']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingFunctionResponseTypesItem']]]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None,
                 parallelization_factor: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingScalingConfigArgs']]] = None,
                 self_managed_event_source: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedEventSourceArgs']]] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input[pulumi.InputType['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventSourceMappingSourceAccessConfigurationArgs']]]]] = None,
                 starting_position: Optional[pulumi.Input[str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[float]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventSourceMappingArgs.__new__(EventSourceMappingArgs)

            __props__.__dict__["amazon_managed_kafka_event_source_config"] = amazon_managed_kafka_event_source_config
            __props__.__dict__["batch_size"] = batch_size
            __props__.__dict__["bisect_batch_on_function_error"] = bisect_batch_on_function_error
            __props__.__dict__["destination_config"] = destination_config
            __props__.__dict__["document_db_event_source_config"] = document_db_event_source_config
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_source_arn"] = event_source_arn
            __props__.__dict__["filter_criteria"] = filter_criteria
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["function_response_types"] = function_response_types
            __props__.__dict__["maximum_batching_window_in_seconds"] = maximum_batching_window_in_seconds
            __props__.__dict__["maximum_record_age_in_seconds"] = maximum_record_age_in_seconds
            __props__.__dict__["maximum_retry_attempts"] = maximum_retry_attempts
            __props__.__dict__["parallelization_factor"] = parallelization_factor
            __props__.__dict__["queues"] = queues
            __props__.__dict__["scaling_config"] = scaling_config
            __props__.__dict__["self_managed_event_source"] = self_managed_event_source
            __props__.__dict__["self_managed_kafka_event_source_config"] = self_managed_kafka_event_source_config
            __props__.__dict__["source_access_configurations"] = source_access_configurations
            __props__.__dict__["starting_position"] = starting_position
            __props__.__dict__["starting_position_timestamp"] = starting_position_timestamp
            __props__.__dict__["topics"] = topics
            __props__.__dict__["tumbling_window_in_seconds"] = tumbling_window_in_seconds
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["amazonManagedKafkaEventSourceConfig", "eventSourceArn", "selfManagedEventSource", "selfManagedKafkaEventSourceConfig", "startingPosition", "startingPositionTimestamp"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EventSourceMapping, __self__).__init__(
            'aws-native:lambda:EventSourceMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EventSourceMapping':
        """
        Get an existing EventSourceMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventSourceMappingArgs.__new__(EventSourceMappingArgs)

        __props__.__dict__["amazon_managed_kafka_event_source_config"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["batch_size"] = None
        __props__.__dict__["bisect_batch_on_function_error"] = None
        __props__.__dict__["destination_config"] = None
        __props__.__dict__["document_db_event_source_config"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["event_source_arn"] = None
        __props__.__dict__["filter_criteria"] = None
        __props__.__dict__["function_name"] = None
        __props__.__dict__["function_response_types"] = None
        __props__.__dict__["maximum_batching_window_in_seconds"] = None
        __props__.__dict__["maximum_record_age_in_seconds"] = None
        __props__.__dict__["maximum_retry_attempts"] = None
        __props__.__dict__["parallelization_factor"] = None
        __props__.__dict__["queues"] = None
        __props__.__dict__["scaling_config"] = None
        __props__.__dict__["self_managed_event_source"] = None
        __props__.__dict__["self_managed_kafka_event_source_config"] = None
        __props__.__dict__["source_access_configurations"] = None
        __props__.__dict__["starting_position"] = None
        __props__.__dict__["starting_position_timestamp"] = None
        __props__.__dict__["topics"] = None
        __props__.__dict__["tumbling_window_in_seconds"] = None
        return EventSourceMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonManagedKafkaEventSourceConfig")
    def amazon_managed_kafka_event_source_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingAmazonManagedKafkaEventSourceConfig']]:
        """
        Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
        """
        return pulumi.get(self, "amazon_managed_kafka_event_source_config")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
          +   *Amazon Kinesis* – Default 100. Max 10,000.
          +   *Amazon DynamoDB Streams* – Default 100. Max 10,000.
          +   *Amazon Simple Queue Service* – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
          +   *Amazon Managed Streaming for Apache Kafka* – Default 100. Max 10,000.
          +   *Self-managed Apache Kafka* – Default 100. Max 10,000.
          +   *Amazon MQ (ActiveMQ and RabbitMQ)* – Default 100. Max 10,000.
          +   *DocumentDB* – Default 100. Max 10,000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> pulumi.Output[Optional[bool]]:
        """
        (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingDestinationConfig']]:
        """
        (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="documentDbEventSourceConfig")
    def document_db_event_source_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingDocumentDbEventSourceConfig']]:
        """
        Specific configuration settings for a DocumentDB event source.
        """
        return pulumi.get(self, "document_db_event_source_config")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         Default: True
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the event source.
          +   *Amazon Kinesis* – The ARN of the data stream or a stream consumer.
          +   *Amazon DynamoDB Streams* – The ARN of the stream.
          +   *Amazon Simple Queue Service* – The ARN of the queue.
          +   *Amazon Managed Streaming for Apache Kafka* – The ARN of the cluster or the ARN of the VPC connection (for [cross-account event source mappings](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc)).
          +   *Amazon MQ* – The ARN of the broker.
          +   *Amazon DocumentDB* – The ARN of the DocumentDB change stream.
        """
        return pulumi.get(self, "event_source_arn")

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> pulumi.Output[Optional['outputs.EventSourceMappingFilterCriteria']]:
        """
        An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
        """
        return pulumi.get(self, "filter_criteria")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        The name or ARN of the Lambda function.
          **Name formats**
         +   *Function name* – ``MyFunction``.
          +   *Function ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction``.
          +   *Version or Alias ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD``.
          +   *Partial ARN* – ``123456789012:function:MyFunction``.
          
         The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> pulumi.Output[Optional[Sequence['EventSourceMappingFunctionResponseTypesItem']]]:
        """
        (Streams and SQS) A list of current response type enums applied to the event source mapping.
         Valid Values: ``ReportBatchItemFailures``
        """
        return pulumi.get(self, "function_response_types")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         *Default (, , event sources)*: 0
         *Default (, Kafka, , event sources)*: 500 ms
         *Related setting:* For SQS event sources, when you set ``BatchSize`` to a value greater than 10, you must set ``MaximumBatchingWindowInSeconds`` to at least 1.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
          The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> pulumi.Output[Optional[int]]:
        """
        (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> pulumi.Output[Optional[int]]:
        """
        (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default value is 1.
        """
        return pulumi.get(self, "parallelization_factor")

    @property
    @pulumi.getter
    def queues(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
        """
        return pulumi.get(self, "queues")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingScalingConfig']]:
        """
        (Amazon SQS only) The scaling configuration for the event source. For more information, see [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> pulumi.Output[Optional['outputs.EventSourceMappingSelfManagedEventSource']]:
        """
        The self-managed Apache Kafka cluster for your event source.
        """
        return pulumi.get(self, "self_managed_event_source")

    @property
    @pulumi.getter(name="selfManagedKafkaEventSourceConfig")
    def self_managed_kafka_event_source_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig']]:
        """
        Specific configuration settings for a self-managed Apache Kafka event source.
        """
        return pulumi.get(self, "self_managed_kafka_event_source_config")

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.EventSourceMappingSourceAccessConfiguration']]]:
        """
        An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
        """
        return pulumi.get(self, "source_access_configurations")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> pulumi.Output[Optional[str]]:
        """
        The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB.
          +  *LATEST* - Read only new records.
          +  *TRIM_HORIZON* - Process all available records.
          +  *AT_TIMESTAMP* - Specify a time from which to start reading records.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> pulumi.Output[Optional[float]]:
        """
        With ``StartingPosition`` set to ``AT_TIMESTAMP``, the time from which to start reading, in Unix time seconds. ``StartingPositionTimestamp`` cannot be in the future.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The name of the Kafka topic.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

