# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataCellsFilterArgs', 'DataCellsFilter']

@pulumi.input_type
class DataCellsFilterArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 table_catalog_id: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 column_wildcard: Optional[pulumi.Input['DataCellsFilterColumnWildcardArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 row_filter: Optional[pulumi.Input['DataCellsFilterRowFilterArgs']] = None):
        """
        The set of arguments for constructing a DataCellsFilter resource.
        :param pulumi.Input[str] database_name: The name of the Database that the Table resides in.
        :param pulumi.Input[str] table_catalog_id: The Catalog Id of the Table on which to create a Data Cells Filter.
        :param pulumi.Input[str] table_name: The name of the Table to create a Data Cells Filter for.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] column_names: A list of columns to be included in this Data Cells Filter.
        :param pulumi.Input['DataCellsFilterColumnWildcardArgs'] column_wildcard: An object representing the Data Cells Filter's Columns. Either Column Names or a Wildcard is required
        :param pulumi.Input[str] name: The desired name of the Data Cells Filter.
        :param pulumi.Input['DataCellsFilterRowFilterArgs'] row_filter: An object representing the Data Cells Filter's Row Filter. Either a Filter Expression or a Wildcard is required
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_catalog_id", table_catalog_id)
        pulumi.set(__self__, "table_name", table_name)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if column_wildcard is not None:
            pulumi.set(__self__, "column_wildcard", column_wildcard)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if row_filter is not None:
            pulumi.set(__self__, "row_filter", row_filter)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The name of the Database that the Table resides in.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> pulumi.Input[str]:
        """
        The Catalog Id of the Table on which to create a Data Cells Filter.
        """
        return pulumi.get(self, "table_catalog_id")

    @table_catalog_id.setter
    def table_catalog_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_catalog_id", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the Table to create a Data Cells Filter for.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of columns to be included in this Data Cells Filter.
        """
        return pulumi.get(self, "column_names")

    @column_names.setter
    def column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "column_names", value)

    @property
    @pulumi.getter(name="columnWildcard")
    def column_wildcard(self) -> Optional[pulumi.Input['DataCellsFilterColumnWildcardArgs']]:
        """
        An object representing the Data Cells Filter's Columns. Either Column Names or a Wildcard is required
        """
        return pulumi.get(self, "column_wildcard")

    @column_wildcard.setter
    def column_wildcard(self, value: Optional[pulumi.Input['DataCellsFilterColumnWildcardArgs']]):
        pulumi.set(self, "column_wildcard", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The desired name of the Data Cells Filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional[pulumi.Input['DataCellsFilterRowFilterArgs']]:
        """
        An object representing the Data Cells Filter's Row Filter. Either a Filter Expression or a Wildcard is required
        """
        return pulumi.get(self, "row_filter")

    @row_filter.setter
    def row_filter(self, value: Optional[pulumi.Input['DataCellsFilterRowFilterArgs']]):
        pulumi.set(self, "row_filter", value)


class DataCellsFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 column_wildcard: Optional[pulumi.Input[pulumi.InputType['DataCellsFilterColumnWildcardArgs']]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 row_filter: Optional[pulumi.Input[pulumi.InputType['DataCellsFilterRowFilterArgs']]] = None,
                 table_catalog_id: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A resource schema representing a Lake Formation Data Cells Filter.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] column_names: A list of columns to be included in this Data Cells Filter.
        :param pulumi.Input[pulumi.InputType['DataCellsFilterColumnWildcardArgs']] column_wildcard: An object representing the Data Cells Filter's Columns. Either Column Names or a Wildcard is required
        :param pulumi.Input[str] database_name: The name of the Database that the Table resides in.
        :param pulumi.Input[str] name: The desired name of the Data Cells Filter.
        :param pulumi.Input[pulumi.InputType['DataCellsFilterRowFilterArgs']] row_filter: An object representing the Data Cells Filter's Row Filter. Either a Filter Expression or a Wildcard is required
        :param pulumi.Input[str] table_catalog_id: The Catalog Id of the Table on which to create a Data Cells Filter.
        :param pulumi.Input[str] table_name: The name of the Table to create a Data Cells Filter for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataCellsFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A resource schema representing a Lake Formation Data Cells Filter.

        :param str resource_name: The name of the resource.
        :param DataCellsFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataCellsFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 column_wildcard: Optional[pulumi.Input[pulumi.InputType['DataCellsFilterColumnWildcardArgs']]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 row_filter: Optional[pulumi.Input[pulumi.InputType['DataCellsFilterRowFilterArgs']]] = None,
                 table_catalog_id: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataCellsFilterArgs.__new__(DataCellsFilterArgs)

            __props__.__dict__["column_names"] = column_names
            __props__.__dict__["column_wildcard"] = column_wildcard
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["name"] = name
            __props__.__dict__["row_filter"] = row_filter
            if table_catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'table_catalog_id'")
            __props__.__dict__["table_catalog_id"] = table_catalog_id
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["columnNames[*]", "columnWildcard", "databaseName", "name", "rowFilter", "tableCatalogId", "tableName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataCellsFilter, __self__).__init__(
            'aws-native:lakeformation:DataCellsFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataCellsFilter':
        """
        Get an existing DataCellsFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataCellsFilterArgs.__new__(DataCellsFilterArgs)

        __props__.__dict__["column_names"] = None
        __props__.__dict__["column_wildcard"] = None
        __props__.__dict__["database_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["row_filter"] = None
        __props__.__dict__["table_catalog_id"] = None
        __props__.__dict__["table_name"] = None
        return DataCellsFilter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of columns to be included in this Data Cells Filter.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="columnWildcard")
    def column_wildcard(self) -> pulumi.Output[Optional['outputs.DataCellsFilterColumnWildcard']]:
        """
        An object representing the Data Cells Filter's Columns. Either Column Names or a Wildcard is required
        """
        return pulumi.get(self, "column_wildcard")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        The name of the Database that the Table resides in.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The desired name of the Data Cells Filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> pulumi.Output[Optional['outputs.DataCellsFilterRowFilter']]:
        """
        An object representing the Data Cells Filter's Row Filter. Either a Filter Expression or a Wildcard is required
        """
        return pulumi.get(self, "row_filter")

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> pulumi.Output[str]:
        """
        The Catalog Id of the Table on which to create a Data Cells Filter.
        """
        return pulumi.get(self, "table_catalog_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[str]:
        """
        The name of the Table to create a Data Cells Filter for.
        """
        return pulumi.get(self, "table_name")

