# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['PlaybackRestrictionPolicyArgs', 'PlaybackRestrictionPolicy']

@pulumi.input_type
class PlaybackRestrictionPolicyArgs:
    def __init__(__self__, *,
                 allowed_countries: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 enable_strict_origin_enforcement: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a PlaybackRestrictionPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_countries: A list of country codes that control geoblocking restriction. Allowed values are the officially assigned ISO 3166-1 alpha-2 codes. Default: All countries (an empty array).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin
        :param pulumi.Input[bool] enable_strict_origin_enforcement: Whether channel playback is constrained by origin site.
        :param pulumi.Input[str] name: Playback-restriction-policy name.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "allowed_countries", allowed_countries)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if enable_strict_origin_enforcement is not None:
            pulumi.set(__self__, "enable_strict_origin_enforcement", enable_strict_origin_enforcement)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowedCountries")
    def allowed_countries(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of country codes that control geoblocking restriction. Allowed values are the officially assigned ISO 3166-1 alpha-2 codes. Default: All countries (an empty array).
        """
        return pulumi.get(self, "allowed_countries")

    @allowed_countries.setter
    def allowed_countries(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_countries", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="enableStrictOriginEnforcement")
    def enable_strict_origin_enforcement(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether channel playback is constrained by origin site.
        """
        return pulumi.get(self, "enable_strict_origin_enforcement")

    @enable_strict_origin_enforcement.setter
    def enable_strict_origin_enforcement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_strict_origin_enforcement", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Playback-restriction-policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class PlaybackRestrictionPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_countries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_strict_origin_enforcement: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IVS::PlaybackRestrictionPolicy.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_countries: A list of country codes that control geoblocking restriction. Allowed values are the officially assigned ISO 3166-1 alpha-2 codes. Default: All countries (an empty array).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin
        :param pulumi.Input[bool] enable_strict_origin_enforcement: Whether channel playback is constrained by origin site.
        :param pulumi.Input[str] name: Playback-restriction-policy name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlaybackRestrictionPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IVS::PlaybackRestrictionPolicy.

        :param str resource_name: The name of the resource.
        :param PlaybackRestrictionPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlaybackRestrictionPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_countries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_strict_origin_enforcement: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlaybackRestrictionPolicyArgs.__new__(PlaybackRestrictionPolicyArgs)

            if allowed_countries is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_countries'")
            __props__.__dict__["allowed_countries"] = allowed_countries
            if allowed_origins is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_origins'")
            __props__.__dict__["allowed_origins"] = allowed_origins
            __props__.__dict__["enable_strict_origin_enforcement"] = enable_strict_origin_enforcement
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(PlaybackRestrictionPolicy, __self__).__init__(
            'aws-native:ivs:PlaybackRestrictionPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PlaybackRestrictionPolicy':
        """
        Get an existing PlaybackRestrictionPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PlaybackRestrictionPolicyArgs.__new__(PlaybackRestrictionPolicyArgs)

        __props__.__dict__["allowed_countries"] = None
        __props__.__dict__["allowed_origins"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["enable_strict_origin_enforcement"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return PlaybackRestrictionPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedCountries")
    def allowed_countries(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of country codes that control geoblocking restriction. Allowed values are the officially assigned ISO 3166-1 alpha-2 codes. Default: All countries (an empty array).
        """
        return pulumi.get(self, "allowed_countries")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Playback-restriction-policy identifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="enableStrictOriginEnforcement")
    def enable_strict_origin_enforcement(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether channel playback is constrained by origin site.
        """
        return pulumi.get(self, "enable_strict_origin_enforcement")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Playback-restriction-policy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

