# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'RecordingConfigurationDestinationConfigurationArgs',
    'RecordingConfigurationRenditionConfigurationArgs',
    'RecordingConfigurationS3DestinationConfigurationArgs',
    'RecordingConfigurationThumbnailConfigurationArgs',
    'StorageConfigurationS3StorageConfigurationArgs',
    'VideoPropertiesArgs',
]

@pulumi.input_type
class RecordingConfigurationDestinationConfigurationArgs:
    def __init__(__self__, *,
                 s3: Optional[pulumi.Input['RecordingConfigurationS3DestinationConfigurationArgs']] = None):
        """
        Recording Destination Configuration.
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['RecordingConfigurationS3DestinationConfigurationArgs']]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['RecordingConfigurationS3DestinationConfigurationArgs']]):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class RecordingConfigurationRenditionConfigurationArgs:
    def __init__(__self__, *,
                 rendition_selection: Optional[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionSelection']] = None,
                 renditions: Optional[pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionsItem']]]] = None):
        """
        Rendition Configuration describes which renditions should be recorded for a stream.
        :param pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionSelection'] rendition_selection: Resolution Selection indicates which set of renditions are recorded for a stream.
        :param pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionsItem']]] renditions: Renditions indicates which renditions are recorded for a stream.
        """
        if rendition_selection is not None:
            pulumi.set(__self__, "rendition_selection", rendition_selection)
        if renditions is not None:
            pulumi.set(__self__, "renditions", renditions)

    @property
    @pulumi.getter(name="renditionSelection")
    def rendition_selection(self) -> Optional[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionSelection']]:
        """
        Resolution Selection indicates which set of renditions are recorded for a stream.
        """
        return pulumi.get(self, "rendition_selection")

    @rendition_selection.setter
    def rendition_selection(self, value: Optional[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionSelection']]):
        pulumi.set(self, "rendition_selection", value)

    @property
    @pulumi.getter
    def renditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionsItem']]]]:
        """
        Renditions indicates which renditions are recorded for a stream.
        """
        return pulumi.get(self, "renditions")

    @renditions.setter
    def renditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationRenditionConfigurationRenditionsItem']]]]):
        pulumi.set(self, "renditions", value)


@pulumi.input_type
class RecordingConfigurationS3DestinationConfigurationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str]):
        """
        Recording S3 Destination Configuration.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)


@pulumi.input_type
class RecordingConfigurationThumbnailConfigurationArgs:
    def __init__(__self__, *,
                 recording_mode: Optional[pulumi.Input['RecordingConfigurationThumbnailConfigurationRecordingMode']] = None,
                 resolution: Optional[pulumi.Input['RecordingConfigurationThumbnailConfigurationResolution']] = None,
                 storage: Optional[pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationThumbnailConfigurationStorageItem']]]] = None,
                 target_interval_seconds: Optional[pulumi.Input[int]] = None):
        """
        Recording Thumbnail Configuration.
        :param pulumi.Input['RecordingConfigurationThumbnailConfigurationRecordingMode'] recording_mode: Thumbnail Recording Mode, which determines whether thumbnails are recorded at an interval or are disabled.
        :param pulumi.Input['RecordingConfigurationThumbnailConfigurationResolution'] resolution: Resolution indicates the desired resolution of recorded thumbnails.
        :param pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationThumbnailConfigurationStorageItem']]] storage: Storage indicates the format in which thumbnails are recorded.
        :param pulumi.Input[int] target_interval_seconds: Target Interval Seconds defines the interval at which thumbnails are recorded. This field is required if RecordingMode is INTERVAL.
        """
        if recording_mode is not None:
            pulumi.set(__self__, "recording_mode", recording_mode)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if target_interval_seconds is not None:
            pulumi.set(__self__, "target_interval_seconds", target_interval_seconds)

    @property
    @pulumi.getter(name="recordingMode")
    def recording_mode(self) -> Optional[pulumi.Input['RecordingConfigurationThumbnailConfigurationRecordingMode']]:
        """
        Thumbnail Recording Mode, which determines whether thumbnails are recorded at an interval or are disabled.
        """
        return pulumi.get(self, "recording_mode")

    @recording_mode.setter
    def recording_mode(self, value: Optional[pulumi.Input['RecordingConfigurationThumbnailConfigurationRecordingMode']]):
        pulumi.set(self, "recording_mode", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input['RecordingConfigurationThumbnailConfigurationResolution']]:
        """
        Resolution indicates the desired resolution of recorded thumbnails.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input['RecordingConfigurationThumbnailConfigurationResolution']]):
        pulumi.set(self, "resolution", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationThumbnailConfigurationStorageItem']]]]:
        """
        Storage indicates the format in which thumbnails are recorded.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordingConfigurationThumbnailConfigurationStorageItem']]]]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter(name="targetIntervalSeconds")
    def target_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Target Interval Seconds defines the interval at which thumbnails are recorded. This field is required if RecordingMode is INTERVAL.
        """
        return pulumi.get(self, "target_interval_seconds")

    @target_interval_seconds.setter
    def target_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_interval_seconds", value)


@pulumi.input_type
class StorageConfigurationS3StorageConfigurationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str]):
        """
        A complex type that describes an S3 location where recorded videos will be stored.
        :param pulumi.Input[str] bucket_name: Location (S3 bucket name) where recorded videos will be stored. Note that the StorageConfiguration and S3 bucket must be in the same region as the Composition.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Location (S3 bucket name) where recorded videos will be stored. Note that the StorageConfiguration and S3 bucket must be in the same region as the Composition.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)


@pulumi.input_type
class VideoPropertiesArgs:
    def __init__(__self__, *,
                 bitrate: Optional[pulumi.Input[int]] = None,
                 framerate: Optional[pulumi.Input[float]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        Video configuration. Default: video resolution 1280x720, bitrate 2500 kbps, 30 fps
        :param pulumi.Input[int] bitrate: Bitrate for generated output, in bps. Default: 2500000.
        :param pulumi.Input[float] framerate: Video frame rate, in fps. Default: 30.
        :param pulumi.Input[int] height: Video-resolution height. Note that the maximum value is determined by width times height, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 720.
        :param pulumi.Input[int] width: Video-resolution width. Note that the maximum value is determined by width times height, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 1280.
        """
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if framerate is not None:
            pulumi.set(__self__, "framerate", framerate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Bitrate for generated output, in bps. Default: 2500000.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def framerate(self) -> Optional[pulumi.Input[float]]:
        """
        Video frame rate, in fps. Default: 30.
        """
        return pulumi.get(self, "framerate")

    @framerate.setter
    def framerate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "framerate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        Video-resolution height. Note that the maximum value is determined by width times height, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 720.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        Video-resolution width. Note that the maximum value is determined by width times height, such that the maximum total pixels is 2073600 (1920x1080 or 1080x1920). Default: 1280.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


