# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SyncJobArgs', 'SyncJob']

@pulumi.input_type
class SyncJobArgs:
    def __init__(__self__, *,
                 sync_role: pulumi.Input[str],
                 sync_source: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SyncJob resource.
        :param pulumi.Input[str] sync_role: The IAM Role that execute SyncJob.
        :param pulumi.Input[str] sync_source: The source of the SyncJob.
        :param pulumi.Input[str] workspace_id: The ID of the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "sync_role", sync_role)
        pulumi.set(__self__, "sync_source", sync_source)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> pulumi.Input[str]:
        """
        The IAM Role that execute SyncJob.
        """
        return pulumi.get(self, "sync_role")

    @sync_role.setter
    def sync_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "sync_role", value)

    @property
    @pulumi.getter(name="syncSource")
    def sync_source(self) -> pulumi.Input[str]:
        """
        The source of the SyncJob.
        """
        return pulumi.get(self, "sync_source")

    @sync_source.setter
    def sync_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "sync_source", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class SyncJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sync_role: Optional[pulumi.Input[str]] = None,
                 sync_source: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::IoTTwinMaker::SyncJob

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] sync_role: The IAM Role that execute SyncJob.
        :param pulumi.Input[str] sync_source: The source of the SyncJob.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A key-value pair to associate with a resource.
        :param pulumi.Input[str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyncJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::IoTTwinMaker::SyncJob

        :param str resource_name: The name of the resource.
        :param SyncJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyncJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sync_role: Optional[pulumi.Input[str]] = None,
                 sync_source: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyncJobArgs.__new__(SyncJobArgs)

            if sync_role is None and not opts.urn:
                raise TypeError("Missing required property 'sync_role'")
            __props__.__dict__["sync_role"] = sync_role
            if sync_source is None and not opts.urn:
                raise TypeError("Missing required property 'sync_source'")
            __props__.__dict__["sync_source"] = sync_source
            __props__.__dict__["tags"] = tags
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_date_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_date_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["syncRole", "syncSource", "tags.*", "workspaceId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SyncJob, __self__).__init__(
            'aws-native:iottwinmaker:SyncJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SyncJob':
        """
        Get an existing SyncJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SyncJobArgs.__new__(SyncJobArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["creation_date_time"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["sync_role"] = None
        __props__.__dict__["sync_source"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["update_date_time"] = None
        __props__.__dict__["workspace_id"] = None
        return SyncJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the SyncJob.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationDateTime")
    def creation_date_time(self) -> pulumi.Output[str]:
        """
        The date and time when the sync job was created.
        """
        return pulumi.get(self, "creation_date_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of SyncJob.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> pulumi.Output[str]:
        """
        The IAM Role that execute SyncJob.
        """
        return pulumi.get(self, "sync_role")

    @property
    @pulumi.getter(name="syncSource")
    def sync_source(self) -> pulumi.Output[str]:
        """
        The source of the SyncJob.
        """
        return pulumi.get(self, "sync_source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateDateTime")
    def update_date_time(self) -> pulumi.Output[str]:
        """
        The date and time when the sync job was updated.
        """
        return pulumi.get(self, "update_date_time")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

