# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetCisScanConfigurationResult',
    'AwaitableGetCisScanConfigurationResult',
    'get_cis_scan_configuration',
    'get_cis_scan_configuration_output',
]

@pulumi.output_type
class GetCisScanConfigurationResult:
    def __init__(__self__, arn=None, scan_name=None, schedule=None, security_level=None, tags=None, targets=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if scan_name and not isinstance(scan_name, str):
            raise TypeError("Expected argument 'scan_name' to be a str")
        pulumi.set(__self__, "scan_name", scan_name)
        if schedule and not isinstance(schedule, dict):
            raise TypeError("Expected argument 'schedule' to be a dict")
        pulumi.set(__self__, "schedule", schedule)
        if security_level and not isinstance(security_level, str):
            raise TypeError("Expected argument 'security_level' to be a str")
        pulumi.set(__self__, "security_level", security_level)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if targets and not isinstance(targets, dict):
            raise TypeError("Expected argument 'targets' to be a dict")
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        CIS Scan configuration unique identifier
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="scanName")
    def scan_name(self) -> Optional[str]:
        """
        Name of the scan
        """
        return pulumi.get(self, "scan_name")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.CisScanConfigurationSchedule']:
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional['CisScanConfigurationCisSecurityLevel']:
        return pulumi.get(self, "security_level")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def targets(self) -> Optional['outputs.CisScanConfigurationCisTargets']:
        return pulumi.get(self, "targets")


class AwaitableGetCisScanConfigurationResult(GetCisScanConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCisScanConfigurationResult(
            arn=self.arn,
            scan_name=self.scan_name,
            schedule=self.schedule,
            security_level=self.security_level,
            tags=self.tags,
            targets=self.targets)


def get_cis_scan_configuration(arn: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCisScanConfigurationResult:
    """
    CIS Scan Configuration resource schema


    :param str arn: CIS Scan configuration unique identifier
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:inspectorv2:getCisScanConfiguration', __args__, opts=opts, typ=GetCisScanConfigurationResult).value

    return AwaitableGetCisScanConfigurationResult(
        arn=pulumi.get(__ret__, 'arn'),
        scan_name=pulumi.get(__ret__, 'scan_name'),
        schedule=pulumi.get(__ret__, 'schedule'),
        security_level=pulumi.get(__ret__, 'security_level'),
        tags=pulumi.get(__ret__, 'tags'),
        targets=pulumi.get(__ret__, 'targets'))


@_utilities.lift_output_func(get_cis_scan_configuration)
def get_cis_scan_configuration_output(arn: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCisScanConfigurationResult]:
    """
    CIS Scan Configuration resource schema


    :param str arn: CIS Scan configuration unique identifier
    """
    ...
