# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 assume_role_policy_document: Any,
                 description: Optional[pulumi.Input[str]] = None,
                 managed_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['RolePolicyArgs']]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param Any assume_role_policy_document: The trust policy that is associated with this role. Trust policies define which entities can assume the role. You can associate only one trust policy with a role. For an example of a policy that can be used to assume a role, see [Template Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#aws-resource-iam-role--examples). For more information about the elements that you can use in an IAM policy, see [Policy Elements Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html) in the *User Guide*.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::IAM::Role` for more information about the expected schema for this property.
        :param pulumi.Input[str] description: A description of the role that you provide.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_policy_arns: A list of Amazon Resource Names (ARNs) of the IAM managed policies that you want to attach to the role.
                For more information about ARNs, see [Amazon Resource Names (ARNs) and Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        :param pulumi.Input[int] max_session_duration: The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12 hours.
                Anyone who assumes the role from the CLI or API can use the ``DurationSeconds`` API parameter or the ``duration-seconds`` CLI parameter to request a longer session. The ``MaxSessionDuration`` setting determines the maximum duration that can be requested using the ``DurationSeconds`` parameter. If users don't specify a value for the ``DurationSeconds`` parameter, their security credentials are valid for one hour by default. This applies when you use the ``AssumeRole*`` API operations or the ``assume-role*`` CLI operations but does not apply when you use those operations to create a console URL. For more information, see [Using IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) in the *IAM User Guide*.
        :param pulumi.Input[str] path: The path to the role. For more information about paths, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
                This parameter is optional. If it is not included, it defaults to a slash (/).
                This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (``\\u0021``) through the DEL character (``\\u007F``), including most punctuation characters, digits, and upper and lowercased letters.
        :param pulumi.Input[str] permissions_boundary: The ARN of the policy used to set the permissions boundary for the role.
                For more information about permissions boundaries, see [Permissions boundaries for IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['RolePolicyArgs']]] policies: Adds or updates an inline policy document that is embedded in the specified IAM role.
                When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions) policy. The role's trust policy is created at the same time as the role. You can update a role's trust policy later. For more information about IAM roles, go to [Using Roles to Delegate Permissions and Federate Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
                A role can also have an attached managed policy. For information about policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
                For information about limits on the number of inline policies that you can embed with a role, see [Limitations on Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html) in the *User Guide*.
                 If an external policy (such as ``AWS::IAM::Policy`` or
        :param pulumi.Input[str] role_name: A name for the IAM role, up to 64 characters in length. For valid values, see the ``RoleName`` parameter for the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) action in the *User Guide*.
                This parameter allows (per its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. The role name must be unique within the account. Role names are not distinguished by case. For example, you cannot create roles named both "Role1" and "role1".
                If you don't specify a name, CFN generates a unique physical ID and uses that ID for the role name.
                If you specify a name, you must specify the ``CAPABILITY_NAMED_IAM`` value to acknowledge your template's capabilities. For more information, see [Acknowledging Resources in Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/Use
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags that are attached to the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
        """
        pulumi.set(__self__, "assume_role_policy_document", assume_role_policy_document)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if managed_policy_arns is not None:
            pulumi.set(__self__, "managed_policy_arns", managed_policy_arns)
        if max_session_duration is not None:
            pulumi.set(__self__, "max_session_duration", max_session_duration)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permissions_boundary is not None:
            pulumi.set(__self__, "permissions_boundary", permissions_boundary)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> Any:
        """
        The trust policy that is associated with this role. Trust policies define which entities can assume the role. You can associate only one trust policy with a role. For an example of a policy that can be used to assume a role, see [Template Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#aws-resource-iam-role--examples). For more information about the elements that you can use in an IAM policy, see [Policy Elements Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html) in the *User Guide*.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::IAM::Role` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "assume_role_policy_document")

    @assume_role_policy_document.setter
    def assume_role_policy_document(self, value: Any):
        pulumi.set(self, "assume_role_policy_document", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the role that you provide.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="managedPolicyArns")
    def managed_policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Amazon Resource Names (ARNs) of the IAM managed policies that you want to attach to the role.
         For more information about ARNs, see [Amazon Resource Names (ARNs) and Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        """
        return pulumi.get(self, "managed_policy_arns")

    @managed_policy_arns.setter
    def managed_policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "managed_policy_arns", value)

    @property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12 hours.
         Anyone who assumes the role from the CLI or API can use the ``DurationSeconds`` API parameter or the ``duration-seconds`` CLI parameter to request a longer session. The ``MaxSessionDuration`` setting determines the maximum duration that can be requested using the ``DurationSeconds`` parameter. If users don't specify a value for the ``DurationSeconds`` parameter, their security credentials are valid for one hour by default. This applies when you use the ``AssumeRole*`` API operations or the ``assume-role*`` CLI operations but does not apply when you use those operations to create a console URL. For more information, see [Using IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) in the *IAM User Guide*.
        """
        return pulumi.get(self, "max_session_duration")

    @max_session_duration.setter
    def max_session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_session_duration", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the role. For more information about paths, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         This parameter is optional. If it is not included, it defaults to a slash (/).
         This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (``\\u0021``) through the DEL character (``\\u007F``), including most punctuation characters, digits, and upper and lowercased letters.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permissionsBoundary")
    def permissions_boundary(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the policy used to set the permissions boundary for the role.
         For more information about permissions boundaries, see [Permissions boundaries for IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
        """
        return pulumi.get(self, "permissions_boundary")

    @permissions_boundary.setter
    def permissions_boundary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RolePolicyArgs']]]]:
        """
        Adds or updates an inline policy document that is embedded in the specified IAM role.
         When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions) policy. The role's trust policy is created at the same time as the role. You can update a role's trust policy later. For more information about IAM roles, go to [Using Roles to Delegate Permissions and Federate Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
         A role can also have an attached managed policy. For information about policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
         For information about limits on the number of inline policies that you can embed with a role, see [Limitations on Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html) in the *User Guide*.
          If an external policy (such as ``AWS::IAM::Policy`` or
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RolePolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the IAM role, up to 64 characters in length. For valid values, see the ``RoleName`` parameter for the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) action in the *User Guide*.
         This parameter allows (per its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. The role name must be unique within the account. Role names are not distinguished by case. For example, you cannot create roles named both "Role1" and "role1".
         If you don't specify a name, CFN generates a unique physical ID and uses that ID for the role name.
         If you specify a name, you must specify the ``CAPABILITY_NAMED_IAM`` value to acknowledge your template's capabilities. For more information, see [Acknowledging Resources in Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/Use
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags that are attached to the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_policy_document: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 managed_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RolePolicyArgs']]]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Creates a new role for your AWS-account.
          For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For information about quotas for role names and the number of roles you can create, see [IAM and quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        iam_role = aws_native.iam.Role("iamRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "cloudformation.amazonaws.com",
                            "gamelift.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            },
            role_name="ScriptIAMRole",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="ScriptResourceIAMPolicy",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": [
                            "s3:GetObject",
                            "s3:GetObjectVersion",
                            "s3:GetObjectMetadata",
                            "s3:*Object*",
                        ],
                        "resource": ["*"],
                    }],
                },
            )])
        script_resource = aws_native.gamelift.Script("scriptResource",
            name="MyRealtimeScript",
            version="v1.0",
            storage_location=aws_native.gamelift.ScriptS3LocationArgs(
                bucket="MyBucketName",
                key="MyScriptFiles.zip",
                role_arn=iam_role.arn,
            ))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        iam_role = aws_native.iam.Role("iamRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "cloudformation.amazonaws.com",
                            "gamelift.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            },
            role_name="ScriptIAMRole",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="ScriptResourceIAMPolicy",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": [
                            "s3:GetObject",
                            "s3:GetObjectVersion",
                            "s3:GetObjectMetadata",
                            "s3:*Object*",
                        ],
                        "resource": ["*"],
                    }],
                },
            )])
        script_resource = aws_native.gamelift.Script("scriptResource",
            name="MyRealtimeScript",
            version="v1.0",
            storage_location=aws_native.gamelift.ScriptS3LocationArgs(
                bucket="MyBucketName",
                key="MyScriptFiles.zip",
                role_arn=iam_role.arn,
            ))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        amazon_grafana_workspace_iam_role = aws_native.iam.Role("amazonGrafanaWorkspaceIAMRole",
            managed_policy_arns=["arn:aws:iam::aws:policy/service-role/AmazonGrafanaAthenaAccess"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["grafana.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            })
        amazon_grafana_workspace = aws_native.grafana.Workspace("amazonGrafanaWorkspace",
            account_access_type=aws_native.grafana.WorkspaceAccountAccessType.CURRENT_ACCOUNT,
            name="AmazonGrafanaWorkspace",
            description="Amazon Grafana Workspace",
            authentication_providers=[aws_native.grafana.WorkspaceAuthenticationProviderTypes.SAML],
            permission_type=aws_native.grafana.WorkspacePermissionType.CUSTOMER_MANAGED,
            grafana_version="9.4",
            role_arn=amazon_grafana_workspace_iam_role.arn,
            saml_configuration=aws_native.grafana.WorkspaceSamlConfigurationArgs(
                idp_metadata=aws_native.grafana.WorkspaceIdpMetadataArgs(
                    xml="<md:EntityDescriptor xmlns:md='urn:oasis:names:tc:SAML:2.0:metadata' entityID='entityId'>DATA</md:EntityDescriptor>",
                ),
                assertion_attributes=aws_native.grafana.WorkspaceAssertionAttributesArgs(
                    name="displayName",
                    login="login",
                    email="email",
                    groups="group",
                    role="role",
                    org="org",
                ),
                role_values=aws_native.grafana.WorkspaceRoleValuesArgs(
                    editor=["editor1"],
                    admin=["admin1"],
                ),
                allowed_organizations=["org1"],
                login_validity_duration=60,
            ))
        pulumi.export("workspaceEndpoint", amazon_grafana_workspace.endpoint)
        pulumi.export("workspaceStatus", amazon_grafana_workspace.status)
        pulumi.export("workspaceId", amazon_grafana_workspace.id)
        pulumi.export("grafanaVersion", amazon_grafana_workspace.grafana_version)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        amazon_grafana_workspace_iam_role = aws_native.iam.Role("amazonGrafanaWorkspaceIAMRole",
            managed_policy_arns=["arn:aws:iam::aws:policy/service-role/AmazonGrafanaAthenaAccess"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["grafana.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            })
        amazon_grafana_workspace = aws_native.grafana.Workspace("amazonGrafanaWorkspace",
            account_access_type=aws_native.grafana.WorkspaceAccountAccessType.CURRENT_ACCOUNT,
            name="AmazonGrafanaWorkspace",
            description="Amazon Grafana Workspace",
            authentication_providers=[aws_native.grafana.WorkspaceAuthenticationProviderTypes.SAML],
            permission_type=aws_native.grafana.WorkspacePermissionType.CUSTOMER_MANAGED,
            grafana_version="9.4",
            role_arn=amazon_grafana_workspace_iam_role.arn,
            saml_configuration=aws_native.grafana.WorkspaceSamlConfigurationArgs(
                idp_metadata=aws_native.grafana.WorkspaceIdpMetadataArgs(
                    xml="<md:EntityDescriptor xmlns:md='urn:oasis:names:tc:SAML:2.0:metadata' entityID='entityId'>DATA</md:EntityDescriptor>",
                ),
                assertion_attributes=aws_native.grafana.WorkspaceAssertionAttributesArgs(
                    name="displayName",
                    login="login",
                    email="email",
                    groups="group",
                    role="role",
                    org="org",
                ),
                role_values=aws_native.grafana.WorkspaceRoleValuesArgs(
                    editor=["editor1"],
                    admin=["admin1"],
                ),
                allowed_organizations=["org1"],
                login_validity_duration=60,
            ))
        pulumi.export("workspaceEndpoint", amazon_grafana_workspace.endpoint)
        pulumi.export("workspaceStatus", amazon_grafana_workspace.status)
        pulumi.export("workspaceId", amazon_grafana_workspace.id)
        pulumi.export("grafanaVersion", amazon_grafana_workspace.grafana_version)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        root_role = aws_native.iam.Role("rootRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["ec2.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            },
            path="/",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="root",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": "*",
                        "resource": "*",
                    }],
                },
            )])
        root_instance_profile = aws_native.iam.InstanceProfile("rootInstanceProfile",
            path="/",
            roles=[root_role.id])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        root_role = aws_native.iam.Role("rootRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["ec2.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            },
            path="/",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="root",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": "*",
                        "resource": "*",
                    }],
                },
            )])
        root_instance_profile = aws_native.iam.InstanceProfile("rootInstanceProfile",
            path="/",
            roles=[root_role.id])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        automation_execution_role = aws_native.iam.Role("automationExecutionRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": "ssm.amazonaws.com",
                    },
                    "action": ["sts:AssumeRole"],
                }],
            },
            path="/",
            managed_policy_arns=["arn:${AWS::Partition}:iam::aws:policy/AmazonEC2FullAccess"])
        automation_association = aws_native.ssm.Association("automationAssociation",
            name="AWS-StopEC2Instance",
            parameters={
                "automationAssumeRole": ["AutomationExecutionRole.Arn"],
            },
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="ParameterValues",
                values=["i-1234567890abcdef0"],
            )],
            automation_target_parameter_name="InstanceId")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any assume_role_policy_document: The trust policy that is associated with this role. Trust policies define which entities can assume the role. You can associate only one trust policy with a role. For an example of a policy that can be used to assume a role, see [Template Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#aws-resource-iam-role--examples). For more information about the elements that you can use in an IAM policy, see [Policy Elements Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html) in the *User Guide*.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::IAM::Role` for more information about the expected schema for this property.
        :param pulumi.Input[str] description: A description of the role that you provide.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_policy_arns: A list of Amazon Resource Names (ARNs) of the IAM managed policies that you want to attach to the role.
                For more information about ARNs, see [Amazon Resource Names (ARNs) and Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        :param pulumi.Input[int] max_session_duration: The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12 hours.
                Anyone who assumes the role from the CLI or API can use the ``DurationSeconds`` API parameter or the ``duration-seconds`` CLI parameter to request a longer session. The ``MaxSessionDuration`` setting determines the maximum duration that can be requested using the ``DurationSeconds`` parameter. If users don't specify a value for the ``DurationSeconds`` parameter, their security credentials are valid for one hour by default. This applies when you use the ``AssumeRole*`` API operations or the ``assume-role*`` CLI operations but does not apply when you use those operations to create a console URL. For more information, see [Using IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) in the *IAM User Guide*.
        :param pulumi.Input[str] path: The path to the role. For more information about paths, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
                This parameter is optional. If it is not included, it defaults to a slash (/).
                This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (``\\u0021``) through the DEL character (``\\u007F``), including most punctuation characters, digits, and upper and lowercased letters.
        :param pulumi.Input[str] permissions_boundary: The ARN of the policy used to set the permissions boundary for the role.
                For more information about permissions boundaries, see [Permissions boundaries for IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RolePolicyArgs']]]] policies: Adds or updates an inline policy document that is embedded in the specified IAM role.
                When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions) policy. The role's trust policy is created at the same time as the role. You can update a role's trust policy later. For more information about IAM roles, go to [Using Roles to Delegate Permissions and Federate Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
                A role can also have an attached managed policy. For information about policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
                For information about limits on the number of inline policies that you can embed with a role, see [Limitations on Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html) in the *User Guide*.
                 If an external policy (such as ``AWS::IAM::Policy`` or
        :param pulumi.Input[str] role_name: A name for the IAM role, up to 64 characters in length. For valid values, see the ``RoleName`` parameter for the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) action in the *User Guide*.
                This parameter allows (per its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. The role name must be unique within the account. Role names are not distinguished by case. For example, you cannot create roles named both "Role1" and "role1".
                If you don't specify a name, CFN generates a unique physical ID and uses that ID for the role name.
                If you specify a name, you must specify the ``CAPABILITY_NAMED_IAM`` value to acknowledge your template's capabilities. For more information, see [Acknowledging Resources in Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/Use
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: A list of tags that are attached to the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new role for your AWS-account.
          For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For information about quotas for role names and the number of roles you can create, see [IAM and quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        iam_role = aws_native.iam.Role("iamRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "cloudformation.amazonaws.com",
                            "gamelift.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            },
            role_name="ScriptIAMRole",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="ScriptResourceIAMPolicy",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": [
                            "s3:GetObject",
                            "s3:GetObjectVersion",
                            "s3:GetObjectMetadata",
                            "s3:*Object*",
                        ],
                        "resource": ["*"],
                    }],
                },
            )])
        script_resource = aws_native.gamelift.Script("scriptResource",
            name="MyRealtimeScript",
            version="v1.0",
            storage_location=aws_native.gamelift.ScriptS3LocationArgs(
                bucket="MyBucketName",
                key="MyScriptFiles.zip",
                role_arn=iam_role.arn,
            ))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        iam_role = aws_native.iam.Role("iamRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": [
                            "cloudformation.amazonaws.com",
                            "gamelift.amazonaws.com",
                        ],
                    },
                    "action": "sts:AssumeRole",
                }],
            },
            role_name="ScriptIAMRole",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="ScriptResourceIAMPolicy",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": [
                            "s3:GetObject",
                            "s3:GetObjectVersion",
                            "s3:GetObjectMetadata",
                            "s3:*Object*",
                        ],
                        "resource": ["*"],
                    }],
                },
            )])
        script_resource = aws_native.gamelift.Script("scriptResource",
            name="MyRealtimeScript",
            version="v1.0",
            storage_location=aws_native.gamelift.ScriptS3LocationArgs(
                bucket="MyBucketName",
                key="MyScriptFiles.zip",
                role_arn=iam_role.arn,
            ))

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        amazon_grafana_workspace_iam_role = aws_native.iam.Role("amazonGrafanaWorkspaceIAMRole",
            managed_policy_arns=["arn:aws:iam::aws:policy/service-role/AmazonGrafanaAthenaAccess"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["grafana.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            })
        amazon_grafana_workspace = aws_native.grafana.Workspace("amazonGrafanaWorkspace",
            account_access_type=aws_native.grafana.WorkspaceAccountAccessType.CURRENT_ACCOUNT,
            name="AmazonGrafanaWorkspace",
            description="Amazon Grafana Workspace",
            authentication_providers=[aws_native.grafana.WorkspaceAuthenticationProviderTypes.SAML],
            permission_type=aws_native.grafana.WorkspacePermissionType.CUSTOMER_MANAGED,
            grafana_version="9.4",
            role_arn=amazon_grafana_workspace_iam_role.arn,
            saml_configuration=aws_native.grafana.WorkspaceSamlConfigurationArgs(
                idp_metadata=aws_native.grafana.WorkspaceIdpMetadataArgs(
                    xml="<md:EntityDescriptor xmlns:md='urn:oasis:names:tc:SAML:2.0:metadata' entityID='entityId'>DATA</md:EntityDescriptor>",
                ),
                assertion_attributes=aws_native.grafana.WorkspaceAssertionAttributesArgs(
                    name="displayName",
                    login="login",
                    email="email",
                    groups="group",
                    role="role",
                    org="org",
                ),
                role_values=aws_native.grafana.WorkspaceRoleValuesArgs(
                    editor=["editor1"],
                    admin=["admin1"],
                ),
                allowed_organizations=["org1"],
                login_validity_duration=60,
            ))
        pulumi.export("workspaceEndpoint", amazon_grafana_workspace.endpoint)
        pulumi.export("workspaceStatus", amazon_grafana_workspace.status)
        pulumi.export("workspaceId", amazon_grafana_workspace.id)
        pulumi.export("grafanaVersion", amazon_grafana_workspace.grafana_version)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        amazon_grafana_workspace_iam_role = aws_native.iam.Role("amazonGrafanaWorkspaceIAMRole",
            managed_policy_arns=["arn:aws:iam::aws:policy/service-role/AmazonGrafanaAthenaAccess"],
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["grafana.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            })
        amazon_grafana_workspace = aws_native.grafana.Workspace("amazonGrafanaWorkspace",
            account_access_type=aws_native.grafana.WorkspaceAccountAccessType.CURRENT_ACCOUNT,
            name="AmazonGrafanaWorkspace",
            description="Amazon Grafana Workspace",
            authentication_providers=[aws_native.grafana.WorkspaceAuthenticationProviderTypes.SAML],
            permission_type=aws_native.grafana.WorkspacePermissionType.CUSTOMER_MANAGED,
            grafana_version="9.4",
            role_arn=amazon_grafana_workspace_iam_role.arn,
            saml_configuration=aws_native.grafana.WorkspaceSamlConfigurationArgs(
                idp_metadata=aws_native.grafana.WorkspaceIdpMetadataArgs(
                    xml="<md:EntityDescriptor xmlns:md='urn:oasis:names:tc:SAML:2.0:metadata' entityID='entityId'>DATA</md:EntityDescriptor>",
                ),
                assertion_attributes=aws_native.grafana.WorkspaceAssertionAttributesArgs(
                    name="displayName",
                    login="login",
                    email="email",
                    groups="group",
                    role="role",
                    org="org",
                ),
                role_values=aws_native.grafana.WorkspaceRoleValuesArgs(
                    editor=["editor1"],
                    admin=["admin1"],
                ),
                allowed_organizations=["org1"],
                login_validity_duration=60,
            ))
        pulumi.export("workspaceEndpoint", amazon_grafana_workspace.endpoint)
        pulumi.export("workspaceStatus", amazon_grafana_workspace.status)
        pulumi.export("workspaceId", amazon_grafana_workspace.id)
        pulumi.export("grafanaVersion", amazon_grafana_workspace.grafana_version)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        root_role = aws_native.iam.Role("rootRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["ec2.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            },
            path="/",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="root",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": "*",
                        "resource": "*",
                    }],
                },
            )])
        root_instance_profile = aws_native.iam.InstanceProfile("rootInstanceProfile",
            path="/",
            roles=[root_role.id])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        root_role = aws_native.iam.Role("rootRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": ["ec2.amazonaws.com"],
                    },
                    "action": ["sts:AssumeRole"],
                }],
            },
            path="/",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="root",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": "*",
                        "resource": "*",
                    }],
                },
            )])
        root_instance_profile = aws_native.iam.InstanceProfile("rootInstanceProfile",
            path="/",
            roles=[root_role.id])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        automation_execution_role = aws_native.iam.Role("automationExecutionRole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": "ssm.amazonaws.com",
                    },
                    "action": ["sts:AssumeRole"],
                }],
            },
            path="/",
            managed_policy_arns=["arn:${AWS::Partition}:iam::aws:policy/AmazonEC2FullAccess"])
        automation_association = aws_native.ssm.Association("automationAssociation",
            name="AWS-StopEC2Instance",
            parameters={
                "automationAssumeRole": ["AutomationExecutionRole.Arn"],
            },
            targets=[aws_native.ssm.AssociationTargetArgs(
                key="ParameterValues",
                values=["i-1234567890abcdef0"],
            )],
            automation_target_parameter_name="InstanceId")

        ```

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_policy_document: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 managed_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 permissions_boundary: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RolePolicyArgs']]]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            if assume_role_policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'assume_role_policy_document'")
            __props__.__dict__["assume_role_policy_document"] = assume_role_policy_document
            __props__.__dict__["description"] = description
            __props__.__dict__["managed_policy_arns"] = managed_policy_arns
            __props__.__dict__["max_session_duration"] = max_session_duration
            __props__.__dict__["path"] = path
            __props__.__dict__["permissions_boundary"] = permissions_boundary
            __props__.__dict__["policies"] = policies
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["role_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["path", "roleName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Role, __self__).__init__(
            'aws-native:iam:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RoleArgs.__new__(RoleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["assume_role_policy_document"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["managed_policy_arns"] = None
        __props__.__dict__["max_session_duration"] = None
        __props__.__dict__["path"] = None
        __props__.__dict__["permissions_boundary"] = None
        __props__.__dict__["policies"] = None
        __props__.__dict__["role_id"] = None
        __props__.__dict__["role_name"] = None
        __props__.__dict__["tags"] = None
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> pulumi.Output[Any]:
        """
        The trust policy that is associated with this role. Trust policies define which entities can assume the role. You can associate only one trust policy with a role. For an example of a policy that can be used to assume a role, see [Template Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html#aws-resource-iam-role--examples). For more information about the elements that you can use in an IAM policy, see [Policy Elements Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html) in the *User Guide*.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::IAM::Role` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "assume_role_policy_document")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the role that you provide.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="managedPolicyArns")
    def managed_policy_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Amazon Resource Names (ARNs) of the IAM managed policies that you want to attach to the role.
         For more information about ARNs, see [Amazon Resource Names (ARNs) and Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        """
        return pulumi.get(self, "managed_policy_arns")

    @property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12 hours.
         Anyone who assumes the role from the CLI or API can use the ``DurationSeconds`` API parameter or the ``duration-seconds`` CLI parameter to request a longer session. The ``MaxSessionDuration`` setting determines the maximum duration that can be requested using the ``DurationSeconds`` parameter. If users don't specify a value for the ``DurationSeconds`` parameter, their security credentials are valid for one hour by default. This applies when you use the ``AssumeRole*`` API operations or the ``assume-role*`` CLI operations but does not apply when you use those operations to create a console URL. For more information, see [Using IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) in the *IAM User Guide*.
        """
        return pulumi.get(self, "max_session_duration")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        The path to the role. For more information about paths, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         This parameter is optional. If it is not included, it defaults to a slash (/).
         This parameter allows (through its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (``\\u0021``) through the DEL character (``\\u007F``), including most punctuation characters, digits, and upper and lowercased letters.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="permissionsBoundary")
    def permissions_boundary(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the policy used to set the permissions boundary for the role.
         For more information about permissions boundaries, see [Permissions boundaries for IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
        """
        return pulumi.get(self, "permissions_boundary")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence['outputs.RolePolicy']]]:
        """
        Adds or updates an inline policy document that is embedded in the specified IAM role.
         When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions) policy. The role's trust policy is created at the same time as the role. You can update a role's trust policy later. For more information about IAM roles, go to [Using Roles to Delegate Permissions and Federate Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
         A role can also have an attached managed policy. For information about policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
         For information about limits on the number of inline policies that you can embed with a role, see [Limitations on Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html) in the *User Guide*.
          If an external policy (such as ``AWS::IAM::Policy`` or
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        A name for the IAM role, up to 64 characters in length. For valid values, see the ``RoleName`` parameter for the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) action in the *User Guide*.
         This parameter allows (per its [regex pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. The role name must be unique within the account. Role names are not distinguished by case. For example, you cannot create roles named both "Role1" and "role1".
         If you don't specify a name, CFN generates a unique physical ID and uses that ID for the role name.
         If you specify a name, you must specify the ``CAPABILITY_NAMED_IAM`` value to acknowledge your template's capabilities. For more information, see [Acknowledging Resources in Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/Use
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags that are attached to the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
        """
        return pulumi.get(self, "tags")

