# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetOidcProviderResult',
    'AwaitableGetOidcProviderResult',
    'get_oidc_provider',
    'get_oidc_provider_output',
]

@pulumi.output_type
class GetOidcProviderResult:
    def __init__(__self__, arn=None, client_id_list=None, tags=None, thumbprint_list=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if client_id_list and not isinstance(client_id_list, list):
            raise TypeError("Expected argument 'client_id_list' to be a list")
        pulumi.set(__self__, "client_id_list", client_id_list)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if thumbprint_list and not isinstance(thumbprint_list, list):
            raise TypeError("Expected argument 'thumbprint_list' to be a list")
        pulumi.set(__self__, "thumbprint_list", thumbprint_list)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the OIDC provider
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientIdList")
    def client_id_list(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "client_id_list")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thumbprintList")
    def thumbprint_list(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "thumbprint_list")


class AwaitableGetOidcProviderResult(GetOidcProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOidcProviderResult(
            arn=self.arn,
            client_id_list=self.client_id_list,
            tags=self.tags,
            thumbprint_list=self.thumbprint_list)


def get_oidc_provider(arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOidcProviderResult:
    """
    Resource Type definition for AWS::IAM::OIDCProvider


    :param str arn: Amazon Resource Name (ARN) of the OIDC provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iam:getOidcProvider', __args__, opts=opts, typ=GetOidcProviderResult).value

    return AwaitableGetOidcProviderResult(
        arn=pulumi.get(__ret__, 'arn'),
        client_id_list=pulumi.get(__ret__, 'client_id_list'),
        tags=pulumi.get(__ret__, 'tags'),
        thumbprint_list=pulumi.get(__ret__, 'thumbprint_list'))


@_utilities.lift_output_func(get_oidc_provider)
def get_oidc_provider_output(arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOidcProviderResult]:
    """
    Resource Type definition for AWS::IAM::OIDCProvider


    :param str arn: Amazon Resource Name (ARN) of the OIDC provider
    """
    ...
