# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'SchemaRegistryArgs',
    'SchemaVersionSchemaArgs',
    'SchemaVersionArgs',
]

@pulumi.input_type
class SchemaRegistryArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Identifier for the registry which the schema is part of.
        :param pulumi.Input[str] arn: Amazon Resource Name for the Registry.
        :param pulumi.Input[str] name: Name of the registry in which the schema will be created.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name for the Registry.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the registry in which the schema will be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SchemaVersionSchemaArgs:
    def __init__(__self__, *,
                 registry_name: Optional[pulumi.Input[str]] = None,
                 schema_arn: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        Identifier for the schema where the schema version will be created.
        :param pulumi.Input[str] registry_name: Name of the registry to identify where the Schema is located.
        :param pulumi.Input[str] schema_arn: Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        :param pulumi.Input[str] schema_name: Name of the schema. This parameter requires RegistryName to be provided.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if schema_arn is not None:
            pulumi.set(__self__, "schema_arn", schema_arn)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the registry to identify where the Schema is located.
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        """
        return pulumi.get(self, "schema_arn")

    @schema_arn.setter
    def schema_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_arn", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the schema. This parameter requires RegistryName to be provided.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


@pulumi.input_type
class SchemaVersionArgs:
    def __init__(__self__, *,
                 is_latest: Optional[pulumi.Input[bool]] = None,
                 version_number: Optional[pulumi.Input[int]] = None):
        """
        Specify checkpoint version for update. This is only required to update the Compatibility.
        :param pulumi.Input[bool] is_latest: Indicates if the latest version needs to be updated.
        :param pulumi.Input[int] version_number: Indicates the version number in the schema to update.
        """
        if is_latest is not None:
            pulumi.set(__self__, "is_latest", is_latest)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the latest version needs to be updated.
        """
        return pulumi.get(self, "is_latest")

    @is_latest.setter
    def is_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_latest", value)

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the version number in the schema to update.
        """
        return pulumi.get(self, "version_number")

    @version_number.setter
    def version_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version_number", value)


