# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetCrossAccountAttachmentResult',
    'AwaitableGetCrossAccountAttachmentResult',
    'get_cross_account_attachment',
    'get_cross_account_attachment_output',
]

@pulumi.output_type
class GetCrossAccountAttachmentResult:
    def __init__(__self__, attachment_arn=None, name=None, principals=None, resources=None, tags=None):
        if attachment_arn and not isinstance(attachment_arn, str):
            raise TypeError("Expected argument 'attachment_arn' to be a str")
        pulumi.set(__self__, "attachment_arn", attachment_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if principals and not isinstance(principals, list):
            raise TypeError("Expected argument 'principals' to be a list")
        pulumi.set(__self__, "principals", principals)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentArn")
    def attachment_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the attachment.
        """
        return pulumi.get(self, "attachment_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The Friendly identifier of the attachment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence[str]]:
        """
        Principals to share the resources with.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence['outputs.CrossAccountAttachmentResource']]:
        """
        Resources shared using the attachment.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        return pulumi.get(self, "tags")


class AwaitableGetCrossAccountAttachmentResult(GetCrossAccountAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCrossAccountAttachmentResult(
            attachment_arn=self.attachment_arn,
            name=self.name,
            principals=self.principals,
            resources=self.resources,
            tags=self.tags)


def get_cross_account_attachment(attachment_arn: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCrossAccountAttachmentResult:
    """
    Resource Type definition for AWS::GlobalAccelerator::CrossAccountAttachment


    :param str attachment_arn: The Amazon Resource Name (ARN) of the attachment.
    """
    __args__ = dict()
    __args__['attachmentArn'] = attachment_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:globalaccelerator:getCrossAccountAttachment', __args__, opts=opts, typ=GetCrossAccountAttachmentResult).value

    return AwaitableGetCrossAccountAttachmentResult(
        attachment_arn=pulumi.get(__ret__, 'attachment_arn'),
        name=pulumi.get(__ret__, 'name'),
        principals=pulumi.get(__ret__, 'principals'),
        resources=pulumi.get(__ret__, 'resources'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_cross_account_attachment)
def get_cross_account_attachment_output(attachment_arn: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCrossAccountAttachmentResult]:
    """
    Resource Type definition for AWS::GlobalAccelerator::CrossAccountAttachment


    :param str attachment_arn: The Amazon Resource Name (ARN) of the attachment.
    """
    ...
