# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['CrossAccountAttachmentArgs', 'CrossAccountAttachment']

@pulumi.input_type
class CrossAccountAttachmentArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['CrossAccountAttachmentResourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a CrossAccountAttachment resource.
        :param pulumi.Input[str] name: The Friendly identifier of the attachment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: Principals to share the resources with.
        :param pulumi.Input[Sequence[pulumi.Input['CrossAccountAttachmentResourceArgs']]] resources: Resources shared using the attachment.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Friendly identifier of the attachment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Principals to share the resources with.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrossAccountAttachmentResourceArgs']]]]:
        """
        Resources shared using the attachment.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrossAccountAttachmentResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class CrossAccountAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CrossAccountAttachmentResourceArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::GlobalAccelerator::CrossAccountAttachment

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The Friendly identifier of the attachment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: Principals to share the resources with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CrossAccountAttachmentResourceArgs']]]] resources: Resources shared using the attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CrossAccountAttachmentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::GlobalAccelerator::CrossAccountAttachment

        :param str resource_name: The name of the resource.
        :param CrossAccountAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CrossAccountAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CrossAccountAttachmentResourceArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CrossAccountAttachmentArgs.__new__(CrossAccountAttachmentArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["principals"] = principals
            __props__.__dict__["resources"] = resources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["attachment_arn"] = None
        super(CrossAccountAttachment, __self__).__init__(
            'aws-native:globalaccelerator:CrossAccountAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CrossAccountAttachment':
        """
        Get an existing CrossAccountAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CrossAccountAttachmentArgs.__new__(CrossAccountAttachmentArgs)

        __props__.__dict__["attachment_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["principals"] = None
        __props__.__dict__["resources"] = None
        __props__.__dict__["tags"] = None
        return CrossAccountAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentArn")
    def attachment_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the attachment.
        """
        return pulumi.get(self, "attachment_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Friendly identifier of the attachment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Principals to share the resources with.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[Sequence['outputs.CrossAccountAttachmentResource']]]:
        """
        Resources shared using the attachment.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

