# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetPartitionResult',
    'AwaitableGetPartitionResult',
    'get_partition',
    'get_partition_output',
]

@pulumi.output_type
class GetPartitionResult:
    def __init__(__self__, dns_suffix=None, partition=None):
        if dns_suffix and not isinstance(dns_suffix, str):
            raise TypeError("Expected argument 'dns_suffix' to be a str")
        pulumi.set(__self__, "dns_suffix", dns_suffix)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> str:
        """
        Base DNS domain name for the current partition (e.g., `amazonaws.com` in AWS Commercial, `amazonaws.com.cn` in AWS China).
        """
        return pulumi.get(self, "dns_suffix")

    @property
    @pulumi.getter
    def partition(self) -> str:
        """
        Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
        """
        return pulumi.get(self, "partition")


class AwaitableGetPartitionResult(GetPartitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPartitionResult(
            dns_suffix=self.dns_suffix,
            partition=self.partition)


def get_partition(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPartitionResult:
    """
    Use this data source to access information about an existing resource.
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:index:getPartition', __args__, opts=opts, typ=GetPartitionResult).value

    return AwaitableGetPartitionResult(
        dns_suffix=pulumi.get(__ret__, 'dns_suffix'),
        partition=pulumi.get(__ret__, 'partition'))


@_utilities.lift_output_func(get_partition)
def get_partition_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPartitionResult]:
    """
    Use this data source to access information about an existing resource.
    """
    ...
