# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMatchmakingConfigurationResult',
    'AwaitableGetMatchmakingConfigurationResult',
    'get_matchmaking_configuration',
    'get_matchmaking_configuration_output',
]

@pulumi.output_type
class GetMatchmakingConfigurationResult:
    def __init__(__self__, acceptance_required=None, acceptance_timeout_seconds=None, additional_player_count=None, arn=None, backfill_mode=None, creation_time=None, custom_event_data=None, description=None, flex_match_mode=None, game_properties=None, game_session_data=None, game_session_queue_arns=None, notification_target=None, request_timeout_seconds=None, rule_set_arn=None, rule_set_name=None, tags=None):
        if acceptance_required and not isinstance(acceptance_required, bool):
            raise TypeError("Expected argument 'acceptance_required' to be a bool")
        pulumi.set(__self__, "acceptance_required", acceptance_required)
        if acceptance_timeout_seconds and not isinstance(acceptance_timeout_seconds, int):
            raise TypeError("Expected argument 'acceptance_timeout_seconds' to be a int")
        pulumi.set(__self__, "acceptance_timeout_seconds", acceptance_timeout_seconds)
        if additional_player_count and not isinstance(additional_player_count, int):
            raise TypeError("Expected argument 'additional_player_count' to be a int")
        pulumi.set(__self__, "additional_player_count", additional_player_count)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if backfill_mode and not isinstance(backfill_mode, str):
            raise TypeError("Expected argument 'backfill_mode' to be a str")
        pulumi.set(__self__, "backfill_mode", backfill_mode)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if custom_event_data and not isinstance(custom_event_data, str):
            raise TypeError("Expected argument 'custom_event_data' to be a str")
        pulumi.set(__self__, "custom_event_data", custom_event_data)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if flex_match_mode and not isinstance(flex_match_mode, str):
            raise TypeError("Expected argument 'flex_match_mode' to be a str")
        pulumi.set(__self__, "flex_match_mode", flex_match_mode)
        if game_properties and not isinstance(game_properties, list):
            raise TypeError("Expected argument 'game_properties' to be a list")
        pulumi.set(__self__, "game_properties", game_properties)
        if game_session_data and not isinstance(game_session_data, str):
            raise TypeError("Expected argument 'game_session_data' to be a str")
        pulumi.set(__self__, "game_session_data", game_session_data)
        if game_session_queue_arns and not isinstance(game_session_queue_arns, list):
            raise TypeError("Expected argument 'game_session_queue_arns' to be a list")
        pulumi.set(__self__, "game_session_queue_arns", game_session_queue_arns)
        if notification_target and not isinstance(notification_target, str):
            raise TypeError("Expected argument 'notification_target' to be a str")
        pulumi.set(__self__, "notification_target", notification_target)
        if request_timeout_seconds and not isinstance(request_timeout_seconds, int):
            raise TypeError("Expected argument 'request_timeout_seconds' to be a int")
        pulumi.set(__self__, "request_timeout_seconds", request_timeout_seconds)
        if rule_set_arn and not isinstance(rule_set_arn, str):
            raise TypeError("Expected argument 'rule_set_arn' to be a str")
        pulumi.set(__self__, "rule_set_arn", rule_set_arn)
        if rule_set_name and not isinstance(rule_set_name, str):
            raise TypeError("Expected argument 'rule_set_name' to be a str")
        pulumi.set(__self__, "rule_set_name", rule_set_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="acceptanceRequired")
    def acceptance_required(self) -> Optional[bool]:
        """
        A flag that indicates whether a match that was created with this configuration must be accepted by the matched players
        """
        return pulumi.get(self, "acceptance_required")

    @property
    @pulumi.getter(name="acceptanceTimeoutSeconds")
    def acceptance_timeout_seconds(self) -> Optional[int]:
        """
        The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        """
        return pulumi.get(self, "acceptance_timeout_seconds")

    @property
    @pulumi.getter(name="additionalPlayerCount")
    def additional_player_count(self) -> Optional[int]:
        """
        The number of player slots in a match to keep open for future players.
        """
        return pulumi.get(self, "additional_player_count")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift matchmaking configuration resource and uniquely identifies it.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="backfillMode")
    def backfill_mode(self) -> Optional['MatchmakingConfigurationBackfillMode']:
        """
        The method used to backfill game sessions created with this matchmaking configuration.
        """
        return pulumi.get(self, "backfill_mode")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        A time stamp indicating when this data object was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customEventData")
    def custom_event_data(self) -> Optional[str]:
        """
        Information to attach to all events related to the matchmaking configuration.
        """
        return pulumi.get(self, "custom_event_data")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A descriptive label that is associated with matchmaking configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flexMatchMode")
    def flex_match_mode(self) -> Optional['MatchmakingConfigurationFlexMatchMode']:
        """
        Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a standalone matchmaking solution.
        """
        return pulumi.get(self, "flex_match_mode")

    @property
    @pulumi.getter(name="gameProperties")
    def game_properties(self) -> Optional[Sequence['outputs.MatchmakingConfigurationGameProperty']]:
        """
        A set of custom properties for a game session, formatted as key:value pairs.
        """
        return pulumi.get(self, "game_properties")

    @property
    @pulumi.getter(name="gameSessionData")
    def game_session_data(self) -> Optional[str]:
        """
        A set of custom game session properties, formatted as a single string value.
        """
        return pulumi.get(self, "game_session_data")

    @property
    @pulumi.getter(name="gameSessionQueueArns")
    def game_session_queue_arns(self) -> Optional[Sequence[str]]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift game session queue resource and uniquely identifies it.
        """
        return pulumi.get(self, "game_session_queue_arns")

    @property
    @pulumi.getter(name="notificationTarget")
    def notification_target(self) -> Optional[str]:
        """
        An SNS topic ARN that is set up to receive matchmaking notifications.
        """
        return pulumi.get(self, "notification_target")

    @property
    @pulumi.getter(name="requestTimeoutSeconds")
    def request_timeout_seconds(self) -> Optional[int]:
        """
        The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        """
        return pulumi.get(self, "request_timeout_seconds")

    @property
    @pulumi.getter(name="ruleSetArn")
    def rule_set_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) associated with the GameLift matchmaking rule set resource that this configuration uses.
        """
        return pulumi.get(self, "rule_set_arn")

    @property
    @pulumi.getter(name="ruleSetName")
    def rule_set_name(self) -> Optional[str]:
        """
        A unique identifier for the matchmaking rule set to use with this configuration.
        """
        return pulumi.get(self, "rule_set_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMatchmakingConfigurationResult(GetMatchmakingConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMatchmakingConfigurationResult(
            acceptance_required=self.acceptance_required,
            acceptance_timeout_seconds=self.acceptance_timeout_seconds,
            additional_player_count=self.additional_player_count,
            arn=self.arn,
            backfill_mode=self.backfill_mode,
            creation_time=self.creation_time,
            custom_event_data=self.custom_event_data,
            description=self.description,
            flex_match_mode=self.flex_match_mode,
            game_properties=self.game_properties,
            game_session_data=self.game_session_data,
            game_session_queue_arns=self.game_session_queue_arns,
            notification_target=self.notification_target,
            request_timeout_seconds=self.request_timeout_seconds,
            rule_set_arn=self.rule_set_arn,
            rule_set_name=self.rule_set_name,
            tags=self.tags)


def get_matchmaking_configuration(name: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMatchmakingConfigurationResult:
    """
    The AWS::GameLift::MatchmakingConfiguration resource creates an Amazon GameLift (GameLift) matchmaking configuration.


    :param str name: A unique identifier for the matchmaking configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gamelift:getMatchmakingConfiguration', __args__, opts=opts, typ=GetMatchmakingConfigurationResult).value

    return AwaitableGetMatchmakingConfigurationResult(
        acceptance_required=pulumi.get(__ret__, 'acceptance_required'),
        acceptance_timeout_seconds=pulumi.get(__ret__, 'acceptance_timeout_seconds'),
        additional_player_count=pulumi.get(__ret__, 'additional_player_count'),
        arn=pulumi.get(__ret__, 'arn'),
        backfill_mode=pulumi.get(__ret__, 'backfill_mode'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        custom_event_data=pulumi.get(__ret__, 'custom_event_data'),
        description=pulumi.get(__ret__, 'description'),
        flex_match_mode=pulumi.get(__ret__, 'flex_match_mode'),
        game_properties=pulumi.get(__ret__, 'game_properties'),
        game_session_data=pulumi.get(__ret__, 'game_session_data'),
        game_session_queue_arns=pulumi.get(__ret__, 'game_session_queue_arns'),
        notification_target=pulumi.get(__ret__, 'notification_target'),
        request_timeout_seconds=pulumi.get(__ret__, 'request_timeout_seconds'),
        rule_set_arn=pulumi.get(__ret__, 'rule_set_arn'),
        rule_set_name=pulumi.get(__ret__, 'rule_set_name'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_matchmaking_configuration)
def get_matchmaking_configuration_output(name: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMatchmakingConfigurationResult]:
    """
    The AWS::GameLift::MatchmakingConfiguration resource creates an Amazon GameLift (GameLift) matchmaking configuration.


    :param str name: A unique identifier for the matchmaking configuration.
    """
    ...
