# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetContainerGroupDefinitionResult',
    'AwaitableGetContainerGroupDefinitionResult',
    'get_container_group_definition',
    'get_container_group_definition_output',
]

@pulumi.output_type
class GetContainerGroupDefinitionResult:
    def __init__(__self__, container_group_definition_arn=None, creation_time=None, tags=None):
        if container_group_definition_arn and not isinstance(container_group_definition_arn, str):
            raise TypeError("Expected argument 'container_group_definition_arn' to be a str")
        pulumi.set(__self__, "container_group_definition_arn", container_group_definition_arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="containerGroupDefinitionArn")
    def container_group_definition_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift container group resource and uniquely identifies it across all AWS Regions.
        """
        return pulumi.get(self, "container_group_definition_arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetContainerGroupDefinitionResult(GetContainerGroupDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerGroupDefinitionResult(
            container_group_definition_arn=self.container_group_definition_arn,
            creation_time=self.creation_time,
            tags=self.tags)


def get_container_group_definition(name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerGroupDefinitionResult:
    """
    The AWS::GameLift::ContainerGroupDefinition resource creates an Amazon GameLift container group definition.


    :param str name: A descriptive label for the container group definition.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gamelift:getContainerGroupDefinition', __args__, opts=opts, typ=GetContainerGroupDefinitionResult).value

    return AwaitableGetContainerGroupDefinitionResult(
        container_group_definition_arn=pulumi.get(__ret__, 'container_group_definition_arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_container_group_definition)
def get_container_group_definition_output(name: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContainerGroupDefinitionResult]:
    """
    The AWS::GameLift::ContainerGroupDefinition resource creates an Amazon GameLift container group definition.


    :param str name: A descriptive label for the container group definition.
    """
    ...
