# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AliasRoutingStrategyArgs',
    'BuildStorageLocationArgs',
    'ContainerGroupDefinitionContainerDefinitionArgs',
    'ContainerGroupDefinitionContainerDependencyArgs',
    'ContainerGroupDefinitionContainerEnvironmentArgs',
    'ContainerGroupDefinitionContainerHealthCheckArgs',
    'ContainerGroupDefinitionContainerPortRangeArgs',
    'ContainerGroupDefinitionMemoryLimitsArgs',
    'ContainerGroupDefinitionPortConfigurationArgs',
    'FleetAnywhereConfigurationArgs',
    'FleetCertificateConfigurationArgs',
    'FleetConnectionPortRangeArgs',
    'FleetContainerGroupsConfigurationArgs',
    'FleetContainerGroupsPerInstanceArgs',
    'FleetIpPermissionArgs',
    'FleetLocationCapacityArgs',
    'FleetLocationConfigurationArgs',
    'FleetResourceCreationLimitPolicyArgs',
    'FleetRuntimeConfigurationArgs',
    'FleetScalingPolicyArgs',
    'FleetServerProcessArgs',
    'FleetTargetConfigurationArgs',
    'GameServerGroupAutoScalingPolicyArgs',
    'GameServerGroupInstanceDefinitionArgs',
    'GameServerGroupLaunchTemplateArgs',
    'GameServerGroupTargetTrackingConfigurationArgs',
    'GameSessionQueueDestinationArgs',
    'GameSessionQueueFilterConfigurationArgs',
    'GameSessionQueuePlayerLatencyPolicyArgs',
    'GameSessionQueuePriorityConfigurationArgs',
    'MatchmakingConfigurationGamePropertyArgs',
    'ScriptS3LocationArgs',
]

@pulumi.input_type
class AliasRoutingStrategyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['AliasRoutingStrategyType'],
                 fleet_id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['AliasRoutingStrategyType'] type: Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        :param pulumi.Input[str] fleet_id: A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        :param pulumi.Input[str] message: The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        pulumi.set(__self__, "type", type)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AliasRoutingStrategyType']:
        """
        Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AliasRoutingStrategyType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class BuildStorageLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 object_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param pulumi.Input[str] key: The name of the zip file that contains the build files or script files.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param pulumi.Input[str] object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name of the zip file that contains the build files or script files.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_version", value)


@pulumi.input_type
class ContainerGroupDefinitionContainerDefinitionArgs:
    def __init__(__self__, *,
                 container_name: pulumi.Input[str],
                 image_uri: pulumi.Input[str],
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]] = None,
                 entry_point: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]] = None,
                 essential: Optional[pulumi.Input[bool]] = None,
                 health_check: Optional[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs']] = None,
                 memory_limits: Optional[pulumi.Input['ContainerGroupDefinitionMemoryLimitsArgs']] = None,
                 port_configuration: Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']] = None,
                 resolved_image_digest: Optional[pulumi.Input[str]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None):
        """
        Details about a container that is used in a container fleet
        :param pulumi.Input[str] container_name: A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        :param pulumi.Input[str] image_uri: Specifies the image URI of this container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: The command that's passed to the container.
        :param pulumi.Input[int] cpu: The maximum number of CPU units reserved for this container. The value is expressed as an integer amount of CPU units. 1 vCPU is equal to 1024 CPU units
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]] depends_on: A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entry_point: The entry point that's passed to the container so that it will run as an executable. If there are multiple arguments, each argument is a string in the array.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]] environment: The environment variables to pass to a container.
        :param pulumi.Input[bool] essential: Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        :param pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs'] health_check: Specifies how the health of the containers will be checked.
        :param pulumi.Input['ContainerGroupDefinitionMemoryLimitsArgs'] memory_limits: Specifies how much memory is available to the container. You must specify at least this parameter or the TotalMemoryLimit parameter of the ContainerGroupDefinition.
        :param pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs'] port_configuration: Defines the ports on the container.
        :param pulumi.Input[str] resolved_image_digest: The digest of the container image.
        :param pulumi.Input[str] working_directory: The working directory to run commands inside the container in.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image_uri", image_uri)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if memory_limits is not None:
            pulumi.set(__self__, "memory_limits", memory_limits)
        if port_configuration is not None:
            pulumi.set(__self__, "port_configuration", port_configuration)
        if resolved_image_digest is not None:
            pulumi.set(__self__, "resolved_image_digest", resolved_image_digest)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Input[str]:
        """
        Specifies the image URI of this container.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The command that's passed to the container.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of CPU units reserved for this container. The value is expressed as an integer amount of CPU units. 1 vCPU is equal to 1024 CPU units
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]]:
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The entry point that's passed to the container so that it will run as an executable. If there are multiple arguments, each argument is a string in the array.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]]:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerEnvironmentArgs']]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def essential(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        """
        return pulumi.get(self, "essential")

    @essential.setter
    def essential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "essential", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs']]:
        """
        Specifies how the health of the containers will be checked.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ContainerGroupDefinitionContainerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="memoryLimits")
    def memory_limits(self) -> Optional[pulumi.Input['ContainerGroupDefinitionMemoryLimitsArgs']]:
        """
        Specifies how much memory is available to the container. You must specify at least this parameter or the TotalMemoryLimit parameter of the ContainerGroupDefinition.
        """
        return pulumi.get(self, "memory_limits")

    @memory_limits.setter
    def memory_limits(self, value: Optional[pulumi.Input['ContainerGroupDefinitionMemoryLimitsArgs']]):
        pulumi.set(self, "memory_limits", value)

    @property
    @pulumi.getter(name="portConfiguration")
    def port_configuration(self) -> Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']]:
        """
        Defines the ports on the container.
        """
        return pulumi.get(self, "port_configuration")

    @port_configuration.setter
    def port_configuration(self, value: Optional[pulumi.Input['ContainerGroupDefinitionPortConfigurationArgs']]):
        pulumi.set(self, "port_configuration", value)

    @property
    @pulumi.getter(name="resolvedImageDigest")
    def resolved_image_digest(self) -> Optional[pulumi.Input[str]]:
        """
        The digest of the container image.
        """
        return pulumi.get(self, "resolved_image_digest")

    @resolved_image_digest.setter
    def resolved_image_digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolved_image_digest", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory to run commands inside the container in.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class ContainerGroupDefinitionContainerDependencyArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition'],
                 container_name: pulumi.Input[str]):
        """
        A dependency that impacts a container's startup and shutdown.
        :param pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition'] condition: The type of dependency.
        :param pulumi.Input[str] container_name: A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition']:
        """
        The type of dependency.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['ContainerGroupDefinitionContainerDependencyCondition']):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)


@pulumi.input_type
class ContainerGroupDefinitionContainerEnvironmentArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        An environment variable to set inside a container, in the form of a key-value pair.
        :param pulumi.Input[str] name: The environment variable name.
        :param pulumi.Input[str] value: The environment variable value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The environment variable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The environment variable value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerGroupDefinitionContainerHealthCheckArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[Sequence[pulumi.Input[str]]],
                 interval: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 start_period: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        Specifies how the process manager checks the health of containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: A string array representing the command that the container runs to determine if it is healthy.
        :param pulumi.Input[int] interval: How often (in seconds) the health is checked.
        :param pulumi.Input[int] retries: How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        :param pulumi.Input[int] start_period: The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        :param pulumi.Input[int] timeout: How many seconds the process manager allows the command to run before canceling it.
        """
        pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) the health is checked.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[pulumi.Input[int]]:
        """
        The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        """
        return pulumi.get(self, "start_period")

    @start_period.setter
    def start_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_period", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How many seconds the process manager allows the command to run before canceling it.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ContainerGroupDefinitionContainerPortRangeArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[int],
                 protocol: pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol'],
                 to_port: pulumi.Input[int]):
        """
        A set of one or more port numbers that can be opened on the container.
        :param pulumi.Input[int] from_port: A starting value for the range of allowed port numbers.
        :param pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol'] protocol: Defines the protocol of these ports.
        :param pulumi.Input[int] to_port: An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[int]:
        """
        A starting value for the range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol']:
        """
        Defines the protocol of these ports.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['ContainerGroupDefinitionContainerPortRangeProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[int]:
        """
        An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "to_port", value)


@pulumi.input_type
class ContainerGroupDefinitionMemoryLimitsArgs:
    def __init__(__self__, *,
                 hard_limit: Optional[pulumi.Input[int]] = None,
                 soft_limit: Optional[pulumi.Input[int]] = None):
        """
        Specifies how much memory is available to the container.
        :param pulumi.Input[int] hard_limit: The hard limit of memory to reserve for the container.
        :param pulumi.Input[int] soft_limit: The amount of memory that is reserved for the container.
        """
        if hard_limit is not None:
            pulumi.set(__self__, "hard_limit", hard_limit)
        if soft_limit is not None:
            pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The hard limit of memory to reserve for the container.
        """
        return pulumi.get(self, "hard_limit")

    @hard_limit.setter
    def hard_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hard_limit", value)

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory that is reserved for the container.
        """
        return pulumi.get(self, "soft_limit")

    @soft_limit.setter
    def soft_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "soft_limit", value)


@pulumi.input_type
class ContainerGroupDefinitionPortConfigurationArgs:
    def __init__(__self__, *,
                 container_port_ranges: pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]]):
        """
        Defines the ports on a container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]] container_port_ranges: Specifies one or more ranges of ports on a container.
        """
        pulumi.set(__self__, "container_port_ranges", container_port_ranges)

    @property
    @pulumi.getter(name="containerPortRanges")
    def container_port_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]]:
        """
        Specifies one or more ranges of ports on a container.
        """
        return pulumi.get(self, "container_port_ranges")

    @container_port_ranges.setter
    def container_port_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerGroupDefinitionContainerPortRangeArgs']]]):
        pulumi.set(self, "container_port_ranges", value)


@pulumi.input_type
class FleetAnywhereConfigurationArgs:
    def __init__(__self__, *,
                 cost: pulumi.Input[str]):
        """
        Configuration for Anywhere fleet.
        :param pulumi.Input[str] cost: Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        pulumi.set(__self__, "cost", cost)

    @property
    @pulumi.getter
    def cost(self) -> pulumi.Input[str]:
        """
        Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        return pulumi.get(self, "cost")

    @cost.setter
    def cost(self, value: pulumi.Input[str]):
        pulumi.set(self, "cost", value)


@pulumi.input_type
class FleetCertificateConfigurationArgs:
    def __init__(__self__, *,
                 certificate_type: pulumi.Input['FleetCertificateConfigurationCertificateType']):
        """
        Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> pulumi.Input['FleetCertificateConfigurationCertificateType']:
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: pulumi.Input['FleetCertificateConfigurationCertificateType']):
        pulumi.set(self, "certificate_type", value)


@pulumi.input_type
class FleetConnectionPortRangeArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[int],
                 to_port: pulumi.Input[int]):
        """
        Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
        :param pulumi.Input[int] from_port: A starting value for a range of allowed port numbers.
        :param pulumi.Input[int] to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[int]:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[int]:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "to_port", value)


@pulumi.input_type
class FleetContainerGroupsConfigurationArgs:
    def __init__(__self__, *,
                 connection_port_range: pulumi.Input['FleetConnectionPortRangeArgs'],
                 container_group_definition_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 container_groups_per_instance: Optional[pulumi.Input['FleetContainerGroupsPerInstanceArgs']] = None):
        """
        Specifies container groups that this instance will hold. You must specify exactly one replica group. Optionally, you may specify exactly one daemon group. You can't change this property after you create the fleet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_group_definition_names: The names of the container group definitions that will be created in an instance. You must specify exactly one REPLICA container group. You have the option to also specify one DAEMON container group.
        """
        pulumi.set(__self__, "connection_port_range", connection_port_range)
        pulumi.set(__self__, "container_group_definition_names", container_group_definition_names)
        if container_groups_per_instance is not None:
            pulumi.set(__self__, "container_groups_per_instance", container_groups_per_instance)

    @property
    @pulumi.getter(name="connectionPortRange")
    def connection_port_range(self) -> pulumi.Input['FleetConnectionPortRangeArgs']:
        return pulumi.get(self, "connection_port_range")

    @connection_port_range.setter
    def connection_port_range(self, value: pulumi.Input['FleetConnectionPortRangeArgs']):
        pulumi.set(self, "connection_port_range", value)

    @property
    @pulumi.getter(name="containerGroupDefinitionNames")
    def container_group_definition_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The names of the container group definitions that will be created in an instance. You must specify exactly one REPLICA container group. You have the option to also specify one DAEMON container group.
        """
        return pulumi.get(self, "container_group_definition_names")

    @container_group_definition_names.setter
    def container_group_definition_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "container_group_definition_names", value)

    @property
    @pulumi.getter(name="containerGroupsPerInstance")
    def container_groups_per_instance(self) -> Optional[pulumi.Input['FleetContainerGroupsPerInstanceArgs']]:
        return pulumi.get(self, "container_groups_per_instance")

    @container_groups_per_instance.setter
    def container_groups_per_instance(self, value: Optional[pulumi.Input['FleetContainerGroupsPerInstanceArgs']]):
        pulumi.set(self, "container_groups_per_instance", value)


@pulumi.input_type
class FleetContainerGroupsPerInstanceArgs:
    def __init__(__self__, *,
                 desired_replica_container_groups_per_instance: Optional[pulumi.Input[int]] = None,
                 max_replica_container_groups_per_instance: Optional[pulumi.Input[int]] = None):
        """
        The number of container groups per instance.
        :param pulumi.Input[int] desired_replica_container_groups_per_instance: Use this parameter to override the number of replica container groups GameLift will launch per instance with a number that is lower than that calculated maximum.
        :param pulumi.Input[int] max_replica_container_groups_per_instance: GameLift calculates the maximum number of replica container groups it can launch per instance based on instance properties such as CPU, memory, and connection ports.
        """
        if desired_replica_container_groups_per_instance is not None:
            pulumi.set(__self__, "desired_replica_container_groups_per_instance", desired_replica_container_groups_per_instance)
        if max_replica_container_groups_per_instance is not None:
            pulumi.set(__self__, "max_replica_container_groups_per_instance", max_replica_container_groups_per_instance)

    @property
    @pulumi.getter(name="desiredReplicaContainerGroupsPerInstance")
    def desired_replica_container_groups_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Use this parameter to override the number of replica container groups GameLift will launch per instance with a number that is lower than that calculated maximum.
        """
        return pulumi.get(self, "desired_replica_container_groups_per_instance")

    @desired_replica_container_groups_per_instance.setter
    def desired_replica_container_groups_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_replica_container_groups_per_instance", value)

    @property
    @pulumi.getter(name="maxReplicaContainerGroupsPerInstance")
    def max_replica_container_groups_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        GameLift calculates the maximum number of replica container groups it can launch per instance based on instance properties such as CPU, memory, and connection ports.
        """
        return pulumi.get(self, "max_replica_container_groups_per_instance")

    @max_replica_container_groups_per_instance.setter
    def max_replica_container_groups_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replica_container_groups_per_instance", value)


@pulumi.input_type
class FleetIpPermissionArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[int],
                 ip_range: pulumi.Input[str],
                 protocol: pulumi.Input['FleetIpPermissionProtocol'],
                 to_port: pulumi.Input[int]):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param pulumi.Input[int] from_port: A starting value for a range of allowed port numbers.
        :param pulumi.Input[str] ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param pulumi.Input['FleetIpPermissionProtocol'] protocol: The network communication protocol used by the fleet.
        :param pulumi.Input[int] to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[int]:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[str]:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['FleetIpPermissionProtocol']:
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['FleetIpPermissionProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[int]:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "to_port", value)


@pulumi.input_type
class FleetLocationCapacityArgs:
    def __init__(__self__, *,
                 desired_ec2_instances: pulumi.Input[int],
                 max_size: pulumi.Input[int],
                 min_size: pulumi.Input[int]):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param pulumi.Input[int] desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param pulumi.Input[int] max_size: The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param pulumi.Input[int] min_size: The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEc2Instances")
    def desired_ec2_instances(self) -> pulumi.Input[int]:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @desired_ec2_instances.setter
    def desired_ec2_instances(self, value: pulumi.Input[int]):
        pulumi.set(self, "desired_ec2_instances", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[int]:
        """
        The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[int]:
        """
        The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_size", value)


@pulumi.input_type
class FleetLocationConfigurationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 location_capacity: Optional[pulumi.Input['FleetLocationCapacityArgs']] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional[pulumi.Input['FleetLocationCapacityArgs']]:
        return pulumi.get(self, "location_capacity")

    @location_capacity.setter
    def location_capacity(self, value: Optional[pulumi.Input['FleetLocationCapacityArgs']]):
        pulumi.set(self, "location_capacity", value)


@pulumi.input_type
class FleetResourceCreationLimitPolicyArgs:
    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[pulumi.Input[int]] = None,
                 policy_period_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param pulumi.Input[int] new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param pulumi.Input[int] policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @new_game_sessions_per_creator.setter
    def new_game_sessions_per_creator(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_game_sessions_per_creator", value)

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")

    @policy_period_in_minutes.setter
    def policy_period_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "policy_period_in_minutes", value)


@pulumi.input_type
class FleetRuntimeConfigurationArgs:
    def __init__(__self__, *,
                 game_session_activation_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 max_concurrent_game_session_activations: Optional[pulumi.Input[int]] = None,
                 server_processes: Optional[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]]] = None):
        """
        A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

        The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

        An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
        :param pulumi.Input[int] game_session_activation_timeout_seconds: The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        :param pulumi.Input[int] max_concurrent_game_session_activations: The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        :param pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]] server_processes: A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        if game_session_activation_timeout_seconds is not None:
            pulumi.set(__self__, "game_session_activation_timeout_seconds", game_session_activation_timeout_seconds)
        if max_concurrent_game_session_activations is not None:
            pulumi.set(__self__, "max_concurrent_game_session_activations", max_concurrent_game_session_activations)
        if server_processes is not None:
            pulumi.set(__self__, "server_processes", server_processes)

    @property
    @pulumi.getter(name="gameSessionActivationTimeoutSeconds")
    def game_session_activation_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        """
        return pulumi.get(self, "game_session_activation_timeout_seconds")

    @game_session_activation_timeout_seconds.setter
    def game_session_activation_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "game_session_activation_timeout_seconds", value)

    @property
    @pulumi.getter(name="maxConcurrentGameSessionActivations")
    def max_concurrent_game_session_activations(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        """
        return pulumi.get(self, "max_concurrent_game_session_activations")

    @max_concurrent_game_session_activations.setter
    def max_concurrent_game_session_activations(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_game_session_activations", value)

    @property
    @pulumi.getter(name="serverProcesses")
    def server_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]]]:
        """
        A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        return pulumi.get(self, "server_processes")

    @server_processes.setter
    def server_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetServerProcessArgs']]]]):
        pulumi.set(self, "server_processes", value)


@pulumi.input_type
class FleetScalingPolicyArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input['FleetScalingPolicyMetricName'],
                 name: pulumi.Input[str],
                 comparison_operator: Optional[pulumi.Input['FleetScalingPolicyComparisonOperator']] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input['FleetScalingPolicyPolicyType']] = None,
                 scaling_adjustment: Optional[pulumi.Input[int]] = None,
                 scaling_adjustment_type: Optional[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']] = None,
                 status: Optional[pulumi.Input['FleetScalingPolicyStatus']] = None,
                 target_configuration: Optional[pulumi.Input['FleetTargetConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 update_status: Optional[pulumi.Input['FleetScalingPolicyUpdateStatus']] = None):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        :param pulumi.Input['FleetScalingPolicyMetricName'] metric_name: Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        :param pulumi.Input[str] name: A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        :param pulumi.Input['FleetScalingPolicyComparisonOperator'] comparison_operator: Comparison operator to use when measuring a metric against the threshold value.
        :param pulumi.Input[int] evaluation_periods: Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        :param pulumi.Input['FleetScalingPolicyPolicyType'] policy_type: The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        :param pulumi.Input[int] scaling_adjustment: Amount of adjustment to make, based on the scaling adjustment type.
        :param pulumi.Input['FleetScalingPolicyScalingAdjustmentType'] scaling_adjustment_type: The type of adjustment to make to a fleet's instance count.
        :param pulumi.Input['FleetScalingPolicyStatus'] status: Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        :param pulumi.Input['FleetTargetConfigurationArgs'] target_configuration: An object that contains settings for a target-based scaling policy.
        :param pulumi.Input[float] threshold: Metric value used to trigger a scaling event.
        :param pulumi.Input['FleetScalingPolicyUpdateStatus'] update_status: The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if scaling_adjustment_type is not None:
            pulumi.set(__self__, "scaling_adjustment_type", scaling_adjustment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if update_status is not None:
            pulumi.set(__self__, "update_status", update_status)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input['FleetScalingPolicyMetricName']:
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input['FleetScalingPolicyMetricName']):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input['FleetScalingPolicyComparisonOperator']]:
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input['FleetScalingPolicyComparisonOperator']]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[int]]:
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input['FleetScalingPolicyPolicyType']]:
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input['FleetScalingPolicyPolicyType']]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scaling_adjustment", value)

    @property
    @pulumi.getter(name="scalingAdjustmentType")
    def scaling_adjustment_type(self) -> Optional[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']]:
        """
        The type of adjustment to make to a fleet's instance count.
        """
        return pulumi.get(self, "scaling_adjustment_type")

    @scaling_adjustment_type.setter
    def scaling_adjustment_type(self, value: Optional[pulumi.Input['FleetScalingPolicyScalingAdjustmentType']]):
        pulumi.set(self, "scaling_adjustment_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['FleetScalingPolicyStatus']]:
        """
        Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['FleetScalingPolicyStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['FleetTargetConfigurationArgs']]:
        """
        An object that contains settings for a target-based scaling policy.
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['FleetTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Metric value used to trigger a scaling event.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="updateStatus")
    def update_status(self) -> Optional[pulumi.Input['FleetScalingPolicyUpdateStatus']]:
        """
        The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        return pulumi.get(self, "update_status")

    @update_status.setter
    def update_status(self, value: Optional[pulumi.Input['FleetScalingPolicyUpdateStatus']]):
        pulumi.set(self, "update_status", value)


@pulumi.input_type
class FleetServerProcessArgs:
    def __init__(__self__, *,
                 concurrent_executions: pulumi.Input[int],
                 launch_path: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[str]] = None):
        """
        A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
        :param pulumi.Input[int] concurrent_executions: The number of server processes that use this configuration to run concurrently on an instance.
        :param pulumi.Input[str] launch_path: The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:
               
               Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"
               
               Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        :param pulumi.Input[str] parameters: An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        pulumi.set(__self__, "concurrent_executions", concurrent_executions)
        pulumi.set(__self__, "launch_path", launch_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="concurrentExecutions")
    def concurrent_executions(self) -> pulumi.Input[int]:
        """
        The number of server processes that use this configuration to run concurrently on an instance.
        """
        return pulumi.get(self, "concurrent_executions")

    @concurrent_executions.setter
    def concurrent_executions(self, value: pulumi.Input[int]):
        pulumi.set(self, "concurrent_executions", value)

    @property
    @pulumi.getter(name="launchPath")
    def launch_path(self) -> pulumi.Input[str]:
        """
        The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:

        Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"

        Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        """
        return pulumi.get(self, "launch_path")

    @launch_path.setter
    def launch_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "launch_path", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class FleetTargetConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[float]):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        :param pulumi.Input[float] target_value: Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[float]:
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[float]):
        pulumi.set(self, "target_value", value)


@pulumi.input_type
class GameServerGroupAutoScalingPolicyArgs:
    def __init__(__self__, *,
                 target_tracking_configuration: pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs'],
                 estimated_instance_warmup: Optional[pulumi.Input[float]] = None):
        """
        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        """
        pulumi.set(__self__, "target_tracking_configuration", target_tracking_configuration)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)

    @property
    @pulumi.getter(name="targetTrackingConfiguration")
    def target_tracking_configuration(self) -> pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs']:
        return pulumi.get(self, "target_tracking_configuration")

    @target_tracking_configuration.setter
    def target_tracking_configuration(self, value: pulumi.Input['GameServerGroupTargetTrackingConfigurationArgs']):
        pulumi.set(self, "target_tracking_configuration", value)

    @property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "estimated_instance_warmup")

    @estimated_instance_warmup.setter
    def estimated_instance_warmup(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "estimated_instance_warmup", value)


@pulumi.input_type
class GameServerGroupInstanceDefinitionArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 weighted_capacity: Optional[pulumi.Input[str]] = None):
        """
        An allowed instance type for your game server group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weighted_capacity", value)


@pulumi.input_type
class GameServerGroupLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GameServerGroupTargetTrackingConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[float]):
        """
        Settings for a target-based scaling policy applied to Auto Scaling group.
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[float]:
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[float]):
        pulumi.set(self, "target_value", value)


@pulumi.input_type
class GameSessionQueueDestinationArgs:
    def __init__(__self__, *,
                 destination_arn: Optional[pulumi.Input[str]] = None):
        """
        A fleet or alias designated in a game session queue.
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_arn", value)


@pulumi.input_type
class GameSessionQueueFilterConfigurationArgs:
    def __init__(__self__, *,
                 allowed_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if allowed_locations is not None:
            pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "allowed_locations")

    @allowed_locations.setter
    def allowed_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_locations", value)


@pulumi.input_type
class GameSessionQueuePlayerLatencyPolicyArgs:
    def __init__(__self__, *,
                 maximum_individual_player_latency_milliseconds: Optional[pulumi.Input[int]] = None,
                 policy_duration_seconds: Optional[pulumi.Input[int]] = None):
        """
        Sets a latency cap for individual players when placing a game session.
        :param pulumi.Input[int] maximum_individual_player_latency_milliseconds: The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        :param pulumi.Input[int] policy_duration_seconds: The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        if maximum_individual_player_latency_milliseconds is not None:
            pulumi.set(__self__, "maximum_individual_player_latency_milliseconds", maximum_individual_player_latency_milliseconds)
        if policy_duration_seconds is not None:
            pulumi.set(__self__, "policy_duration_seconds", policy_duration_seconds)

    @property
    @pulumi.getter(name="maximumIndividualPlayerLatencyMilliseconds")
    def maximum_individual_player_latency_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        """
        return pulumi.get(self, "maximum_individual_player_latency_milliseconds")

    @maximum_individual_player_latency_milliseconds.setter
    def maximum_individual_player_latency_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_individual_player_latency_milliseconds", value)

    @property
    @pulumi.getter(name="policyDurationSeconds")
    def policy_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        return pulumi.get(self, "policy_duration_seconds")

    @policy_duration_seconds.setter
    def policy_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "policy_duration_seconds", value)


@pulumi.input_type
class GameSessionQueuePriorityConfigurationArgs:
    def __init__(__self__, *,
                 location_order: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority_order: Optional[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]] = None):
        if location_order is not None:
            pulumi.set(__self__, "location_order", location_order)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)

    @property
    @pulumi.getter(name="locationOrder")
    def location_order(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "location_order")

    @location_order.setter
    def location_order(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "location_order", value)

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]]:
        return pulumi.get(self, "priority_order")

    @priority_order.setter
    def priority_order(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GameSessionQueuePriorityOrderItem']]]]):
        pulumi.set(self, "priority_order", value)


@pulumi.input_type
class MatchmakingConfigurationGamePropertyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair that contains information about a game session.
        :param pulumi.Input[str] key: The game property identifier.
        :param pulumi.Input[str] value: The game property value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The game property identifier.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The game property value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScriptS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 object_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param pulumi.Input[str] key: The name of the zip file that contains the script files.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param pulumi.Input[str] object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name of the zip file that contains the script files.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_version", value)


