# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AliasRoutingStrategyType',
    'BuildOperatingSystem',
    'ContainerGroupDefinitionContainerDependencyCondition',
    'ContainerGroupDefinitionContainerPortRangeProtocol',
    'ContainerGroupDefinitionOperatingSystem',
    'ContainerGroupDefinitionSchedulingStrategy',
    'FleetApplyCapacity',
    'FleetCertificateConfigurationCertificateType',
    'FleetComputeType',
    'FleetInstanceRoleCredentialsProvider',
    'FleetIpPermissionProtocol',
    'FleetNewGameSessionProtectionPolicy',
    'FleetScalingPolicyComparisonOperator',
    'FleetScalingPolicyMetricName',
    'FleetScalingPolicyPolicyType',
    'FleetScalingPolicyScalingAdjustmentType',
    'FleetScalingPolicyStatus',
    'FleetScalingPolicyUpdateStatus',
    'FleetType',
    'GameServerGroupBalancingStrategy',
    'GameServerGroupDeleteOption',
    'GameServerGroupGameServerProtectionPolicy',
    'GameSessionQueuePriorityOrderItem',
    'MatchmakingConfigurationBackfillMode',
    'MatchmakingConfigurationFlexMatchMode',
]


class AliasRoutingStrategyType(str, Enum):
    """
    Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
    """
    SIMPLE = "SIMPLE"
    TERMINAL = "TERMINAL"


class BuildOperatingSystem(str, Enum):
    """
    The operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build. If your game build contains multiple executables, they all must run on the same operating system. If an operating system is not specified when creating a build, Amazon GameLift uses the default value (WINDOWS_2012). This value cannot be changed later.
    """
    AMAZON_LINUX = "AMAZON_LINUX"
    AMAZON_LINUX2 = "AMAZON_LINUX_2"
    AMAZON_LINUX2023 = "AMAZON_LINUX_2023"
    WINDOWS2012 = "WINDOWS_2012"
    WINDOWS2016 = "WINDOWS_2016"


class ContainerGroupDefinitionContainerDependencyCondition(str, Enum):
    """
    The type of dependency.
    """
    START = "START"
    COMPLETE = "COMPLETE"
    SUCCESS = "SUCCESS"
    HEALTHY = "HEALTHY"


class ContainerGroupDefinitionContainerPortRangeProtocol(str, Enum):
    """
    Defines the protocol of these ports.
    """
    TCP = "TCP"
    UDP = "UDP"


class ContainerGroupDefinitionOperatingSystem(str, Enum):
    """
    The operating system of the container group
    """
    AMAZON_LINUX2023 = "AMAZON_LINUX_2023"


class ContainerGroupDefinitionSchedulingStrategy(str, Enum):
    """
    Specifies whether the container group includes replica or daemon containers.
    """
    REPLICA = "REPLICA"
    DAEMON = "DAEMON"


class FleetApplyCapacity(str, Enum):
    """
    Determines whether to apply fleet or location capacities on fleet creation.
    """
    ON_UPDATE = "ON_UPDATE"
    ON_CREATE_AND_UPDATE = "ON_CREATE_AND_UPDATE"


class FleetCertificateConfigurationCertificateType(str, Enum):
    DISABLED = "DISABLED"
    GENERATED = "GENERATED"


class FleetComputeType(str, Enum):
    """
    ComputeType to differentiate EC2 hardware managed by GameLift and Anywhere hardware managed by the customer.
    """
    EC2 = "EC2"
    ANYWHERE = "ANYWHERE"
    CONTAINER = "CONTAINER"


class FleetInstanceRoleCredentialsProvider(str, Enum):
    """
    Credentials provider implementation that loads credentials from the Amazon EC2 Instance Metadata Service.
    """
    SHARED_CREDENTIAL_FILE = "SHARED_CREDENTIAL_FILE"


class FleetIpPermissionProtocol(str, Enum):
    """
    The network communication protocol used by the fleet.
    """
    TCP = "TCP"
    UDP = "UDP"


class FleetNewGameSessionProtectionPolicy(str, Enum):
    """
    A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
    """
    FULL_PROTECTION = "FullProtection"
    NO_PROTECTION = "NoProtection"


class FleetScalingPolicyComparisonOperator(str, Enum):
    """
    Comparison operator to use when measuring a metric against the threshold value.
    """
    GREATER_THAN_OR_EQUAL_TO_THRESHOLD = "GreaterThanOrEqualToThreshold"
    GREATER_THAN_THRESHOLD = "GreaterThanThreshold"
    LESS_THAN_THRESHOLD = "LessThanThreshold"
    LESS_THAN_OR_EQUAL_TO_THRESHOLD = "LessThanOrEqualToThreshold"


class FleetScalingPolicyMetricName(str, Enum):
    """
    Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
    """
    ACTIVATING_GAME_SESSIONS = "ActivatingGameSessions"
    ACTIVE_GAME_SESSIONS = "ActiveGameSessions"
    ACTIVE_INSTANCES = "ActiveInstances"
    AVAILABLE_GAME_SESSIONS = "AvailableGameSessions"
    AVAILABLE_PLAYER_SESSIONS = "AvailablePlayerSessions"
    CURRENT_PLAYER_SESSIONS = "CurrentPlayerSessions"
    IDLE_INSTANCES = "IdleInstances"
    PERCENT_AVAILABLE_GAME_SESSIONS = "PercentAvailableGameSessions"
    PERCENT_IDLE_INSTANCES = "PercentIdleInstances"
    QUEUE_DEPTH = "QueueDepth"
    WAIT_TIME = "WaitTime"
    CONCURRENT_ACTIVATABLE_GAME_SESSIONS = "ConcurrentActivatableGameSessions"


class FleetScalingPolicyPolicyType(str, Enum):
    """
    The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
    """
    RULE_BASED = "RuleBased"
    TARGET_BASED = "TargetBased"


class FleetScalingPolicyScalingAdjustmentType(str, Enum):
    """
    The type of adjustment to make to a fleet's instance count.
    """
    CHANGE_IN_CAPACITY = "ChangeInCapacity"
    EXACT_CAPACITY = "ExactCapacity"
    PERCENT_CHANGE_IN_CAPACITY = "PercentChangeInCapacity"


class FleetScalingPolicyStatus(str, Enum):
    """
    Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
    """
    ACTIVE = "ACTIVE"
    UPDATE_REQUESTED = "UPDATE_REQUESTED"
    UPDATING = "UPDATING"
    DELETE_REQUESTED = "DELETE_REQUESTED"
    DELETING = "DELETING"
    DELETED = "DELETED"
    ERROR = "ERROR"


class FleetScalingPolicyUpdateStatus(str, Enum):
    """
    The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
    """
    PENDING_UPDATE = "PENDING_UPDATE"


class FleetType(str, Enum):
    """
    Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
    """
    ON_DEMAND = "ON_DEMAND"
    SPOT = "SPOT"


class GameServerGroupBalancingStrategy(str, Enum):
    """
    The fallback balancing method to use for the game server group when Spot Instances in a Region become unavailable or are not viable for game hosting.
    """
    SPOT_ONLY = "SPOT_ONLY"
    SPOT_PREFERRED = "SPOT_PREFERRED"
    ON_DEMAND_ONLY = "ON_DEMAND_ONLY"


class GameServerGroupDeleteOption(str, Enum):
    """
    The type of delete to perform.
    """
    SAFE_DELETE = "SAFE_DELETE"
    FORCE_DELETE = "FORCE_DELETE"
    RETAIN = "RETAIN"


class GameServerGroupGameServerProtectionPolicy(str, Enum):
    """
    A flag that indicates whether instances in the game server group are protected from early termination.
    """
    NO_PROTECTION = "NO_PROTECTION"
    FULL_PROTECTION = "FULL_PROTECTION"


class GameSessionQueuePriorityOrderItem(str, Enum):
    LATENCY = "LATENCY"
    COST = "COST"
    DESTINATION = "DESTINATION"
    LOCATION = "LOCATION"


class MatchmakingConfigurationBackfillMode(str, Enum):
    """
    The method used to backfill game sessions created with this matchmaking configuration.
    """
    AUTOMATIC = "AUTOMATIC"
    MANUAL = "MANUAL"


class MatchmakingConfigurationFlexMatchMode(str, Enum):
    """
    Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a standalone matchmaking solution.
    """
    STANDALONE = "STANDALONE"
    WITH_QUEUE = "WITH_QUEUE"
