# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataRepositoryAssociationArgs', 'DataRepositoryAssociation']

@pulumi.input_type
class DataRepositoryAssociationArgs:
    def __init__(__self__, *,
                 data_repository_path: pulumi.Input[str],
                 file_system_id: pulumi.Input[str],
                 file_system_path: pulumi.Input[str],
                 batch_import_meta_data_on_create: Optional[pulumi.Input[bool]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 s3: Optional[pulumi.Input['DataRepositoryAssociationS3Args']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataRepositoryAssociation resource.
        :param pulumi.Input[str] data_repository_path: The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format ``s3://myBucket/myPrefix/``. This path specifies where in the S3 data repository files will be imported from or exported to.
        :param pulumi.Input[str] file_system_id: The ID of the file system on which the data repository association is configured.
        :param pulumi.Input[str] file_system_path: A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as ``/ns1/``) or subdirectory (such as ``/ns1/subdir/``) that will be mapped 1-1 with ``DataRepositoryPath``. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path ``/ns1/``, then you cannot link another data repository with file system path ``/ns1/ns2``.
                This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
                 If you specify only a forward slash (``/``) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
        :param pulumi.Input[bool] batch_import_meta_data_on_create: A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to ``true``.
        :param pulumi.Input[int] imported_file_chunk_size: For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
                The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
        :param pulumi.Input['DataRepositoryAssociationS3Args'] s3: The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
                For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        pulumi.set(__self__, "data_repository_path", data_repository_path)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "file_system_path", file_system_path)
        if batch_import_meta_data_on_create is not None:
            pulumi.set(__self__, "batch_import_meta_data_on_create", batch_import_meta_data_on_create)
        if imported_file_chunk_size is not None:
            pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataRepositoryPath")
    def data_repository_path(self) -> pulumi.Input[str]:
        """
        The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format ``s3://myBucket/myPrefix/``. This path specifies where in the S3 data repository files will be imported from or exported to.
        """
        return pulumi.get(self, "data_repository_path")

    @data_repository_path.setter
    def data_repository_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_repository_path", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        """
        The ID of the file system on which the data repository association is configured.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> pulumi.Input[str]:
        """
        A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as ``/ns1/``) or subdirectory (such as ``/ns1/subdir/``) that will be mapped 1-1 with ``DataRepositoryPath``. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path ``/ns1/``, then you cannot link another data repository with file system path ``/ns1/ns2``.
         This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
          If you specify only a forward slash (``/``) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
        """
        return pulumi.get(self, "file_system_path")

    @file_system_path.setter
    def file_system_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_path", value)

    @property
    @pulumi.getter(name="batchImportMetaDataOnCreate")
    def batch_import_meta_data_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to ``true``.
        """
        return pulumi.get(self, "batch_import_meta_data_on_create")

    @batch_import_meta_data_on_create.setter
    def batch_import_meta_data_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "batch_import_meta_data_on_create", value)

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[pulumi.Input[int]]:
        """
        For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
        """
        return pulumi.get(self, "imported_file_chunk_size")

    @imported_file_chunk_size.setter
    def imported_file_chunk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "imported_file_chunk_size", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['DataRepositoryAssociationS3Args']]:
        """
        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['DataRepositoryAssociationS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
         For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class DataRepositoryAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_import_meta_data_on_create: Optional[pulumi.Input[bool]] = None,
                 data_repository_path: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 file_system_path: Optional[pulumi.Input[str]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['DataRepositoryAssociationS3Args']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding ``scratch_1`` deployment type.
         Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        fs_id = config.require("fsId")
        dra_id_export_name = config.require("draIdExportName")
        file_system_path = config.require("fileSystemPath")
        imported_file_chunk_size = config.require("importedFileChunkSize")
        test_dra = aws_native.fsx.DataRepositoryAssociation("testDRA",
            file_system_id=fs_id,
            file_system_path=file_system_path,
            data_repository_path="s3://example-bucket",
            batch_import_meta_data_on_create=True,
            imported_file_chunk_size=imported_file_chunk_size,
            s3=aws_native.fsx.DataRepositoryAssociationS3Args(
                auto_import_policy=aws_native.fsx.DataRepositoryAssociationAutoImportPolicyArgs(
                    events=[
                        aws_native.fsx.DataRepositoryAssociationEventType.NEW,
                        aws_native.fsx.DataRepositoryAssociationEventType.CHANGED,
                        aws_native.fsx.DataRepositoryAssociationEventType.DELETED,
                    ],
                ),
                auto_export_policy=aws_native.fsx.DataRepositoryAssociationAutoExportPolicyArgs(
                    events=[
                        aws_native.fsx.DataRepositoryAssociationEventType.NEW,
                        aws_native.fsx.DataRepositoryAssociationEventType.CHANGED,
                        aws_native.fsx.DataRepositoryAssociationEventType.DELETED,
                    ],
                ),
            ),
            tags=[aws_native.TagArgs(
                key="Location",
                value="Boston",
            )])
        pulumi.export("draId", test_dra.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] batch_import_meta_data_on_create: A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to ``true``.
        :param pulumi.Input[str] data_repository_path: The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format ``s3://myBucket/myPrefix/``. This path specifies where in the S3 data repository files will be imported from or exported to.
        :param pulumi.Input[str] file_system_id: The ID of the file system on which the data repository association is configured.
        :param pulumi.Input[str] file_system_path: A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as ``/ns1/``) or subdirectory (such as ``/ns1/subdir/``) that will be mapped 1-1 with ``DataRepositoryPath``. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path ``/ns1/``, then you cannot link another data repository with file system path ``/ns1/ns2``.
                This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
                 If you specify only a forward slash (``/``) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
        :param pulumi.Input[int] imported_file_chunk_size: For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
                The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
        :param pulumi.Input[pulumi.InputType['DataRepositoryAssociationS3Args']] s3: The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this resource.
                For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataRepositoryAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding ``scratch_1`` deployment type.
         Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        fs_id = config.require("fsId")
        dra_id_export_name = config.require("draIdExportName")
        file_system_path = config.require("fileSystemPath")
        imported_file_chunk_size = config.require("importedFileChunkSize")
        test_dra = aws_native.fsx.DataRepositoryAssociation("testDRA",
            file_system_id=fs_id,
            file_system_path=file_system_path,
            data_repository_path="s3://example-bucket",
            batch_import_meta_data_on_create=True,
            imported_file_chunk_size=imported_file_chunk_size,
            s3=aws_native.fsx.DataRepositoryAssociationS3Args(
                auto_import_policy=aws_native.fsx.DataRepositoryAssociationAutoImportPolicyArgs(
                    events=[
                        aws_native.fsx.DataRepositoryAssociationEventType.NEW,
                        aws_native.fsx.DataRepositoryAssociationEventType.CHANGED,
                        aws_native.fsx.DataRepositoryAssociationEventType.DELETED,
                    ],
                ),
                auto_export_policy=aws_native.fsx.DataRepositoryAssociationAutoExportPolicyArgs(
                    events=[
                        aws_native.fsx.DataRepositoryAssociationEventType.NEW,
                        aws_native.fsx.DataRepositoryAssociationEventType.CHANGED,
                        aws_native.fsx.DataRepositoryAssociationEventType.DELETED,
                    ],
                ),
            ),
            tags=[aws_native.TagArgs(
                key="Location",
                value="Boston",
            )])
        pulumi.export("draId", test_dra.id)

        ```

        :param str resource_name: The name of the resource.
        :param DataRepositoryAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataRepositoryAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_import_meta_data_on_create: Optional[pulumi.Input[bool]] = None,
                 data_repository_path: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 file_system_path: Optional[pulumi.Input[str]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['DataRepositoryAssociationS3Args']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataRepositoryAssociationArgs.__new__(DataRepositoryAssociationArgs)

            __props__.__dict__["batch_import_meta_data_on_create"] = batch_import_meta_data_on_create
            if data_repository_path is None and not opts.urn:
                raise TypeError("Missing required property 'data_repository_path'")
            __props__.__dict__["data_repository_path"] = data_repository_path
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if file_system_path is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_path'")
            __props__.__dict__["file_system_path"] = file_system_path
            __props__.__dict__["imported_file_chunk_size"] = imported_file_chunk_size
            __props__.__dict__["s3"] = s3
            __props__.__dict__["tags"] = tags
            __props__.__dict__["association_id"] = None
            __props__.__dict__["resource_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["batchImportMetaDataOnCreate", "dataRepositoryPath", "fileSystemId", "fileSystemPath"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataRepositoryAssociation, __self__).__init__(
            'aws-native:fsx:DataRepositoryAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataRepositoryAssociation':
        """
        Get an existing DataRepositoryAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataRepositoryAssociationArgs.__new__(DataRepositoryAssociationArgs)

        __props__.__dict__["association_id"] = None
        __props__.__dict__["batch_import_meta_data_on_create"] = None
        __props__.__dict__["data_repository_path"] = None
        __props__.__dict__["file_system_id"] = None
        __props__.__dict__["file_system_path"] = None
        __props__.__dict__["imported_file_chunk_size"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["s3"] = None
        __props__.__dict__["tags"] = None
        return DataRepositoryAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="batchImportMetaDataOnCreate")
    def batch_import_meta_data_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to ``true``.
        """
        return pulumi.get(self, "batch_import_meta_data_on_create")

    @property
    @pulumi.getter(name="dataRepositoryPath")
    def data_repository_path(self) -> pulumi.Output[str]:
        """
        The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format ``s3://myBucket/myPrefix/``. This path specifies where in the S3 data repository files will be imported from or exported to.
        """
        return pulumi.get(self, "data_repository_path")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        The ID of the file system on which the data repository association is configured.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> pulumi.Output[str]:
        """
        A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as ``/ns1/``) or subdirectory (such as ``/ns1/subdir/``) that will be mapped 1-1 with ``DataRepositoryPath``. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path ``/ns1/``, then you cannot link another data repository with file system path ``/ns1/ns2``.
         This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
          If you specify only a forward slash (``/``) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
        """
        return pulumi.get(self, "file_system_path")

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> pulumi.Output[Optional[int]]:
        """
        For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
        """
        return pulumi.get(self, "imported_file_chunk_size")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.DataRepositoryAssociationS3']]:
        """
        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
         For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")

