# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['SchemaArgs', 'Schema']

@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 registry_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Schema resource.
        :param pulumi.Input[str] content: The source of the schema definition.
        :param pulumi.Input[str] registry_name: The name of the schema registry.
        :param pulumi.Input[str] type: The type of schema. Valid types include OpenApi3 and JSONSchemaDraft4.
        :param pulumi.Input[str] description: A description of the schema.
        :param pulumi.Input[str] schema_name: The name of the schema.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags associated with the resource.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "registry_name", registry_name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The source of the schema definition.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> pulumi.Input[str]:
        """
        The name of the schema registry.
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of schema. Valid types include OpenApi3 and JSONSchemaDraft4.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the schema.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the schema.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags associated with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Schema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 registry_name: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::EventSchemas::Schema

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        execution_status_change_schema = aws_native.eventschemas.Schema("executionStatusChangeSchema",
            registry_name="aws.events",
            schema_name="ExecutionStatusChange",
            description="event emitted when the status of a state machine execution change",
            type="OpenApi3",
            content="{   \\"openapi\\": \\"3.0.0\\",   \\"info\\": {     \\"version\\": \\"1.0.0\\",     \\"title\\": \\"StepFunctionsExecutionStatusChange\\"   },   \\"paths\\":{},   \\"components\\": {     \\"schemas\\": {       \\"StepFunctionsExecutionStatusChange\\": {         \\"type\\": \\"object\\",         \\"required\\": [ \\"output\\", \\"input\\", \\"executionArn\\", \\"name\\", \\"stateMachineArn\\", \\"startDate\\", \\"stopDate\\", \\"status\\" ],         \\"properties\\": {           \\"output\\": {\\"type\\": \\"string\\",\\"nullable\\": true},           \\"input\\": {\\"type\\": \\"string\\"},           \\"executionArn\\": {\\"type\\": \\"string\\"},           \\"name\\": {\\"type\\": \\"string\\"},           \\"stateMachineArn\\": {\\"type\\": \\"string\\"},           \\"startDate\\": {\\"type\\": \\"integer\\",\\"format\\": \\"int64\\"},           \\"stopDate\\": {\\"type\\": \\"integer\\",\\"format\\": \\"int64\\",\\"nullable\\": true},           \\"status\\": {\\"type\\": \\"string\\",\\"enum\\": [ \\"FAILED\\", \\"RUNNING\\", \\"SUCCEEDED\\", \\"ABORTED\\" ]}         }       }     }   } }")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: The source of the schema definition.
        :param pulumi.Input[str] description: A description of the schema.
        :param pulumi.Input[str] registry_name: The name of the schema registry.
        :param pulumi.Input[str] schema_name: The name of the schema.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: Tags associated with the resource.
        :param pulumi.Input[str] type: The type of schema. Valid types include OpenApi3 and JSONSchemaDraft4.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::EventSchemas::Schema

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        execution_status_change_schema = aws_native.eventschemas.Schema("executionStatusChangeSchema",
            registry_name="aws.events",
            schema_name="ExecutionStatusChange",
            description="event emitted when the status of a state machine execution change",
            type="OpenApi3",
            content="{   \\"openapi\\": \\"3.0.0\\",   \\"info\\": {     \\"version\\": \\"1.0.0\\",     \\"title\\": \\"StepFunctionsExecutionStatusChange\\"   },   \\"paths\\":{},   \\"components\\": {     \\"schemas\\": {       \\"StepFunctionsExecutionStatusChange\\": {         \\"type\\": \\"object\\",         \\"required\\": [ \\"output\\", \\"input\\", \\"executionArn\\", \\"name\\", \\"stateMachineArn\\", \\"startDate\\", \\"stopDate\\", \\"status\\" ],         \\"properties\\": {           \\"output\\": {\\"type\\": \\"string\\",\\"nullable\\": true},           \\"input\\": {\\"type\\": \\"string\\"},           \\"executionArn\\": {\\"type\\": \\"string\\"},           \\"name\\": {\\"type\\": \\"string\\"},           \\"stateMachineArn\\": {\\"type\\": \\"string\\"},           \\"startDate\\": {\\"type\\": \\"integer\\",\\"format\\": \\"int64\\"},           \\"stopDate\\": {\\"type\\": \\"integer\\",\\"format\\": \\"int64\\",\\"nullable\\": true},           \\"status\\": {\\"type\\": \\"string\\",\\"enum\\": [ \\"FAILED\\", \\"RUNNING\\", \\"SUCCEEDED\\", \\"ABORTED\\" ]}         }       }     }   } }")

        ```

        :param str resource_name: The name of the resource.
        :param SchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 registry_name: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaArgs.__new__(SchemaArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            if registry_name is None and not opts.urn:
                raise TypeError("Missing required property 'registry_name'")
            __props__.__dict__["registry_name"] = registry_name
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["schema_arn"] = None
            __props__.__dict__["schema_version"] = None
            __props__.__dict__["version_created_date"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["registryName", "schemaName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Schema, __self__).__init__(
            'aws-native:eventschemas:Schema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Schema':
        """
        Get an existing Schema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SchemaArgs.__new__(SchemaArgs)

        __props__.__dict__["content"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["last_modified"] = None
        __props__.__dict__["registry_name"] = None
        __props__.__dict__["schema_arn"] = None
        __props__.__dict__["schema_name"] = None
        __props__.__dict__["schema_version"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["version_created_date"] = None
        return Schema(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        The source of the schema definition.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the schema.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        The last modified time of the schema.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> pulumi.Output[str]:
        """
        The name of the schema registry.
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the schema.
        """
        return pulumi.get(self, "schema_arn")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the schema.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> pulumi.Output[str]:
        """
        The version number of the schema.
        """
        return pulumi.get(self, "schema_version")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags associated with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of schema. Valid types include OpenApi3 and JSONSchemaDraft4.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="versionCreatedDate")
    def version_created_date(self) -> pulumi.Output[str]:
        """
        The date the schema version was created.
        """
        return pulumi.get(self, "version_created_date")

