# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[Any] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['RuleState']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['RuleTargetArgs']]]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[str] event_bus_name: The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
        :param Any event_pattern: The event pattern of the rule. For more information, see Events and Event Patterns in the Amazon EventBridge User Guide.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Events::Rule` for more information about the expected schema for this property.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the role that is used for target invocation.
        :param pulumi.Input[str] schedule_expression: The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see Creating an Amazon EventBridge rule that runs on a schedule.
        :param pulumi.Input['RuleState'] state: The state of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['RuleTargetArgs']]] targets: Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
               Targets are the resources that are invoked when a rule is triggered.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_bus_name is not None:
            pulumi.set(__self__, "event_bus_name", event_bus_name)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @event_bus_name.setter
    def event_bus_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_bus_name", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[Any]:
        """
        The event pattern of the rule. For more information, see Events and Event Patterns in the Amazon EventBridge User Guide.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Events::Rule` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[Any]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the role that is used for target invocation.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see Creating an Amazon EventBridge rule that runs on a schedule.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['RuleState']]:
        """
        The state of the rule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['RuleState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleTargetArgs']]]]:
        """
        Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
        Targets are the resources that are invoked when a rule is triggered.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleTargetArgs']]]]):
        pulumi.set(self, "targets", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[Any] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['RuleState']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleTargetArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Events::Rule

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        event_bridge_ia_mrole = aws_native.iam.Role("eventBridgeIAMrole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": "events.amazonaws.com",
                    },
                    "action": "sts:AssumeRole",
                }],
            },
            path="/",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="PutEventsDestinationBus",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": ["events:PutEvents"],
                        "resource": ["arn:aws:events:us-east-1:123456789012:event-bus/CrossRegionDestinationBus"],
                    }],
                },
            )])
        event_rule_region1 = aws_native.events.Rule("eventRuleRegion1",
            description="Routes to us-east-1 event bus",
            event_bus_name="MyBusName",
            state=aws_native.events.RuleState.ENABLED,
            event_pattern={
                "source": ["MyTestApp"],
                "detail": ["MyTestAppDetail"],
            },
            targets=[aws_native.events.RuleTargetArgs(
                arn="arn:aws:events:us-east-1:123456789012:event-bus/CrossRegionDestinationBus",
                id=" CrossRegionDestinationBus",
                role_arn=event_bridge_ia_mrole.arn,
            )])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[str] event_bus_name: The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
        :param Any event_pattern: The event pattern of the rule. For more information, see Events and Event Patterns in the Amazon EventBridge User Guide.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Events::Rule` for more information about the expected schema for this property.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the role that is used for target invocation.
        :param pulumi.Input[str] schedule_expression: The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see Creating an Amazon EventBridge rule that runs on a schedule.
        :param pulumi.Input['RuleState'] state: The state of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleTargetArgs']]]] targets: Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
               Targets are the resources that are invoked when a rule is triggered.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Events::Rule

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        event_bridge_ia_mrole = aws_native.iam.Role("eventBridgeIAMrole",
            assume_role_policy_document={
                "version": "2012-10-17",
                "statement": [{
                    "effect": "Allow",
                    "principal": {
                        "service": "events.amazonaws.com",
                    },
                    "action": "sts:AssumeRole",
                }],
            },
            path="/",
            policies=[aws_native.iam.RolePolicyArgs(
                policy_name="PutEventsDestinationBus",
                policy_document={
                    "version": "2012-10-17",
                    "statement": [{
                        "effect": "Allow",
                        "action": ["events:PutEvents"],
                        "resource": ["arn:aws:events:us-east-1:123456789012:event-bus/CrossRegionDestinationBus"],
                    }],
                },
            )])
        event_rule_region1 = aws_native.events.Rule("eventRuleRegion1",
            description="Routes to us-east-1 event bus",
            event_bus_name="MyBusName",
            state=aws_native.events.RuleState.ENABLED,
            event_pattern={
                "source": ["MyTestApp"],
                "detail": ["MyTestAppDetail"],
            },
            targets=[aws_native.events.RuleTargetArgs(
                arn="arn:aws:events:us-east-1:123456789012:event-bus/CrossRegionDestinationBus",
                id=" CrossRegionDestinationBus",
                role_arn=event_bridge_ia_mrole.arn,
            )])

        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[Any] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['RuleState']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleTargetArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["event_bus_name"] = event_bus_name
            __props__.__dict__["event_pattern"] = event_pattern
            __props__.__dict__["name"] = name
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["schedule_expression"] = schedule_expression
            __props__.__dict__["state"] = state
            __props__.__dict__["targets"] = targets
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Rule, __self__).__init__(
            'aws-native:events:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RuleArgs.__new__(RuleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["event_bus_name"] = None
        __props__.__dict__["event_pattern"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["schedule_expression"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["targets"] = None
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the rule, such as arn:aws:events:us-east-2:123456789012:rule/example.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> pulumi.Output[Optional[Any]]:
        """
        The event pattern of the rule. For more information, see Events and Event Patterns in the Amazon EventBridge User Guide.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Events::Rule` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "event_pattern")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the role that is used for target invocation.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see Creating an Amazon EventBridge rule that runs on a schedule.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional['RuleState']]:
        """
        The state of the rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Optional[Sequence['outputs.RuleTarget']]]:
        """
        Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
        Targets are the resources that are invoked when a rule is triggered.
        """
        return pulumi.get(self, "targets")

