# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetEventBusResult',
    'AwaitableGetEventBusResult',
    'get_event_bus',
    'get_event_bus_output',
]

@pulumi.output_type
class GetEventBusResult:
    def __init__(__self__, arn=None, policy=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the event bus.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        A JSON string that describes the permission policy statement for the event bus.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Events::EventBus` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Any tags assigned to the event bus.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEventBusResult(GetEventBusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventBusResult(
            arn=self.arn,
            policy=self.policy,
            tags=self.tags)


def get_event_bus(name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventBusResult:
    """
    Resource type definition for AWS::Events::EventBus


    :param str name: The name of the event bus.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:events:getEventBus', __args__, opts=opts, typ=GetEventBusResult).value

    return AwaitableGetEventBusResult(
        arn=pulumi.get(__ret__, 'arn'),
        policy=pulumi.get(__ret__, 'policy'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_event_bus)
def get_event_bus_output(name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventBusResult]:
    """
    Resource type definition for AWS::Events::EventBus


    :param str name: The name of the event bus.
    """
    ...
