# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['MatchingWorkflowArgs', 'MatchingWorkflow']

@pulumi.input_type
class MatchingWorkflowArgs:
    def __init__(__self__, *,
                 input_source_config: pulumi.Input[Sequence[pulumi.Input['MatchingWorkflowInputSourceArgs']]],
                 output_source_config: pulumi.Input[Sequence[pulumi.Input['MatchingWorkflowOutputSourceArgs']]],
                 resolution_techniques: pulumi.Input['MatchingWorkflowResolutionTechniquesArgs'],
                 role_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MatchingWorkflow resource.
        :param pulumi.Input[str] description: The description of the MatchingWorkflow
        :param pulumi.Input[str] workflow_name: The name of the MatchingWorkflow
        """
        pulumi.set(__self__, "input_source_config", input_source_config)
        pulumi.set(__self__, "output_source_config", output_source_config)
        pulumi.set(__self__, "resolution_techniques", resolution_techniques)
        pulumi.set(__self__, "role_arn", role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workflow_name is not None:
            pulumi.set(__self__, "workflow_name", workflow_name)

    @property
    @pulumi.getter(name="inputSourceConfig")
    def input_source_config(self) -> pulumi.Input[Sequence[pulumi.Input['MatchingWorkflowInputSourceArgs']]]:
        return pulumi.get(self, "input_source_config")

    @input_source_config.setter
    def input_source_config(self, value: pulumi.Input[Sequence[pulumi.Input['MatchingWorkflowInputSourceArgs']]]):
        pulumi.set(self, "input_source_config", value)

    @property
    @pulumi.getter(name="outputSourceConfig")
    def output_source_config(self) -> pulumi.Input[Sequence[pulumi.Input['MatchingWorkflowOutputSourceArgs']]]:
        return pulumi.get(self, "output_source_config")

    @output_source_config.setter
    def output_source_config(self, value: pulumi.Input[Sequence[pulumi.Input['MatchingWorkflowOutputSourceArgs']]]):
        pulumi.set(self, "output_source_config", value)

    @property
    @pulumi.getter(name="resolutionTechniques")
    def resolution_techniques(self) -> pulumi.Input['MatchingWorkflowResolutionTechniquesArgs']:
        return pulumi.get(self, "resolution_techniques")

    @resolution_techniques.setter
    def resolution_techniques(self, value: pulumi.Input['MatchingWorkflowResolutionTechniquesArgs']):
        pulumi.set(self, "resolution_techniques", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the MatchingWorkflow
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MatchingWorkflow
        """
        return pulumi.get(self, "workflow_name")

    @workflow_name.setter
    def workflow_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_name", value)


class MatchingWorkflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchingWorkflowInputSourceArgs']]]]] = None,
                 output_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchingWorkflowOutputSourceArgs']]]]] = None,
                 resolution_techniques: Optional[pulumi.Input[pulumi.InputType['MatchingWorkflowResolutionTechniquesArgs']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        MatchingWorkflow defined in AWS Entity Resolution service

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the MatchingWorkflow
        :param pulumi.Input[str] workflow_name: The name of the MatchingWorkflow
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MatchingWorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        MatchingWorkflow defined in AWS Entity Resolution service

        :param str resource_name: The name of the resource.
        :param MatchingWorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MatchingWorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchingWorkflowInputSourceArgs']]]]] = None,
                 output_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchingWorkflowOutputSourceArgs']]]]] = None,
                 resolution_techniques: Optional[pulumi.Input[pulumi.InputType['MatchingWorkflowResolutionTechniquesArgs']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MatchingWorkflowArgs.__new__(MatchingWorkflowArgs)

            __props__.__dict__["description"] = description
            if input_source_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_source_config'")
            __props__.__dict__["input_source_config"] = input_source_config
            if output_source_config is None and not opts.urn:
                raise TypeError("Missing required property 'output_source_config'")
            __props__.__dict__["output_source_config"] = output_source_config
            if resolution_techniques is None and not opts.urn:
                raise TypeError("Missing required property 'resolution_techniques'")
            __props__.__dict__["resolution_techniques"] = resolution_techniques
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workflow_name"] = workflow_name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["workflow_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["workflowName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MatchingWorkflow, __self__).__init__(
            'aws-native:entityresolution:MatchingWorkflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MatchingWorkflow':
        """
        Get an existing MatchingWorkflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MatchingWorkflowArgs.__new__(MatchingWorkflowArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["input_source_config"] = None
        __props__.__dict__["output_source_config"] = None
        __props__.__dict__["resolution_techniques"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["workflow_arn"] = None
        __props__.__dict__["workflow_name"] = None
        return MatchingWorkflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the MatchingWorkflow
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="inputSourceConfig")
    def input_source_config(self) -> pulumi.Output[Sequence['outputs.MatchingWorkflowInputSource']]:
        return pulumi.get(self, "input_source_config")

    @property
    @pulumi.getter(name="outputSourceConfig")
    def output_source_config(self) -> pulumi.Output[Sequence['outputs.MatchingWorkflowOutputSource']]:
        return pulumi.get(self, "output_source_config")

    @property
    @pulumi.getter(name="resolutionTechniques")
    def resolution_techniques(self) -> pulumi.Output['outputs.MatchingWorkflowResolutionTechniques']:
        return pulumi.get(self, "resolution_techniques")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="workflowArn")
    def workflow_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "workflow_arn")

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> pulumi.Output[str]:
        """
        The name of the MatchingWorkflow
        """
        return pulumi.get(self, "workflow_name")

