# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['TrustStoreArgs', 'TrustStore']

@pulumi.input_type
class TrustStoreArgs:
    def __init__(__self__, *,
                 ca_certificates_bundle_s3_bucket: Optional[pulumi.Input[str]] = None,
                 ca_certificates_bundle_s3_key: Optional[pulumi.Input[str]] = None,
                 ca_certificates_bundle_s3_object_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a TrustStore resource.
        :param pulumi.Input[str] ca_certificates_bundle_s3_bucket: The name of the S3 bucket to fetch the CA certificate bundle from.
        :param pulumi.Input[str] ca_certificates_bundle_s3_key: The name of the S3 object to fetch the CA certificate bundle from.
        :param pulumi.Input[str] ca_certificates_bundle_s3_object_version: The version of the S3 bucket that contains the CA certificate bundle.
        :param pulumi.Input[str] name: The name of the trust store.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to assign to the trust store.
        """
        if ca_certificates_bundle_s3_bucket is not None:
            pulumi.set(__self__, "ca_certificates_bundle_s3_bucket", ca_certificates_bundle_s3_bucket)
        if ca_certificates_bundle_s3_key is not None:
            pulumi.set(__self__, "ca_certificates_bundle_s3_key", ca_certificates_bundle_s3_key)
        if ca_certificates_bundle_s3_object_version is not None:
            pulumi.set(__self__, "ca_certificates_bundle_s3_object_version", ca_certificates_bundle_s3_object_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="caCertificatesBundleS3Bucket")
    def ca_certificates_bundle_s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the S3 bucket to fetch the CA certificate bundle from.
        """
        return pulumi.get(self, "ca_certificates_bundle_s3_bucket")

    @ca_certificates_bundle_s3_bucket.setter
    def ca_certificates_bundle_s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificates_bundle_s3_bucket", value)

    @property
    @pulumi.getter(name="caCertificatesBundleS3Key")
    def ca_certificates_bundle_s3_key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the S3 object to fetch the CA certificate bundle from.
        """
        return pulumi.get(self, "ca_certificates_bundle_s3_key")

    @ca_certificates_bundle_s3_key.setter
    def ca_certificates_bundle_s3_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificates_bundle_s3_key", value)

    @property
    @pulumi.getter(name="caCertificatesBundleS3ObjectVersion")
    def ca_certificates_bundle_s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the S3 bucket that contains the CA certificate bundle.
        """
        return pulumi.get(self, "ca_certificates_bundle_s3_object_version")

    @ca_certificates_bundle_s3_object_version.setter
    def ca_certificates_bundle_s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificates_bundle_s3_object_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the trust store.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to assign to the trust store.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class TrustStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_certificates_bundle_s3_bucket: Optional[pulumi.Input[str]] = None,
                 ca_certificates_bundle_s3_key: Optional[pulumi.Input[str]] = None,
                 ca_certificates_bundle_s3_object_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ElasticLoadBalancingV2::TrustStore

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_certificates_bundle_s3_bucket: The name of the S3 bucket to fetch the CA certificate bundle from.
        :param pulumi.Input[str] ca_certificates_bundle_s3_key: The name of the S3 object to fetch the CA certificate bundle from.
        :param pulumi.Input[str] ca_certificates_bundle_s3_object_version: The version of the S3 bucket that contains the CA certificate bundle.
        :param pulumi.Input[str] name: The name of the trust store.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: The tags to assign to the trust store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TrustStoreArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ElasticLoadBalancingV2::TrustStore

        :param str resource_name: The name of the resource.
        :param TrustStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_certificates_bundle_s3_bucket: Optional[pulumi.Input[str]] = None,
                 ca_certificates_bundle_s3_key: Optional[pulumi.Input[str]] = None,
                 ca_certificates_bundle_s3_object_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustStoreArgs.__new__(TrustStoreArgs)

            __props__.__dict__["ca_certificates_bundle_s3_bucket"] = ca_certificates_bundle_s3_bucket
            __props__.__dict__["ca_certificates_bundle_s3_key"] = ca_certificates_bundle_s3_key
            __props__.__dict__["ca_certificates_bundle_s3_object_version"] = ca_certificates_bundle_s3_object_version
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["number_of_ca_certificates"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["trust_store_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TrustStore, __self__).__init__(
            'aws-native:elasticloadbalancingv2:TrustStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TrustStore':
        """
        Get an existing TrustStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TrustStoreArgs.__new__(TrustStoreArgs)

        __props__.__dict__["ca_certificates_bundle_s3_bucket"] = None
        __props__.__dict__["ca_certificates_bundle_s3_key"] = None
        __props__.__dict__["ca_certificates_bundle_s3_object_version"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["number_of_ca_certificates"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["trust_store_arn"] = None
        return TrustStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caCertificatesBundleS3Bucket")
    def ca_certificates_bundle_s3_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the S3 bucket to fetch the CA certificate bundle from.
        """
        return pulumi.get(self, "ca_certificates_bundle_s3_bucket")

    @property
    @pulumi.getter(name="caCertificatesBundleS3Key")
    def ca_certificates_bundle_s3_key(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the S3 object to fetch the CA certificate bundle from.
        """
        return pulumi.get(self, "ca_certificates_bundle_s3_key")

    @property
    @pulumi.getter(name="caCertificatesBundleS3ObjectVersion")
    def ca_certificates_bundle_s3_object_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the S3 bucket that contains the CA certificate bundle.
        """
        return pulumi.get(self, "ca_certificates_bundle_s3_object_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the trust store.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfCaCertificates")
    def number_of_ca_certificates(self) -> pulumi.Output[int]:
        """
        The number of certificates associated with the trust store.
        """
        return pulumi.get(self, "number_of_ca_certificates")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the trust store, could be either of ACTIVE or CREATING.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to assign to the trust store.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the trust store.
        """
        return pulumi.get(self, "trust_store_arn")

